/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class MediaProjectionEvent
implements Parcelable {
    public static final int PROJECTION_STARTED_DURING_CALL_AND_ACTIVE_POST_CALL = 0;
    private final int mEventType;
    private final long mTimestampMillis;
    public static final Parcelable.Creator<MediaProjectionEvent> CREATOR = new Parcelable.Creator<MediaProjectionEvent>(){

        @Override
        public MediaProjectionEvent createFromParcel(Parcel in) {
            return new MediaProjectionEvent(in);
        }

        public MediaProjectionEvent[] newArray(int size) {
            return new MediaProjectionEvent[size];
        }
    };

    public MediaProjectionEvent(int eventType, long timestampMillis) {
        this.mEventType = eventType;
        this.mTimestampMillis = timestampMillis;
    }

    private MediaProjectionEvent(Parcel in) {
        this.mEventType = in.readInt();
        this.mTimestampMillis = in.readLong();
    }

    public int getEventType() {
        return this.mEventType;
    }

    public long getTimestampMillis() {
        return this.mTimestampMillis;
    }

    public boolean equals(Object o) {
        if (o instanceof MediaProjectionEvent) {
            MediaProjectionEvent other = (MediaProjectionEvent)o;
            return this.mEventType == other.mEventType && this.mTimestampMillis == other.mTimestampMillis;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mEventType, this.mTimestampMillis);
    }

    public String toString() {
        return "MediaProjectionEvent{mEventType=" + this.mEventType + ", mTimestampMillis=" + this.mTimestampMillis + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mEventType);
        out.writeLong(this.mTimestampMillis);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }
}

