/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.media.projection.IMediaProjectionCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface IMediaProjection
extends IInterface {
    public void start(IMediaProjectionCallback var1) throws RemoteException;

    public void stop(int var1) throws RemoteException;

    public boolean canProjectAudio() throws RemoteException;

    public boolean canProjectVideo() throws RemoteException;

    public boolean canProjectSecureVideo() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public int applyVirtualDisplayFlags(int var1) throws RemoteException;

    public void registerCallback(IMediaProjectionCallback var1) throws RemoteException;

    public void unregisterCallback(IMediaProjectionCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public ActivityOptions.LaunchCookie getLaunchCookie() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public int getTaskId() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public boolean isRecordingOverlay() throws RemoteException;

    public int getDisplayId() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void setLaunchCookie(ActivityOptions.LaunchCookie var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void setTaskId(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void setRecordingOverlay(boolean var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public boolean isValid() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyVirtualDisplayCreated(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaProjection {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.media.projection.IMediaProjection";
        static final int TRANSACTION_start = 1;
        static final int TRANSACTION_stop = 2;
        static final int TRANSACTION_canProjectAudio = 3;
        static final int TRANSACTION_canProjectVideo = 4;
        static final int TRANSACTION_canProjectSecureVideo = 5;
        static final int TRANSACTION_applyVirtualDisplayFlags = 6;
        static final int TRANSACTION_registerCallback = 7;
        static final int TRANSACTION_unregisterCallback = 8;
        static final int TRANSACTION_getLaunchCookie = 9;
        static final int TRANSACTION_getTaskId = 10;
        static final int TRANSACTION_isRecordingOverlay = 11;
        static final int TRANSACTION_getDisplayId = 12;
        static final int TRANSACTION_setLaunchCookie = 13;
        static final int TRANSACTION_setTaskId = 14;
        static final int TRANSACTION_setRecordingOverlay = 15;
        static final int TRANSACTION_isValid = 16;
        static final int TRANSACTION_notifyVirtualDisplayCreated = 17;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IMediaProjection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaProjection) {
                return (IMediaProjection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "start";
                }
                case 2: {
                    return "stop";
                }
                case 3: {
                    return "canProjectAudio";
                }
                case 4: {
                    return "canProjectVideo";
                }
                case 5: {
                    return "canProjectSecureVideo";
                }
                case 6: {
                    return "applyVirtualDisplayFlags";
                }
                case 7: {
                    return "registerCallback";
                }
                case 8: {
                    return "unregisterCallback";
                }
                case 9: {
                    return "getLaunchCookie";
                }
                case 10: {
                    return "getTaskId";
                }
                case 11: {
                    return "isRecordingOverlay";
                }
                case 12: {
                    return "getDisplayId";
                }
                case 13: {
                    return "setLaunchCookie";
                }
                case 14: {
                    return "setTaskId";
                }
                case 15: {
                    return "setRecordingOverlay";
                }
                case 16: {
                    return "isValid";
                }
                case 17: {
                    return "notifyVirtualDisplayCreated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IMediaProjectionCallback _arg0 = IMediaProjectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.start(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stop(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _result = this.canProjectAudio();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    boolean _result = this.canProjectVideo();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    boolean _result = this.canProjectSecureVideo();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.applyVirtualDisplayFlags(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    IMediaProjectionCallback _arg0 = IMediaProjectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IMediaProjectionCallback _arg0 = IMediaProjectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    ActivityOptions.LaunchCookie _result = this.getLaunchCookie();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    int _result = this.getTaskId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    boolean _result = this.isRecordingOverlay();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    int _result = this.getDisplayId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    ActivityOptions.LaunchCookie _arg0 = data.readTypedObject(ActivityOptions.LaunchCookie.CREATOR);
                    data.enforceNoDataAvail();
                    this.setLaunchCookie(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setTaskId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecordingOverlay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _result = this.isValid();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyVirtualDisplayCreated(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void applyVirtualDisplayFlags_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLaunchCookie_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getTaskId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isRecordingOverlay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setLaunchCookie_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setTaskId_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setRecordingOverlay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isValid_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyVirtualDisplayCreated_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 16;
        }

        private static class Proxy
        implements IMediaProjection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(IMediaProjectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop(int stopReason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(stopReason);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canProjectAudio() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canProjectVideo() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canProjectSecureVideo() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int applyVirtualDisplayFlags(int flags) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IMediaProjectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IMediaProjectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ActivityOptions.LaunchCookie getLaunchCookie() throws RemoteException {
                ActivityOptions.LaunchCookie _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ActivityOptions.LaunchCookie.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTaskId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRecordingOverlay() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLaunchCookie(ActivityOptions.LaunchCookie launchCookie) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(launchCookie, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskId(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecordingOverlay(boolean isRecordingOverlay) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isRecordingOverlay);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValid() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVirtualDisplayCreated(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaProjection {
        @Override
        public void start(IMediaProjectionCallback callback) throws RemoteException {
        }

        @Override
        public void stop(int stopReason) throws RemoteException {
        }

        @Override
        public boolean canProjectAudio() throws RemoteException {
            return false;
        }

        @Override
        public boolean canProjectVideo() throws RemoteException {
            return false;
        }

        @Override
        public boolean canProjectSecureVideo() throws RemoteException {
            return false;
        }

        @Override
        public int applyVirtualDisplayFlags(int flags) throws RemoteException {
            return 0;
        }

        @Override
        public void registerCallback(IMediaProjectionCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterCallback(IMediaProjectionCallback callback) throws RemoteException {
        }

        @Override
        public ActivityOptions.LaunchCookie getLaunchCookie() throws RemoteException {
            return null;
        }

        @Override
        public int getTaskId() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isRecordingOverlay() throws RemoteException {
            return false;
        }

        @Override
        public int getDisplayId() throws RemoteException {
            return 0;
        }

        @Override
        public void setLaunchCookie(ActivityOptions.LaunchCookie launchCookie) throws RemoteException {
        }

        @Override
        public void setTaskId(int taskId) throws RemoteException {
        }

        @Override
        public void setRecordingOverlay(boolean isRecordingOverlay) throws RemoteException {
        }

        @Override
        public boolean isValid() throws RemoteException {
            return false;
        }

        @Override
        public void notifyVirtualDisplayCreated(int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

