/*
 * Decompiled with CFR 0.152.
 */
package android.media.musicrecognition;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class RecognitionRequest
implements Parcelable {
    @NonNull
    private final AudioAttributes mAudioAttributes;
    @NonNull
    private final AudioFormat mAudioFormat;
    private final int mCaptureSession;
    private final int mMaxAudioLengthSeconds;
    private final int mIgnoreBeginningFrames;
    @NonNull
    public static final Parcelable.Creator<RecognitionRequest> CREATOR = new Parcelable.Creator<RecognitionRequest>(){

        @Override
        public RecognitionRequest createFromParcel(Parcel p) {
            return new RecognitionRequest(p);
        }

        public RecognitionRequest[] newArray(int size) {
            return new RecognitionRequest[size];
        }
    };

    private RecognitionRequest(Builder b) {
        this.mAudioAttributes = Objects.requireNonNull(b.mAudioAttributes);
        this.mAudioFormat = Objects.requireNonNull(b.mAudioFormat);
        this.mCaptureSession = b.mCaptureSession;
        this.mMaxAudioLengthSeconds = b.mMaxAudioLengthSeconds;
        this.mIgnoreBeginningFrames = b.mIgnoreBeginningFrames;
    }

    @NonNull
    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    @NonNull
    public AudioFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getCaptureSession() {
        return this.mCaptureSession;
    }

    public int getMaxAudioLengthSeconds() {
        return this.mMaxAudioLengthSeconds;
    }

    public int getIgnoreBeginningFrames() {
        return this.mIgnoreBeginningFrames;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mAudioFormat, flags);
        dest.writeParcelable(this.mAudioAttributes, flags);
        dest.writeInt(this.mCaptureSession);
        dest.writeInt(this.mMaxAudioLengthSeconds);
        dest.writeInt(this.mIgnoreBeginningFrames);
    }

    private RecognitionRequest(Parcel in) {
        this.mAudioFormat = in.readParcelable(AudioFormat.class.getClassLoader(), AudioFormat.class);
        this.mAudioAttributes = in.readParcelable(AudioAttributes.class.getClassLoader(), AudioAttributes.class);
        this.mCaptureSession = in.readInt();
        this.mMaxAudioLengthSeconds = in.readInt();
        this.mIgnoreBeginningFrames = in.readInt();
    }

    @SystemApi
    public static class Builder {
        private AudioFormat mAudioFormat = new AudioFormat.Builder().setSampleRate(16000).setEncoding(2).build();
        private AudioAttributes mAudioAttributes = new AudioAttributes.Builder().setContentType(2).build();
        private int mCaptureSession = 1;
        private int mMaxAudioLengthSeconds = 24;
        private int mIgnoreBeginningFrames = 0;

        @NonNull
        public Builder setAudioAttributes(@NonNull AudioAttributes audioAttributes) {
            this.mAudioAttributes = audioAttributes;
            return this;
        }

        @NonNull
        public Builder setAudioFormat(@NonNull AudioFormat audioFormat) {
            this.mAudioFormat = audioFormat;
            return this;
        }

        @NonNull
        public Builder setCaptureSession(int captureSession) {
            this.mCaptureSession = captureSession;
            return this;
        }

        @NonNull
        public Builder setMaxAudioLengthSeconds(int maxAudioLengthSeconds) {
            this.mMaxAudioLengthSeconds = maxAudioLengthSeconds;
            return this;
        }

        @NonNull
        public Builder setIgnoreBeginningFrames(int ignoreBeginningFrames) {
            this.mIgnoreBeginningFrames = ignoreBeginningFrames;
            return this;
        }

        @NonNull
        public RecognitionRequest build() {
            return new RecognitionRequest(this);
        }
    }
}

