/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.NonNull;
import android.media.metrics.BundleSession;
import android.media.metrics.EditingEndedEvent;
import android.media.metrics.EditingSession;
import android.media.metrics.IMediaMetricsManager;
import android.media.metrics.NetworkEvent;
import android.media.metrics.PlaybackErrorEvent;
import android.media.metrics.PlaybackMetrics;
import android.media.metrics.PlaybackSession;
import android.media.metrics.PlaybackStateEvent;
import android.media.metrics.RecordingSession;
import android.media.metrics.TrackChangeEvent;
import android.media.metrics.TranscodingSession;
import android.os.PersistableBundle;
import android.os.RemoteException;

public class MediaMetricsManager {
    public static final long INVALID_TIMESTAMP = -1L;
    private static final String TAG = "MediaMetricsManager";
    private IMediaMetricsManager mService;
    private int mUserId;

    public MediaMetricsManager(IMediaMetricsManager service, int userId) {
        this.mService = service;
        this.mUserId = userId;
    }

    public void reportPlaybackMetrics(@NonNull String sessionId, PlaybackMetrics metrics) {
        try {
            this.mService.reportPlaybackMetrics(sessionId, metrics, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportBundleMetrics(@NonNull String sessionId, PersistableBundle metrics) {
        try {
            this.mService.reportBundleMetrics(sessionId, metrics, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportNetworkEvent(@NonNull String sessionId, NetworkEvent event) {
        try {
            this.mService.reportNetworkEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportPlaybackStateEvent(@NonNull String sessionId, PlaybackStateEvent event) {
        try {
            this.mService.reportPlaybackStateEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportTrackChangeEvent(@NonNull String sessionId, TrackChangeEvent event) {
        try {
            this.mService.reportTrackChangeEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public PlaybackSession createPlaybackSession() {
        try {
            String id2 = this.mService.getPlaybackSessionId(this.mUserId);
            PlaybackSession session = new PlaybackSession(id2, this);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public RecordingSession createRecordingSession() {
        try {
            String id2 = this.mService.getRecordingSessionId(this.mUserId);
            RecordingSession session = new RecordingSession(id2, this);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public TranscodingSession createTranscodingSession() {
        try {
            String id2 = this.mService.getTranscodingSessionId(this.mUserId);
            TranscodingSession session = new TranscodingSession(id2, this);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public EditingSession createEditingSession() {
        try {
            String id2 = this.mService.getEditingSessionId(this.mUserId);
            EditingSession session = new EditingSession(id2, this);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public BundleSession createBundleSession() {
        try {
            String id2 = this.mService.getBundleSessionId(this.mUserId);
            BundleSession session = new BundleSession(id2, this);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public void releaseSessionId(@NonNull String sessionId) {
        try {
            this.mService.releaseSessionId(sessionId, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportPlaybackErrorEvent(@NonNull String sessionId, PlaybackErrorEvent event) {
        try {
            this.mService.reportPlaybackErrorEvent(sessionId, event, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportEditingEndedEvent(@NonNull String sessionId, EditingEndedEvent editingEndedEvent) {
        try {
            this.mService.reportEditingEndedEvent(sessionId, editingEndedEvent, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

