/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.Session2Command;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Session2CommandGroup
implements Parcelable {
    private static final String TAG = "Session2CommandGroup";
    @NonNull
    public static final Parcelable.Creator<Session2CommandGroup> CREATOR = new Parcelable.Creator<Session2CommandGroup>(){

        @Override
        public Session2CommandGroup createFromParcel(Parcel in) {
            return new Session2CommandGroup(in);
        }

        public Session2CommandGroup[] newArray(int size) {
            return new Session2CommandGroup[size];
        }
    };
    Set<Session2Command> mCommands = new HashSet<Session2Command>();

    Session2CommandGroup(@Nullable Collection<Session2Command> commands) {
        if (commands != null) {
            this.mCommands.addAll(commands);
        }
    }

    Session2CommandGroup(Parcel in) {
        Parcelable[] commands = in.readParcelableArray(Session2Command.class.getClassLoader());
        if (commands != null) {
            for (Parcelable command : commands) {
                this.mCommands.add((Session2Command)command);
            }
        }
    }

    public boolean hasCommand(@NonNull Session2Command command) {
        if (command == null) {
            throw new IllegalArgumentException("command shouldn't be null");
        }
        return this.mCommands.contains(command);
    }

    public boolean hasCommand(int commandCode) {
        if (commandCode == 0) {
            throw new IllegalArgumentException("Use hasCommand(Command) for custom command");
        }
        for (Session2Command command : this.mCommands) {
            if (command.getCommandCode() != commandCode) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public Set<Session2Command> getCommands() {
        return new HashSet<Session2Command>(this.mCommands);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("parcel shouldn't be null");
        }
        dest.writeParcelableArray(this.mCommands.toArray(new Session2Command[0]), 0);
    }

    public static class Builder {
        private Set<Session2Command> mCommands;

        public Builder() {
            this.mCommands = new HashSet<Session2Command>();
        }

        public Builder(@NonNull Session2CommandGroup commandGroup) {
            if (commandGroup == null) {
                throw new IllegalArgumentException("command group shouldn't be null");
            }
            this.mCommands = commandGroup.getCommands();
        }

        @NonNull
        public Builder addCommand(@NonNull Session2Command command) {
            if (command == null) {
                throw new IllegalArgumentException("command shouldn't be null");
            }
            this.mCommands.add(command);
            return this;
        }

        @NonNull
        public Builder removeCommand(@NonNull Session2Command command) {
            if (command == null) {
                throw new IllegalArgumentException("command shouldn't be null");
            }
            this.mCommands.remove(command);
            return this;
        }

        @NonNull
        public Session2CommandGroup build() {
            return new Session2CommandGroup(this.mCommands);
        }
    }
}

