/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.ApplicationMediaCapabilities;
import android.media.CamcorderProfile;
import android.media.IMediaTranscodingService;
import android.media.ITranscodingClient;
import android.media.ITranscodingClientCallback;
import android.media.MediaFormat;
import android.media.MediaFrameworkInitializer;
import android.media.TranscodingRequestParcel;
import android.media.TranscodingResultParcel;
import android.media.TranscodingSessionParcel;
import android.media.TranscodingTestConfig;
import android.media.TranscodingVideoTrackFormat;
import android.media.internal.annotation.MinSdk;
import android.media.internal.utils.build.SdkLevel;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.Os;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.io.FileNotFoundException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@SystemApi
@MinSdk(value=31)
@RequiresApi(value=31)
public class MediaTranscodingManager {
    private static final String TAG = "MediaTranscodingManager";
    private static final int CONNECT_SERVICE_RETRY_COUNT = 100;
    private static final int INTERVAL_CONNECT_SERVICE_RETRY_MS = 40;
    private static final float BPP = 0.25f;
    private final Context mContext;
    private ContentResolver mContentResolver;
    private final String mPackageName;
    private final int mPid;
    private final int mUid;
    private final ExecutorService mExecutor = Executors.newSingleThreadExecutor();
    private final HashMap<Integer, TranscodingSession> mPendingTranscodingSessions = new HashMap();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    @NonNull
    private ITranscodingClient mTranscodingClient = null;
    private static MediaTranscodingManager sMediaTranscodingManager;
    private ITranscodingClientCallback mTranscodingClientCallback = new ITranscodingClientCallback.Stub(){

        @Override
        public ParcelFileDescriptor openFileDescriptor(String fileUri, String mode) throws RemoteException {
            if (!(mode.equals("r") || mode.equals("w") || mode.equals("rw"))) {
                Log.e(MediaTranscodingManager.TAG, "Unsupport mode: " + mode);
                return null;
            }
            Uri uri = Uri.parse(fileUri);
            try {
                AssetFileDescriptor afd = MediaTranscodingManager.this.mContentResolver.openAssetFileDescriptor(uri, mode);
                if (afd != null) {
                    return afd.getParcelFileDescriptor();
                }
            }
            catch (FileNotFoundException e) {
                Log.w(MediaTranscodingManager.TAG, "Cannot find content uri: " + uri, e);
            }
            catch (SecurityException e) {
                Log.w(MediaTranscodingManager.TAG, "Cannot open content uri: " + uri, e);
            }
            catch (Exception e) {
                Log.w(MediaTranscodingManager.TAG, "Unknown content uri: " + uri, e);
            }
            return null;
        }

        @Override
        public void onTranscodingStarted(int sessionId) throws RemoteException {
            MediaTranscodingManager.this.updateStatus(sessionId, 2);
        }

        @Override
        public void onTranscodingPaused(int sessionId) throws RemoteException {
            MediaTranscodingManager.this.updateStatus(sessionId, 4);
        }

        @Override
        public void onTranscodingResumed(int sessionId) throws RemoteException {
            MediaTranscodingManager.this.updateStatus(sessionId, 2);
        }

        @Override
        public void onTranscodingFinished(int sessionId, TranscodingResultParcel result) throws RemoteException {
            MediaTranscodingManager.this.handleTranscodingFinished(sessionId, result);
        }

        @Override
        public void onTranscodingFailed(int sessionId, int errorCode) throws RemoteException {
            MediaTranscodingManager.this.handleTranscodingFailed(sessionId, errorCode);
        }

        @Override
        public void onAwaitNumberOfSessionsChanged(int sessionId, int oldAwaitNumber, int newAwaitNumber) throws RemoteException {
        }

        @Override
        public void onProgressUpdate(int sessionId, int newProgress) throws RemoteException {
            MediaTranscodingManager.this.handleTranscodingProgressUpdate(sessionId, newProgress);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTranscodingFinished(int sessionId, TranscodingResultParcel result) {
        HashMap<Integer, TranscodingSession> hashMap = this.mPendingTranscodingSessions;
        synchronized (hashMap) {
            TranscodingSession session = this.mPendingTranscodingSessions.remove(sessionId);
            if (session == null) {
                Log.e(TAG, "Session " + sessionId + " is not in Pendingsessions");
                return;
            }
            session.updateStatusAndResult(3, 2, 0);
            if (session.mListener != null && session.mListenerExecutor != null) {
                session.mListenerExecutor.execute(() -> session.mListener.onTranscodingFinished(session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTranscodingFailed(int sessionId, int errorCode) {
        HashMap<Integer, TranscodingSession> hashMap = this.mPendingTranscodingSessions;
        synchronized (hashMap) {
            TranscodingSession session = this.mPendingTranscodingSessions.remove(sessionId);
            if (session == null) {
                Log.e(TAG, "Session " + sessionId + " is not in Pendingsessions");
                return;
            }
            session.updateStatusAndResult(3, 3, errorCode);
            if (session.mListener != null && session.mListenerExecutor != null) {
                session.mListenerExecutor.execute(() -> session.mListener.onTranscodingFinished(session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTranscodingProgressUpdate(int sessionId, int newProgress) {
        HashMap<Integer, TranscodingSession> hashMap = this.mPendingTranscodingSessions;
        synchronized (hashMap) {
            TranscodingSession session = this.mPendingTranscodingSessions.get(sessionId);
            if (session == null) {
                Log.e(TAG, "Session " + sessionId + " is not in Pendingsessions");
                return;
            }
            session.updateProgress(newProgress);
        }
    }

    private IMediaTranscodingService getService(boolean retry) {
        if (!SdkLevel.isAtLeastS()) {
            return null;
        }
        int retryCount = !retry ? 1 : 100;
        Log.i(TAG, "get service with retry " + retryCount);
        for (int count = 1; count <= retryCount; ++count) {
            Log.d(TAG, "Trying to connect to service. Try count: " + count);
            IMediaTranscodingService service = IMediaTranscodingService.Stub.asInterface(MediaFrameworkInitializer.getMediaServiceManager().getMediaTranscodingServiceRegisterer().get());
            if (service != null) {
                return service;
            }
            try {
                Thread.sleep(40L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.w(TAG, "Failed to get service");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClientDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.mTranscodingClient = null;
        }
        this.mExecutor.execute(() -> {
            ArrayList<TranscodingSession> retrySessions = new ArrayList<TranscodingSession>();
            HashMap<Integer, TranscodingSession> hashMap = this.mPendingTranscodingSessions;
            synchronized (hashMap) {
                for (Map.Entry<Integer, TranscodingSession> entry : this.mPendingTranscodingSessions.entrySet()) {
                    TranscodingSession session = entry.getValue();
                    if (session.getStatus() == 2) {
                        session.updateStatusAndResult(3, 3, 2);
                        this.mPendingTranscodingSessions.remove(entry.getKey());
                        if (session.mListener == null || session.mListenerExecutor == null) continue;
                        Log.i(TAG, "Notify client session failed");
                        session.mListenerExecutor.execute(() -> session.mListener.onTranscodingFinished(session));
                        continue;
                    }
                    if (session.getStatus() != 1 && session.getStatus() != 4) continue;
                    retrySessions.add(session);
                }
            }
            IMediaTranscodingService service = this.getService(true);
            boolean haveTranscodingClient = false;
            if (service != null) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mTranscodingClient = this.registerClient(service);
                    if (this.mTranscodingClient != null) {
                        haveTranscodingClient = true;
                    }
                }
            }
            for (TranscodingSession session : retrySessions) {
                if (!haveTranscodingClient) {
                    this.handleTranscodingFailed(session.getSessionId(), 0);
                }
                try {
                    session.retryInternal(false);
                }
                catch (Exception re) {
                    this.handleTranscodingFailed(session.getSessionId(), 0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(int sessionId, int status) {
        HashMap<Integer, TranscodingSession> hashMap = this.mPendingTranscodingSessions;
        synchronized (hashMap) {
            TranscodingSession session = this.mPendingTranscodingSessions.get(sessionId);
            if (session == null) {
                Log.e(TAG, "Session " + sessionId + " is not in Pendingsessions");
                return;
            }
            session.updateStatus(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITranscodingClient registerClient(IMediaTranscodingService service) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mTranscodingClient = service.registerClient(this.mTranscodingClientCallback, this.mPackageName, this.mPackageName);
                if (this.mTranscodingClient != null) {
                    this.mTranscodingClient.asBinder().linkToDeath(() -> this.onClientDied(), 0);
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "Failed to register new client due to exception " + ex);
                this.mTranscodingClient = null;
            }
        }
        return this.mTranscodingClient;
    }

    public MediaTranscodingManager(@NonNull Context context) {
        this.mContext = context;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mPackageName = this.mContext.getPackageName();
        this.mUid = Os.getuid();
        this.mPid = Os.getpid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITranscodingClient getTranscodingClient() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTranscodingClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TranscodingSession enqueueRequest(@NonNull TranscodingRequest transcodingRequest, @NonNull Executor listenerExecutor, @NonNull OnTranscodingFinishedListener listener) {
        Log.i(TAG, "enqueueRequest called.");
        Objects.requireNonNull(transcodingRequest, "transcodingRequest must not be null");
        Objects.requireNonNull(listenerExecutor, "listenerExecutor must not be null");
        Objects.requireNonNull(listener, "listener must not be null");
        TranscodingRequestParcel requestParcel = transcodingRequest.writeToParcel(this.mContext);
        Log.i(TAG, "Getting transcoding request " + transcodingRequest.getSourceUri());
        try {
            TranscodingSessionParcel sessionParcel = new TranscodingSessionParcel();
            HashMap<Integer, TranscodingSession> hashMap = this.mPendingTranscodingSessions;
            synchronized (hashMap) {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mTranscodingClient == null) {
                        IMediaTranscodingService service = this.getService(false);
                        if (service == null) {
                            Log.w(TAG, "Service rebooting. Try again later");
                            return null;
                        }
                        this.mTranscodingClient = this.registerClient(service);
                        if (this.mTranscodingClient == null) {
                            Log.w(TAG, "Service rebooting. Try again later");
                            return null;
                        }
                    }
                    if (!this.mTranscodingClient.submitRequest(requestParcel, sessionParcel)) {
                        throw new UnsupportedOperationException("Failed to enqueue request");
                    }
                }
                TranscodingSession session = new TranscodingSession(this, transcodingRequest, sessionParcel, listenerExecutor, listener);
                this.mPendingTranscodingSessions.put(session.getSessionId(), session);
                return session;
            }
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Service rebooting. Try again later");
            return null;
        }
        catch (ServiceSpecificException ex) {
            throw new UnsupportedOperationException("Failed to submit request to Transcoding service. Error: " + ex);
        }
    }

    public static class TranscodingSession {
        public static final int STATUS_PENDING = 1;
        public static final int STATUS_RUNNING = 2;
        public static final int STATUS_FINISHED = 3;
        public static final int STATUS_PAUSED = 4;
        public static final int RESULT_NONE = 1;
        public static final int RESULT_SUCCESS = 2;
        public static final int RESULT_ERROR = 3;
        public static final int RESULT_CANCELED = 4;
        public static final int ERROR_NONE = 0;
        public static final int ERROR_DROPPED_BY_SERVICE = 1;
        public static final int ERROR_SERVICE_DIED = 2;
        private final MediaTranscodingManager mManager;
        private Executor mListenerExecutor;
        private OnTranscodingFinishedListener mListener;
        private int mSessionId = -1;
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private Executor mProgressUpdateExecutor = null;
        @GuardedBy(value={"mLock"})
        private OnProgressUpdateListener mProgressUpdateListener = null;
        @GuardedBy(value={"mLock"})
        private int mProgress = 0;
        @GuardedBy(value={"mLock"})
        private int mProgressUpdateInterval = 0;
        @GuardedBy(value={"mLock"})
        private int mStatus = 1;
        @GuardedBy(value={"mLock"})
        private int mResult = 1;
        @GuardedBy(value={"mLock"})
        private int mErrorCode = 0;
        @GuardedBy(value={"mLock"})
        private boolean mHasRetried = false;
        private final TranscodingRequest mRequest;

        private TranscodingSession(@NonNull MediaTranscodingManager manager, @NonNull TranscodingRequest request, @NonNull TranscodingSessionParcel parcel, @NonNull Executor executor, @NonNull OnTranscodingFinishedListener listener) {
            Objects.requireNonNull(manager, "manager must not be null");
            Objects.requireNonNull(parcel, "parcel must not be null");
            Objects.requireNonNull(executor, "listenerExecutor must not be null");
            Objects.requireNonNull(listener, "listener must not be null");
            this.mManager = manager;
            this.mSessionId = parcel.sessionId;
            this.mListenerExecutor = executor;
            this.mListener = listener;
            this.mRequest = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOnProgressUpdateListener(@NonNull Executor executor, @NonNull OnProgressUpdateListener listener) {
            Object object = this.mLock;
            synchronized (object) {
                Objects.requireNonNull(executor, "listenerExecutor must not be null");
                Objects.requireNonNull(listener, "listener must not be null");
                this.mProgressUpdateExecutor = executor;
                this.mProgressUpdateListener = listener;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearOnProgressUpdateListener() {
            Object object = this.mLock;
            synchronized (object) {
                this.mProgressUpdateExecutor = null;
                this.mProgressUpdateListener = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateStatusAndResult(int sessionStatus, int sessionResult, int errorCode) {
            Object object = this.mLock;
            synchronized (object) {
                this.mStatus = sessionStatus;
                this.mResult = sessionResult;
                this.mErrorCode = errorCode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getErrorCode() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mErrorCode;
            }
        }

        public boolean retry() {
            return this.retryInternal(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean retryInternal(boolean setHasRetried) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mStatus == 1 || this.mStatus == 2) {
                    throw new UnsupportedOperationException("Failed to retry as session is in processing");
                }
                if (this.mHasRetried) {
                    throw new UnsupportedOperationException("Session has been retried already");
                }
                ITranscodingClient client = this.mManager.getTranscodingClient();
                if (client == null) {
                    Log.e(MediaTranscodingManager.TAG, "Service rebooting. Try again later");
                    return false;
                }
                HashMap<Integer, TranscodingSession> hashMap = this.mManager.mPendingTranscodingSessions;
                synchronized (hashMap) {
                    try {
                        TranscodingSessionParcel sessionParcel = new TranscodingSessionParcel();
                        if (!client.submitRequest(this.mRequest.writeToParcel(this.mManager.mContext), sessionParcel)) {
                            this.mHasRetried = true;
                            throw new UnsupportedOperationException("Failed to enqueue request");
                        }
                        this.mSessionId = sessionParcel.sessionId;
                        this.mManager.mPendingTranscodingSessions.put(this.mSessionId, this);
                    }
                    catch (RemoteException re) {
                        return false;
                    }
                    this.mStatus = 1;
                    this.mHasRetried = setHasRetried;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mStatus != 3) {
                    try {
                        ITranscodingClient client = this.mManager.getTranscodingClient();
                        if (client != null) {
                            client.cancelSession(this.mSessionId);
                        }
                    }
                    catch (RemoteException re) {
                        Log.e(MediaTranscodingManager.TAG, "Failed to cancel the session due to exception:  " + re);
                    }
                    this.mStatus = 3;
                    this.mResult = 4;
                    this.mListenerExecutor.execute(() -> this.mListener.onTranscodingFinished(this));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getProgress() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mProgress;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStatus() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mStatus;
            }
        }

        public boolean addClientUid(int uid) {
            if (uid < 0) {
                throw new IllegalArgumentException("Invalid Uid");
            }
            ITranscodingClient client = this.mManager.getTranscodingClient();
            if (client == null) {
                Log.e(MediaTranscodingManager.TAG, "Service is dead...");
                return false;
            }
            try {
                if (!client.addClientUid(this.mSessionId, uid)) {
                    Log.e(MediaTranscodingManager.TAG, "Failed to add client uid");
                    return false;
                }
            }
            catch (Exception ex) {
                Log.e(MediaTranscodingManager.TAG, "Failed to get client uids due to " + ex);
                return false;
            }
            return true;
        }

        @NonNull
        public List<Integer> getClientUids() {
            ArrayList<Integer> uidList = new ArrayList<Integer>();
            ITranscodingClient client = this.mManager.getTranscodingClient();
            if (client == null) {
                Log.e(MediaTranscodingManager.TAG, "Service is dead...");
                return uidList;
            }
            try {
                int[] clientUids;
                for (int i : clientUids = client.getClientUids(this.mSessionId)) {
                    uidList.add(i);
                }
            }
            catch (Exception ex) {
                Log.e(MediaTranscodingManager.TAG, "Failed to get client uids due to " + ex);
            }
            return uidList;
        }

        public int getSessionId() {
            return this.mSessionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getResult() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mResult;
            }
        }

        public String toString() {
            String status;
            String result;
            switch (this.mResult) {
                case 1: {
                    result = "RESULT_NONE";
                    break;
                }
                case 2: {
                    result = "RESULT_SUCCESS";
                    break;
                }
                case 3: {
                    result = "RESULT_ERROR(" + this.mErrorCode + ")";
                    break;
                }
                case 4: {
                    result = "RESULT_CANCELED";
                    break;
                }
                default: {
                    result = String.valueOf(this.mResult);
                }
            }
            switch (this.mStatus) {
                case 1: {
                    status = "STATUS_PENDING";
                    break;
                }
                case 4: {
                    status = "STATUS_PAUSED";
                    break;
                }
                case 2: {
                    status = "STATUS_RUNNING";
                    break;
                }
                case 3: {
                    status = "STATUS_FINISHED";
                    break;
                }
                default: {
                    status = String.valueOf(this.mStatus);
                }
            }
            return String.format(" session: {id: %d, status: %s, result: %s, progress: %d}", this.mSessionId, status, result, this.mProgress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateProgress(int newProgress) {
            Object object = this.mLock;
            synchronized (object) {
                this.mProgress = newProgress;
                if (this.mProgressUpdateExecutor != null && this.mProgressUpdateListener != null) {
                    OnProgressUpdateListener listener = this.mProgressUpdateListener;
                    this.mProgressUpdateExecutor.execute(() -> listener.onProgressUpdate(this, newProgress));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateStatus(int newStatus) {
            Object object = this.mLock;
            synchronized (object) {
                this.mStatus = newStatus;
            }
        }

        @FunctionalInterface
        public static interface OnProgressUpdateListener {
            public void onProgressUpdate(@NonNull TranscodingSession var1, int var2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TranscodingSessionErrorCode {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Result {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Status {
        }
    }

    @FunctionalInterface
    public static interface OnTranscodingFinishedListener {
        public void onTranscodingFinished(@NonNull TranscodingSession var1);
    }

    public static abstract class TranscodingRequest {
        public static final int TRANSCODING_TYPE_UNKNOWN = 0;
        public static final int TRANSCODING_TYPE_VIDEO = 1;
        public static final int TRANSCODING_TYPE_IMAGE = 2;
        public static final int PRIORITY_UNKNOWN = 0;
        public static final int PRIORITY_REALTIME = 1;
        public static final int PRIORITY_OFFLINE = 2;
        @NonNull
        private Uri mSourceUri;
        @NonNull
        private Uri mDestinationUri;
        @Nullable
        private ParcelFileDescriptor mSourceFileDescriptor;
        @Nullable
        private ParcelFileDescriptor mDestinationFileDescriptor;
        private int mClientUid = -1;
        private int mClientPid = -1;
        private int mType = 0;
        private int mPriority = 0;
        @Nullable
        private MediaFormat mImageFormat = null;
        @VisibleForTesting
        private TranscodingTestConfig mTestConfig = null;

        TranscodingRequest() {
        }

        private TranscodingRequest(Builder b) {
            this.mSourceUri = b.mSourceUri;
            this.mSourceFileDescriptor = b.mSourceFileDescriptor;
            this.mDestinationUri = b.mDestinationUri;
            this.mDestinationFileDescriptor = b.mDestinationFileDescriptor;
            this.mClientUid = b.mClientUid;
            this.mClientPid = b.mClientPid;
            this.mPriority = b.mPriority;
            this.mType = b.mType;
            this.mTestConfig = b.mTestConfig;
        }

        public int getType() {
            return this.mType;
        }

        @NonNull
        public Uri getSourceUri() {
            return this.mSourceUri;
        }

        @Nullable
        public ParcelFileDescriptor getSourceFileDescriptor() {
            return this.mSourceFileDescriptor;
        }

        public int getClientUid() {
            return this.mClientUid;
        }

        public int getClientPid() {
            return this.mClientPid;
        }

        @NonNull
        public Uri getDestinationUri() {
            return this.mDestinationUri;
        }

        @Nullable
        public ParcelFileDescriptor getDestinationFileDescriptor() {
            return this.mDestinationFileDescriptor;
        }

        public int getPriority() {
            return this.mPriority;
        }

        @Nullable
        public TranscodingTestConfig getTestConfig() {
            return this.mTestConfig;
        }

        abstract void writeFormatToParcel(TranscodingRequestParcel var1);

        private TranscodingRequestParcel writeToParcel(@NonNull Context context) {
            TranscodingRequestParcel parcel = new TranscodingRequestParcel();
            switch (this.mPriority) {
                case 2: {
                    parcel.priority = 0;
                    break;
                }
                default: {
                    parcel.priority = 21;
                }
            }
            parcel.transcodingType = this.mType;
            parcel.sourceFilePath = this.mSourceUri.toString();
            parcel.sourceFd = this.mSourceFileDescriptor;
            parcel.destinationFilePath = this.mDestinationUri.toString();
            parcel.destinationFd = this.mDestinationFileDescriptor;
            parcel.clientUid = this.mClientUid;
            parcel.clientPid = this.mClientPid;
            if (this.mClientUid < 0) {
                parcel.clientPackageName = context.getPackageName();
            } else {
                String packageName = context.getPackageManager().getNameForUid(this.mClientUid);
                if (packageName == null) {
                    Log.w(MediaTranscodingManager.TAG, "Failed to find package for uid: " + this.mClientUid);
                    packageName = "Unavailable";
                }
                parcel.clientPackageName = packageName;
            }
            this.writeFormatToParcel(parcel);
            if (this.mTestConfig != null) {
                parcel.isForTesting = true;
                parcel.testConfig = this.mTestConfig;
            }
            return parcel;
        }

        static abstract class Builder<T extends Builder<T>> {
            @NonNull
            private Uri mSourceUri;
            @NonNull
            private Uri mDestinationUri;
            @Nullable
            private ParcelFileDescriptor mSourceFileDescriptor = null;
            @Nullable
            private ParcelFileDescriptor mDestinationFileDescriptor = null;
            private int mClientUid = -1;
            private int mClientPid = -1;
            private int mType = 0;
            private int mPriority = 0;
            private TranscodingTestConfig mTestConfig;

            abstract T self();

            private Builder(int type, @NonNull Uri sourceUri, @NonNull Uri destinationUri) {
                this.mType = type;
                if (sourceUri == null || ((Object)Uri.EMPTY).equals(sourceUri)) {
                    throw new IllegalArgumentException("You must specify a non-empty source Uri.");
                }
                this.mSourceUri = sourceUri;
                if (destinationUri == null || ((Object)Uri.EMPTY).equals(destinationUri)) {
                    throw new IllegalArgumentException("You must specify a non-empty destination Uri.");
                }
                this.mDestinationUri = destinationUri;
            }

            @NonNull
            public T setSourceFileDescriptor(@NonNull ParcelFileDescriptor fileDescriptor) {
                if (fileDescriptor == null || fileDescriptor.getFd() < 0) {
                    throw new IllegalArgumentException("Invalid source descriptor.");
                }
                this.mSourceFileDescriptor = fileDescriptor;
                return this.self();
            }

            @NonNull
            public T setDestinationFileDescriptor(@NonNull ParcelFileDescriptor fileDescriptor) {
                if (fileDescriptor == null || fileDescriptor.getFd() < 0) {
                    throw new IllegalArgumentException("Invalid destination descriptor.");
                }
                this.mDestinationFileDescriptor = fileDescriptor;
                return this.self();
            }

            @NonNull
            public T setClientUid(int uid) {
                if (uid < 0) {
                    throw new IllegalArgumentException("Invalid Uid");
                }
                this.mClientUid = uid;
                return this.self();
            }

            @NonNull
            public T setClientPid(int pid) {
                if (pid < 0) {
                    throw new IllegalArgumentException("Invalid pid");
                }
                this.mClientPid = pid;
                return this.self();
            }

            @NonNull
            public T setPriority(int priority) {
                if (priority != 2 && priority != 1) {
                    throw new IllegalArgumentException("Invalid priority: " + priority);
                }
                this.mPriority = priority;
                return this.self();
            }

            @VisibleForTesting
            @NonNull
            public T setTestConfig(@NonNull TranscodingTestConfig config) {
                this.mTestConfig = config;
                return this.self();
            }
        }

        public static class VideoFormatResolver
        extends MediaFormatResolver {
            private static final int BIT_RATE = 20000000;
            private MediaFormat mSrcVideoFormatHint;
            private MediaFormat mSrcAudioFormatHint;

            public VideoFormatResolver(@NonNull ApplicationMediaCapabilities clientCaps, @NonNull MediaFormat srcVideoFormatHint) {
                super(clientCaps);
                this.mSrcVideoFormatHint = srcVideoFormatHint;
            }

            VideoFormatResolver(@NonNull ApplicationMediaCapabilities clientCaps, @NonNull MediaFormat srcVideoFormatHint, @NonNull MediaFormat srcAudioFormatHint) {
                super(clientCaps);
                this.mSrcVideoFormatHint = srcVideoFormatHint;
                this.mSrcAudioFormatHint = srcAudioFormatHint;
            }

            @Override
            public boolean shouldTranscode() {
                boolean supportHevc = this.getClientCapabilities().isVideoMimeTypeSupported("video/hevc");
                return !supportHevc && "video/hevc".equals(this.mSrcVideoFormatHint.getString("mime"));
            }

            @Nullable
            public MediaFormat resolveVideoFormat() {
                if (!this.shouldTranscode()) {
                    return null;
                }
                MediaFormat videoTrackFormat = new MediaFormat(this.mSrcVideoFormatHint);
                videoTrackFormat.setString("mime", "video/avc");
                int width = this.mSrcVideoFormatHint.getInteger("width", -1);
                int height = this.mSrcVideoFormatHint.getInteger("height", -1);
                if (width <= 0 || height <= 0) {
                    throw new IllegalArgumentException("Source Width and height must be larger than 0");
                }
                float frameRate = this.mSrcVideoFormatHint.getNumber("frame-rate", 30.0).floatValue();
                if (frameRate <= 0.0f) {
                    throw new IllegalArgumentException("frameRate must be larger than 0");
                }
                int bitrate = VideoFormatResolver.getAVCBitrate(width, height, frameRate);
                videoTrackFormat.setInteger("bitrate", bitrate);
                return videoTrackFormat;
            }

            private static int getDefaultBitrate(int width, int height, float frameRate) {
                return (int)((float)(width * height) * frameRate * 0.25f);
            }

            private static int getAVCBitrate(int width, int height, float frameRate) {
                int bitrate = -1;
                int[] cameraIds = new int[]{0, 1};
                int[] preferQualities = new int[]{8, 6, 5, 4, 0};
                block0: for (int cameraId : cameraIds) {
                    for (int quality : preferQualities) {
                        if (!CamcorderProfile.hasProfile(cameraId, quality)) continue;
                        CamcorderProfile profile = CamcorderProfile.get(cameraId, quality);
                        if ((width != profile.videoFrameWidth || height != profile.videoFrameHeight) && (height != profile.videoFrameWidth || width != profile.videoFrameHeight) || (int)frameRate != profile.videoFrameRate || profile.videoCodec != 2) continue;
                        if (bitrate >= profile.videoBitRate) continue block0;
                        bitrate = profile.videoBitRate;
                        continue block0;
                    }
                }
                if (bitrate == -1) {
                    Log.w(MediaTranscodingManager.TAG, "Failed to find CamcorderProfile for w: " + width + "h: " + height + " fps: " + frameRate);
                    bitrate = VideoFormatResolver.getDefaultBitrate(width, height, frameRate);
                }
                Log.d(MediaTranscodingManager.TAG, "Using bitrate " + bitrate + " for " + width + " " + height + " " + frameRate);
                return bitrate;
            }

            @Nullable
            public MediaFormat resolveAudioFormat() {
                if (!this.shouldTranscode()) {
                    return null;
                }
                return null;
            }
        }

        static abstract class MediaFormatResolver {
            @NonNull
            private ApplicationMediaCapabilities mClientCaps;

            MediaFormatResolver() {
            }

            MediaFormatResolver(@NonNull ApplicationMediaCapabilities clientCaps) {
                if (clientCaps == null) {
                    throw new IllegalArgumentException("Client capabilities must not be null");
                }
                this.mClientCaps = clientCaps;
            }

            @NonNull
            ApplicationMediaCapabilities getClientCapabilities() {
                return this.mClientCaps;
            }

            abstract boolean shouldTranscode();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TranscodingPriority {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TranscodingType {
        }
    }

    public static class VideoTranscodingRequest
    extends TranscodingRequest {
        @Nullable
        private MediaFormat mVideoTrackFormat = null;
        @Nullable
        private MediaFormat mAudioTrackFormat = null;

        private VideoTranscodingRequest(Builder builder) {
            super(builder);
            this.mVideoTrackFormat = builder.mVideoTrackFormat;
            this.mAudioTrackFormat = builder.mAudioTrackFormat;
        }

        @NonNull
        public MediaFormat getVideoTrackFormat() {
            return this.mVideoTrackFormat;
        }

        @Override
        void writeFormatToParcel(TranscodingRequestParcel parcel) {
            parcel.requestedVideoTrackFormat = VideoTranscodingRequest.convertToVideoTrackFormat(this.mVideoTrackFormat);
        }

        private static TranscodingVideoTrackFormat convertToVideoTrackFormat(MediaFormat format) {
            if (format == null) {
                throw new IllegalArgumentException("Invalid MediaFormat");
            }
            TranscodingVideoTrackFormat trackFormat = new TranscodingVideoTrackFormat();
            if (format.containsKey("mime")) {
                String mime = format.getString("mime");
                if ("video/avc".equals(mime)) {
                    trackFormat.codecType = 1;
                } else if ("video/hevc".equals(mime)) {
                    trackFormat.codecType = 2;
                } else {
                    throw new UnsupportedOperationException("Only support transcode to avc/hevc");
                }
            }
            if (format.containsKey("bitrate")) {
                int bitrateBps = format.getInteger("bitrate");
                if (bitrateBps <= 0) {
                    throw new IllegalArgumentException("Bitrate must be larger than 0");
                }
                trackFormat.bitrateBps = bitrateBps;
            }
            if (format.containsKey("width") && format.containsKey("height")) {
                int width = format.getInteger("width");
                int height = format.getInteger("height");
                if (width <= 0 || height <= 0) {
                    throw new IllegalArgumentException("Width and height must be larger than 0");
                }
                trackFormat.width = width;
                trackFormat.height = height;
            }
            if (format.containsKey("profile")) {
                int profile = format.getInteger("profile");
                if (profile <= 0) {
                    throw new IllegalArgumentException("Invalid codec profile");
                }
                trackFormat.profile = profile;
            }
            if (format.containsKey("level")) {
                int level = format.getInteger("level");
                if (level <= 0) {
                    throw new IllegalArgumentException("Invalid codec level");
                }
                trackFormat.level = level;
            }
            return trackFormat;
        }

        public static class Builder
        extends TranscodingRequest.Builder<Builder> {
            @Nullable
            private MediaFormat mVideoTrackFormat = null;
            @Nullable
            private MediaFormat mAudioTrackFormat = null;

            public Builder(@NonNull Uri sourceUri, @NonNull Uri destinationUri, @NonNull MediaFormat videoFormat) {
                super(1, sourceUri, destinationUri);
                this.setVideoTrackFormat(videoFormat);
            }

            @Override
            @NonNull
            public Builder setClientUid(int uid) {
                super.setClientUid(uid);
                return this.self();
            }

            @Override
            @NonNull
            public Builder setClientPid(int pid) {
                super.setClientPid(pid);
                return this.self();
            }

            @Override
            @NonNull
            public Builder setSourceFileDescriptor(@NonNull ParcelFileDescriptor fd) {
                super.setSourceFileDescriptor(fd);
                return this.self();
            }

            @Override
            @NonNull
            public Builder setDestinationFileDescriptor(@NonNull ParcelFileDescriptor fd) {
                super.setDestinationFileDescriptor(fd);
                return this.self();
            }

            private void setVideoTrackFormat(@NonNull MediaFormat videoFormat) {
                String mime;
                if (videoFormat == null) {
                    throw new IllegalArgumentException("videoFormat must not be null");
                }
                String string2 = mime = videoFormat.containsKey("mime") ? videoFormat.getString("mime") : null;
                if (mime == null || !mime.startsWith("video/")) {
                    throw new IllegalArgumentException("Invalid video format: wrong mime type");
                }
                this.mVideoTrackFormat = videoFormat;
            }

            @NonNull
            public VideoTranscodingRequest build() {
                return new VideoTranscodingRequest(this);
            }

            @Override
            Builder self() {
                return this;
            }
        }
    }
}

