/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.media.IMediaRouter2;
import android.media.IMediaRouter2Manager;
import android.media.IMediaRouterService;
import android.media.MediaRoute2Info;
import android.media.MediaRouter2Manager;
import android.media.RouteDiscoveryPreference;
import android.media.RouteListingPreference;
import android.media.RoutingSessionInfo;
import android.media.SuggestedDeviceInfo;
import android.media.session.MediaSession;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.com.android.media.flags.Flags;
import com.android.internal.util.function.pooled.PooledLambda;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MediaRouter2 {
    public static final int SCANNING_STATE_NOT_SCANNING = 0;
    public static final int SCANNING_STATE_WHILE_INTERACTIVE = 1;
    public static final int SCANNING_STATE_SCANNING_FULL = 2;
    private static final String TAG = "MR2";
    private static final boolean DEBUG = Log.isLoggable("MR2", 3);
    private static final Object sSystemRouterLock = new Object();
    private static final Object sRouterLock = new Object();
    private static final int TRANSFER_TIMEOUT_MS = 30000;
    private static final long MANAGER_REQUEST_ID_NONE = 0L;
    @GuardedBy(value={"sSystemRouterLock"})
    private static final Map<PackageNameUserHandlePair, MediaRouter2> sAppToProxyRouterMap = new ArrayMap<PackageNameUserHandlePair, MediaRouter2>();
    @GuardedBy(value={"sRouterLock"})
    private static MediaRouter2 sInstance;
    private final Context mContext;
    private final IMediaRouterService mMediaRouterService;
    private final Object mLock = new Object();
    private final MediaRouter2Impl mImpl;
    private final CopyOnWriteArrayList<RouteCallbackRecord> mRouteCallbackRecords = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<RouteListingPreferenceCallbackRecord> mListingPreferenceCallbackRecords = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TransferCallbackRecord> mTransferCallbackRecords = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ControllerCallbackRecord> mControllerCallbackRecords = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<DeviceSuggestionsUpdatesCallbackRecord> mDeviceSuggestionsUpdatesCallbackRecords = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ControllerCreationRequest> mControllerCreationRequests = new CopyOnWriteArrayList();
    @GuardedBy(value={"mLock"})
    private final Map<String, MediaRoute2Info> mRoutes = new ArrayMap<String, MediaRoute2Info>();
    private final RoutingController mSystemController;
    @GuardedBy(value={"mLock"})
    private final Map<String, RoutingController> mNonSystemRoutingControllers = new ArrayMap<String, RoutingController>();
    @GuardedBy(value={"mLock"})
    private int mScreenOffScanRequestCount = 0;
    @GuardedBy(value={"mLock"})
    private int mScreenOnScanRequestCount = 0;
    private final SparseArray<ScanRequest> mScanRequestsMap = new SparseArray();
    private final AtomicInteger mNextRequestId = new AtomicInteger(1);
    private final Handler mHandler;
    @GuardedBy(value={"mLock"})
    private RouteDiscoveryPreference mDiscoveryPreference = RouteDiscoveryPreference.EMPTY;
    @GuardedBy(value={"mLock"})
    private MediaRouter2Stub mStub;
    @GuardedBy(value={"mLock"})
    @Nullable
    private RouteListingPreference mRouteListingPreference;
    @GuardedBy(value={"mLock"})
    @Nullable
    private Map<String, List<SuggestedDeviceInfo>> mSuggestedDeviceInfo = new HashMap<String, List<SuggestedDeviceInfo>>();
    private volatile ArrayMap<String, MediaRoute2Info> mPreviousFilteredRoutes = new ArrayMap();
    private final Map<String, MediaRoute2Info> mPreviousUnfilteredRoutes = new ArrayMap<String, MediaRoute2Info>();
    private volatile List<MediaRoute2Info> mFilteredRoutes = Collections.emptyList();
    private volatile OnGetControllerHintsListener mOnGetControllerHintsListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MediaRouter2 getInstance(@NonNull Context context) {
        Objects.requireNonNull(context, "context must not be null");
        Object object = sRouterLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new MediaRouter2(context.getApplicationContext());
            }
            return sInstance;
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MEDIA_CONTENT_CONTROL", "android.permission.MEDIA_ROUTING_CONTROL"})
    @Nullable
    public static MediaRouter2 getInstance(@NonNull Context context, @NonNull String clientPackageName) {
        try {
            return MediaRouter2.findOrCreateProxyInstanceForCallingUser(context, clientPackageName, context.getUser(), null, null);
        }
        catch (IllegalArgumentException ex) {
            Log.e(TAG, "Failed to create proxy router for package '" + clientPackageName + "'", ex);
            return null;
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_privileged_routing_for_media_routing_control")
    @RequiresPermission(anyOf={"android.permission.MEDIA_CONTENT_CONTROL", "android.permission.MEDIA_ROUTING_CONTROL"})
    @NonNull
    public static MediaRouter2 getInstance(@NonNull Context context, @NonNull String clientPackageName, @NonNull Executor executor, @NonNull Runnable onInstanceInvalidatedListener) {
        Objects.requireNonNull(executor, "Executor must not be null");
        Objects.requireNonNull(onInstanceInvalidatedListener, "onInstanceInvalidatedListener must not be null.");
        return MediaRouter2.findOrCreateProxyInstanceForCallingUser(context, clientPackageName, context.getUser(), executor, onInstanceInvalidatedListener);
    }

    @RequiresPermission(anyOf={"android.permission.MEDIA_CONTENT_CONTROL", "android.permission.MEDIA_ROUTING_CONTROL"})
    @NonNull
    public static MediaRouter2 getInstance(@NonNull Context context, @NonNull String clientPackageName, @NonNull UserHandle user) {
        return MediaRouter2.findOrCreateProxyInstanceForCallingUser(context, clientPackageName, user, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static MediaRouter2 findOrCreateProxyInstanceForCallingUser(Context context, String clientPackageName, UserHandle user, @Nullable Executor executor, @Nullable Runnable onInstanceInvalidatedListener) {
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(user, "user must not be null");
        if (TextUtils.isEmpty(clientPackageName)) {
            throw new IllegalArgumentException("clientPackageName must not be null or empty");
        }
        if ((executor == null || onInstanceInvalidatedListener == null) && MediaRouter2.checkCallerHasOnlyRevocablePermissions(context)) {
            throw new IllegalStateException("Use getInstance(Context, String, Executor, Runnable) to obtain a proxy MediaRouter2 instance.");
        }
        PackageNameUserHandlePair key = new PackageNameUserHandlePair(clientPackageName, user);
        Object object = sSystemRouterLock;
        synchronized (object) {
            MediaRouter2 instance = sAppToProxyRouterMap.get(key);
            if (instance == null) {
                instance = new MediaRouter2(context, Looper.getMainLooper(), clientPackageName, user);
                ((ProxyMediaRouter2Impl)instance.mImpl).registerProxyRouter();
                sAppToProxyRouterMap.put(key, instance);
            }
            ((ProxyMediaRouter2Impl)instance.mImpl).registerInstanceInvalidatedCallback(executor, onInstanceInvalidatedListener);
            return instance;
        }
    }

    private static boolean checkCallerHasOnlyRevocablePermissions(@NonNull Context context) {
        boolean hasMediaContentControl = context.checkSelfPermission("android.permission.MEDIA_CONTENT_CONTROL") == 0;
        boolean hasRegularMediaRoutingControl = context.checkSelfPermission("android.permission.MEDIA_ROUTING_CONTROL") == 0;
        AppOpsManager appOpsManager = context.getSystemService(AppOpsManager.class);
        boolean hasAppOpMediaRoutingControl = appOpsManager.unsafeCheckOp("android:media_routing_control", context.getApplicationInfo().uid, context.getOpPackageName()) == 0;
        return !hasMediaContentControl && !hasRegularMediaRoutingControl && hasAppOpMediaRoutingControl;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void startScan() {
        this.mImpl.startScan();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void stopScan() {
        this.mImpl.stopScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.media.flags.enable_screen_off_scanning")
    @NonNull
    public ScanToken requestScan(@NonNull ScanRequest scanRequest) {
        Objects.requireNonNull(scanRequest, "scanRequest must not be null.");
        ScanToken token = new ScanToken(this.mNextRequestId.getAndIncrement());
        Object object = this.mLock;
        synchronized (object) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = this.mScreenOffScanRequestCount == 0 && (scanRequest.isScreenOffScan() || this.mScreenOnScanRequestCount == 0);
            if (shouldUpdate) {
                try {
                    this.mImpl.updateScanningState(scanRequest.isScreenOffScan() ? 2 : 1);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
            if (scanRequest.isScreenOffScan()) {
                ++this.mScreenOffScanRequestCount;
            } else {
                ++this.mScreenOnScanRequestCount;
            }
            this.mScanRequestsMap.put(token.mId, scanRequest);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.media.flags.enable_screen_off_scanning")
    public void cancelScanRequest(@NonNull ScanToken token) {
        Objects.requireNonNull(token, "token must not be null");
        Object object = this.mLock;
        synchronized (object) {
            boolean shouldUpdate;
            ScanRequest request = this.mScanRequestsMap.get(token.mId);
            if (request == null) {
                throw new IllegalArgumentException("The token does not match any active scan request");
            }
            boolean bl = request.isScreenOffScan() ? this.mScreenOffScanRequestCount == 1 : (shouldUpdate = this.mScreenOnScanRequestCount == 1 && this.mScreenOffScanRequestCount == 0);
            if (shouldUpdate) {
                try {
                    if (!request.isScreenOffScan() || this.mScreenOnScanRequestCount == 0) {
                        this.mImpl.updateScanningState(0);
                    } else {
                        this.mImpl.updateScanningState(1);
                    }
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
            }
            if (request.isScreenOffScan()) {
                --this.mScreenOffScanRequestCount;
            } else {
                --this.mScreenOnScanRequestCount;
            }
            this.mScanRequestsMap.remove(token.mId);
        }
    }

    private MediaRouter2(Context appContext) {
        this.mContext = appContext;
        this.mMediaRouterService = IMediaRouterService.Stub.asInterface(ServiceManager.getService("media_router"));
        this.mImpl = new LocalMediaRouter2Impl(this.mContext.getPackageName());
        this.mHandler = new Handler(Looper.getMainLooper());
        this.loadSystemRoutes(false);
        RoutingSessionInfo currentSystemSessionInfo = this.mImpl.getSystemSessionInfo();
        if (currentSystemSessionInfo == null) {
            throw new RuntimeException("Null currentSystemSessionInfo. Something is wrong.");
        }
        this.mSystemController = new SystemRoutingController(currentSystemSessionInfo);
    }

    private MediaRouter2(Context context, Looper looper, String clientPackageName, UserHandle user) {
        this.mContext = context;
        this.mHandler = new Handler(looper);
        this.mMediaRouterService = IMediaRouterService.Stub.asInterface(ServiceManager.getService("media_router"));
        this.loadSystemRoutes(true);
        this.mSystemController = new SystemRoutingController(ProxyMediaRouter2Impl.getSystemSessionInfoImpl(this.mMediaRouterService, this.mContext.getPackageName(), clientPackageName));
        this.mImpl = new ProxyMediaRouter2Impl(context, clientPackageName, user);
    }

    @GuardedBy(value={"mLock"})
    private void loadSystemRoutes(boolean isProxyRouter) {
        List<MediaRoute2Info> currentSystemRoutes = null;
        try {
            currentSystemRoutes = this.mMediaRouterService.getSystemRoutes(this.mContext.getPackageName(), isProxyRouter);
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
        if (currentSystemRoutes == null || currentSystemRoutes.isEmpty()) {
            throw new RuntimeException("Null or empty currentSystemRoutes. Something is wrong.");
        }
        for (MediaRoute2Info route : currentSystemRoutes) {
            this.mRoutes.put(route.getId(), route);
        }
    }

    @SystemApi
    @Nullable
    public String getClientPackageName() {
        return this.mImpl.getClientPackageName();
    }

    public void registerRouteCallback(@NonNull Executor executor, @NonNull RouteCallback routeCallback, @NonNull RouteDiscoveryPreference preference) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(routeCallback, "callback must not be null");
        Objects.requireNonNull(preference, "preference must not be null");
        RouteCallbackRecord record = this.mImpl.createRouteCallbackRecord(executor, routeCallback, preference);
        this.mRouteCallbackRecords.remove(record);
        this.mRouteCallbackRecords.addIfAbsent(record);
        this.mImpl.registerRouteCallback();
    }

    public void unregisterRouteCallback(@NonNull RouteCallback routeCallback) {
        Objects.requireNonNull(routeCallback, "callback must not be null");
        if (!this.mRouteCallbackRecords.remove(new RouteCallbackRecord(null, routeCallback, null))) {
            Log.w(TAG, "unregisterRouteCallback: Ignoring unknown callback");
            return;
        }
        this.mImpl.unregisterRouteCallback();
    }

    public void registerRouteListingPreferenceUpdatedCallback(@NonNull Executor executor, @NonNull Consumer<RouteListingPreference> routeListingPreferenceCallback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(routeListingPreferenceCallback, "callback must not be null");
        RouteListingPreferenceCallbackRecord record = new RouteListingPreferenceCallbackRecord(executor, routeListingPreferenceCallback);
        this.mListingPreferenceCallbackRecords.remove(record);
        this.mListingPreferenceCallbackRecords.add(record);
    }

    @FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
    public void registerDeviceSuggestionsUpdatesCallback(@NonNull Executor executor, @NonNull DeviceSuggestionsUpdatesCallback deviceSuggestionsUpdatesCallback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(deviceSuggestionsUpdatesCallback, "callback must not be null");
        DeviceSuggestionsUpdatesCallbackRecord record = new DeviceSuggestionsUpdatesCallbackRecord(executor, deviceSuggestionsUpdatesCallback);
        this.mDeviceSuggestionsUpdatesCallbackRecords.remove(record);
        this.mDeviceSuggestionsUpdatesCallbackRecords.add(record);
    }

    public void unregisterRouteListingPreferenceUpdatedCallback(@NonNull Consumer<RouteListingPreference> callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        if (!this.mListingPreferenceCallbackRecords.remove(new RouteListingPreferenceCallbackRecord(null, callback))) {
            Log.w(TAG, "unregisterRouteListingPreferenceUpdatedCallback: Ignoring an unknown callback");
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
    public void unregisterDeviceSuggestionsUpdatesCallback(@NonNull DeviceSuggestionsUpdatesCallback callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        if (!this.mDeviceSuggestionsUpdatesCallbackRecords.remove(new DeviceSuggestionsUpdatesCallbackRecord(null, callback))) {
            Log.w(TAG, "unregisterDeviceSuggestionsUpdatesCallback: Ignoring an unknown callback");
        }
    }

    public boolean showSystemOutputSwitcher() {
        return this.mImpl.showSystemOutputSwitcher(null);
    }

    @FlaggedApi(value="com.android.media.flags.enable_route_visibility_control_api")
    public boolean showSystemOutputSwitcher(@NonNull MediaSession.Token sessionToken) {
        Objects.requireNonNull(sessionToken, "sessionToken must not be null");
        return this.mImpl.showSystemOutputSwitcher(sessionToken);
    }

    public void setRouteListingPreference(@Nullable RouteListingPreference routeListingPreference) {
        this.mImpl.setRouteListingPreference(routeListingPreference);
    }

    @FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
    public void setDeviceSuggestions(@NonNull List<SuggestedDeviceInfo> suggestedDeviceInfo) {
        this.mImpl.setDeviceSuggestions(suggestedDeviceInfo);
    }

    @FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
    public void clearDeviceSuggestions() {
        this.mImpl.setDeviceSuggestions(null);
    }

    @FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
    @NonNull
    public Map<String, List<SuggestedDeviceInfo>> getDeviceSuggestions() {
        return this.mImpl.getDeviceSuggestions();
    }

    @FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
    public void notifyDeviceSuggestionRequested() {
        this.mImpl.notifyDeviceSuggestionRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RouteListingPreference getRouteListingPreference() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRouteListingPreference;
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean updateDiscoveryPreferenceIfNeededLocked() {
        RouteDiscoveryPreference newDiscoveryPreference = new RouteDiscoveryPreference.Builder(this.mRouteCallbackRecords.stream().map(record -> record.mPreference).collect(Collectors.toList())).build();
        if (Objects.equals(this.mDiscoveryPreference, newDiscoveryPreference)) {
            return false;
        }
        this.mDiscoveryPreference = newDiscoveryPreference;
        this.updateFilteredRoutesLocked();
        return true;
    }

    @SystemApi
    @NonNull
    public List<MediaRoute2Info> getAllRoutes() {
        return this.mImpl.getAllRoutes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<MediaRoute2Info> getRoutes() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredRoutes;
        }
    }

    public void registerTransferCallback(@NonNull Executor executor, @NonNull TransferCallback callback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        TransferCallbackRecord record = new TransferCallbackRecord(executor, callback);
        if (!this.mTransferCallbackRecords.addIfAbsent(record)) {
            Log.w(TAG, "registerTransferCallback: Ignoring the same callback");
        }
    }

    public void unregisterTransferCallback(@NonNull TransferCallback callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        if (!this.mTransferCallbackRecords.remove(new TransferCallbackRecord(null, callback))) {
            Log.w(TAG, "unregisterTransferCallback: Ignoring an unknown callback");
        }
    }

    public void registerControllerCallback(@NonNull Executor executor, @NonNull ControllerCallback callback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        ControllerCallbackRecord record = new ControllerCallbackRecord(executor, callback);
        if (!this.mControllerCallbackRecords.addIfAbsent(record)) {
            Log.w(TAG, "registerControllerCallback: Ignoring the same callback");
        }
    }

    public void unregisterControllerCallback(@NonNull ControllerCallback callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        if (!this.mControllerCallbackRecords.remove(new ControllerCallbackRecord(null, callback))) {
            Log.w(TAG, "unregisterControllerCallback: Ignoring an unknown callback");
        }
    }

    public void setOnGetControllerHintsListener(@Nullable OnGetControllerHintsListener listener) {
        this.mImpl.setOnGetControllerHintsListener(listener);
    }

    public void transferTo(@NonNull MediaRoute2Info route) {
        this.mImpl.transferTo(route);
    }

    public void stop() {
        this.mImpl.stop();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void transfer(@NonNull RoutingController controller, @NonNull MediaRoute2Info route) {
        this.mImpl.transfer(controller.getRoutingSessionInfo(), route);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestCreateController(@NonNull RoutingController controller, @NonNull MediaRoute2Info route, long managerRequestId) {
        block8: {
            MediaRouter2Stub stub;
            if (route.isSystemRoute()) {
                this.notifyTransfer(controller, this.getSystemController());
                controller.release();
                return;
            }
            int requestId = this.mNextRequestId.getAndIncrement();
            ControllerCreationRequest request = new ControllerCreationRequest(requestId, managerRequestId, route, controller);
            this.mControllerCreationRequests.add(request);
            OnGetControllerHintsListener listener = this.mOnGetControllerHintsListener;
            Bundle controllerHints = null;
            if (listener != null && (controllerHints = listener.onGetControllerHints(route)) != null) {
                controllerHints = new Bundle(controllerHints);
            }
            Object object = this.mLock;
            synchronized (object) {
                stub = this.mStub;
            }
            if (stub != null) {
                try {
                    this.mMediaRouterService.requestCreateSessionWithRouter2(stub, requestId, managerRequestId, controller.getRoutingSessionInfo(), route, controllerHints);
                }
                catch (RemoteException ex) {
                    Log.e(TAG, "createControllerForTransfer: Failed to request for creating a controller.", ex);
                    this.mControllerCreationRequests.remove(request);
                    if (managerRequestId != 0L) break block8;
                    this.notifyTransferFailure(route);
                }
            }
        }
    }

    @NonNull
    private RoutingController getCurrentController() {
        List<RoutingController> controllers = this.getControllers();
        return controllers.get(controllers.size() - 1);
    }

    @NonNull
    public RoutingController getSystemController() {
        return this.mSystemController;
    }

    @Nullable
    public RoutingController getController(@NonNull String id2) {
        Objects.requireNonNull(id2, "id must not be null");
        for (RoutingController controller : this.getControllers()) {
            if (!TextUtils.equals(id2, controller.getId())) continue;
            return controller;
        }
        return null;
    }

    @NonNull
    public List<RoutingController> getControllers() {
        return this.mImpl.getControllers();
    }

    @FlaggedApi(value="com.android.media.flags.enable_privileged_routing_for_media_routing_control")
    @RequiresPermission(anyOf={"android.permission.MEDIA_CONTENT_CONTROL", "android.permission.MEDIA_ROUTING_CONTROL"})
    public void setRouteVolume(@NonNull MediaRoute2Info route, int volume) {
        Objects.requireNonNull(route, "route must not be null");
        this.mImpl.setRouteVolume(route, volume);
    }

    void syncRoutesOnHandler(List<MediaRoute2Info> currentRoutes, RoutingSessionInfo currentSystemSessionInfo) {
        if (currentRoutes == null || currentRoutes.isEmpty() || currentSystemSessionInfo == null) {
            Log.e(TAG, "syncRoutesOnHandler: Received wrong data. currentRoutes=" + currentRoutes + ", currentSystemSessionInfo=" + currentSystemSessionInfo);
            return;
        }
        this.updateRoutesOnHandler(currentRoutes);
        RoutingSessionInfo oldInfo = this.mSystemController.getRoutingSessionInfo();
        this.mSystemController.setRoutingSessionInfo(MediaRouter2.ensureClientPackageNameForSystemSession(currentSystemSessionInfo, this.mContext.getPackageName()));
        if (!oldInfo.equals(currentSystemSessionInfo)) {
            this.notifyControllerUpdated(this.mSystemController);
        }
    }

    void dispatchFilteredRoutesUpdatedOnHandler(List<MediaRoute2Info> newRoutes) {
        ArrayList<MediaRoute2Info> addedRoutes = new ArrayList<MediaRoute2Info>();
        ArrayList<MediaRoute2Info> removedRoutes = new ArrayList<MediaRoute2Info>();
        ArrayList<MediaRoute2Info> changedRoutes = new ArrayList<MediaRoute2Info>();
        Set newRouteIds = newRoutes.stream().map(MediaRoute2Info::getId).collect(Collectors.toSet());
        for (MediaRoute2Info route : newRoutes) {
            MediaRoute2Info prevRoute = this.mPreviousFilteredRoutes.get(route.getId());
            if (prevRoute == null) {
                addedRoutes.add(route);
                continue;
            }
            if (prevRoute.equals(route)) continue;
            changedRoutes.add(route);
        }
        for (int i = 0; i < this.mPreviousFilteredRoutes.size(); ++i) {
            if (newRouteIds.contains(this.mPreviousFilteredRoutes.keyAt(i))) continue;
            removedRoutes.add(this.mPreviousFilteredRoutes.valueAt(i));
        }
        for (MediaRoute2Info route : removedRoutes) {
            this.mPreviousFilteredRoutes.remove(route.getId());
        }
        for (MediaRoute2Info route : addedRoutes) {
            this.mPreviousFilteredRoutes.put(route.getId(), route);
        }
        for (MediaRoute2Info route : changedRoutes) {
            this.mPreviousFilteredRoutes.put(route.getId(), route);
        }
        if (!addedRoutes.isEmpty()) {
            this.notifyRoutesAdded(addedRoutes);
        }
        if (!removedRoutes.isEmpty()) {
            this.notifyRoutesRemoved(removedRoutes);
        }
        if (!changedRoutes.isEmpty()) {
            this.notifyRoutesChanged(changedRoutes);
        }
        if (!(addedRoutes.isEmpty() && removedRoutes.isEmpty() && changedRoutes.isEmpty())) {
            this.notifyRoutesUpdated(newRoutes);
        }
    }

    void dispatchControllerUpdatedIfNeededOnHandler(Map<String, MediaRoute2Info> routesMap) {
        List<RoutingController> controllers = this.getControllers();
        block0: for (RoutingController controller : controllers) {
            for (String selectedRoute : controller.getRoutingSessionInfo().getSelectedRoutes()) {
                MediaRoute2Info oldRoute;
                MediaRoute2Info currentRoute;
                if (!routesMap.containsKey(selectedRoute) || !this.mPreviousUnfilteredRoutes.containsKey(selectedRoute) || (currentRoute = routesMap.get(selectedRoute)).equals(oldRoute = this.mPreviousUnfilteredRoutes.get(selectedRoute))) continue;
                this.notifyControllerUpdated(controller);
                continue block0;
            }
        }
        this.mPreviousUnfilteredRoutes.clear();
        this.mPreviousUnfilteredRoutes.putAll(routesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoutesOnHandler(List<MediaRoute2Info> newRoutes) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRoutes.clear();
            for (MediaRoute2Info route : newRoutes) {
                this.mRoutes.put(route.getId(), route);
            }
            this.updateFilteredRoutesLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    void updateFilteredRoutesLocked() {
        this.mFilteredRoutes = Collections.unmodifiableList(this.filterRoutesWithCompositePreferenceLocked(List.copyOf(this.mRoutes.values())));
        this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::dispatchFilteredRoutesUpdatedOnHandler, this, this.mFilteredRoutes));
        this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::dispatchControllerUpdatedIfNeededOnHandler, this, new HashMap<String, MediaRoute2Info>(this.mRoutes)));
    }

    void createControllerOnHandler(int requestId, @Nullable RoutingSessionInfo sessionInfo) {
        ControllerCreationRequest matchingRequest = null;
        for (ControllerCreationRequest request : this.mControllerCreationRequests) {
            if (request.mRequestId != requestId) continue;
            matchingRequest = request;
            break;
        }
        if (matchingRequest == null) {
            Log.w(TAG, "createControllerOnHandler: Ignoring an unknown request.");
            return;
        }
        this.mControllerCreationRequests.remove(matchingRequest);
        MediaRoute2Info requestedRoute = matchingRequest.mRoute;
        if (sessionInfo == null) {
            this.notifyTransferFailure(requestedRoute);
            return;
        }
        if (!TextUtils.equals(requestedRoute.getProviderId(), sessionInfo.getProviderId())) {
            Log.w(TAG, "The session's provider ID does not match the requested route's. (requested route's providerId=" + requestedRoute.getProviderId() + ", actual providerId=" + sessionInfo.getProviderId() + ")");
            this.notifyTransferFailure(requestedRoute);
            return;
        }
        RoutingController oldController = matchingRequest.mOldController;
        if (!oldController.scheduleRelease()) {
            Log.w(TAG, "createControllerOnHandler: Ignoring controller creation for released old controller. oldController=" + oldController);
            if (!sessionInfo.isSystemSession()) {
                new RoutingController(sessionInfo).release();
            }
            this.notifyTransferFailure(requestedRoute);
            return;
        }
        RoutingController newController = this.addRoutingController(sessionInfo);
        this.notifyTransfer(oldController, newController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private RoutingController addRoutingController(@NonNull RoutingSessionInfo session) {
        RoutingController controller;
        if (session.isSystemSession()) {
            this.mSystemController.setRoutingSessionInfo(session);
            controller = this.mSystemController;
        } else {
            controller = new RoutingController(session);
            Object object = this.mLock;
            synchronized (object) {
                this.mNonSystemRoutingControllers.put(controller.getId(), controller);
            }
        }
        return controller;
    }

    void updateControllerOnHandler(RoutingSessionInfo sessionInfo) {
        if (sessionInfo == null) {
            Log.w(TAG, "updateControllerOnHandler: Ignoring null sessionInfo.");
            return;
        }
        RoutingController controller = this.getMatchingController(sessionInfo, "updateControllerOnHandler");
        if (controller != null) {
            if (Flags.enableMirroringInMediaRouter2()) {
                sessionInfo = MediaRouter2.ensureClientPackageNameForSystemSession(sessionInfo, this.mImpl.getClientPackageName());
            }
            controller.setRoutingSessionInfo(sessionInfo);
            this.notifyControllerUpdated(controller);
        }
    }

    void releaseControllerOnHandler(RoutingSessionInfo sessionInfo) {
        if (sessionInfo == null) {
            Log.w(TAG, "releaseControllerOnHandler: Ignoring null sessionInfo.");
            return;
        }
        RoutingController matchingController = this.getMatchingController(sessionInfo, "releaseControllerOnHandler");
        if (matchingController != null) {
            matchingController.releaseInternal(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RoutingController getMatchingController(RoutingSessionInfo sessionInfo, String logPrefix) {
        RoutingController controller;
        if (sessionInfo.isSystemSession()) {
            return this.getSystemController();
        }
        Object object = this.mLock;
        synchronized (object) {
            controller = this.mNonSystemRoutingControllers.get(sessionInfo.getId());
        }
        if (controller == null) {
            Log.w(TAG, logPrefix + ": Matching controller not found. uniqueSessionId=" + sessionInfo.getId());
            return null;
        }
        RoutingSessionInfo oldInfo = controller.getRoutingSessionInfo();
        if (!TextUtils.equals(oldInfo.getProviderId(), sessionInfo.getProviderId())) {
            Log.w(TAG, logPrefix + ": Provider IDs are not matched. old=" + oldInfo.getProviderId() + ", new=" + sessionInfo.getProviderId());
            return null;
        }
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRequestCreateControllerByManagerOnHandler(RoutingSessionInfo oldSession, MediaRoute2Info route, long managerRequestId) {
        RoutingController controller;
        Log.i(TAG, TextUtils.formatSimple("requestCreateSessionByManager | requestId: %d, oldSession: %s, route: %s", managerRequestId, oldSession, route));
        String oldSessionId = oldSession.getId();
        if (oldSession.isSystemSession()) {
            controller = this.getSystemController();
        } else {
            Object object = this.mLock;
            synchronized (object) {
                controller = this.mNonSystemRoutingControllers.get(oldSessionId);
            }
        }
        if (controller == null) {
            Log.w(TAG, TextUtils.formatSimple("Ignoring requestCreateSessionByManager (requestId: %d) because no controller for old session (id: %s) was found.", managerRequestId, oldSessionId));
            return;
        }
        this.requestCreateController(controller, route, managerRequestId);
    }

    private List<MediaRoute2Info> getSortedRoutes(List<MediaRoute2Info> routes, List<String> packageOrder) {
        if (packageOrder.isEmpty()) {
            return routes;
        }
        ArrayMap<String, Integer> packagePriority = new ArrayMap<String, Integer>();
        int count = packageOrder.size();
        for (int i = 0; i < count; ++i) {
            packagePriority.put(packageOrder.get(i), count - i);
        }
        ArrayList<MediaRoute2Info> sortedRoutes = new ArrayList<MediaRoute2Info>(routes);
        sortedRoutes.sort(Comparator.comparingInt(r -> -packagePriority.getOrDefault(r.getProviderPackageName(), 0).intValue()));
        return sortedRoutes;
    }

    @GuardedBy(value={"mLock"})
    private List<MediaRoute2Info> filterRoutesWithCompositePreferenceLocked(List<MediaRoute2Info> routes) {
        ArraySet<String> deduplicationIdSet = new ArraySet<String>();
        ArrayList<MediaRoute2Info> filteredRoutes = new ArrayList<MediaRoute2Info>();
        for (MediaRoute2Info route : this.getSortedRoutes(routes, this.mDiscoveryPreference.getDeduplicationPackageOrder())) {
            if (!route.hasAnyFeatures(this.mDiscoveryPreference.getPreferredFeatures()) || !this.mDiscoveryPreference.getAllowedPackages().isEmpty() && (route.getProviderPackageName() == null || !this.mDiscoveryPreference.getAllowedPackages().contains(route.getProviderPackageName()))) continue;
            if (this.mDiscoveryPreference.shouldRemoveDuplicates()) {
                if (!Collections.disjoint(deduplicationIdSet, route.getDeduplicationIds())) continue;
                deduplicationIdSet.addAll(route.getDeduplicationIds());
            }
            filteredRoutes.add(route);
        }
        return filteredRoutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private List<MediaRoute2Info> getRoutesWithIds(@NonNull List<String> routeIds) {
        Object object = this.mLock;
        synchronized (object) {
            return routeIds.stream().map(this.mRoutes::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    private void notifyRoutesAdded(List<MediaRoute2Info> routes) {
        for (RouteCallbackRecord record : this.mRouteCallbackRecords) {
            List<MediaRoute2Info> filteredRoutes = this.mImpl.filterRoutesWithIndividualPreference(routes, record.mPreference);
            if (filteredRoutes.isEmpty()) continue;
            record.mExecutor.execute(() -> record.mRouteCallback.onRoutesAdded(filteredRoutes));
        }
    }

    private void notifyRoutesRemoved(List<MediaRoute2Info> routes) {
        for (RouteCallbackRecord record : this.mRouteCallbackRecords) {
            List<MediaRoute2Info> filteredRoutes = this.mImpl.filterRoutesWithIndividualPreference(routes, record.mPreference);
            if (filteredRoutes.isEmpty()) continue;
            record.mExecutor.execute(() -> record.mRouteCallback.onRoutesRemoved(filteredRoutes));
        }
    }

    private void notifyRoutesChanged(List<MediaRoute2Info> routes) {
        for (RouteCallbackRecord record : this.mRouteCallbackRecords) {
            List<MediaRoute2Info> filteredRoutes = this.mImpl.filterRoutesWithIndividualPreference(routes, record.mPreference);
            if (filteredRoutes.isEmpty()) continue;
            record.mExecutor.execute(() -> record.mRouteCallback.onRoutesChanged(filteredRoutes));
        }
    }

    private void notifyRoutesUpdated(List<MediaRoute2Info> routes) {
        for (RouteCallbackRecord record : this.mRouteCallbackRecords) {
            List<MediaRoute2Info> filteredRoutes = this.mImpl.filterRoutesWithIndividualPreference(routes, record.mPreference);
            record.mExecutor.execute(() -> record.mRouteCallback.onRoutesUpdated(filteredRoutes));
        }
    }

    private void notifyPreferredFeaturesChanged(List<String> features) {
        for (RouteCallbackRecord record : this.mRouteCallbackRecords) {
            record.mExecutor.execute(() -> record.mRouteCallback.onPreferredFeaturesChanged(features));
        }
    }

    private void notifyRouteListingPreferenceUpdated(@Nullable RouteListingPreference preference) {
        for (RouteListingPreferenceCallbackRecord record : this.mListingPreferenceCallbackRecords) {
            record.mExecutor.execute(() -> record.mRouteListingPreferenceCallback.accept(preference));
        }
    }

    private void notifyDeviceSuggestionsUpdated(@NonNull String suggestingPackageName, @Nullable List<SuggestedDeviceInfo> deviceSuggestions) {
        for (DeviceSuggestionsUpdatesCallbackRecord record : this.mDeviceSuggestionsUpdatesCallbackRecords) {
            record.mExecutor.execute(() -> {
                if (deviceSuggestions != null) {
                    record.mDeviceSuggestionsUpdatesCallback.onSuggestionsUpdated(suggestingPackageName, deviceSuggestions);
                } else {
                    record.mDeviceSuggestionsUpdatesCallback.onSuggestionsCleared(suggestingPackageName);
                }
            });
        }
    }

    private void notifyCallbacksDeviceSuggestionRequested() {
        for (DeviceSuggestionsUpdatesCallbackRecord record : this.mDeviceSuggestionsUpdatesCallbackRecords) {
            record.mExecutor.execute(() -> record.mDeviceSuggestionsUpdatesCallback.onSuggestionsRequested());
        }
    }

    private void notifyTransfer(RoutingController oldController, RoutingController newController) {
        for (TransferCallbackRecord record : this.mTransferCallbackRecords) {
            record.mExecutor.execute(() -> record.mTransferCallback.onTransfer(oldController, newController));
        }
    }

    private void notifyTransferFailure(MediaRoute2Info route) {
        for (TransferCallbackRecord record : this.mTransferCallbackRecords) {
            record.mExecutor.execute(() -> record.mTransferCallback.onTransferFailure(route));
        }
    }

    private void notifyRequestFailed(int reason) {
        for (TransferCallbackRecord record : this.mTransferCallbackRecords) {
            record.mExecutor.execute(() -> record.mTransferCallback.onRequestFailed(reason));
        }
    }

    private void notifyStop(RoutingController controller) {
        for (TransferCallbackRecord record : this.mTransferCallbackRecords) {
            record.mExecutor.execute(() -> record.mTransferCallback.onStop(controller));
        }
    }

    private void notifyControllerUpdated(RoutingController controller) {
        for (ControllerCallbackRecord record : this.mControllerCallbackRecords) {
            record.mExecutor.execute(() -> record.mCallback.onControllerUpdated(controller));
        }
    }

    private static RoutingSessionInfo ensureClientPackageNameForSystemSession(@NonNull RoutingSessionInfo sessionInfo, @NonNull String packageName) {
        if (!sessionInfo.isSystemSession() || !TextUtils.isEmpty(sessionInfo.getClientPackageName())) {
            return sessionInfo;
        }
        return new RoutingSessionInfo.Builder(sessionInfo).setClientPackageName(packageName).build();
    }

    private static class PackageNameUserHandlePair
    extends Record {
        private final String packageName;
        private final UserHandle user;

        private PackageNameUserHandlePair(String packageName, UserHandle user) {
            this.packageName = packageName;
            this.user = user;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PackageNameUserHandlePair.class, "packageName;user", "packageName", "user"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackageNameUserHandlePair.class, "packageName;user", "packageName", "user"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackageNameUserHandlePair.class, "packageName;user", "packageName", "user"}, this, o);
        }

        public String packageName() {
            return this.packageName;
        }

        public UserHandle user() {
            return this.user;
        }
    }

    private static interface MediaRouter2Impl {
        public void updateScanningState(int var1) throws RemoteException;

        public void startScan();

        public void stopScan();

        public String getClientPackageName();

        public String getPackageName();

        public RoutingSessionInfo getSystemSessionInfo();

        public RouteCallbackRecord createRouteCallbackRecord(@NonNull Executor var1, @NonNull RouteCallback var2, @NonNull RouteDiscoveryPreference var3);

        public void registerRouteCallback();

        public void unregisterRouteCallback();

        public void setRouteListingPreference(@Nullable RouteListingPreference var1);

        public void setDeviceSuggestions(@Nullable List<SuggestedDeviceInfo> var1);

        @Nullable
        public Map<String, List<SuggestedDeviceInfo>> getDeviceSuggestions();

        public void notifyDeviceSuggestionRequested();

        public boolean showSystemOutputSwitcher(@Nullable MediaSession.Token var1);

        public List<MediaRoute2Info> getAllRoutes();

        public void setOnGetControllerHintsListener(OnGetControllerHintsListener var1);

        public void transferTo(MediaRoute2Info var1);

        public void stop();

        public void transfer(@NonNull RoutingSessionInfo var1, @NonNull MediaRoute2Info var2);

        public List<RoutingController> getControllers();

        public void setRouteVolume(MediaRoute2Info var1, int var2);

        public List<MediaRoute2Info> filterRoutesWithIndividualPreference(List<MediaRoute2Info> var1, RouteDiscoveryPreference var2);

        public void setSessionVolume(int var1, RoutingSessionInfo var2);

        public void selectRoute(MediaRoute2Info var1, RoutingSessionInfo var2);

        public void deselectRoute(MediaRoute2Info var1, RoutingSessionInfo var2);

        public void releaseSession(boolean var1, boolean var2, RoutingController var3);

        public boolean wasTransferredBySelf(RoutingSessionInfo var1);
    }

    private class ProxyMediaRouter2Impl
    implements MediaRouter2Impl {
        private final IMediaRouter2Manager.Stub mClient;
        private final CopyOnWriteArrayList<MediaRouter2Manager.TransferRequest> mTransferRequests = new CopyOnWriteArrayList();
        private final AtomicInteger mScanRequestCount = new AtomicInteger(0);
        @NonNull
        private final String mClientPackageName;
        @NonNull
        private final UserHandle mClientUser;
        private final AtomicBoolean mIsScanning = new AtomicBoolean(false);
        @GuardedBy(value={"mLock"})
        private final List<InstanceInvalidatedCallbackRecord> mInstanceInvalidatedCallbackRecords = new ArrayList<InstanceInvalidatedCallbackRecord>();

        ProxyMediaRouter2Impl(@NonNull Context context, @NonNull String clientPackageName, UserHandle user) {
            this.mClientUser = user;
            this.mClientPackageName = clientPackageName;
            this.mClient = new Client();
            MediaRouter2.this.mDiscoveryPreference = RouteDiscoveryPreference.EMPTY;
        }

        public void registerProxyRouter() {
            try {
                MediaRouter2.this.mMediaRouterService.registerProxyRouter(this.mClient, MediaRouter2.this.mContext.getApplicationContext().getPackageName(), this.mClientPackageName, this.mClientUser);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerInstanceInvalidatedCallback(@Nullable Executor executor, @Nullable Runnable onInstanceInvalidatedListener) {
            if (executor == null || onInstanceInvalidatedListener == null) {
                return;
            }
            InstanceInvalidatedCallbackRecord record = new InstanceInvalidatedCallbackRecord(executor, onInstanceInvalidatedListener);
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                if (!this.mInstanceInvalidatedCallbackRecords.contains(record)) {
                    this.mInstanceInvalidatedCallbackRecords.add(record);
                }
            }
        }

        @Override
        public void updateScanningState(int scanningState) throws RemoteException {
            MediaRouter2.this.mMediaRouterService.updateScanningState(this.mClient, scanningState);
        }

        @Override
        public void startScan() {
            if (!this.mIsScanning.getAndSet(true) && this.mScanRequestCount.getAndIncrement() == 0) {
                try {
                    MediaRouter2.this.mMediaRouterService.updateScanningState(this.mClient, 1);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public void stopScan() {
            if (this.mIsScanning.getAndSet(false) && this.mScanRequestCount.updateAndGet(count -> {
                if (count == 0) {
                    throw new IllegalStateException("No active scan requests to unregister.");
                }
                return --count;
            }) == 0) {
                try {
                    MediaRouter2.this.mMediaRouterService.updateScanningState(this.mClient, 0);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public String getClientPackageName() {
            return this.mClientPackageName;
        }

        @Override
        public String getPackageName() {
            return null;
        }

        @Override
        public RoutingSessionInfo getSystemSessionInfo() {
            return ProxyMediaRouter2Impl.getSystemSessionInfoImpl(MediaRouter2.this.mMediaRouterService, MediaRouter2.this.mContext.getPackageName(), this.mClientPackageName);
        }

        @Override
        public RouteCallbackRecord createRouteCallbackRecord(Executor executor, RouteCallback routeCallback, RouteDiscoveryPreference preference) {
            return new RouteCallbackRecord(executor, routeCallback, RouteDiscoveryPreference.EMPTY);
        }

        @Override
        public void registerRouteCallback() {
        }

        @Override
        public void unregisterRouteCallback() {
        }

        @Override
        public void setRouteListingPreference(@Nullable RouteListingPreference preference) {
            throw new UnsupportedOperationException("RouteListingPreference cannot be set by a proxy MediaRouter2 instance.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDeviceSuggestions(@Nullable List<SuggestedDeviceInfo> suggestedDeviceInfo) {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                try {
                    MediaRouter2.this.mMediaRouterService.setDeviceSuggestionsWithManager(this.mClient, suggestedDeviceInfo);
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public Map<String, List<SuggestedDeviceInfo>> getDeviceSuggestions() {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                try {
                    return MediaRouter2.this.mMediaRouterService.getDeviceSuggestionsWithManager(this.mClient);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public void notifyDeviceSuggestionRequested() {
            try {
                MediaRouter2.this.mMediaRouterService.onDeviceSuggestionRequestedWithManager(this.mClient);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        @Override
        public boolean showSystemOutputSwitcher(MediaSession.Token sessionToken) {
            try {
                return MediaRouter2.this.mMediaRouterService.showMediaOutputSwitcherWithProxyRouter(this.mClient, sessionToken);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<MediaRoute2Info> getAllRoutes() {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                return new ArrayList<MediaRoute2Info>(MediaRouter2.this.mRoutes.values());
            }
        }

        @Override
        public void setOnGetControllerHintsListener(OnGetControllerHintsListener listener) {
        }

        @Override
        public void transferTo(MediaRoute2Info route) {
            Objects.requireNonNull(route, "route must not be null");
            List<RoutingSessionInfo> sessionInfos = this.getRoutingSessions();
            RoutingSessionInfo targetSession = sessionInfos.get(sessionInfos.size() - 1);
            this.transfer(targetSession, route);
        }

        @Override
        public void stop() {
            List<RoutingSessionInfo> sessionInfos = this.getRoutingSessions();
            RoutingSessionInfo sessionToRelease = sessionInfos.get(sessionInfos.size() - 1);
            this.releaseSession(sessionToRelease);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transfer(@NonNull RoutingSessionInfo sessionInfo, @NonNull MediaRoute2Info route) {
            boolean isSystemRouteReselection;
            boolean isUnknownRoute;
            Objects.requireNonNull(sessionInfo, "sessionInfo must not be null");
            Objects.requireNonNull(route, "route must not be null");
            Log.v(MediaRouter2.TAG, "Transferring routing session. session= " + sessionInfo + ", route=" + route);
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                isUnknownRoute = !MediaRouter2.this.mRoutes.containsKey(route.getId());
            }
            if (isUnknownRoute) {
                Log.w(MediaRouter2.TAG, "transfer: Ignoring an unknown route id=" + route.getId());
                this.onTransferFailed(sessionInfo, route);
                return;
            }
            boolean bl = isSystemRouteReselection = Flags.enableBuiltInSpeakerRouteSuitabilityStatuses() && sessionInfo.isSystemSession() && route.isSystemRoute() && sessionInfo.getSelectedRoutes().contains(route.getId());
            if (sessionInfo.getTransferableRoutes().contains(route.getId()) || isSystemRouteReselection) {
                this.transferToRoute(sessionInfo, route, this.mClientUser, this.mClientPackageName);
            } else {
                boolean isTransferFromUserRouteToUnselectedSystemRoute;
                RoutingSessionInfo systemSessionInfo = MediaRouter2.this.mSystemController.getRoutingSessionInfo();
                boolean bl2 = isTransferFromUserRouteToUnselectedSystemRoute = !sessionInfo.isSystemSession() && route.isSystemRoute() && !systemSessionInfo.getSelectedRoutes().contains(route.getId());
                if (isTransferFromUserRouteToUnselectedSystemRoute) {
                    this.transferToRoute(systemSessionInfo, route, this.mClientUser, this.mClientPackageName);
                }
                this.requestCreateSession(sessionInfo, route);
            }
        }

        @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
        private void transferToRoute(@NonNull RoutingSessionInfo session, @NonNull MediaRoute2Info route, @NonNull UserHandle transferInitiatorUserHandle, @NonNull String transferInitiatorPackageName) {
            int requestId = this.createTransferRequest(session, route);
            try {
                MediaRouter2.this.mMediaRouterService.transferToRouteWithManager(this.mClient, requestId, session.getId(), route, transferInitiatorUserHandle, transferInitiatorPackageName);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        private void requestCreateSession(@NonNull RoutingSessionInfo oldSession, @NonNull MediaRoute2Info route) {
            if (TextUtils.isEmpty(oldSession.getClientPackageName())) {
                Log.w(MediaRouter2.TAG, "requestCreateSession: Can't create a session without package name.");
                this.onTransferFailed(oldSession, route);
                return;
            }
            int requestId = this.createTransferRequest(oldSession, route);
            try {
                MediaRouter2.this.mMediaRouterService.requestCreateSessionWithManager(this.mClient, requestId, oldSession, route);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        @Override
        public List<RoutingController> getControllers() {
            ArrayList<RoutingController> result = new ArrayList<RoutingController>();
            List<RoutingSessionInfo> sessions = this.getRoutingSessions();
            for (RoutingSessionInfo session : sessions) {
                RoutingController controller;
                if (session.isSystemSession()) {
                    MediaRouter2.this.mSystemController.setRoutingSessionInfo(session);
                    controller = MediaRouter2.this.mSystemController;
                } else {
                    controller = new RoutingController(session);
                }
                result.add(controller);
            }
            return result;
        }

        @Override
        public void setRouteVolume(@NonNull MediaRoute2Info route, int volume) {
            if (route.getVolumeHandling() == 0) {
                Log.w(MediaRouter2.TAG, "setRouteVolume: the route has fixed volume. Ignoring.");
                return;
            }
            if (volume < 0 || volume > route.getVolumeMax()) {
                Log.w(MediaRouter2.TAG, "setRouteVolume: the target volume is out of range. Ignoring");
                return;
            }
            try {
                int requestId = MediaRouter2.this.mNextRequestId.getAndIncrement();
                MediaRouter2.this.mMediaRouterService.setRouteVolumeWithManager(this.mClient, requestId, route, volume);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        @Override
        public void setSessionVolume(int volume, RoutingSessionInfo sessionInfo) {
            Objects.requireNonNull(sessionInfo, "sessionInfo must not be null");
            if (sessionInfo.getVolumeHandling() == 0) {
                Log.w(MediaRouter2.TAG, "setSessionVolume: the route has fixed volume. Ignoring.");
                return;
            }
            if (volume < 0 || volume > sessionInfo.getVolumeMax()) {
                Log.w(MediaRouter2.TAG, "setSessionVolume: the target volume is out of range. Ignoring");
                return;
            }
            try {
                int requestId = MediaRouter2.this.mNextRequestId.getAndIncrement();
                MediaRouter2.this.mMediaRouterService.setSessionVolumeWithManager(this.mClient, requestId, sessionInfo.getId(), volume);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        @Override
        public List<MediaRoute2Info> filterRoutesWithIndividualPreference(List<MediaRoute2Info> routes, RouteDiscoveryPreference discoveryPreference) {
            return new ArrayList<MediaRoute2Info>(routes);
        }

        @Override
        public void selectRoute(MediaRoute2Info route, RoutingSessionInfo sessionInfo) {
            Objects.requireNonNull(sessionInfo, "sessionInfo must not be null");
            Objects.requireNonNull(route, "route must not be null");
            if (sessionInfo.getSelectedRoutes().contains(route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring selecting a route that is already selected. route=" + route);
                return;
            }
            if (!sessionInfo.getSelectableRoutes().contains(route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring selecting a non-selectable route=" + route);
                return;
            }
            try {
                int requestId = MediaRouter2.this.mNextRequestId.getAndIncrement();
                MediaRouter2.this.mMediaRouterService.selectRouteWithManager(this.mClient, requestId, sessionInfo.getId(), route);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        @Override
        public void deselectRoute(MediaRoute2Info route, RoutingSessionInfo sessionInfo) {
            Objects.requireNonNull(sessionInfo, "sessionInfo must not be null");
            Objects.requireNonNull(route, "route must not be null");
            if (!sessionInfo.getSelectedRoutes().contains(route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring deselecting a route that is not selected. route=" + route);
                return;
            }
            if (!sessionInfo.getDeselectableRoutes().contains(route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring deselecting a non-deselectable route=" + route);
                return;
            }
            try {
                int requestId = MediaRouter2.this.mNextRequestId.getAndIncrement();
                MediaRouter2.this.mMediaRouterService.deselectRouteWithManager(this.mClient, requestId, sessionInfo.getId(), route);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        @Override
        public void releaseSession(boolean shouldReleaseSession, boolean shouldNotifyStop, RoutingController controller) {
            this.releaseSession(controller.getRoutingSessionInfo());
        }

        @Override
        public boolean wasTransferredBySelf(RoutingSessionInfo sessionInfo) {
            UserHandle transferInitiatorUserHandle = sessionInfo.getTransferInitiatorUserHandle();
            String transferInitiatorPackageName = sessionInfo.getTransferInitiatorPackageName();
            return Objects.equals(this.mClientUser, transferInitiatorUserHandle) && Objects.equals(this.mClientPackageName, transferInitiatorPackageName);
        }

        static RoutingSessionInfo getSystemSessionInfoImpl(@NonNull IMediaRouterService service, @NonNull String callerPackageName, @NonNull String clientPackageName) {
            try {
                return service.getSystemSessionInfoForPackage(callerPackageName, clientPackageName);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        private void releaseSession(@NonNull RoutingSessionInfo sessionInfo) {
            Objects.requireNonNull(sessionInfo, "sessionInfo must not be null");
            try {
                int requestId = MediaRouter2.this.mNextRequestId.getAndIncrement();
                MediaRouter2.this.mMediaRouterService.releaseSessionWithManager(this.mClient, requestId, sessionInfo.getId());
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        private int createTransferRequest(@NonNull RoutingSessionInfo session, @NonNull MediaRoute2Info route) {
            int requestId = MediaRouter2.this.mNextRequestId.getAndIncrement();
            MediaRouter2Manager.TransferRequest transferRequest = new MediaRouter2Manager.TransferRequest(requestId, session, route);
            this.mTransferRequests.add(transferRequest);
            Message timeoutMessage = PooledLambda.obtainMessage(ProxyMediaRouter2Impl::handleTransferTimeout, this, transferRequest);
            MediaRouter2.this.mHandler.sendMessageDelayed(timeoutMessage, 30000L);
            return requestId;
        }

        private void handleTransferTimeout(MediaRouter2Manager.TransferRequest request) {
            boolean removed = this.mTransferRequests.remove(request);
            if (removed) {
                this.onTransferFailed(request.mOldSessionInfo, request.mTargetRoute);
            }
        }

        @NonNull
        private List<RoutingSessionInfo> getRoutingSessions() {
            List<RoutingSessionInfo> remoteSessions;
            ArrayList<RoutingSessionInfo> sessions = new ArrayList<RoutingSessionInfo>();
            sessions.add(this.getSystemSessionInfo());
            try {
                remoteSessions = MediaRouter2.this.mMediaRouterService.getRemoteSessions(this.mClient);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            for (RoutingSessionInfo sessionInfo : remoteSessions) {
                if (!TextUtils.equals(sessionInfo.getClientPackageName(), this.mClientPackageName)) continue;
                sessions.add(sessionInfo);
            }
            return sessions;
        }

        private void onTransferred(@NonNull RoutingSessionInfo oldSession, @NonNull RoutingSessionInfo newSession) {
            RoutingController newController;
            RoutingController oldController;
            if (!this.isSessionRelatedToTargetPackageName(oldSession) || !this.isSessionRelatedToTargetPackageName(newSession)) {
                return;
            }
            if (oldSession.isSystemSession()) {
                MediaRouter2.this.mSystemController.setRoutingSessionInfo(MediaRouter2.ensureClientPackageNameForSystemSession(oldSession, this.mClientPackageName));
                oldController = MediaRouter2.this.mSystemController;
            } else {
                oldController = new RoutingController(oldSession);
            }
            if (newSession.isSystemSession()) {
                MediaRouter2.this.mSystemController.setRoutingSessionInfo(MediaRouter2.ensureClientPackageNameForSystemSession(newSession, this.mClientPackageName));
                newController = MediaRouter2.this.mSystemController;
            } else {
                newController = new RoutingController(newSession);
            }
            MediaRouter2.this.notifyTransfer(oldController, newController);
        }

        private void onTransferFailed(@NonNull RoutingSessionInfo session, @NonNull MediaRoute2Info route) {
            if (!this.isSessionRelatedToTargetPackageName(session)) {
                return;
            }
            MediaRouter2.this.notifyTransferFailure(route);
        }

        private void onSessionUpdated(@NonNull RoutingSessionInfo session) {
            RoutingController controller;
            if (!this.isSessionRelatedToTargetPackageName(session)) {
                return;
            }
            if (session.isSystemSession()) {
                MediaRouter2.this.mSystemController.setRoutingSessionInfo(MediaRouter2.ensureClientPackageNameForSystemSession(session, this.mClientPackageName));
                controller = MediaRouter2.this.mSystemController;
            } else {
                controller = new RoutingController(session);
            }
            MediaRouter2.this.notifyControllerUpdated(controller);
        }

        private boolean isSessionRelatedToTargetPackageName(@NonNull RoutingSessionInfo session) {
            return session.isSystemSession() || TextUtils.equals(this.getClientPackageName(), session.getClientPackageName());
        }

        private void onSessionCreatedOnHandler(int requestId, @NonNull RoutingSessionInfo sessionInfo) {
            MediaRouter2Manager.TransferRequest matchingRequest = null;
            for (MediaRouter2Manager.TransferRequest request : this.mTransferRequests) {
                if (request.mRequestId != requestId) continue;
                matchingRequest = request;
                break;
            }
            if (matchingRequest == null) {
                return;
            }
            this.mTransferRequests.remove(matchingRequest);
            MediaRoute2Info requestedRoute = matchingRequest.mTargetRoute;
            if (!sessionInfo.getSelectedRoutes().contains(requestedRoute.getId())) {
                Log.w(MediaRouter2.TAG, "The session does not contain the requested route. (requestedRouteId=" + requestedRoute.getId() + ", actualRoutes=" + sessionInfo.getSelectedRoutes() + ")");
                this.onTransferFailed(matchingRequest.mOldSessionInfo, requestedRoute);
            } else if (!TextUtils.equals(requestedRoute.getProviderId(), sessionInfo.getProviderId())) {
                Log.w(MediaRouter2.TAG, "The session's provider ID does not match the requested route's. (requested route's providerId=" + requestedRoute.getProviderId() + ", actual providerId=" + sessionInfo.getProviderId() + ")");
                this.onTransferFailed(matchingRequest.mOldSessionInfo, requestedRoute);
            } else {
                this.onTransferred(matchingRequest.mOldSessionInfo, sessionInfo);
            }
        }

        private void onSessionUpdatedOnHandler(@NonNull RoutingSessionInfo updatedSession) {
            for (MediaRouter2Manager.TransferRequest request : this.mTransferRequests) {
                String sessionId = request.mOldSessionInfo.getId();
                if (!TextUtils.equals(sessionId, updatedSession.getId()) || !updatedSession.getSelectedRoutes().contains(request.mTargetRoute.getId())) continue;
                this.mTransferRequests.remove(request);
                break;
            }
            this.onSessionUpdated(updatedSession);
        }

        private void onSessionReleasedOnHandler(@NonNull RoutingSessionInfo session) {
            if (session.isSystemSession()) {
                Log.e(MediaRouter2.TAG, "onSessionReleasedOnHandler: Called on system session. Ignoring.");
                return;
            }
            if (!TextUtils.equals(this.getClientPackageName(), session.getClientPackageName())) {
                return;
            }
            MediaRouter2.this.notifyStop(new RoutingController(session, 3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDiscoveryPreferenceChangedOnHandler(@NonNull String packageName, @Nullable RouteDiscoveryPreference preference) {
            if (!TextUtils.equals(this.getClientPackageName(), packageName)) {
                return;
            }
            if (preference == null) {
                return;
            }
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                if (Objects.equals(preference, MediaRouter2.this.mDiscoveryPreference)) {
                    return;
                }
                MediaRouter2.this.mDiscoveryPreference = preference;
                MediaRouter2.this.updateFilteredRoutesLocked();
            }
            MediaRouter2.this.notifyPreferredFeaturesChanged(preference.getPreferredFeatures());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRouteListingPreferenceChangedOnHandler(@NonNull String packageName, @Nullable RouteListingPreference routeListingPreference) {
            if (!TextUtils.equals(this.getClientPackageName(), packageName)) {
                return;
            }
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                if (Objects.equals(MediaRouter2.this.mRouteListingPreference, routeListingPreference)) {
                    return;
                }
                MediaRouter2.this.mRouteListingPreference = routeListingPreference;
            }
            MediaRouter2.this.notifyRouteListingPreferenceUpdated(routeListingPreference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDeviceSuggestionsChangeHandler(@NonNull String packageName, @NonNull String suggestingPackageName, @Nullable List<SuggestedDeviceInfo> suggestedDeviceInfo) {
            if (!TextUtils.equals(this.getClientPackageName(), packageName)) {
                return;
            }
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                if (Objects.equals(MediaRouter2.this.mSuggestedDeviceInfo.get(suggestingPackageName), suggestedDeviceInfo)) {
                    return;
                }
                MediaRouter2.this.mSuggestedDeviceInfo.put(suggestingPackageName, suggestedDeviceInfo);
            }
            MediaRouter2.this.notifyDeviceSuggestionsUpdated(suggestingPackageName, suggestedDeviceInfo);
        }

        private void notifyDeviceSuggestionRequestedHandler() {
            MediaRouter2.this.notifyCallbacksDeviceSuggestionRequested();
        }

        private void onRequestFailedOnHandler(int requestId, int reason) {
            MediaRouter2Manager.TransferRequest matchingRequest = null;
            for (MediaRouter2Manager.TransferRequest request : this.mTransferRequests) {
                if (request.mRequestId != requestId) continue;
                matchingRequest = request;
                break;
            }
            if (matchingRequest != null) {
                this.mTransferRequests.remove(matchingRequest);
                this.onTransferFailed(matchingRequest.mOldSessionInfo, matchingRequest.mTargetRoute);
            } else {
                MediaRouter2.this.notifyRequestFailed(reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onInvalidateInstanceOnHandler() {
            Log.w(MediaRouter2.TAG, "MEDIA_ROUTING_CONTROL has been revoked for this package. Invalidating instance.");
            Object object = sSystemRouterLock;
            synchronized (object) {
                PackageNameUserHandlePair key = new PackageNameUserHandlePair(this.mClientPackageName, this.mClientUser);
                sAppToProxyRouterMap.remove(key);
            }
            object = MediaRouter2.this.mLock;
            synchronized (object) {
                for (InstanceInvalidatedCallbackRecord record : this.mInstanceInvalidatedCallbackRecords) {
                    record.executor.execute(record.runnable);
                }
            }
            MediaRouter2.this.mRouteCallbackRecords.clear();
            MediaRouter2.this.mControllerCallbackRecords.clear();
            MediaRouter2.this.mTransferCallbackRecords.clear();
        }

        private class Client
        extends IMediaRouter2Manager.Stub {
            private Client() {
            }

            @Override
            public void notifySessionCreated(int requestId, RoutingSessionInfo routingSessionInfo) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onSessionCreatedOnHandler, ProxyMediaRouter2Impl.this, requestId, routingSessionInfo));
            }

            @Override
            public void notifySessionUpdated(RoutingSessionInfo routingSessionInfo) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onSessionUpdatedOnHandler, ProxyMediaRouter2Impl.this, routingSessionInfo));
            }

            @Override
            public void notifySessionReleased(RoutingSessionInfo routingSessionInfo) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onSessionReleasedOnHandler, ProxyMediaRouter2Impl.this, routingSessionInfo));
            }

            @Override
            public void notifyDiscoveryPreferenceChanged(String packageName, RouteDiscoveryPreference routeDiscoveryPreference) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onDiscoveryPreferenceChangedOnHandler, ProxyMediaRouter2Impl.this, packageName, routeDiscoveryPreference));
            }

            @Override
            public void notifyRouteListingPreferenceChange(String packageName, RouteListingPreference routeListingPreference) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onRouteListingPreferenceChangedOnHandler, ProxyMediaRouter2Impl.this, packageName, routeListingPreference));
            }

            @Override
            public void notifyDeviceSuggestionsUpdated(String packageName, String suggestingPackageName, @Nullable List<SuggestedDeviceInfo> deviceSuggestions) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onDeviceSuggestionsChangeHandler, ProxyMediaRouter2Impl.this, packageName, suggestingPackageName, deviceSuggestions));
            }

            @Override
            public void notifyDeviceSuggestionRequested() {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::notifyDeviceSuggestionRequestedHandler, ProxyMediaRouter2Impl.this));
            }

            @Override
            public void notifyRoutesUpdated(List<MediaRoute2Info> routes) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::updateRoutesOnHandler, MediaRouter2.this, routes));
            }

            @Override
            public void notifyRequestFailed(int requestId, int reason) {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onRequestFailedOnHandler, ProxyMediaRouter2Impl.this, requestId, reason));
            }

            @Override
            public void invalidateInstance() {
                MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(ProxyMediaRouter2Impl::onInvalidateInstanceOnHandler, ProxyMediaRouter2Impl.this));
            }
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_screen_off_scanning")
    public static class ScanToken {
        private final int mId;

        private ScanToken(int id2) {
            this.mId = id2;
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_screen_off_scanning")
    public static class ScanRequest {
        private final boolean mIsScreenOffScan;

        private ScanRequest(boolean isScreenOffScan) {
            this.mIsScreenOffScan = isScreenOffScan;
        }

        public boolean isScreenOffScan() {
            return this.mIsScreenOffScan;
        }

        public static class Builder {
            boolean mIsScreenOffScan;

            @NonNull
            public Builder setScreenOffScan(boolean isScreenOffScan) {
                this.mIsScreenOffScan = isScreenOffScan;
                return this;
            }

            @NonNull
            public ScanRequest build() {
                return new ScanRequest(this.mIsScreenOffScan);
            }
        }
    }

    private class LocalMediaRouter2Impl
    implements MediaRouter2Impl {
        private final String mPackageName;

        LocalMediaRouter2Impl(String packageName) {
            this.mPackageName = packageName;
        }

        @Override
        public void startScan() {
        }

        @Override
        public void stopScan() {
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void updateScanningState(int scanningState) throws RemoteException {
            if (scanningState != 0) {
                this.registerRouterStubIfNeededLocked();
            }
            MediaRouter2.this.mMediaRouterService.updateScanningStateWithRouter2(MediaRouter2.this.mStub, scanningState);
            if (scanningState == 0) {
                this.unregisterRouterStubIfNeededLocked(true);
            }
        }

        @Override
        public String getClientPackageName() {
            return Flags.enableMirroringInMediaRouter2() ? this.mPackageName : null;
        }

        @Override
        public String getPackageName() {
            return this.mPackageName;
        }

        @Override
        public RoutingSessionInfo getSystemSessionInfo() {
            RoutingSessionInfo currentSystemSessionInfo = null;
            try {
                currentSystemSessionInfo = MediaRouter2.ensureClientPackageNameForSystemSession(MediaRouter2.this.mMediaRouterService.getSystemSessionInfo(), MediaRouter2.this.mContext.getPackageName());
            }
            catch (RemoteException ex) {
                ex.rethrowFromSystemServer();
            }
            return currentSystemSessionInfo;
        }

        @Override
        public RouteCallbackRecord createRouteCallbackRecord(Executor executor, RouteCallback routeCallback, RouteDiscoveryPreference preference) {
            return new RouteCallbackRecord(executor, routeCallback, preference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerRouteCallback() {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                try {
                    this.registerRouterStubIfNeededLocked();
                    if (MediaRouter2.this.updateDiscoveryPreferenceIfNeededLocked()) {
                        MediaRouter2.this.mMediaRouterService.setDiscoveryRequestWithRouter2(MediaRouter2.this.mStub, MediaRouter2.this.mDiscoveryPreference);
                    }
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterRouteCallback() {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                if (MediaRouter2.this.mStub == null) {
                    return;
                }
                try {
                    if (MediaRouter2.this.updateDiscoveryPreferenceIfNeededLocked()) {
                        MediaRouter2.this.mMediaRouterService.setDiscoveryRequestWithRouter2(MediaRouter2.this.mStub, MediaRouter2.this.mDiscoveryPreference);
                    }
                    this.unregisterRouterStubIfNeededLocked(false);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter2.TAG, "unregisterRouteCallback: Unable to set discovery request.", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRouteListingPreference(@Nullable RouteListingPreference preference) {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                if (Objects.equals(MediaRouter2.this.mRouteListingPreference, preference)) {
                    return;
                }
                MediaRouter2.this.mRouteListingPreference = preference;
                try {
                    this.registerRouterStubIfNeededLocked();
                    MediaRouter2.this.mMediaRouterService.setRouteListingPreference(MediaRouter2.this.mStub, MediaRouter2.this.mRouteListingPreference);
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
                MediaRouter2.this.notifyRouteListingPreferenceUpdated(preference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDeviceSuggestions(@Nullable List<SuggestedDeviceInfo> deviceSuggestions) {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                try {
                    this.registerRouterStubIfNeededLocked();
                    MediaRouter2.this.mMediaRouterService.setDeviceSuggestionsWithRouter2(MediaRouter2.this.mStub, deviceSuggestions);
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
            }
        }

        @Override
        @Nullable
        public Map<String, List<SuggestedDeviceInfo>> getDeviceSuggestions() {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                try {
                    return MediaRouter2.this.mMediaRouterService.getDeviceSuggestionsWithRouter2(MediaRouter2.this.mStub);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public void notifyDeviceSuggestionRequested() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean showSystemOutputSwitcher(@Nullable MediaSession.Token sessionToken) {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                try {
                    return MediaRouter2.this.mMediaRouterService.showMediaOutputSwitcherWithRouter2(this.mPackageName, sessionToken);
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
            }
            return false;
        }

        @Override
        public List<MediaRoute2Info> getAllRoutes() {
            return Collections.emptyList();
        }

        @Override
        public void setOnGetControllerHintsListener(OnGetControllerHintsListener listener) {
            MediaRouter2.this.mOnGetControllerHintsListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transferTo(MediaRoute2Info route) {
            boolean routeFound;
            Log.v(MediaRouter2.TAG, "Transferring to route: " + route);
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                routeFound = MediaRouter2.this.mRoutes.containsKey(route.getId());
            }
            if (!routeFound) {
                MediaRouter2.this.notifyTransferFailure(route);
                return;
            }
            RoutingController controller = MediaRouter2.this.getCurrentController();
            if (!controller.tryTransferWithinProvider(route)) {
                MediaRouter2.this.requestCreateController(controller, route, 0L);
            }
        }

        @Override
        public void stop() {
            MediaRouter2.this.getCurrentController().release();
        }

        @Override
        public void transfer(@NonNull RoutingSessionInfo sessionInfo, @NonNull MediaRoute2Info route) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<RoutingController> getControllers() {
            ArrayList<RoutingController> result = new ArrayList<RoutingController>();
            result.add(0, MediaRouter2.this.mSystemController);
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                result.addAll(MediaRouter2.this.mNonSystemRoutingControllers.values());
            }
            return result;
        }

        @Override
        public void setRouteVolume(MediaRoute2Info route, int volume) {
            throw new UnsupportedOperationException("setRouteVolume is only supported by proxy routers. See javadoc.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSessionVolume(int volume, RoutingSessionInfo sessionInfo) {
            MediaRouter2Stub stub;
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                stub = MediaRouter2.this.mStub;
            }
            if (stub != null) {
                try {
                    MediaRouter2.this.mMediaRouterService.setSessionVolumeWithRouter2(stub, sessionInfo.getId(), volume);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter2.TAG, "setVolume: Failed to deliver request.", ex);
                }
            }
        }

        @Override
        public List<MediaRoute2Info> filterRoutesWithIndividualPreference(List<MediaRoute2Info> routes, RouteDiscoveryPreference discoveryPreference) {
            ArrayList<MediaRoute2Info> filteredRoutes = new ArrayList<MediaRoute2Info>();
            for (MediaRoute2Info route : routes) {
                if (!route.hasAnyFeatures(discoveryPreference.getPreferredFeatures()) || !discoveryPreference.getAllowedPackages().isEmpty() && (route.getProviderPackageName() == null || !discoveryPreference.getAllowedPackages().contains(route.getProviderPackageName()))) continue;
                filteredRoutes.add(route);
            }
            return filteredRoutes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectRoute(MediaRoute2Info route, RoutingSessionInfo sessionInfo) {
            MediaRouter2Stub stub;
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                stub = MediaRouter2.this.mStub;
            }
            if (stub != null) {
                try {
                    MediaRouter2.this.mMediaRouterService.selectRouteWithRouter2(stub, sessionInfo.getId(), route);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter2.TAG, "Unable to select route for session.", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deselectRoute(MediaRoute2Info route, RoutingSessionInfo sessionInfo) {
            MediaRouter2Stub stub;
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                stub = MediaRouter2.this.mStub;
            }
            if (stub != null) {
                try {
                    MediaRouter2.this.mMediaRouterService.deselectRouteWithRouter2(stub, sessionInfo.getId(), route);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter2.TAG, "Unable to deselect route from session.", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseSession(boolean shouldReleaseSession, boolean shouldNotifyStop, RoutingController controller) {
            Object object = MediaRouter2.this.mLock;
            synchronized (object) {
                MediaRouter2.this.mNonSystemRoutingControllers.remove(controller.getId(), controller);
                if (shouldReleaseSession && MediaRouter2.this.mStub != null) {
                    try {
                        MediaRouter2.this.mMediaRouterService.releaseSessionWithRouter2(MediaRouter2.this.mStub, controller.getId());
                    }
                    catch (RemoteException ex) {
                        ex.rethrowFromSystemServer();
                    }
                }
                if (shouldNotifyStop) {
                    MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::notifyStop, MediaRouter2.this, controller));
                }
                try {
                    this.unregisterRouterStubIfNeededLocked(false);
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public boolean wasTransferredBySelf(RoutingSessionInfo sessionInfo) {
            UserHandle transferInitiatorUserHandle = sessionInfo.getTransferInitiatorUserHandle();
            String transferInitiatorPackageName = sessionInfo.getTransferInitiatorPackageName();
            return Objects.equals(Process.myUserHandle(), transferInitiatorUserHandle) && Objects.equals(MediaRouter2.this.mContext.getPackageName(), transferInitiatorPackageName);
        }

        @GuardedBy(value={"mLock"})
        private void registerRouterStubIfNeededLocked() throws RemoteException {
            if (MediaRouter2.this.mStub == null) {
                MediaRouter2Stub stub = new MediaRouter2Stub();
                MediaRouter2.this.mMediaRouterService.registerRouter2(stub, this.mPackageName);
                MediaRouter2.this.mStub = stub;
            }
        }

        @GuardedBy(value={"mLock"})
        private void unregisterRouterStubIfNeededLocked(boolean isScanningStopping) throws RemoteException {
            if (MediaRouter2.this.mStub != null && MediaRouter2.this.mRouteCallbackRecords.isEmpty() && MediaRouter2.this.mNonSystemRoutingControllers.isEmpty() && (MediaRouter2.this.mScanRequestsMap.size() == 0 || isScanningStopping)) {
                MediaRouter2.this.mMediaRouterService.unregisterRouter2(MediaRouter2.this.mStub);
                MediaRouter2.this.mStub = null;
            }
        }
    }

    class SystemRoutingController
    extends RoutingController {
        SystemRoutingController(RoutingSessionInfo sessionInfo) {
            super(sessionInfo);
        }

        @Override
        public boolean isReleased() {
            return false;
        }

        @Override
        boolean scheduleRelease() {
            return true;
        }

        @Override
        void releaseInternal(boolean shouldReleaseSession) {
            if (Flags.enableOutputSwitcherPersonalAudioSharing()) {
                MediaRouter2.this.mImpl.releaseSession(shouldReleaseSession, false, this);
            }
        }
    }

    public class RoutingController {
        private final Object mControllerLock = new Object();
        private static final int CONTROLLER_STATE_UNKNOWN = 0;
        private static final int CONTROLLER_STATE_ACTIVE = 1;
        private static final int CONTROLLER_STATE_RELEASING = 2;
        private static final int CONTROLLER_STATE_RELEASED = 3;
        @GuardedBy(value={"mControllerLock"})
        private RoutingSessionInfo mSessionInfo;
        @GuardedBy(value={"mControllerLock"})
        private int mState;

        RoutingController(RoutingSessionInfo sessionInfo) {
            this.mSessionInfo = sessionInfo;
            this.mState = 1;
        }

        RoutingController(RoutingSessionInfo sessionInfo, int state) {
            this.mSessionInfo = sessionInfo;
            this.mState = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public String getId() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mSessionInfo.getId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public String getOriginalId() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mSessionInfo.getOriginalId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Bundle getControlHints() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mSessionInfo.getControlHints();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public List<MediaRoute2Info> getSelectedRoutes() {
            List<String> selectedRouteIds;
            Object object = this.mControllerLock;
            synchronized (object) {
                selectedRouteIds = this.mSessionInfo.getSelectedRoutes();
            }
            return MediaRouter2.this.getRoutesWithIds(selectedRouteIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public List<MediaRoute2Info> getSelectableRoutes() {
            List<String> selectableRouteIds;
            Object object = this.mControllerLock;
            synchronized (object) {
                selectableRouteIds = this.mSessionInfo.getSelectableRoutes();
            }
            return MediaRouter2.this.getRoutesWithIds(selectableRouteIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public List<MediaRoute2Info> getDeselectableRoutes() {
            List<String> deselectableRouteIds;
            Object object = this.mControllerLock;
            synchronized (object) {
                deselectableRouteIds = this.mSessionInfo.getDeselectableRoutes();
            }
            return MediaRouter2.this.getRoutesWithIds(deselectableRouteIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FlaggedApi(value="com.android.media.flags.enable_get_transferable_routes")
        @NonNull
        public List<MediaRoute2Info> getTransferableRoutes() {
            List<String> transferableRoutes;
            Object object = this.mControllerLock;
            synchronized (object) {
                transferableRoutes = this.mSessionInfo.getTransferableRoutes();
            }
            return MediaRouter2.this.getRoutesWithIds(transferableRoutes);
        }

        @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
        public boolean wasTransferInitiatedBySelf() {
            return MediaRouter2.this.mImpl.wasTransferredBySelf(this.getRoutingSessionInfo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public RoutingSessionInfo getRoutingSessionInfo() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mSessionInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getVolumeHandling() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mSessionInfo.getVolumeHandling();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getVolumeMax() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mSessionInfo.getVolumeMax();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getVolume() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mSessionInfo.getVolume();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isReleased() {
            Object object = this.mControllerLock;
            synchronized (object) {
                return this.mState == 3;
            }
        }

        public void selectRoute(@NonNull MediaRoute2Info route) {
            Objects.requireNonNull(route, "route must not be null");
            if (this.isReleased()) {
                Log.w(MediaRouter2.TAG, "selectRoute: Called on released controller. Ignoring.");
                return;
            }
            List<MediaRoute2Info> selectedRoutes = this.getSelectedRoutes();
            if (RoutingController.containsRouteInfoWithId(selectedRoutes, route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring selecting a route that is already selected. route=" + route);
                return;
            }
            List<MediaRoute2Info> selectableRoutes = this.getSelectableRoutes();
            if (!RoutingController.containsRouteInfoWithId(selectableRoutes, route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring selecting a non-selectable route=" + route);
                return;
            }
            MediaRouter2.this.mImpl.selectRoute(route, this.getRoutingSessionInfo());
        }

        public void deselectRoute(@NonNull MediaRoute2Info route) {
            Objects.requireNonNull(route, "route must not be null");
            if (this.isReleased()) {
                Log.w(MediaRouter2.TAG, "deselectRoute: called on released controller. Ignoring.");
                return;
            }
            List<MediaRoute2Info> selectedRoutes = this.getSelectedRoutes();
            if (!RoutingController.containsRouteInfoWithId(selectedRoutes, route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring deselecting a route that is not selected. route=" + route);
                return;
            }
            List<MediaRoute2Info> deselectableRoutes = this.getDeselectableRoutes();
            if (!RoutingController.containsRouteInfoWithId(deselectableRoutes, route.getId())) {
                Log.w(MediaRouter2.TAG, "Ignoring deselecting a non-deselectable route=" + route);
                return;
            }
            MediaRouter2.this.mImpl.deselectRoute(route, this.getRoutingSessionInfo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean tryTransferWithinProvider(@NonNull MediaRoute2Info route) {
            MediaRouter2Stub stub;
            Objects.requireNonNull(route, "route must not be null");
            Object object = this.mControllerLock;
            synchronized (object) {
                boolean isSystemRouteReselection;
                if (this.isReleased()) {
                    Log.w(MediaRouter2.TAG, "tryTransferWithinProvider: Called on released controller. Ignoring.");
                    return true;
                }
                boolean bl = isSystemRouteReselection = Flags.enableBuiltInSpeakerRouteSuitabilityStatuses() && this.mSessionInfo.isSystemSession() && route.isSystemRoute() && this.mSessionInfo.getSelectedRoutes().contains(route.getId());
                if (!isSystemRouteReselection && !this.mSessionInfo.getTransferableRoutes().contains(route.getId())) {
                    Log.i(MediaRouter2.TAG, "Transferring to a non-transferable route=" + route + " session= " + this.mSessionInfo.getId());
                    return false;
                }
            }
            Object isSystemRouteReselection = MediaRouter2.this.mLock;
            synchronized (isSystemRouteReselection) {
                stub = MediaRouter2.this.mStub;
            }
            if (stub != null) {
                try {
                    MediaRouter2.this.mMediaRouterService.transferToRouteWithRouter2(stub, this.getId(), route);
                }
                catch (RemoteException ex) {
                    Log.e(MediaRouter2.TAG, "Unable to transfer to route for session.", ex);
                }
            }
            return true;
        }

        public void setVolume(int volume) {
            if (this.getVolumeHandling() == 0) {
                Log.w(MediaRouter2.TAG, "setVolume: The routing session has fixed volume. Ignoring.");
                return;
            }
            if (volume < 0 || volume > this.getVolumeMax()) {
                Log.w(MediaRouter2.TAG, "setVolume: The target volume is out of range. Ignoring");
                return;
            }
            if (this.isReleased()) {
                Log.w(MediaRouter2.TAG, "setVolume: Called on released controller. Ignoring.");
                return;
            }
            MediaRouter2.this.mImpl.setSessionVolume(volume, this.getRoutingSessionInfo());
        }

        public void release() {
            this.releaseInternal(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean scheduleRelease() {
            Object object = this.mControllerLock;
            synchronized (object) {
                if (this.mState != 1) {
                    return false;
                }
                this.mState = 2;
            }
            object = MediaRouter2.this.mLock;
            synchronized (object) {
                if (!MediaRouter2.this.mNonSystemRoutingControllers.remove(this.getId(), this)) {
                    return true;
                }
            }
            MediaRouter2.this.mHandler.postDelayed(this::release, 30000L);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseInternal(boolean shouldReleaseSession) {
            boolean shouldNotifyStop;
            Object object = this.mControllerLock;
            synchronized (object) {
                if (this.mState == 3) {
                    if (DEBUG) {
                        Log.d(MediaRouter2.TAG, "releaseInternal: Called on released controller. Ignoring.");
                    }
                    return;
                }
                shouldNotifyStop = this.mState == 1;
                this.mState = 3;
            }
            MediaRouter2.this.mImpl.releaseSession(shouldReleaseSession, shouldNotifyStop, this);
        }

        public String toString() {
            List selectedRoutes = this.getSelectedRoutes().stream().map(MediaRoute2Info::getId).collect(Collectors.toList());
            List selectableRoutes = this.getSelectableRoutes().stream().map(MediaRoute2Info::getId).collect(Collectors.toList());
            List deselectableRoutes = this.getDeselectableRoutes().stream().map(MediaRoute2Info::getId).collect(Collectors.toList());
            StringBuilder result = new StringBuilder().append("RoutingController{ ").append("id=").append(this.getId()).append(", selectedRoutes={").append(selectedRoutes).append("}").append(", selectableRoutes={").append(selectableRoutes).append("}").append(", deselectableRoutes={").append(deselectableRoutes).append("}").append(" }");
            return result.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setRoutingSessionInfo(@NonNull RoutingSessionInfo info) {
            Object object = this.mControllerLock;
            synchronized (object) {
                this.mSessionInfo = info;
            }
        }

        private static boolean containsRouteInfoWithId(@NonNull List<MediaRoute2Info> routeList, @NonNull String routeId) {
            for (MediaRoute2Info info : routeList) {
                if (!TextUtils.equals(routeId, info.getId())) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class RouteCallback {
        @Deprecated
        public void onRoutesAdded(@NonNull List<MediaRoute2Info> routes) {
        }

        @Deprecated
        public void onRoutesRemoved(@NonNull List<MediaRoute2Info> routes) {
        }

        @Deprecated
        public void onRoutesChanged(@NonNull List<MediaRoute2Info> routes) {
        }

        public void onRoutesUpdated(@NonNull List<MediaRoute2Info> routes) {
        }

        @SystemApi
        public void onPreferredFeaturesChanged(@NonNull List<String> preferredFeatures) {
        }
    }

    static class RouteCallbackRecord {
        public final Executor mExecutor;
        public final RouteCallback mRouteCallback;
        public final RouteDiscoveryPreference mPreference;

        RouteCallbackRecord(@Nullable Executor executor, @NonNull RouteCallback routeCallback, @Nullable RouteDiscoveryPreference preference) {
            this.mRouteCallback = routeCallback;
            this.mExecutor = executor;
            this.mPreference = preference;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RouteCallbackRecord)) {
                return false;
            }
            return this.mRouteCallback == ((RouteCallbackRecord)obj).mRouteCallback;
        }

        public int hashCode() {
            return this.mRouteCallback.hashCode();
        }
    }

    private static class RouteListingPreferenceCallbackRecord {
        public final Executor mExecutor;
        public final Consumer<RouteListingPreference> mRouteListingPreferenceCallback;

        RouteListingPreferenceCallbackRecord(@NonNull Executor executor, @NonNull Consumer<RouteListingPreference> routeListingPreferenceCallback) {
            this.mExecutor = executor;
            this.mRouteListingPreferenceCallback = routeListingPreferenceCallback;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RouteListingPreferenceCallbackRecord)) {
                return false;
            }
            return this.mRouteListingPreferenceCallback == ((RouteListingPreferenceCallbackRecord)obj).mRouteListingPreferenceCallback;
        }

        public int hashCode() {
            return this.mRouteListingPreferenceCallback.hashCode();
        }
    }

    private static class DeviceSuggestionsUpdatesCallbackRecord {
        public final Executor mExecutor;
        public final DeviceSuggestionsUpdatesCallback mDeviceSuggestionsUpdatesCallback;

        DeviceSuggestionsUpdatesCallbackRecord(@NonNull Executor executor, @NonNull DeviceSuggestionsUpdatesCallback deviceSuggestionsUpdatesCallback) {
            this.mExecutor = executor;
            this.mDeviceSuggestionsUpdatesCallback = deviceSuggestionsUpdatesCallback;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DeviceSuggestionsUpdatesCallbackRecord)) {
                return false;
            }
            return this.mDeviceSuggestionsUpdatesCallback == ((DeviceSuggestionsUpdatesCallbackRecord)obj).mDeviceSuggestionsUpdatesCallback;
        }

        public int hashCode() {
            return this.mDeviceSuggestionsUpdatesCallback.hashCode();
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
    public static interface DeviceSuggestionsUpdatesCallback {
        public void onSuggestionsUpdated(@NonNull String var1, @NonNull List<SuggestedDeviceInfo> var2);

        public void onSuggestionsCleared(@NonNull String var1);

        public void onSuggestionsRequested();
    }

    static class TransferCallbackRecord {
        public final Executor mExecutor;
        public final TransferCallback mTransferCallback;

        TransferCallbackRecord(@NonNull Executor executor, @NonNull TransferCallback transferCallback) {
            this.mTransferCallback = transferCallback;
            this.mExecutor = executor;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TransferCallbackRecord)) {
                return false;
            }
            return this.mTransferCallback == ((TransferCallbackRecord)obj).mTransferCallback;
        }

        public int hashCode() {
            return this.mTransferCallback.hashCode();
        }
    }

    public static abstract class TransferCallback {
        public void onTransfer(@NonNull RoutingController oldController, @NonNull RoutingController newController) {
        }

        public void onTransferFailure(@NonNull MediaRoute2Info requestedRoute) {
        }

        public void onStop(@NonNull RoutingController controller) {
        }

        public void onRequestFailed(int reason) {
        }
    }

    static class ControllerCallbackRecord {
        public final Executor mExecutor;
        public final ControllerCallback mCallback;

        ControllerCallbackRecord(@Nullable Executor executor, @NonNull ControllerCallback callback) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ControllerCallbackRecord)) {
                return false;
            }
            return this.mCallback == ((ControllerCallbackRecord)obj).mCallback;
        }

        public int hashCode() {
            return this.mCallback.hashCode();
        }
    }

    public static abstract class ControllerCallback {
        public void onControllerUpdated(@NonNull RoutingController controller) {
        }
    }

    public static interface OnGetControllerHintsListener {
        @Nullable
        public Bundle onGetControllerHints(@NonNull MediaRoute2Info var1);
    }

    static class ControllerCreationRequest {
        public final int mRequestId;
        public final long mManagerRequestId;
        public final MediaRoute2Info mRoute;
        public final RoutingController mOldController;

        ControllerCreationRequest(int requestId, long managerRequestId, @NonNull MediaRoute2Info route, @NonNull RoutingController oldController) {
            this.mRequestId = requestId;
            this.mManagerRequestId = managerRequestId;
            this.mRoute = Objects.requireNonNull(route, "route must not be null");
            this.mOldController = Objects.requireNonNull(oldController, "oldController must not be null");
        }
    }

    class MediaRouter2Stub
    extends IMediaRouter2.Stub {
        MediaRouter2Stub() {
        }

        @Override
        public void notifyRouterRegistered(List<MediaRoute2Info> currentRoutes, RoutingSessionInfo currentSystemSessionInfo) {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::syncRoutesOnHandler, MediaRouter2.this, currentRoutes, currentSystemSessionInfo));
        }

        @Override
        public void notifyRoutesUpdated(List<MediaRoute2Info> routes) {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::updateRoutesOnHandler, MediaRouter2.this, routes));
        }

        @Override
        public void notifySessionCreated(int requestId, @Nullable RoutingSessionInfo sessionInfo) {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::createControllerOnHandler, MediaRouter2.this, requestId, sessionInfo));
        }

        @Override
        public void notifySessionInfoChanged(@Nullable RoutingSessionInfo sessionInfo) {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::updateControllerOnHandler, MediaRouter2.this, sessionInfo));
        }

        @Override
        public void notifySessionReleased(RoutingSessionInfo sessionInfo) {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::releaseControllerOnHandler, MediaRouter2.this, sessionInfo));
        }

        @Override
        public void notifyDeviceSuggestionsUpdated(String suggestingPackageName, @Nullable List<SuggestedDeviceInfo> suggestions) {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::notifyDeviceSuggestionsUpdated, MediaRouter2.this, suggestingPackageName, suggestions));
        }

        @Override
        public void notifyDeviceSuggestionRequested() {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::notifyCallbacksDeviceSuggestionRequested, MediaRouter2.this));
        }

        @Override
        public void requestCreateSessionByManager(long managerRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route) {
            MediaRouter2.this.mHandler.sendMessage(PooledLambda.obtainMessage(MediaRouter2::onRequestCreateControllerByManagerOnHandler, MediaRouter2.this, oldSession, route, managerRequestId));
        }
    }

    private static class InstanceInvalidatedCallbackRecord
    extends Record {
        private final Executor executor;
        private final Runnable runnable;

        private InstanceInvalidatedCallbackRecord(Executor executor, Runnable runnable) {
            this.executor = executor;
            this.runnable = runnable;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InstanceInvalidatedCallbackRecord.class, "executor;runnable", "executor", "runnable"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InstanceInvalidatedCallbackRecord.class, "executor;runnable", "executor", "runnable"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InstanceInvalidatedCallbackRecord.class, "executor;runnable", "executor", "runnable"}, this, o);
        }

        public Executor executor() {
            return this.executor;
        }

        public Runnable runnable() {
            return this.runnable;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanningState {
    }
}

