/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.SoundDoseRecord;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISoundDoseCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.ISoundDoseCallback";

    public void onMomentaryExposure(float var1, int var2) throws RemoteException;

    public void onNewCsdValue(float var1, SoundDoseRecord[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISoundDoseCallback {
        static final int TRANSACTION_onMomentaryExposure = 1;
        static final int TRANSACTION_onNewCsdValue = 2;

        public Stub() {
            this.attachInterface(this, ISoundDoseCallback.DESCRIPTOR);
        }

        public static ISoundDoseCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISoundDoseCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISoundDoseCallback) {
                return (ISoundDoseCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISoundDoseCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    float _arg0 = data.readFloat();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onMomentaryExposure(_arg0, _arg1);
                    break;
                }
                case 2: {
                    float _arg0 = data.readFloat();
                    SoundDoseRecord[] _arg1 = data.createTypedArray(SoundDoseRecord.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNewCsdValue(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISoundDoseCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISoundDoseCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMomentaryExposure(float currentMel, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDoseCallback.DESCRIPTOR);
                    _data.writeFloat(currentMel);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewCsdValue(float currentCsd, SoundDoseRecord[] records) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundDoseCallback.DESCRIPTOR);
                    _data.writeFloat(currentCsd);
                    _data.writeTypedArray(records, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISoundDoseCallback {
        @Override
        public void onMomentaryExposure(float currentMel, int deviceId) throws RemoteException {
        }

        @Override
        public void onNewCsdValue(float currentCsd, SoundDoseRecord[] records) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

