/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.VolumeShaper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.IntArray;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.media.audiopolicy.enable_fade_manager_configuration")
public class FadeManagerConfiguration
implements Parcelable {
    public static final String TAG = "FadeManagerConfiguration";
    public static final int FADE_STATE_DISABLED = 0;
    public static final int FADE_STATE_ENABLED_DEFAULT = 1;
    public static final int VOLUME_SHAPER_SYSTEM_FADE_ID = 2;
    public static final long DURATION_NOT_SET = 0L;
    private static final long DEFAULT_FADE_OUT_DURATION_MS = 2000L;
    private static final long DEFAULT_FADE_IN_DURATION_MS = 1000L;
    private final SparseArray<FadeVolumeShaperConfigsWrapper> mUsageToFadeWrapperMap;
    private final ArrayMap<AudioAttributes, FadeVolumeShaperConfigsWrapper> mAttrToFadeWrapperMap;
    @NonNull
    private final IntArray mFadeableUsages;
    @NonNull
    private final IntArray mUnfadeableContentTypes;
    @NonNull
    private final IntArray mUnfadeablePlayerTypes;
    @NonNull
    private final IntArray mUnfadeableUids;
    @NonNull
    private final List<AudioAttributes> mUnfadeableAudioAttributes;
    private final int mFadeState;
    private final long mFadeOutDurationMillis;
    private final long mFadeInDurationMillis;
    private final long mFadeInDelayForOffendersMillis;
    @NonNull
    public static final Parcelable.Creator<FadeManagerConfiguration> CREATOR = new Parcelable.Creator<FadeManagerConfiguration>(){

        @Override
        @NonNull
        public FadeManagerConfiguration createFromParcel(@NonNull Parcel in) {
            return new FadeManagerConfiguration(in);
        }

        @NonNull
        public FadeManagerConfiguration[] newArray(int size) {
            return new FadeManagerConfiguration[size];
        }
    };

    private FadeManagerConfiguration(int fadeState, long fadeOutDurationMillis, long fadeInDurationMillis, long offendersFadeInDelayMillis, @NonNull SparseArray<FadeVolumeShaperConfigsWrapper> usageToFadeWrapperMap, @NonNull ArrayMap<AudioAttributes, FadeVolumeShaperConfigsWrapper> attrToFadeWrapperMap, @NonNull IntArray fadeableUsages, @NonNull IntArray unfadeableContentTypes, @NonNull IntArray unfadeablePlayerTypes, @NonNull IntArray unfadeableUids, @NonNull List<AudioAttributes> unfadeableAudioAttributes) {
        this.mFadeState = fadeState;
        this.mFadeOutDurationMillis = fadeOutDurationMillis;
        this.mFadeInDurationMillis = fadeInDurationMillis;
        this.mFadeInDelayForOffendersMillis = offendersFadeInDelayMillis;
        this.mUsageToFadeWrapperMap = Objects.requireNonNull(usageToFadeWrapperMap, "Usage to fade wrapper map cannot be null");
        this.mAttrToFadeWrapperMap = Objects.requireNonNull(attrToFadeWrapperMap, "Attribute to fade wrapper map cannot be null");
        this.mFadeableUsages = Objects.requireNonNull(fadeableUsages, "List of fadeable usages cannot be null");
        this.mUnfadeableContentTypes = Objects.requireNonNull(unfadeableContentTypes, "List of unfadeable content types cannot be null");
        this.mUnfadeablePlayerTypes = Objects.requireNonNull(unfadeablePlayerTypes, "List of unfadeable player types cannot be null");
        this.mUnfadeableUids = Objects.requireNonNull(unfadeableUids, "List of unfadeable uids cannot be null");
        this.mUnfadeableAudioAttributes = Objects.requireNonNull(unfadeableAudioAttributes, "List of unfadeable audio attributes cannot be null");
    }

    public int getFadeState() {
        return this.mFadeState;
    }

    @NonNull
    public List<Integer> getFadeableUsages() {
        this.ensureFadingIsEnabled();
        return FadeManagerConfiguration.convertIntArrayToIntegerList(this.mFadeableUsages);
    }

    @NonNull
    public List<Integer> getUnfadeablePlayerTypes() {
        this.ensureFadingIsEnabled();
        return FadeManagerConfiguration.convertIntArrayToIntegerList(this.mUnfadeablePlayerTypes);
    }

    @NonNull
    public List<Integer> getUnfadeableContentTypes() {
        this.ensureFadingIsEnabled();
        return FadeManagerConfiguration.convertIntArrayToIntegerList(this.mUnfadeableContentTypes);
    }

    @NonNull
    public List<Integer> getUnfadeableUids() {
        this.ensureFadingIsEnabled();
        return FadeManagerConfiguration.convertIntArrayToIntegerList(this.mUnfadeableUids);
    }

    @NonNull
    public List<AudioAttributes> getUnfadeableAudioAttributes() {
        this.ensureFadingIsEnabled();
        return this.mUnfadeableAudioAttributes;
    }

    public long getFadeOutDurationForUsage(int usage) {
        this.ensureFadingIsEnabled();
        FadeManagerConfiguration.validateUsage(usage);
        return this.getDurationForVolumeShaperConfig(this.getVolumeShaperConfigFromWrapper(this.mUsageToFadeWrapperMap.get(usage), false));
    }

    public long getFadeInDurationForUsage(int usage) {
        this.ensureFadingIsEnabled();
        FadeManagerConfiguration.validateUsage(usage);
        return this.getDurationForVolumeShaperConfig(this.getVolumeShaperConfigFromWrapper(this.mUsageToFadeWrapperMap.get(usage), true));
    }

    @Nullable
    public VolumeShaper.Configuration getFadeOutVolumeShaperConfigForUsage(int usage) {
        this.ensureFadingIsEnabled();
        FadeManagerConfiguration.validateUsage(usage);
        return this.getVolumeShaperConfigFromWrapper(this.mUsageToFadeWrapperMap.get(usage), false);
    }

    @Nullable
    public VolumeShaper.Configuration getFadeInVolumeShaperConfigForUsage(int usage) {
        this.ensureFadingIsEnabled();
        FadeManagerConfiguration.validateUsage(usage);
        return this.getVolumeShaperConfigFromWrapper(this.mUsageToFadeWrapperMap.get(usage), true);
    }

    public long getFadeOutDurationForAudioAttributes(@NonNull AudioAttributes audioAttributes) {
        this.ensureFadingIsEnabled();
        return this.getDurationForVolumeShaperConfig(this.getVolumeShaperConfigFromWrapper(this.mAttrToFadeWrapperMap.get(audioAttributes), false));
    }

    public long getFadeInDurationForAudioAttributes(@NonNull AudioAttributes audioAttributes) {
        this.ensureFadingIsEnabled();
        return this.getDurationForVolumeShaperConfig(this.getVolumeShaperConfigFromWrapper(this.mAttrToFadeWrapperMap.get(audioAttributes), true));
    }

    @Nullable
    public VolumeShaper.Configuration getFadeOutVolumeShaperConfigForAudioAttributes(@NonNull AudioAttributes audioAttributes) {
        Objects.requireNonNull(audioAttributes, "Audio attributes cannot be null");
        this.ensureFadingIsEnabled();
        return this.getVolumeShaperConfigFromWrapper(this.mAttrToFadeWrapperMap.get(audioAttributes), false);
    }

    @Nullable
    public VolumeShaper.Configuration getFadeInVolumeShaperConfigForAudioAttributes(@NonNull AudioAttributes audioAttributes) {
        Objects.requireNonNull(audioAttributes, "Audio attributes cannot be null");
        this.ensureFadingIsEnabled();
        return this.getVolumeShaperConfigFromWrapper(this.mAttrToFadeWrapperMap.get(audioAttributes), true);
    }

    @NonNull
    public List<AudioAttributes> getAudioAttributesWithVolumeShaperConfigs() {
        return this.getAudioAttributesInternal();
    }

    public long getFadeInDelayForOffenders() {
        return this.mFadeInDelayForOffendersMillis;
    }

    public boolean isFadeEnabled() {
        return this.mFadeState != 0;
    }

    public boolean isUsageFadeable(int usage) {
        if (!this.isFadeEnabled()) {
            return false;
        }
        return this.mFadeableUsages.contains(usage);
    }

    public boolean isContentTypeUnfadeable(int contentType) {
        if (!this.isFadeEnabled()) {
            return true;
        }
        return this.mUnfadeableContentTypes.contains(contentType);
    }

    public boolean isPlayerTypeUnfadeable(int playerType) {
        if (!this.isFadeEnabled()) {
            return true;
        }
        return this.mUnfadeablePlayerTypes.contains(playerType);
    }

    public boolean isAudioAttributesUnfadeable(@NonNull AudioAttributes audioAttributes) {
        Objects.requireNonNull(audioAttributes, "Audio attributes cannot be null");
        if (!this.isFadeEnabled()) {
            return true;
        }
        return this.mUnfadeableAudioAttributes.contains(audioAttributes);
    }

    public boolean isUidUnfadeable(int uid) {
        if (!this.isFadeEnabled()) {
            return true;
        }
        return this.mUnfadeableUids.contains(uid);
    }

    public static long getDefaultFadeOutDurationMillis() {
        return 2000L;
    }

    public static long getDefaultFadeInDurationMillis() {
        return 1000L;
    }

    public String toString() {
        return "FadeManagerConfiguration { fade state = " + FadeManagerConfiguration.fadeStateToString(this.mFadeState) + ", fade out duration = " + this.mFadeOutDurationMillis + ", fade in duration = " + this.mFadeInDurationMillis + ", offenders fade in delay = " + this.mFadeInDelayForOffendersMillis + ", fade volume shapers for audio attributes = " + this.mAttrToFadeWrapperMap + ", fadeable usages = " + this.mFadeableUsages.toString() + ", unfadeable content types = " + this.mUnfadeableContentTypes.toString() + ", unfadeable player types = " + this.mUnfadeablePlayerTypes.toString() + ", unfadeable uids = " + this.mUnfadeableUids.toString() + ", unfadeable audio attributes = " + this.mUnfadeableAudioAttributes + "}";
    }

    @NonNull
    public static String fadeStateToString(int fadeState) {
        switch (fadeState) {
            case 0: {
                return "FADE_STATE_DISABLED";
            }
            case 1: {
                return "FADE_STATE_ENABLED_DEFAULT";
            }
        }
        return "unknown fade state: " + fadeState;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FadeManagerConfiguration)) {
            return false;
        }
        FadeManagerConfiguration rhs = (FadeManagerConfiguration)o;
        return this.mUsageToFadeWrapperMap.contentEquals(rhs.mUsageToFadeWrapperMap) && this.mAttrToFadeWrapperMap.equals(rhs.mAttrToFadeWrapperMap) && Arrays.equals(this.mFadeableUsages.toArray(), rhs.mFadeableUsages.toArray()) && Arrays.equals(this.mUnfadeableContentTypes.toArray(), rhs.mUnfadeableContentTypes.toArray()) && Arrays.equals(this.mUnfadeablePlayerTypes.toArray(), rhs.mUnfadeablePlayerTypes.toArray()) && Arrays.equals(this.mUnfadeableUids.toArray(), rhs.mUnfadeableUids.toArray()) && this.mUnfadeableAudioAttributes.equals(rhs.mUnfadeableAudioAttributes) && this.mFadeState == rhs.mFadeState && this.mFadeOutDurationMillis == rhs.mFadeOutDurationMillis && this.mFadeInDurationMillis == rhs.mFadeInDurationMillis && this.mFadeInDelayForOffendersMillis == rhs.mFadeInDelayForOffendersMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mUsageToFadeWrapperMap, this.mAttrToFadeWrapperMap, this.mFadeableUsages, this.mUnfadeableContentTypes, this.mUnfadeablePlayerTypes, this.mUnfadeableAudioAttributes, this.mUnfadeableUids, this.mFadeState, this.mFadeOutDurationMillis, this.mFadeInDurationMillis, this.mFadeInDelayForOffendersMillis);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFadeState);
        dest.writeLong(this.mFadeOutDurationMillis);
        dest.writeLong(this.mFadeInDurationMillis);
        dest.writeLong(this.mFadeInDelayForOffendersMillis);
        dest.writeTypedSparseArray(this.mUsageToFadeWrapperMap, flags);
        dest.writeMap(this.mAttrToFadeWrapperMap);
        dest.writeIntArray(this.mFadeableUsages.toArray());
        dest.writeIntArray(this.mUnfadeableContentTypes.toArray());
        dest.writeIntArray(this.mUnfadeablePlayerTypes.toArray());
        dest.writeIntArray(this.mUnfadeableUids.toArray());
        dest.writeTypedList(this.mUnfadeableAudioAttributes, flags);
    }

    @VisibleForTesting
    FadeManagerConfiguration(Parcel in) {
        int fadeState = in.readInt();
        long fadeOutDurationMillis = in.readLong();
        long fadeInDurationMillis = in.readLong();
        long fadeInDelayForOffenders = in.readLong();
        SparseArray<FadeVolumeShaperConfigsWrapper> usageToWrapperMap = in.createTypedSparseArray(FadeVolumeShaperConfigsWrapper.CREATOR);
        ArrayMap attrToFadeWrapperMap = new ArrayMap();
        in.readMap(attrToFadeWrapperMap, this.getClass().getClassLoader(), AudioAttributes.class, FadeVolumeShaperConfigsWrapper.class);
        int[] fadeableUsages = in.createIntArray();
        int[] unfadeableContentTypes = in.createIntArray();
        int[] unfadeablePlayerTypes = in.createIntArray();
        int[] unfadeableUids = in.createIntArray();
        ArrayList<AudioAttributes> unfadeableAudioAttributes = new ArrayList<AudioAttributes>();
        in.readTypedList(unfadeableAudioAttributes, AudioAttributes.CREATOR);
        this.mFadeState = fadeState;
        this.mFadeOutDurationMillis = fadeOutDurationMillis;
        this.mFadeInDurationMillis = fadeInDurationMillis;
        this.mFadeInDelayForOffendersMillis = fadeInDelayForOffenders;
        this.mUsageToFadeWrapperMap = usageToWrapperMap;
        this.mAttrToFadeWrapperMap = attrToFadeWrapperMap;
        this.mFadeableUsages = IntArray.wrap(fadeableUsages);
        this.mUnfadeableContentTypes = IntArray.wrap(unfadeableContentTypes);
        this.mUnfadeablePlayerTypes = IntArray.wrap(unfadeablePlayerTypes);
        this.mUnfadeableUids = IntArray.wrap(unfadeableUids);
        this.mUnfadeableAudioAttributes = unfadeableAudioAttributes;
    }

    private long getDurationForVolumeShaperConfig(VolumeShaper.Configuration config) {
        return config != null ? config.getDuration() : 0L;
    }

    @Nullable
    private VolumeShaper.Configuration getVolumeShaperConfigFromWrapper(FadeVolumeShaperConfigsWrapper wrapper, boolean isFadeIn) {
        if (wrapper == null) {
            return null;
        }
        if (isFadeIn) {
            return wrapper.getFadeInVolShaperConfig();
        }
        return wrapper.getFadeOutVolShaperConfig();
    }

    private List<AudioAttributes> getAudioAttributesInternal() {
        ArrayList<AudioAttributes> attrs = new ArrayList<AudioAttributes>(this.mAttrToFadeWrapperMap.size());
        for (int index = 0; index < this.mAttrToFadeWrapperMap.size(); ++index) {
            attrs.add(this.mAttrToFadeWrapperMap.keyAt(index));
        }
        return attrs;
    }

    private static boolean isUsageValid(int usage) {
        return AudioAttributes.isSdkUsage(usage) || AudioAttributes.isSystemUsage(usage) || AudioAttributes.isHiddenUsage(usage);
    }

    private void ensureFadingIsEnabled() {
        if (!this.isFadeEnabled()) {
            throw new IllegalStateException("Method call not allowed when fade is disabled");
        }
    }

    private static void validateUsage(int usage) {
        Preconditions.checkArgument(FadeManagerConfiguration.isUsageValid(usage), "Invalid usage: %s", usage);
    }

    private static IntArray convertIntegerListToIntArray(List<Integer> integerList) {
        if (integerList == null) {
            return new IntArray();
        }
        IntArray intArray = new IntArray(integerList.size());
        for (int index = 0; index < integerList.size(); ++index) {
            intArray.add(integerList.get(index));
        }
        return intArray;
    }

    private static List<Integer> convertIntArrayToIntegerList(IntArray intArray) {
        if (intArray == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> integerArrayList = new ArrayList<Integer>(intArray.size());
        for (int index = 0; index < intArray.size(); ++index) {
            integerArrayList.add(intArray.get(index));
        }
        return integerArrayList;
    }

    private static class FadeVolumeShaperConfigsWrapper
    implements Parcelable {
        @Nullable
        private VolumeShaper.Configuration mFadeOutVolShaperConfig;
        @Nullable
        private VolumeShaper.Configuration mFadeInVolShaperConfig;
        @NonNull
        public static final Parcelable.Creator<FadeVolumeShaperConfigsWrapper> CREATOR = new Parcelable.Creator<FadeVolumeShaperConfigsWrapper>(){

            @Override
            @NonNull
            public FadeVolumeShaperConfigsWrapper createFromParcel(@NonNull Parcel in) {
                return new FadeVolumeShaperConfigsWrapper(in);
            }

            @NonNull
            public FadeVolumeShaperConfigsWrapper[] newArray(int size) {
                return new FadeVolumeShaperConfigsWrapper[size];
            }
        };

        FadeVolumeShaperConfigsWrapper() {
        }

        FadeVolumeShaperConfigsWrapper(@NonNull FadeVolumeShaperConfigsWrapper wrapper) {
            Objects.requireNonNull(wrapper, "Fade volume shaper configs wrapper cannot be null");
            this.mFadeOutVolShaperConfig = wrapper.mFadeOutVolShaperConfig;
            this.mFadeInVolShaperConfig = wrapper.mFadeInVolShaperConfig;
        }

        public void setFadeOutVolShaperConfig(@Nullable VolumeShaper.Configuration fadeOutConfig) {
            this.mFadeOutVolShaperConfig = fadeOutConfig;
        }

        public void setFadeInVolShaperConfig(@Nullable VolumeShaper.Configuration fadeInConfig) {
            this.mFadeInVolShaperConfig = fadeInConfig;
        }

        @Nullable
        public VolumeShaper.Configuration getFadeOutVolShaperConfig() {
            return this.mFadeOutVolShaperConfig;
        }

        @Nullable
        public VolumeShaper.Configuration getFadeInVolShaperConfig() {
            return this.mFadeInVolShaperConfig;
        }

        public boolean isInactive() {
            return !this.isFadeOutConfigActive() && !this.isFadeInConfigActive();
        }

        boolean isFadeOutConfigActive() {
            return this.mFadeOutVolShaperConfig != null;
        }

        boolean isFadeInConfigActive() {
            return this.mFadeInVolShaperConfig != null;
        }

        public boolean equals(Object o) {
            boolean isEqual;
            if (this == o) {
                return true;
            }
            if (!(o instanceof FadeVolumeShaperConfigsWrapper)) {
                return false;
            }
            FadeVolumeShaperConfigsWrapper rhs = (FadeVolumeShaperConfigsWrapper)o;
            if (this.mFadeInVolShaperConfig == null && rhs.mFadeInVolShaperConfig == null && this.mFadeOutVolShaperConfig == null && rhs.mFadeOutVolShaperConfig == null) {
                return true;
            }
            if (this.mFadeOutVolShaperConfig != null) {
                isEqual = this.mFadeOutVolShaperConfig.equals(rhs.mFadeOutVolShaperConfig);
            } else {
                if (rhs.mFadeOutVolShaperConfig != null) {
                    return false;
                }
                isEqual = true;
            }
            if (this.mFadeInVolShaperConfig != null) {
                isEqual = isEqual && this.mFadeInVolShaperConfig.equals(rhs.mFadeInVolShaperConfig);
            } else if (rhs.mFadeInVolShaperConfig != null) {
                return false;
            }
            return isEqual;
        }

        public int hashCode() {
            return Objects.hash(this.mFadeOutVolShaperConfig, this.mFadeInVolShaperConfig);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            this.mFadeOutVolShaperConfig.writeToParcel(dest, flags);
            this.mFadeInVolShaperConfig.writeToParcel(dest, flags);
        }

        @VisibleForTesting
        FadeVolumeShaperConfigsWrapper(Parcel in) {
            this.mFadeOutVolShaperConfig = VolumeShaper.Configuration.CREATOR.createFromParcel(in);
            this.mFadeInVolShaperConfig = VolumeShaper.Configuration.CREATOR.createFromParcel(in);
        }
    }

    public static class Builder {
        private static final int INVALID_INDEX = -1;
        private static final long IS_BUILDER_USED_FIELD_SET = 1L;
        private static final long IS_FADEABLE_USAGES_FIELD_SET = 2L;
        private static final long IS_UNFADEABLE_CONTENT_TYPE_FIELD_SET = 4L;
        private static final long DEFAULT_DELAY_FADE_IN_OFFENDERS_MS = 2000L;
        private static final IntArray DEFAULT_UNFADEABLE_PLAYER_TYPES = IntArray.wrap(new int[]{13, 3});
        private static final IntArray DEFAULT_UNFADEABLE_CONTENT_TYPES = IntArray.wrap(new int[]{1});
        private static final IntArray DEFAULT_FADEABLE_USAGES = IntArray.wrap(new int[]{14, 1});
        private int mFadeState = 1;
        private long mFadeInDelayForOffendersMillis = 2000L;
        private long mFadeOutDurationMillis;
        private long mFadeInDurationMillis;
        private long mBuilderFieldsSet;
        private SparseArray<FadeVolumeShaperConfigsWrapper> mUsageToFadeWrapperMap = new SparseArray();
        private ArrayMap<AudioAttributes, FadeVolumeShaperConfigsWrapper> mAttrToFadeWrapperMap = new ArrayMap();
        private IntArray mFadeableUsages = new IntArray();
        private IntArray mUnfadeableContentTypes = new IntArray();
        private IntArray mUnfadeablePlayerTypes = DEFAULT_UNFADEABLE_PLAYER_TYPES;
        private IntArray mUnfadeableUids = new IntArray();
        private List<AudioAttributes> mUnfadeableAudioAttributes = new ArrayList<AudioAttributes>();

        public Builder() {
            this.mFadeOutDurationMillis = 2000L;
            this.mFadeInDurationMillis = 1000L;
        }

        public Builder(long fadeOutDurationMillis, long fadeInDurationMills) {
            this.mFadeOutDurationMillis = fadeOutDurationMillis;
            this.mFadeInDurationMillis = fadeInDurationMills;
        }

        public Builder(@NonNull FadeManagerConfiguration fmc) {
            this.mFadeState = fmc.mFadeState;
            this.copyUsageToFadeWrapperMapInternal(fmc.mUsageToFadeWrapperMap);
            this.mAttrToFadeWrapperMap = new ArrayMap<AudioAttributes, FadeVolumeShaperConfigsWrapper>(fmc.mAttrToFadeWrapperMap);
            this.mFadeableUsages = fmc.mFadeableUsages.clone();
            this.setFlag(2L);
            this.mUnfadeableContentTypes = fmc.mUnfadeableContentTypes.clone();
            this.setFlag(4L);
            this.mUnfadeablePlayerTypes = fmc.mUnfadeablePlayerTypes.clone();
            this.mUnfadeableUids = fmc.mUnfadeableUids.clone();
            this.mUnfadeableAudioAttributes = new ArrayList<AudioAttributes>(fmc.mUnfadeableAudioAttributes);
            this.mFadeOutDurationMillis = fmc.mFadeOutDurationMillis;
            this.mFadeInDurationMillis = fmc.mFadeInDurationMillis;
        }

        @NonNull
        public Builder setFadeState(int state) {
            this.validateFadeState(state);
            this.mFadeState = state;
            return this;
        }

        @NonNull
        public Builder setFadeOutVolumeShaperConfigForUsage(int usage, @Nullable VolumeShaper.Configuration fadeOutVShaperConfig) {
            FadeManagerConfiguration.validateUsage(usage);
            this.getFadeVolShaperConfigWrapperForUsage(usage).setFadeOutVolShaperConfig(fadeOutVShaperConfig);
            this.cleanupInactiveWrapperEntries(usage);
            return this;
        }

        @NonNull
        public Builder setFadeInVolumeShaperConfigForUsage(int usage, @Nullable VolumeShaper.Configuration fadeInVShaperConfig) {
            FadeManagerConfiguration.validateUsage(usage);
            this.getFadeVolShaperConfigWrapperForUsage(usage).setFadeInVolShaperConfig(fadeInVShaperConfig);
            this.cleanupInactiveWrapperEntries(usage);
            return this;
        }

        @NonNull
        public Builder setFadeOutDurationForUsage(int usage, long fadeOutDurationMillis) {
            FadeManagerConfiguration.validateUsage(usage);
            VolumeShaper.Configuration fadeOutVShaperConfig = this.createVolShaperConfigForDuration(fadeOutDurationMillis, false);
            this.setFadeOutVolumeShaperConfigForUsage(usage, fadeOutVShaperConfig);
            return this;
        }

        @NonNull
        public Builder setFadeInDurationForUsage(int usage, long fadeInDurationMillis) {
            FadeManagerConfiguration.validateUsage(usage);
            VolumeShaper.Configuration fadeInVShaperConfig = this.createVolShaperConfigForDuration(fadeInDurationMillis, true);
            this.setFadeInVolumeShaperConfigForUsage(usage, fadeInVShaperConfig);
            return this;
        }

        @NonNull
        public Builder setFadeOutVolumeShaperConfigForAudioAttributes(@NonNull AudioAttributes audioAttributes, @Nullable VolumeShaper.Configuration fadeOutVShaperConfig) {
            Objects.requireNonNull(audioAttributes, "Audio attribute cannot be null");
            this.getFadeVolShaperConfigWrapperForAttr(audioAttributes).setFadeOutVolShaperConfig(fadeOutVShaperConfig);
            this.cleanupInactiveWrapperEntries(audioAttributes);
            return this;
        }

        @NonNull
        public Builder setFadeInVolumeShaperConfigForAudioAttributes(@NonNull AudioAttributes audioAttributes, @Nullable VolumeShaper.Configuration fadeInVShaperConfig) {
            Objects.requireNonNull(audioAttributes, "Audio attribute cannot be null");
            this.getFadeVolShaperConfigWrapperForAttr(audioAttributes).setFadeInVolShaperConfig(fadeInVShaperConfig);
            this.cleanupInactiveWrapperEntries(audioAttributes);
            return this;
        }

        @NonNull
        public Builder setFadeOutDurationForAudioAttributes(@NonNull AudioAttributes audioAttributes, long fadeOutDurationMillis) {
            Objects.requireNonNull(audioAttributes, "Audio attribute cannot be null");
            VolumeShaper.Configuration fadeOutVShaperConfig = this.createVolShaperConfigForDuration(fadeOutDurationMillis, false);
            this.setFadeOutVolumeShaperConfigForAudioAttributes(audioAttributes, fadeOutVShaperConfig);
            return this;
        }

        @NonNull
        public Builder setFadeInDurationForAudioAttributes(@NonNull AudioAttributes audioAttributes, long fadeInDurationMillis) {
            Objects.requireNonNull(audioAttributes, "Audio attribute cannot be null");
            VolumeShaper.Configuration fadeInVShaperConfig = this.createVolShaperConfigForDuration(fadeInDurationMillis, true);
            this.setFadeInVolumeShaperConfigForAudioAttributes(audioAttributes, fadeInVShaperConfig);
            return this;
        }

        @NonNull
        public Builder setFadeableUsages(@NonNull List<Integer> usages) {
            Objects.requireNonNull(usages, "List of usages cannot be null");
            this.validateUsages(usages);
            this.setFlag(2L);
            this.mFadeableUsages.clear();
            this.mFadeableUsages.addAll(FadeManagerConfiguration.convertIntegerListToIntArray(usages));
            return this;
        }

        @NonNull
        public Builder addFadeableUsage(int usage) {
            FadeManagerConfiguration.validateUsage(usage);
            this.setFlag(2L);
            if (!this.mFadeableUsages.contains(usage)) {
                this.mFadeableUsages.add(usage);
            }
            return this;
        }

        @NonNull
        public Builder clearFadeableUsages() {
            this.setFlag(2L);
            this.mFadeableUsages.clear();
            return this;
        }

        @NonNull
        public Builder setUnfadeableContentTypes(@NonNull List<Integer> contentTypes) {
            Objects.requireNonNull(contentTypes, "List of content types cannot be null");
            this.validateContentTypes(contentTypes);
            this.setFlag(4L);
            this.mUnfadeableContentTypes.clear();
            this.mUnfadeableContentTypes.addAll(FadeManagerConfiguration.convertIntegerListToIntArray(contentTypes));
            return this;
        }

        @NonNull
        public Builder addUnfadeableContentType(int contentType) {
            this.validateContentType(contentType);
            this.setFlag(4L);
            if (!this.mUnfadeableContentTypes.contains(contentType)) {
                this.mUnfadeableContentTypes.add(contentType);
            }
            return this;
        }

        @NonNull
        public Builder clearUnfadeableContentTypes() {
            this.setFlag(4L);
            this.mUnfadeableContentTypes.clear();
            return this;
        }

        @NonNull
        public Builder setUnfadeableUids(@NonNull List<Integer> uids) {
            Objects.requireNonNull(uids, "List of uids cannot be null");
            this.mUnfadeableUids.clear();
            this.mUnfadeableUids.addAll(FadeManagerConfiguration.convertIntegerListToIntArray(uids));
            return this;
        }

        @NonNull
        public Builder addUnfadeableUid(int uid) {
            if (!this.mUnfadeableUids.contains(uid)) {
                this.mUnfadeableUids.add(uid);
            }
            return this;
        }

        @NonNull
        public Builder clearUnfadeableUids() {
            this.mUnfadeableUids.clear();
            return this;
        }

        @NonNull
        public Builder setUnfadeableAudioAttributes(@NonNull List<AudioAttributes> attrs) {
            Objects.requireNonNull(attrs, "List of audio attributes cannot be null");
            this.mUnfadeableAudioAttributes.clear();
            this.mUnfadeableAudioAttributes.addAll(attrs);
            return this;
        }

        @NonNull
        public Builder addUnfadeableAudioAttributes(@NonNull AudioAttributes audioAttributes) {
            Objects.requireNonNull(audioAttributes, "Audio attributes cannot be null");
            if (!this.mUnfadeableAudioAttributes.contains(audioAttributes)) {
                this.mUnfadeableAudioAttributes.add(audioAttributes);
            }
            return this;
        }

        @NonNull
        public Builder clearUnfadeableAudioAttributes() {
            this.mUnfadeableAudioAttributes.clear();
            return this;
        }

        @NonNull
        public Builder setFadeInDelayForOffenders(long delayMillis) {
            Preconditions.checkArgument(delayMillis >= 0L, "Delay cannot be negative");
            this.mFadeInDelayForOffendersMillis = delayMillis;
            return this;
        }

        @NonNull
        public FadeManagerConfiguration build() {
            if (!this.checkNotSet(1L)) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
            this.setFlag(1L);
            if (this.checkNotSet(2L)) {
                this.mFadeableUsages = DEFAULT_FADEABLE_USAGES;
                this.setVolShaperConfigsForUsages(this.mFadeableUsages);
            }
            if (this.checkNotSet(4L)) {
                this.mUnfadeableContentTypes = DEFAULT_UNFADEABLE_CONTENT_TYPES;
            }
            this.validateFadeConfigurations();
            return new FadeManagerConfiguration(this.mFadeState, this.mFadeOutDurationMillis, this.mFadeInDurationMillis, this.mFadeInDelayForOffendersMillis, this.mUsageToFadeWrapperMap, this.mAttrToFadeWrapperMap, this.mFadeableUsages, this.mUnfadeableContentTypes, this.mUnfadeablePlayerTypes, this.mUnfadeableUids, this.mUnfadeableAudioAttributes);
        }

        private void setFlag(long flag) {
            this.mBuilderFieldsSet |= flag;
        }

        private boolean checkNotSet(long flag) {
            return (this.mBuilderFieldsSet & flag) == 0L;
        }

        private FadeVolumeShaperConfigsWrapper getFadeVolShaperConfigWrapperForUsage(int usage) {
            if (!this.mUsageToFadeWrapperMap.contains(usage)) {
                this.mUsageToFadeWrapperMap.put(usage, new FadeVolumeShaperConfigsWrapper());
            }
            return this.mUsageToFadeWrapperMap.get(usage);
        }

        private FadeVolumeShaperConfigsWrapper getFadeVolShaperConfigWrapperForAttr(AudioAttributes attr2) {
            if (!this.mAttrToFadeWrapperMap.containsKey(attr2)) {
                this.mAttrToFadeWrapperMap.put(attr2, new FadeVolumeShaperConfigsWrapper());
            }
            return this.mAttrToFadeWrapperMap.get(attr2);
        }

        private VolumeShaper.Configuration createVolShaperConfigForDuration(long duration, boolean isFadeIn) {
            if (duration == 0L) {
                return null;
            }
            VolumeShaper.Configuration.Builder builder = new VolumeShaper.Configuration.Builder().setId(2).setOptionFlags(2).setDuration(duration);
            if (isFadeIn) {
                builder.setCurve(new float[]{0.0f, 0.5f, 1.0f}, new float[]{0.0f, 0.3f, 1.0f});
            } else {
                builder.setCurve(new float[]{0.0f, 0.25f, 1.0f}, new float[]{1.0f, 0.65f, 0.0f});
            }
            return builder.build();
        }

        private void cleanupInactiveWrapperEntries(int usage) {
            FadeVolumeShaperConfigsWrapper fmcw = this.mUsageToFadeWrapperMap.get(usage);
            if (fmcw != null && fmcw.isInactive()) {
                this.mUsageToFadeWrapperMap.remove(usage);
            }
        }

        private void cleanupInactiveWrapperEntries(AudioAttributes attr2) {
            FadeVolumeShaperConfigsWrapper fmcw = this.mAttrToFadeWrapperMap.get(attr2);
            if (fmcw != null && fmcw.isInactive()) {
                this.mAttrToFadeWrapperMap.remove(attr2);
            }
        }

        private void setVolShaperConfigsForUsages(IntArray usages) {
            for (int index = 0; index < usages.size(); ++index) {
                this.setMissingVolShaperConfigsForWrapper(this.getFadeVolShaperConfigWrapperForUsage(usages.get(index)));
            }
        }

        private void setMissingVolShaperConfigsForWrapper(FadeVolumeShaperConfigsWrapper wrapper) {
            if (!wrapper.isFadeOutConfigActive()) {
                wrapper.setFadeOutVolShaperConfig(this.createVolShaperConfigForDuration(this.mFadeOutDurationMillis, false));
            }
            if (!wrapper.isFadeInConfigActive()) {
                wrapper.setFadeInVolShaperConfig(this.createVolShaperConfigForDuration(this.mFadeInDurationMillis, true));
            }
        }

        private void copyUsageToFadeWrapperMapInternal(SparseArray<FadeVolumeShaperConfigsWrapper> usageToFadeWrapperMap) {
            for (int index = 0; index < usageToFadeWrapperMap.size(); ++index) {
                this.mUsageToFadeWrapperMap.put(usageToFadeWrapperMap.keyAt(index), new FadeVolumeShaperConfigsWrapper(usageToFadeWrapperMap.valueAt(index)));
            }
        }

        private void validateFadeState(int state) {
            switch (state) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown fade state: " + state);
                }
            }
        }

        private void validateUsages(List<Integer> usages) {
            for (int index = 0; index < usages.size(); ++index) {
                FadeManagerConfiguration.validateUsage(usages.get(index));
            }
        }

        private void validateContentTypes(List<Integer> contentTypes) {
            for (int index = 0; index < contentTypes.size(); ++index) {
                this.validateContentType(contentTypes.get(index));
            }
        }

        private void validateContentType(int contentType) {
            Preconditions.checkArgument(AudioAttributes.isSdkContentType(contentType), "Invalid content type: %d", contentType);
        }

        private void validateFadeConfigurations() {
            this.validateFadeableUsages();
            this.validateFadeVolumeShaperConfigsWrappers();
            this.validateUnfadeableAudioAttributes();
        }

        private void validateFadeableUsages() {
            Preconditions.checkArgumentPositive(this.mFadeableUsages.size(), "Fadeable usage list cannot be empty when state set to enabled");
            for (int index = 0; index < this.mFadeableUsages.size(); ++index) {
                this.setMissingVolShaperConfigsForWrapper(this.getFadeVolShaperConfigWrapperForUsage(this.mFadeableUsages.get(index)));
            }
        }

        private void validateFadeVolumeShaperConfigsWrappers() {
            int index;
            for (index = 0; index < this.mUsageToFadeWrapperMap.size(); ++index) {
                this.setMissingVolShaperConfigsForWrapper(this.getFadeVolShaperConfigWrapperForUsage(this.mUsageToFadeWrapperMap.keyAt(index)));
            }
            for (index = 0; index < this.mAttrToFadeWrapperMap.size(); ++index) {
                this.setMissingVolShaperConfigsForWrapper(this.getFadeVolShaperConfigWrapperForAttr(this.mAttrToFadeWrapperMap.keyAt(index)));
            }
        }

        private void validateUnfadeableAudioAttributes() {
            for (int index = 0; index < this.mUnfadeableAudioAttributes.size(); ++index) {
                AudioAttributes targetAttr = this.mUnfadeableAudioAttributes.get(index);
                int usage = targetAttr.getSystemUsage();
                boolean isFadeableUsage = this.mFadeableUsages.contains(usage);
                Preconditions.checkArgument(!isFadeableUsage || isFadeableUsage && !Builder.isGeneric(targetAttr), "Unfadeable audio attributes cannot be generic of the fadeable usage");
            }
        }

        private static boolean isGeneric(AudioAttributes attr2) {
            return attr2.getContentType() == 0 && attr2.getFlags() == 0 && attr2.getBundle() == null && attr2.getTags().isEmpty();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FadeStateEnum {
    }
}

