/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import android.media.AudioRecordingMonitor;
import android.media.AudioRecordingMonitorClient;
import android.media.IAudioService;
import android.media.IRecordingConfigDispatcher;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public class AudioRecordingMonitorImpl
implements AudioRecordingMonitor {
    private static final String TAG = "android.media.AudioRecordingMonitor";
    private static IAudioService sService;
    private final AudioRecordingMonitorClient mClient;
    private static final int MSG_RECORDING_CONFIG_CHANGE = 1;
    private final Object mRecordCallbackLock = new Object();
    @GuardedBy(value={"mRecordCallbackLock"})
    @NonNull
    private LinkedList<AudioRecordingCallbackInfo> mRecordCallbackList = new LinkedList();
    @GuardedBy(value={"mRecordCallbackLock"})
    @Nullable
    private HandlerThread mRecordingCallbackHandlerThread;
    @GuardedBy(value={"mRecordCallbackLock"})
    @Nullable
    private volatile Handler mRecordingCallbackHandler;
    @GuardedBy(value={"mRecordCallbackLock"})
    private final IRecordingConfigDispatcher mRecordingCallback = new IRecordingConfigDispatcher.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchRecordingConfigChange(List<AudioRecordingConfiguration> configs) {
            AudioRecordingConfiguration config = AudioRecordingMonitorImpl.this.getMyConfig(configs);
            if (config != null) {
                Object object = AudioRecordingMonitorImpl.this.mRecordCallbackLock;
                synchronized (object) {
                    if (AudioRecordingMonitorImpl.this.mRecordingCallbackHandler != null) {
                        Message m = AudioRecordingMonitorImpl.this.mRecordingCallbackHandler.obtainMessage(1, config);
                        AudioRecordingMonitorImpl.this.mRecordingCallbackHandler.sendMessage(m);
                    }
                }
            }
        }
    };

    AudioRecordingMonitorImpl(@NonNull AudioRecordingMonitorClient client) {
        this.mClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAudioRecordingCallback(@NonNull Executor executor, @NonNull AudioManager.AudioRecordingCallback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null AudioRecordingCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor");
        }
        Object object = this.mRecordCallbackLock;
        synchronized (object) {
            for (AudioRecordingCallbackInfo arci : this.mRecordCallbackList) {
                if (arci.mCb != cb) continue;
                throw new IllegalArgumentException("AudioRecordingCallback already registered");
            }
            this.beginRecordingCallbackHandling();
            this.mRecordCallbackList.add(new AudioRecordingCallbackInfo(executor, cb));
        }
    }

    @Override
    public void unregisterAudioRecordingCallback(@NonNull AudioManager.AudioRecordingCallback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null AudioRecordingCallback argument");
        }
        Object object = this.mRecordCallbackLock;
        synchronized (object) {
            for (AudioRecordingCallbackInfo arci : this.mRecordCallbackList) {
                if (arci.mCb != cb) continue;
                this.mRecordCallbackList.remove(arci);
                if (this.mRecordCallbackList.size() == 0) {
                    this.endRecordingCallbackHandling();
                }
                return;
            }
            throw new IllegalArgumentException("AudioRecordingCallback was not registered");
        }
    }

    @Override
    @Nullable
    public AudioRecordingConfiguration getActiveRecordingConfiguration() {
        IAudioService service = AudioRecordingMonitorImpl.getService();
        try {
            List<AudioRecordingConfiguration> configs = service.getActiveRecordingConfigurations();
            return this.getMyConfig(configs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value={"mRecordCallbackLock"})
    private void beginRecordingCallbackHandling() {
        if (this.mRecordingCallbackHandlerThread == null) {
            this.mRecordingCallbackHandlerThread = new HandlerThread("android.media.AudioRecordingMonitor.RecordingCallback");
            this.mRecordingCallbackHandlerThread.start();
            Looper looper = this.mRecordingCallbackHandlerThread.getLooper();
            if (looper != null) {
                this.mRecordingCallbackHandler = new Handler(looper){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 1: {
                                LinkedList<AudioRecordingCallbackInfo> cbInfoList;
                                if (msg.obj == null) {
                                    return;
                                }
                                ArrayList<AudioRecordingConfiguration> configs = new ArrayList<AudioRecordingConfiguration>();
                                configs.add((AudioRecordingConfiguration)msg.obj);
                                Object object = AudioRecordingMonitorImpl.this.mRecordCallbackLock;
                                synchronized (object) {
                                    if (AudioRecordingMonitorImpl.this.mRecordCallbackList.size() == 0) {
                                        return;
                                    }
                                    cbInfoList = new LinkedList<AudioRecordingCallbackInfo>(AudioRecordingMonitorImpl.this.mRecordCallbackList);
                                }
                                long identity = Binder.clearCallingIdentity();
                                try {
                                    for (AudioRecordingCallbackInfo cbi : cbInfoList) {
                                        cbi.mExecutor.execute(() -> cbi.mCb.onRecordingConfigChanged(configs));
                                    }
                                    break;
                                }
                                finally {
                                    Binder.restoreCallingIdentity(identity);
                                }
                            }
                            default: {
                                Log.e(AudioRecordingMonitorImpl.TAG, "Unknown event " + msg.what);
                            }
                        }
                    }
                };
                IAudioService service = AudioRecordingMonitorImpl.getService();
                try {
                    service.registerRecordingCallback(this.mRecordingCallback);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @GuardedBy(value={"mRecordCallbackLock"})
    private void endRecordingCallbackHandling() {
        if (this.mRecordingCallbackHandlerThread != null) {
            IAudioService service = AudioRecordingMonitorImpl.getService();
            try {
                service.unregisterRecordingCallback(this.mRecordingCallback);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mRecordingCallbackHandlerThread.quit();
            this.mRecordingCallbackHandlerThread = null;
        }
    }

    AudioRecordingConfiguration getMyConfig(List<AudioRecordingConfiguration> configs) {
        int portId = this.mClient.getPortId();
        for (AudioRecordingConfiguration config : configs) {
            if (config.getClientPortId() != portId) continue;
            return config;
        }
        return null;
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private static class AudioRecordingCallbackInfo {
        final AudioManager.AudioRecordingCallback mCb;
        final Executor mExecutor;

        AudioRecordingCallbackInfo(Executor e, AudioManager.AudioRecordingCallback cb) {
            this.mExecutor = e;
            this.mCb = cb;
        }
    }
}

