/*
 * Decompiled with CFR 0.152.
 */
package android.location.provider;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.location.flags.new_geocoder")
public class ReverseGeocodeRequest
implements Parcelable {
    private final double mLatitude;
    private final double mLongitude;
    private final int mMaxResults;
    private final Locale mLocale;
    private final int mCallingUid;
    private final String mCallingPackage;
    @Nullable
    private final String mCallingAttributionTag;
    @NonNull
    public static final Parcelable.Creator<ReverseGeocodeRequest> CREATOR = new Parcelable.Creator<ReverseGeocodeRequest>(){

        @Override
        public ReverseGeocodeRequest createFromParcel(Parcel in) {
            return new ReverseGeocodeRequest(in.readDouble(), in.readDouble(), in.readInt(), new Locale(in.readString8(), in.readString8(), in.readString8()), in.readInt(), Objects.requireNonNull(in.readString8()), in.readString8());
        }

        public ReverseGeocodeRequest[] newArray(int size) {
            return new ReverseGeocodeRequest[size];
        }
    };

    private ReverseGeocodeRequest(double latitude, double longitude, int maxResults, Locale locale, int callingUid, String callingPackage, @Nullable String callingAttributionTag) {
        Preconditions.checkArgumentInRange(latitude, -90.0, 90.0, "latitude");
        Preconditions.checkArgumentInRange(longitude, -180.0, 180.0, "longitude");
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mMaxResults = Math.max(maxResults, 1);
        this.mLocale = Objects.requireNonNull(locale);
        this.mCallingUid = callingUid;
        this.mCallingPackage = Objects.requireNonNull(callingPackage);
        this.mCallingAttributionTag = callingAttributionTag;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public int getMaxResults() {
        return this.mMaxResults;
    }

    @NonNull
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getCallingUid() {
        return this.mCallingUid;
    }

    @NonNull
    public String getCallingPackage() {
        return this.mCallingPackage;
    }

    @Nullable
    public String getCallingAttributionTag() {
        return this.mCallingAttributionTag;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeInt(this.mMaxResults);
        parcel.writeString8(this.mLocale.getLanguage());
        parcel.writeString8(this.mLocale.getCountry());
        parcel.writeString8(this.mLocale.getVariant());
        parcel.writeInt(this.mCallingUid);
        parcel.writeString8(this.mCallingPackage);
        parcel.writeString8(this.mCallingAttributionTag);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof ReverseGeocodeRequest) {
            ReverseGeocodeRequest that = (ReverseGeocodeRequest)object;
            return this.mLatitude == that.mLatitude && this.mLongitude == that.mLongitude && this.mMaxResults == that.mMaxResults && this.mCallingUid == that.mCallingUid && ((Object)this.mLocale).equals(that.mLocale) && this.mCallingPackage.equals(that.mCallingPackage) && Objects.equals(this.mCallingAttributionTag, that.mCallingAttributionTag);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mLatitude, this.mLongitude, this.mMaxResults, this.mLocale, this.mCallingUid, this.mCallingPackage, this.mCallingAttributionTag);
    }

    public static class Builder {
        private final double mLatitude;
        private final double mLongitude;
        private final int mMaxResults;
        private final Locale mLocale;
        private final int mCallingUid;
        private final String mCallingPackage;
        @Nullable
        private String mCallingAttributionTag;

        public Builder(double latitude, double longitude, int maxResults, @NonNull Locale locale, int callingUid, @NonNull String callingPackage) {
            this.mLatitude = latitude;
            this.mLongitude = longitude;
            this.mMaxResults = maxResults;
            this.mLocale = locale;
            this.mCallingUid = callingUid;
            this.mCallingPackage = callingPackage;
            this.mCallingAttributionTag = null;
        }

        @NonNull
        public Builder setCallingAttributionTag(@NonNull String attributionTag) {
            this.mCallingAttributionTag = attributionTag;
            return this;
        }

        @NonNull
        public ReverseGeocodeRequest build() {
            return new ReverseGeocodeRequest(this.mLatitude, this.mLongitude, this.mMaxResults, this.mLocale, this.mCallingUid, this.mCallingPackage, this.mCallingAttributionTag);
        }
    }
}

