/*
 * Decompiled with CFR 0.152.
 */
package android.location.provider;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ProviderProperties
implements Parcelable {
    public static final int POWER_USAGE_LOW = 1;
    public static final int POWER_USAGE_MEDIUM = 2;
    public static final int POWER_USAGE_HIGH = 3;
    public static final int ACCURACY_FINE = 1;
    public static final int ACCURACY_COARSE = 2;
    private final boolean mHasNetworkRequirement;
    private final boolean mHasSatelliteRequirement;
    private final boolean mHasCellRequirement;
    private final boolean mHasMonetaryCost;
    private final boolean mHasAltitudeSupport;
    private final boolean mHasSpeedSupport;
    private final boolean mHasBearingSupport;
    private final int mPowerUsage;
    private final int mAccuracy;
    @NonNull
    public static final Parcelable.Creator<ProviderProperties> CREATOR = new Parcelable.Creator<ProviderProperties>(){

        @Override
        public ProviderProperties createFromParcel(Parcel in) {
            return new ProviderProperties(in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readInt(), in.readInt());
        }

        public ProviderProperties[] newArray(int size) {
            return new ProviderProperties[size];
        }
    };

    private ProviderProperties(boolean hasNetworkRequirement, boolean hasSatelliteRequirement, boolean hasCellRequirement, boolean hasMonetaryCost, boolean hasAltitudeSupport, boolean hasSpeedSupport, boolean hasBearingSupport, int powerUsage, int accuracy) {
        this.mHasNetworkRequirement = hasNetworkRequirement;
        this.mHasSatelliteRequirement = hasSatelliteRequirement;
        this.mHasCellRequirement = hasCellRequirement;
        this.mHasMonetaryCost = hasMonetaryCost;
        this.mHasAltitudeSupport = hasAltitudeSupport;
        this.mHasSpeedSupport = hasSpeedSupport;
        this.mHasBearingSupport = hasBearingSupport;
        this.mPowerUsage = powerUsage;
        this.mAccuracy = accuracy;
    }

    public boolean hasNetworkRequirement() {
        return this.mHasNetworkRequirement;
    }

    public boolean hasSatelliteRequirement() {
        return this.mHasSatelliteRequirement;
    }

    public boolean hasCellRequirement() {
        return this.mHasCellRequirement;
    }

    public boolean hasMonetaryCost() {
        return this.mHasMonetaryCost;
    }

    public boolean hasAltitudeSupport() {
        return this.mHasAltitudeSupport;
    }

    public boolean hasSpeedSupport() {
        return this.mHasSpeedSupport;
    }

    public boolean hasBearingSupport() {
        return this.mHasBearingSupport;
    }

    public int getPowerUsage() {
        return this.mPowerUsage;
    }

    public int getAccuracy() {
        return this.mAccuracy;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeBoolean(this.mHasNetworkRequirement);
        parcel.writeBoolean(this.mHasSatelliteRequirement);
        parcel.writeBoolean(this.mHasCellRequirement);
        parcel.writeBoolean(this.mHasMonetaryCost);
        parcel.writeBoolean(this.mHasAltitudeSupport);
        parcel.writeBoolean(this.mHasSpeedSupport);
        parcel.writeBoolean(this.mHasBearingSupport);
        parcel.writeInt(this.mPowerUsage);
        parcel.writeInt(this.mAccuracy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProviderProperties)) {
            return false;
        }
        ProviderProperties that = (ProviderProperties)o;
        return this.mHasNetworkRequirement == that.mHasNetworkRequirement && this.mHasSatelliteRequirement == that.mHasSatelliteRequirement && this.mHasCellRequirement == that.mHasCellRequirement && this.mHasMonetaryCost == that.mHasMonetaryCost && this.mHasAltitudeSupport == that.mHasAltitudeSupport && this.mHasSpeedSupport == that.mHasSpeedSupport && this.mHasBearingSupport == that.mHasBearingSupport && this.mPowerUsage == that.mPowerUsage && this.mAccuracy == that.mAccuracy;
    }

    public int hashCode() {
        return Objects.hash(this.mHasNetworkRequirement, this.mHasSatelliteRequirement, this.mHasCellRequirement, this.mHasMonetaryCost, this.mHasAltitudeSupport, this.mHasSpeedSupport, this.mHasBearingSupport, this.mPowerUsage, this.mAccuracy);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ProviderProperties[");
        b.append("powerUsage=").append(ProviderProperties.powerToString(this.mPowerUsage)).append(", ");
        b.append("accuracy=").append(ProviderProperties.accuracyToString(this.mAccuracy));
        if (this.mHasNetworkRequirement || this.mHasSatelliteRequirement || this.mHasCellRequirement) {
            b.append(", requires=");
            if (this.mHasNetworkRequirement) {
                b.append("network,");
            }
            if (this.mHasSatelliteRequirement) {
                b.append("satellite,");
            }
            if (this.mHasCellRequirement) {
                b.append("cell,");
            }
            b.setLength(b.length() - 1);
        }
        if (this.mHasMonetaryCost) {
            b.append(", hasMonetaryCost");
        }
        if (this.mHasBearingSupport || this.mHasSpeedSupport || this.mHasAltitudeSupport) {
            b.append(", supports=[");
            if (this.mHasBearingSupport) {
                b.append("bearing,");
            }
            if (this.mHasSpeedSupport) {
                b.append("speed,");
            }
            if (this.mHasAltitudeSupport) {
                b.append("altitude,");
            }
            b.setLength(b.length() - 1);
            b.append("]");
        }
        b.append("]");
        return b.toString();
    }

    private static String powerToString(int power) {
        switch (power) {
            case 1: {
                return "Low";
            }
            case 2: {
                return "Medium";
            }
            case 3: {
                return "High";
            }
        }
        throw new AssertionError();
    }

    private static String accuracyToString(int accuracy) {
        switch (accuracy) {
            case 2: {
                return "Coarse";
            }
            case 1: {
                return "Fine";
            }
        }
        throw new AssertionError();
    }

    public static class Builder {
        private boolean mHasNetworkRequirement;
        private boolean mHasSatelliteRequirement;
        private boolean mHasCellRequirement;
        private boolean mHasMonetaryCost;
        private boolean mHasAltitudeSupport;
        private boolean mHasSpeedSupport;
        private boolean mHasBearingSupport;
        private int mPowerUsage;
        private int mAccuracy;

        public Builder() {
            this.mHasNetworkRequirement = false;
            this.mHasSatelliteRequirement = false;
            this.mHasCellRequirement = false;
            this.mHasMonetaryCost = false;
            this.mHasAltitudeSupport = false;
            this.mHasSpeedSupport = false;
            this.mHasBearingSupport = false;
            this.mPowerUsage = 3;
            this.mAccuracy = 2;
        }

        public Builder(@NonNull ProviderProperties providerProperties) {
            this.mHasNetworkRequirement = providerProperties.mHasNetworkRequirement;
            this.mHasSatelliteRequirement = providerProperties.mHasSatelliteRequirement;
            this.mHasCellRequirement = providerProperties.mHasCellRequirement;
            this.mHasMonetaryCost = providerProperties.mHasMonetaryCost;
            this.mHasAltitudeSupport = providerProperties.mHasAltitudeSupport;
            this.mHasSpeedSupport = providerProperties.mHasSpeedSupport;
            this.mHasBearingSupport = providerProperties.mHasBearingSupport;
            this.mPowerUsage = providerProperties.mPowerUsage;
            this.mAccuracy = providerProperties.mAccuracy;
        }

        @NonNull
        public Builder setHasNetworkRequirement(boolean requiresNetwork) {
            this.mHasNetworkRequirement = requiresNetwork;
            return this;
        }

        @NonNull
        public Builder setHasSatelliteRequirement(boolean requiresSatellite) {
            this.mHasSatelliteRequirement = requiresSatellite;
            return this;
        }

        @NonNull
        public Builder setHasCellRequirement(boolean requiresCell) {
            this.mHasCellRequirement = requiresCell;
            return this;
        }

        @NonNull
        public Builder setHasMonetaryCost(boolean monetaryCost) {
            this.mHasMonetaryCost = monetaryCost;
            return this;
        }

        @NonNull
        public Builder setHasAltitudeSupport(boolean supportsAltitude) {
            this.mHasAltitudeSupport = supportsAltitude;
            return this;
        }

        @NonNull
        public Builder setHasSpeedSupport(boolean supportsSpeed) {
            this.mHasSpeedSupport = supportsSpeed;
            return this;
        }

        @NonNull
        public Builder setHasBearingSupport(boolean supportsBearing) {
            this.mHasBearingSupport = supportsBearing;
            return this;
        }

        @NonNull
        public Builder setPowerUsage(int powerUsage) {
            this.mPowerUsage = Preconditions.checkArgumentInRange(powerUsage, 1, 3, "powerUsage");
            return this;
        }

        @NonNull
        public Builder setAccuracy(int accuracy) {
            this.mAccuracy = Preconditions.checkArgumentInRange(accuracy, 1, 2, "accuracy");
            return this;
        }

        @NonNull
        public ProviderProperties build() {
            return new ProviderProperties(this.mHasNetworkRequirement, this.mHasSatelliteRequirement, this.mHasCellRequirement, this.mHasMonetaryCost, this.mHasAltitudeSupport, this.mHasSpeedSupport, this.mHasBearingSupport, this.mPowerUsage, this.mAccuracy);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Accuracy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerUsage {
    }
}

