/*
 * Decompiled with CFR 0.152.
 */
package android.location.provider;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.location.flags.new_geocoder")
public class ForwardGeocodeRequest
implements Parcelable {
    private final String mLocationName;
    private final double mLowerLeftLatitude;
    private final double mLowerLeftLongitude;
    private final double mUpperRightLatitude;
    private final double mUpperRightLongitude;
    private final int mMaxResults;
    private final Locale mLocale;
    private final int mCallingUid;
    private final String mCallingPackage;
    @Nullable
    private final String mCallingAttributionTag;
    @NonNull
    public static final Parcelable.Creator<ForwardGeocodeRequest> CREATOR = new Parcelable.Creator<ForwardGeocodeRequest>(){

        @Override
        public ForwardGeocodeRequest createFromParcel(Parcel in) {
            return new ForwardGeocodeRequest(Objects.requireNonNull(in.readString8()), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readInt(), new Locale(in.readString8(), in.readString8(), in.readString8()), in.readInt(), Objects.requireNonNull(in.readString8()), in.readString8());
        }

        public ForwardGeocodeRequest[] newArray(int size) {
            return new ForwardGeocodeRequest[size];
        }
    };

    private ForwardGeocodeRequest(@NonNull String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, @NonNull Locale locale, int callingUid, @NonNull String callingPackage, @Nullable String callingAttributionTag) {
        Preconditions.checkArgument(locationName != null, "locationName must not be null");
        Preconditions.checkArgumentInRange(lowerLeftLatitude, -90.0, 90.0, "lowerLeftLatitude");
        Preconditions.checkArgumentInRange(lowerLeftLongitude, -180.0, 180.0, "lowerLeftLongitude");
        Preconditions.checkArgumentInRange(upperRightLatitude, -90.0, 90.0, "upperRightLatitude");
        Preconditions.checkArgumentInRange(upperRightLongitude, -180.0, 180.0, "upperRightLongitude");
        this.mLocationName = locationName;
        this.mLowerLeftLatitude = lowerLeftLatitude;
        this.mLowerLeftLongitude = lowerLeftLongitude;
        this.mUpperRightLatitude = upperRightLatitude;
        this.mUpperRightLongitude = upperRightLongitude;
        this.mMaxResults = Math.max(maxResults, 1);
        this.mLocale = Objects.requireNonNull(locale);
        this.mCallingUid = callingUid;
        this.mCallingPackage = Objects.requireNonNull(callingPackage);
        this.mCallingAttributionTag = callingAttributionTag;
    }

    @NonNull
    public String getLocationName() {
        return this.mLocationName;
    }

    public double getLowerLeftLatitude() {
        return this.mLowerLeftLatitude;
    }

    public double getLowerLeftLongitude() {
        return this.mLowerLeftLongitude;
    }

    public double getUpperRightLatitude() {
        return this.mUpperRightLatitude;
    }

    public double getUpperRightLongitude() {
        return this.mUpperRightLongitude;
    }

    public int getMaxResults() {
        return this.mMaxResults;
    }

    @NonNull
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getCallingUid() {
        return this.mCallingUid;
    }

    @NonNull
    public String getCallingPackage() {
        return this.mCallingPackage;
    }

    @Nullable
    public String getCallingAttributionTag() {
        return this.mCallingAttributionTag;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeString8(this.mLocationName);
        parcel.writeDouble(this.mLowerLeftLatitude);
        parcel.writeDouble(this.mLowerLeftLongitude);
        parcel.writeDouble(this.mUpperRightLatitude);
        parcel.writeDouble(this.mUpperRightLongitude);
        parcel.writeInt(this.mMaxResults);
        parcel.writeString8(this.mLocale.getLanguage());
        parcel.writeString8(this.mLocale.getCountry());
        parcel.writeString8(this.mLocale.getVariant());
        parcel.writeInt(this.mCallingUid);
        parcel.writeString8(this.mCallingPackage);
        parcel.writeString8(this.mCallingAttributionTag);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof ForwardGeocodeRequest) {
            ForwardGeocodeRequest that = (ForwardGeocodeRequest)object;
            return this.mLowerLeftLatitude == that.mLowerLeftLatitude && this.mLowerLeftLongitude == that.mLowerLeftLongitude && this.mUpperRightLatitude == that.mUpperRightLatitude && this.mUpperRightLongitude == that.mUpperRightLongitude && this.mMaxResults == that.mMaxResults && this.mCallingUid == that.mCallingUid && ((Object)this.mLocale).equals(that.mLocale) && this.mCallingPackage.equals(that.mCallingPackage) && this.mLocationName.equals(that.mLocationName) && Objects.equals(this.mCallingAttributionTag, that.mCallingAttributionTag);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mLocationName, this.mLowerLeftLatitude, this.mLowerLeftLongitude, this.mUpperRightLatitude, this.mUpperRightLongitude, this.mMaxResults, this.mLocale, this.mCallingUid, this.mCallingPackage, this.mCallingAttributionTag);
    }

    public static class Builder {
        private final String mLocationName;
        private final double mLowerLeftLatitude;
        private final double mLowerLeftLongitude;
        private final double mUpperRightLatitude;
        private final double mUpperRightLongitude;
        private final int mMaxResults;
        private final Locale mLocale;
        private final int mCallingUid;
        private final String mCallingPackage;
        @Nullable
        private String mCallingAttributionTag;

        public Builder(@NonNull String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, @NonNull Locale locale, int callingUid, @NonNull String callingPackage) {
            this.mLocationName = locationName;
            this.mLowerLeftLatitude = lowerLeftLatitude;
            this.mLowerLeftLongitude = lowerLeftLongitude;
            this.mUpperRightLatitude = upperRightLatitude;
            this.mUpperRightLongitude = upperRightLongitude;
            this.mMaxResults = maxResults;
            this.mLocale = locale;
            this.mCallingUid = callingUid;
            this.mCallingPackage = callingPackage;
            this.mCallingAttributionTag = null;
        }

        @NonNull
        public Builder setCallingAttributionTag(@NonNull String attributionTag) {
            this.mCallingAttributionTag = attributionTag;
            return this;
        }

        @NonNull
        public ForwardGeocodeRequest build() {
            return new ForwardGeocodeRequest(this.mLocationName, this.mLowerLeftLatitude, this.mLowerLeftLongitude, this.mUpperRightLatitude, this.mUpperRightLongitude, this.mMaxResults, this.mLocale, this.mCallingUid, this.mCallingPackage, this.mCallingAttributionTag);
        }
    }
}

