/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Duration;
import java.time.Instant;

public class LocationTime
implements Parcelable {
    private final long mUnixEpochTimeMillis;
    private final long mElapsedRealtimeNanos;
    @NonNull
    public static final Parcelable.Creator<LocationTime> CREATOR = new Parcelable.Creator<LocationTime>(){

        @Override
        public LocationTime createFromParcel(Parcel in) {
            long time = in.readLong();
            long elapsedRealtimeNanos = in.readLong();
            return new LocationTime(time, elapsedRealtimeNanos);
        }

        public LocationTime[] newArray(int size) {
            return new LocationTime[size];
        }
    };

    public LocationTime(long unixEpochTimeMillis, long elapsedRealtimeNanos) {
        this.mUnixEpochTimeMillis = unixEpochTimeMillis;
        this.mElapsedRealtimeNanos = elapsedRealtimeNanos;
    }

    public long getUnixEpochTimeMillis() {
        return this.mUnixEpochTimeMillis;
    }

    public long getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNanos;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mUnixEpochTimeMillis);
        out.writeLong(this.mElapsedRealtimeNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "LocationTime{mUnixEpochTimeMillis=" + Instant.ofEpochMilli(this.mUnixEpochTimeMillis) + "(" + this.mUnixEpochTimeMillis + "), mElapsedRealtimeNanos=" + Duration.ofNanos(this.mElapsedRealtimeNanos) + "(" + this.mElapsedRealtimeNanos + ")" + '}';
    }
}

