/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GnssStatus;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IGnssStatusListener
extends IInterface {
    public void onGnssStarted() throws RemoteException;

    public void onGnssStopped() throws RemoteException;

    public void onFirstFix(int var1) throws RemoteException;

    public void onSvStatusChanged(GnssStatus var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGnssStatusListener {
        public static final String DESCRIPTOR = "android.location.IGnssStatusListener";
        static final int TRANSACTION_onGnssStarted = 1;
        static final int TRANSACTION_onGnssStopped = 2;
        static final int TRANSACTION_onFirstFix = 3;
        static final int TRANSACTION_onSvStatusChanged = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IGnssStatusListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IGnssStatusListener) {
                return (IGnssStatusListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onGnssStarted";
                }
                case 2: {
                    return "onGnssStopped";
                }
                case 3: {
                    return "onFirstFix";
                }
                case 4: {
                    return "onSvStatusChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.onGnssStarted();
                    break;
                }
                case 2: {
                    this.onGnssStopped();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFirstFix(_arg0);
                    break;
                }
                case 4: {
                    GnssStatus _arg0 = data.readTypedObject(GnssStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSvStatusChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IGnssStatusListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onGnssStarted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onGnssStopped() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFirstFix(int ttff) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ttff);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSvStatusChanged(GnssStatus gnssStatus) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(gnssStatus, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IGnssStatusListener {
        @Override
        public void onGnssStarted() throws RemoteException {
        }

        @Override
        public void onGnssStopped() throws RemoteException {
        }

        @Override
        public void onFirstFix(int ttff) throws RemoteException {
        }

        @Override
        public void onSvStatusChanged(GnssStatus gnssStatus) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

