/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.location.GnssMeasurementRequest;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class GnssRequest
implements Parcelable {
    private final boolean mFullTracking;
    @NonNull
    public static final Parcelable.Creator<GnssRequest> CREATOR = new Parcelable.Creator<GnssRequest>(){

        @Override
        @NonNull
        public GnssRequest createFromParcel(@NonNull Parcel parcel) {
            return new GnssRequest(parcel.readBoolean());
        }

        public GnssRequest[] newArray(int i) {
            return new GnssRequest[i];
        }
    };

    private GnssRequest(boolean fullTracking) {
        this.mFullTracking = fullTracking;
    }

    public boolean isFullTracking() {
        return this.mFullTracking;
    }

    @NonNull
    public GnssMeasurementRequest toGnssMeasurementRequest() {
        return new GnssMeasurementRequest.Builder().setFullTracking(this.isFullTracking()).build();
    }

    @NonNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("GnssRequest[");
        if (this.mFullTracking) {
            s.append("FullTracking");
        }
        s.append(']');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GnssRequest)) {
            return false;
        }
        GnssRequest other = (GnssRequest)obj;
        return this.mFullTracking == other.mFullTracking;
    }

    public int hashCode() {
        return this.mFullTracking ? 1 : 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeBoolean(this.mFullTracking);
    }

    public static class Builder {
        private boolean mFullTracking;

        public Builder() {
        }

        public Builder(@NonNull GnssRequest request) {
            this.mFullTracking = request.isFullTracking();
        }

        @NonNull
        public Builder setFullTracking(boolean value) {
            this.mFullTracking = value;
            return this;
        }

        @NonNull
        public GnssRequest build() {
            return new GnssRequest(this.mFullTracking);
        }
    }
}

