/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.app.Dialog;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.ExtractEditText;
import android.inputmethodservice.ImsConfigurationTracker;
import android.inputmethodservice.InkWindow;
import android.inputmethodservice.InlineSuggestionSessionController;
import android.inputmethodservice.InputMethodServiceInternal;
import android.inputmethodservice.NavigationBarController;
import android.inputmethodservice.RemoteInputConnection;
import android.inputmethodservice.SoftInputWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.os.Trace;
import android.provider.Settings;
import android.text.Layout;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.Xml;
import android.util.proto.ProtoOutputStream;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InlineSuggestionsRequest;
import android.view.inputmethod.InlineSuggestionsResponse;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.window.CompatOnBackInvokedCallback;
import android.window.ImeOnBackInvokedDispatcher;
import android.window.WindowMetricsHelper;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.input.flags.Flags;
import com.android.internal.inputmethod.IConnectionlessHandwritingCallback;
import com.android.internal.inputmethod.IInlineSuggestionsRequestCallback;
import com.android.internal.inputmethod.IInputContentUriToken;
import com.android.internal.inputmethod.IInputMethod;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.ImeTracing;
import com.android.internal.inputmethod.InlineSuggestionsRequestInfo;
import com.android.internal.inputmethod.InputMethodPrivilegedOperations;
import com.android.internal.inputmethod.InputMethodPrivilegedOperationsRegistry;
import com.android.internal.util.RingBuffer;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.xmlpull.v1.XmlPullParserException;

public class InputMethodService
extends AbstractInputMethodService {
    static final String TAG = "InputMethodService";
    static final boolean DEBUG = false;
    private static final int MAX_EVENTS_BUFFER = 500;
    private static final long STYLUS_HANDWRITING_IDLE_TIMEOUT_MS = 10000L;
    private static final long STYLUS_HANDWRITING_IDLE_TIMEOUT_MAX_MS = 30000L;
    private static final long STYLUS_WINDOW_IDLE_TIMEOUT_MILLIS = 300000L;
    private RingBuffer<MotionEvent> mPendingEvents;
    private ImeOnBackInvokedDispatcher mImeDispatcher;
    private boolean mBackCallbackRegistered = false;
    private final CompatOnBackInvokedCallback mCompatBackCallback = this::compatHandleBack;
    private Runnable mImeSurfaceRemoverRunnable;
    private Runnable mFinishHwRunnable;
    private long mStylusHwSessionsTimeout = 10000L;
    private Runnable mStylusWindowIdleTimeoutRunnable;
    private long mStylusWindowIdleTimeoutForTest;
    private boolean mUsingCtrlShiftShortcut = false;
    private Region mLastHandwritingRegion;
    public static final int BACK_DISPOSITION_DEFAULT = 0;
    @Deprecated
    public static final int BACK_DISPOSITION_WILL_NOT_DISMISS = 1;
    @Deprecated
    public static final int BACK_DISPOSITION_WILL_DISMISS = 2;
    public static final int BACK_DISPOSITION_ADJUST_NOTHING = 3;
    public static final int IME_ACTIVE = 1;
    public static final int IME_VISIBLE = 2;
    private static final int BACK_DISPOSITION_MIN = 0;
    private static final int BACK_DISPOSITION_MAX = 3;
    private static final long TIMEOUT_SURFACE_REMOVAL_MILLIS = 500L;
    InputMethodManager mImm;
    private InputMethodPrivilegedOperations mPrivOps = new InputMethodPrivilegedOperations();
    @NonNull
    private final NavigationBarController mNavigationBarController = new NavigationBarController(this);
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mTheme = 0;
    public static final long FINISH_INPUT_NO_FALLBACK_CONNECTION = 156215187L;
    public static final long DISALLOW_INPUT_METHOD_INTERFACE_OVERRIDE = 148086656L;
    LayoutInflater mInflater;
    TypedArray mThemeAttrs;
    @UnsupportedAppUsage
    View mRootView;
    SoftInputWindow mWindow;
    boolean mInitialized;
    boolean mViewsCreated;
    boolean mDecorViewVisible;
    boolean mDecorViewWasVisible;
    boolean mInShowWindow;
    boolean mWindowVisible;
    ViewGroup mFullscreenArea;
    FrameLayout mExtractFrame;
    FrameLayout mCandidatesFrame;
    FrameLayout mInputFrame;
    IBinder mToken;
    InputBinding mInputBinding;
    InputConnection mInputConnection;
    boolean mInputStarted;
    boolean mInputViewStarted;
    boolean mCandidatesViewStarted;
    InputConnection mStartedInputConnection;
    EditorInfo mInputEditorInfo;
    int mShowInputFlags;
    boolean mShowInputRequested;
    boolean mLastShowInputRequested;
    int mCandidatesVisibility;
    CompletionInfo[] mCurCompletions;
    boolean mFullscreenApplied;
    boolean mIsFullscreen;
    private boolean mLastWasInFullscreenMode;
    @UnsupportedAppUsage
    View mExtractView;
    boolean mExtractViewHidden;
    @UnsupportedAppUsage
    ExtractEditText mExtractEditText;
    ViewGroup mExtractAccessories;
    View mExtractAction;
    ExtractedText mExtractedText;
    int mExtractedToken;
    View mInputView;
    boolean mIsInputViewShown;
    int mStatusIcon;
    int mBackDisposition;
    @ImeWindowVisibility
    private int mImeWindowVisibility;
    private Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mNotifyUserActionSent;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    final Insets mTmpInsets = new Insets();
    final int[] mTmpLocation = new int[2];
    private InlineSuggestionSessionController mInlineSuggestionSessionController;
    @NonNull
    private OptionalInt mHandwritingRequestId = OptionalInt.empty();
    private InputEventReceiver mHandwritingEventReceiver;
    private Handler mHandler;
    private ImsConfigurationTracker mConfigTracker = new ImsConfigurationTracker();
    private boolean mDestroyed;
    private boolean mOnPreparedStylusHwCalled;
    private InkWindow mInkWindow;
    private IConnectionlessHandwritingCallback mConnectionlessHandwritingCallback;
    private boolean mIsConnectionlessHandwritingForDelegation;
    private CharSequence mHandwritingDelegationText;
    @Nullable
    private ImeTracker.Token mCurStatsToken;
    final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer = info -> {
        this.onComputeInsets(this.mTmpInsets);
        this.mNavigationBarController.updateInsets(this.mTmpInsets);
        if (this.isExtractViewShown()) {
            View decor = this.getWindow().getWindow().getDecorView();
            info.contentInsets.top = info.visibleInsets.top = decor.getHeight();
            info.touchableRegion.setEmpty();
            info.setTouchableInsets(0);
        } else {
            info.contentInsets.top = this.mTmpInsets.contentTopInsets;
            info.visibleInsets.top = this.mTmpInsets.visibleTopInsets;
            info.touchableRegion.set(this.mTmpInsets.touchableRegion);
            info.setTouchableInsets(this.mTmpInsets.touchableInsets);
        }
        this.mNavigationBarController.updateTouchableInsets(this.mTmpInsets, info);
        if (this.mInputFrame != null) {
            this.setImeExclusionRect(this.mTmpInsets.visibleTopInsets);
        }
    };
    final View.OnClickListener mActionClickListener = v -> {
        EditorInfo ei = this.getCurrentInputEditorInfo();
        InputConnection ic = this.getCurrentInputConnection();
        if (ei != null && ic != null) {
            if (ei.actionId != 0) {
                ic.performEditorAction(ei.actionId);
            } else if ((ei.imeOptions & 0xFF) != 1) {
                ic.performEditorAction(ei.imeOptions & 0xFF);
            }
        }
    };
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private SettingsObserver mSettingsObserver;
    static final int MOVEMENT_DOWN = -1;
    static final int MOVEMENT_UP = -2;
    private final ImeTracing.ServiceDumper mDumper = new ImeTracing.ServiceDumper(){

        @Override
        public void dumpToProto(ProtoOutputStream proto, @Nullable byte[] icProto) {
            long token = proto.start(1146756268035L);
            InputMethodService.this.mWindow.dumpDebug(proto, 0x10B00000001L);
            proto.write(1133871366146L, InputMethodService.this.mViewsCreated);
            proto.write(1133871366147L, InputMethodService.this.mDecorViewVisible);
            proto.write(1133871366148L, InputMethodService.this.mDecorViewWasVisible);
            proto.write(1133871366149L, InputMethodService.this.mWindowVisible);
            proto.write(1133871366150L, InputMethodService.this.mInShowWindow);
            proto.write(1138166333447L, InputMethodService.this.getResources().getConfiguration().toString());
            proto.write(1138166333448L, Objects.toString(InputMethodService.this.mToken));
            proto.write(0x10900000009L, Objects.toString(InputMethodService.this.mInputBinding));
            proto.write(1133871366154L, InputMethodService.this.mInputStarted);
            proto.write(1133871366155L, InputMethodService.this.mInputViewStarted);
            proto.write(1133871366156L, InputMethodService.this.mCandidatesViewStarted);
            if (InputMethodService.this.mInputEditorInfo != null) {
                InputMethodService.this.mInputEditorInfo.dumpDebug(proto, 1146756268045L);
            }
            proto.write(1133871366158L, InputMethodService.this.mShowInputRequested);
            proto.write(1133871366159L, InputMethodService.this.mLastShowInputRequested);
            proto.write(1120986464274L, InputMethodService.this.mShowInputFlags);
            proto.write(1120986464275L, InputMethodService.this.mCandidatesVisibility);
            proto.write(1133871366164L, InputMethodService.this.mFullscreenApplied);
            proto.write(1133871366165L, InputMethodService.this.mIsFullscreen);
            proto.write(1133871366166L, InputMethodService.this.mExtractViewHidden);
            proto.write(1120986464279L, InputMethodService.this.mExtractedToken);
            proto.write(0x10800000018L, InputMethodService.this.mIsInputViewShown);
            proto.write(1120986464281L, InputMethodService.this.mStatusIcon);
            InputMethodService.this.mTmpInsets.dumpDebug(proto, 1146756268058L);
            proto.write(1138166333467L, Objects.toString(InputMethodService.this.mSettingsObserver));
            if (icProto != null) {
                proto.write(1146756268060L, icProto);
            }
            proto.end(token);
        }
    };

    @Nullable
    public InlineSuggestionsRequest onCreateInlineSuggestionsRequest(@NonNull Bundle uiExtras) {
        return null;
    }

    public boolean onInlineSuggestionsResponse(@NonNull InlineSuggestionsResponse response) {
        return false;
    }

    @Nullable
    private IBinder getHostInputToken() {
        ViewRootImpl viewRoot = null;
        if (this.mRootView != null) {
            viewRoot = this.mRootView.getViewRootImpl();
        }
        return viewRoot == null ? null : viewRoot.getInputToken();
    }

    private void scheduleImeSurfaceRemoval() {
        if (this.mShowInputRequested || this.mWindowVisible || this.mWindow == null || this.mImeSurfaceRemoverRunnable != null) {
            return;
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.getMainLooper());
        }
        if (this.mLastWasInFullscreenMode) {
            this.removeImeSurface();
        } else {
            this.mImeSurfaceRemoverRunnable = () -> this.removeImeSurface();
            this.mHandler.postDelayed(this.mImeSurfaceRemoverRunnable, 500L);
        }
    }

    private void removeImeSurface() {
        this.cancelImeSurfaceRemoval();
        if (this.mWindow != null) {
            this.mWindow.hide();
        }
    }

    private void cancelImeSurfaceRemoval() {
        if (this.mHandler != null && this.mImeSurfaceRemoverRunnable != null) {
            this.mHandler.removeCallbacks(this.mImeSurfaceRemoverRunnable);
        }
        this.mImeSurfaceRemoverRunnable = null;
    }

    private void setImeWindowVisibility(@ImeWindowVisibility int vis) {
        if (vis == this.mImeWindowVisibility) {
            return;
        }
        this.mImeWindowVisibility = vis;
        this.setImeWindowStatus(this.mImeWindowVisibility, this.mBackDisposition);
    }

    private void setImeWindowStatus(@ImeWindowVisibility int vis, int backDisposition) {
        this.mPrivOps.setImeWindowStatusAsync(vis, backDisposition);
    }

    private void setImeExclusionRect(int visibleTopInsets) {
        View rootView = this.mInputFrame.getRootView();
        android.graphics.Insets systemGesture = rootView.getRootWindowInsets().getInsets(WindowInsets.Type.systemGestures());
        ArrayList<Rect> exclusionRects = new ArrayList<Rect>();
        exclusionRects.add(new Rect(0, visibleTopInsets, systemGesture.left, rootView.getHeight()));
        exclusionRects.add(new Rect(rootView.getWidth() - systemGesture.right, visibleTopInsets, rootView.getWidth(), rootView.getHeight()));
        rootView.setSystemGestureExclusionRects(exclusionRects);
    }

    private void updateEditorToolTypeInternal(int toolType) {
        if (this.mInputEditorInfo != null) {
            this.mInputEditorInfo.setInitialToolType(toolType);
        }
        this.onUpdateEditorToolType(toolType);
    }

    @VisibleForTesting
    public boolean getShouldShowImeWithHardKeyboardForTesting() {
        return this.mSettingsObserver.shouldShowImeWithHardKeyboard();
    }

    @Override
    public void setTheme(int theme) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = theme;
    }

    @Deprecated
    public boolean enableHardwareAcceleration() {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        return ActivityManager.isHighEndGfx();
    }

    @Override
    public void onCreate() {
        if (this.methodIsOverridden("onCreateInputMethodSessionInterface", new Class[0]) && CompatChanges.isChangeEnabled(148086656L)) {
            throw new LinkageError("InputMethodService#onCreateInputMethodSessionInterface() can no longer be overridden!");
        }
        Trace.traceBegin(32L, "IMS.onCreate");
        this.mTheme = Resources.selectSystemTheme(this.mTheme, this.getApplicationInfo().targetSdkVersion, 16973908, 16973951, 16974142, 16974142);
        super.setTheme(this.mTheme);
        super.onCreate();
        this.mImm = (InputMethodManager)this.getSystemService("input_method");
        this.mSettingsObserver = SettingsObserver.createAndRegister(this);
        this.mSettingsObserver.shouldShowImeWithHardKeyboard();
        boolean hideNavBarForKeyboard = this.getApplicationContext().getResources().getBoolean(17891782);
        this.initConfigurationTracker();
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        Trace.traceBegin(32L, "IMS.initSoftInputWindow");
        this.mWindow = new SoftInputWindow(this, this.mTheme, this.mDispatcherState);
        if (this.mImeDispatcher != null) {
            this.mWindow.getOnBackInvokedDispatcher().setImeOnBackInvokedDispatcher(this.mImeDispatcher);
        }
        this.mNavigationBarController.onSoftInputWindowCreated(this.mWindow);
        Window window = this.mWindow.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.setTitle("InputMethod");
        lp.type = 2011;
        lp.width = -1;
        lp.height = -2;
        lp.gravity = 80;
        lp.setFitInsetsTypes(WindowInsets.Type.statusBars() | WindowInsets.Type.navigationBars());
        lp.setFitInsetsSides(WindowInsets.Side.all() & 0xFFFFFFF7);
        lp.receiveInsetsIgnoringZOrder = true;
        window.setAttributes(lp);
        int windowFlags = -2147483384;
        int windowFlagsMask = -2147483382;
        window.setFlags(-2147483384, -2147483382);
        if (hideNavBarForKeyboard) {
            window.setDecorFitsSystemWindows(false);
        }
        this.initViews();
        Trace.traceEnd(32L);
        this.mInlineSuggestionSessionController = new InlineSuggestionSessionController(this::onCreateInlineSuggestionsRequest, this::getHostInputToken, this::onInlineSuggestionsResponse);
        Trace.traceEnd(32L);
    }

    private void initConfigurationTracker() {
        ServiceInfo si;
        int flags = 32896;
        ComponentName imeComponent = new ComponentName(this.getPackageName(), this.getClass().getName());
        String imeId = imeComponent.flattenToShortString();
        try {
            si = this.getPackageManager().getServiceInfo(imeComponent, PackageManager.ComponentInfoFlags.of(32896L));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.wtf(TAG, "Unable to find input method " + imeId, e);
            return;
        }
        try (XmlResourceParser parser = si.loadXmlMetaData(this.getPackageManager(), "android.view.im");
             TypedArray sa = this.getResources().obtainAttributes(Xml.asAttributeSet(parser), R.styleable.InputMethod);){
            if (parser == null) {
                throw new XmlPullParserException("No android.view.im meta-data");
            }
            int handledConfigChanges = sa.getInt(0, 0);
            this.mConfigTracker.onInitialize(handledConfigChanges);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Unable to load input method " + imeId, e);
        }
    }

    public void onInitializeInterface() {
    }

    void initialize() {
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.onInitializeInterface();
        }
    }

    void initViews() {
        Trace.traceBegin(32L, "IMS.initViews");
        this.mInitialized = false;
        this.mViewsCreated = false;
        this.mShowInputRequested = false;
        this.mShowInputFlags = 0;
        this.mThemeAttrs = this.obtainStyledAttributes(R.styleable.InputMethodService);
        this.mRootView = this.mInflater.inflate(0x1090090, null);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.mFullscreenArea = (ViewGroup)this.mRootView.findViewById(16909122);
        this.mExtractViewHidden = false;
        this.mExtractFrame = (FrameLayout)this.mRootView.findViewById(16908316);
        this.mExtractView = null;
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
        this.mFullscreenApplied = false;
        this.mCandidatesFrame = (FrameLayout)this.mRootView.findViewById(16908317);
        this.mInputFrame = (FrameLayout)this.mRootView.findViewById(16908318);
        this.mInputView = null;
        this.mIsInputViewShown = false;
        this.mExtractFrame.setVisibility(8);
        this.mCandidatesVisibility = this.getCandidatesHiddenVisibility();
        this.mCandidatesFrame.setVisibility(this.mCandidatesVisibility);
        this.mInputFrame.setVisibility(8);
        this.mNavigationBarController.onViewInitialized();
        Trace.traceEnd(32L);
    }

    @Override
    public void onDestroy() {
        this.mDestroyed = true;
        super.onDestroy();
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.doFinishInput();
        this.mNavigationBarController.onDestroy();
        this.mWindow.dismissForDestroyIfNecessary();
        if (this.mSettingsObserver != null) {
            this.mSettingsObserver.unregister();
            this.mSettingsObserver = null;
        }
        if (this.mToken != null) {
            InputMethodPrivilegedOperationsRegistry.remove(this.mToken);
        }
        this.mImeDispatcher = null;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mConfigTracker.onConfigurationChanged(newConfig, this::resetStateForNewConfiguration);
    }

    private void resetStateForNewConfiguration() {
        Trace.traceBegin(32L, "IMS.resetStateForNewConfiguration");
        boolean visible = this.mDecorViewVisible;
        int showFlags = this.mShowInputFlags;
        boolean showingInput = this.mShowInputRequested;
        CompletionInfo[] completions = this.mCurCompletions;
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.initViews();
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.doStartInput(this.getCurrentInputConnection(), this.getCurrentInputEditorInfo(), true);
        }
        if (visible) {
            boolean showing;
            if (showingInput) {
                if (this.dispatchOnShowInputRequested(showFlags, true)) {
                    this.showWindowWithToken(true, 44);
                    if (completions != null) {
                        this.mCurCompletions = completions;
                        this.onDisplayCompletions(completions);
                    }
                } else {
                    this.hideWindowWithToken(44);
                }
            } else if (this.mCandidatesVisibility == 0) {
                this.showWindowWithToken(false, 44);
            } else {
                this.hideWindowWithToken(44);
            }
            this.setImeWindowVisibility(1 | ((showing = this.onEvaluateInputViewShown()) ? 2 : 0));
        }
        Trace.traceEnd(32L);
    }

    @Override
    @Deprecated
    public AbstractInputMethodService.AbstractInputMethodImpl onCreateInputMethodInterface() {
        return new InputMethodImpl();
    }

    @Override
    @Deprecated
    public AbstractInputMethodService.AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface() {
        return new InputMethodSessionImpl();
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public Dialog getWindow() {
        return this.mWindow;
    }

    public void setBackDisposition(int disposition) {
        if (disposition == this.mBackDisposition) {
            return;
        }
        if (disposition > 3 || disposition < 0) {
            Log.e(TAG, "Invalid back disposition value (" + disposition + ") specified.");
            return;
        }
        this.mBackDisposition = disposition;
        this.setImeWindowStatus(this.mImeWindowVisibility, this.mBackDisposition);
    }

    public int getBackDisposition() {
        return this.mBackDisposition;
    }

    public int getMaxWidth() {
        WindowManager windowManager = this.getSystemService(WindowManager.class);
        return WindowMetricsHelper.getBoundsExcludingNavigationBarAndCutout(windowManager.getCurrentWindowMetrics()).width();
    }

    public InputBinding getCurrentInputBinding() {
        return this.mInputBinding;
    }

    public InputConnection getCurrentInputConnection() {
        InputConnection ic = this.mStartedInputConnection;
        if (ic != null) {
            return ic;
        }
        return this.mInputConnection;
    }

    public boolean switchToPreviousInputMethod() {
        return this.mPrivOps.switchToPreviousInputMethod();
    }

    public boolean switchToNextInputMethod(boolean onlyCurrentIme) {
        return this.mPrivOps.switchToNextInputMethod(onlyCurrentIme);
    }

    public boolean shouldOfferSwitchingToNextInputMethod() {
        return this.mPrivOps.shouldOfferSwitchingToNextInputMethod();
    }

    public boolean getCurrentInputStarted() {
        return this.mInputStarted;
    }

    public EditorInfo getCurrentInputEditorInfo() {
        return this.mInputEditorInfo;
    }

    private void reportFullscreenMode() {
        this.mPrivOps.reportFullscreenModeAsync(this.mIsFullscreen);
    }

    public void updateFullscreenMode() {
        boolean changed;
        Trace.traceBegin(32L, "IMS.updateFullscreenMode");
        boolean isFullscreen = this.mShowInputRequested && this.onEvaluateFullscreenMode();
        boolean bl = changed = this.mLastShowInputRequested != this.mShowInputRequested;
        if (this.mIsFullscreen != isFullscreen || !this.mFullscreenApplied) {
            changed = true;
            this.mIsFullscreen = isFullscreen;
            this.reportFullscreenMode();
            this.mFullscreenApplied = true;
            this.initialize();
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mFullscreenArea.getLayoutParams();
            if (isFullscreen) {
                this.mFullscreenArea.setBackgroundDrawable(this.mThemeAttrs.getDrawable(0));
                lp.height = 0;
                lp.weight = 1.0f;
            } else {
                this.mFullscreenArea.setBackgroundDrawable(null);
                lp.height = -2;
                lp.weight = 0.0f;
            }
            ((ViewGroup)this.mFullscreenArea.getParent()).updateViewLayout(this.mFullscreenArea, lp);
            if (isFullscreen) {
                View v;
                if (this.mExtractView == null && (v = this.onCreateExtractTextView()) != null) {
                    this.setExtractView(v);
                }
                this.startExtractingText(false);
            }
            this.updateExtractFrameVisibility();
        }
        if (changed) {
            this.onConfigureWindow(this.mWindow.getWindow(), isFullscreen, !this.mShowInputRequested);
            this.mLastShowInputRequested = this.mShowInputRequested;
        }
        Trace.traceEnd(32L);
    }

    public void onConfigureWindow(Window win, boolean isFullscreen, boolean isCandidatesOnly) {
        int newHeight;
        int currentHeight = this.mWindow.getWindow().getAttributes().height;
        int n = newHeight = isFullscreen ? -1 : -2;
        if (!this.mIsInputViewShown || currentHeight != newHeight) {
            // empty if block
        }
        this.mWindow.getWindow().setLayout(-1, newHeight);
    }

    public boolean isFullscreenMode() {
        return this.mIsFullscreen;
    }

    public boolean onEvaluateFullscreenMode() {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation != 2) {
            return false;
        }
        return this.mInputEditorInfo == null || (this.mInputEditorInfo.imeOptions & 0x2000000) == 0 && (this.mInputEditorInfo.internalImeOptions & 1) == 0;
    }

    public void setExtractViewShown(boolean shown) {
        if (this.mExtractViewHidden == shown) {
            this.mExtractViewHidden = !shown;
            this.updateExtractFrameVisibility();
        }
    }

    public boolean isExtractViewShown() {
        return this.mIsFullscreen && !this.mExtractViewHidden;
    }

    void updateExtractFrameVisibility() {
        int animRes;
        int vis;
        this.updateCandidatesVisibility(this.mCandidatesVisibility == 0);
        if (this.isFullscreenMode()) {
            vis = this.mExtractViewHidden ? 4 : 0;
            this.mExtractFrame.setVisibility(vis);
        } else {
            vis = this.mCandidatesVisibility;
            this.mExtractFrame.setVisibility(8);
        }
        if (this.mDecorViewWasVisible && this.mFullscreenArea.getVisibility() != vis && (animRes = this.mThemeAttrs.getResourceId(vis == 0 ? 1 : 2, 0)) != 0) {
            this.mFullscreenArea.startAnimation(AnimationUtils.loadAnimation(this, animRes));
        }
        this.mFullscreenArea.setVisibility(vis);
    }

    public void onComputeInsets(Insets outInsets) {
        View decor;
        Trace.traceBegin(32L, "IMS.onComputeInsets");
        int[] loc = this.mTmpLocation;
        if (this.mInputFrame.getVisibility() == 0) {
            this.mInputFrame.getLocationInWindow(loc);
        } else {
            decor = this.getWindow().getWindow().getDecorView();
            loc[1] = decor.getHeight();
        }
        if (this.isFullscreenMode()) {
            decor = this.getWindow().getWindow().getDecorView();
            outInsets.contentTopInsets = decor.getHeight();
        } else {
            outInsets.contentTopInsets = loc[1];
        }
        if (this.mCandidatesFrame.getVisibility() == 0) {
            this.mCandidatesFrame.getLocationInWindow(loc);
        }
        outInsets.visibleTopInsets = loc[1];
        outInsets.touchableInsets = 2;
        outInsets.touchableRegion.setEmpty();
        Trace.traceEnd(32L);
    }

    public void updateInputViewShown() {
        boolean isShown;
        boolean bl = isShown = this.mShowInputRequested && this.onEvaluateInputViewShown();
        if (this.mIsInputViewShown != isShown && this.mDecorViewVisible) {
            this.mIsInputViewShown = isShown;
            this.mInputFrame.setVisibility(isShown ? 0 : 8);
            if (this.mInputView == null) {
                this.initialize();
                View v = this.onCreateInputView();
                if (v != null) {
                    this.setInputView(v);
                }
            }
        }
    }

    public boolean isShowInputRequested() {
        return this.mShowInputRequested;
    }

    public boolean isInputViewShown() {
        return this.mDecorViewVisible;
    }

    public boolean onEvaluateInputViewShown() {
        if (this.mSettingsObserver == null) {
            Log.w(TAG, "onEvaluateInputViewShown: mSettingsObserver must not be null here.");
            return false;
        }
        if (this.mSettingsObserver.shouldShowImeWithHardKeyboard()) {
            return true;
        }
        Configuration config = this.getResources().getConfiguration();
        return config.keyboard == 1 || config.hardKeyboardHidden == 2;
    }

    public void setCandidatesViewShown(boolean shown) {
        this.updateCandidatesVisibility(shown);
        if (!this.mShowInputRequested && this.mDecorViewVisible != shown) {
            if (shown) {
                this.showWindowWithToken(false, 45);
            } else {
                this.hideWindowWithToken(45);
            }
        }
    }

    void updateCandidatesVisibility(boolean shown) {
        int vis;
        int n = vis = shown ? 0 : this.getCandidatesHiddenVisibility();
        if (this.mCandidatesVisibility != vis) {
            this.mCandidatesFrame.setVisibility(vis);
            this.mCandidatesVisibility = vis;
        }
    }

    public int getCandidatesHiddenVisibility() {
        return this.isExtractViewShown() ? 8 : 4;
    }

    public void showStatusIcon(int iconResId) {
        this.mStatusIcon = iconResId;
        this.mPrivOps.updateStatusIconAsync(this.getPackageName(), iconResId);
    }

    public void hideStatusIcon() {
        this.mStatusIcon = 0;
        this.mPrivOps.updateStatusIconAsync(null, 0);
    }

    public void switchInputMethod(String id2) {
        this.mPrivOps.setInputMethod(id2);
    }

    public void switchInputMethod(String id2, InputMethodSubtype subtype) {
        this.mPrivOps.setInputMethodAndSubtype(id2, subtype);
    }

    public void setExtractView(View view) {
        this.mExtractFrame.removeAllViews();
        this.mExtractFrame.addView(view, new FrameLayout.LayoutParams(-1, -1));
        this.mExtractView = view;
        if (view != null) {
            this.mExtractEditText = (ExtractEditText)view.findViewById(16908325);
            this.mExtractEditText.setIME(this);
            this.mExtractAction = view.findViewById(16908377);
            if (this.mExtractAction != null) {
                this.mExtractAccessories = (ViewGroup)view.findViewById(16908378);
            }
            this.startExtractingText(false);
        } else {
            this.mExtractEditText = null;
            this.mExtractAccessories = null;
            this.mExtractAction = null;
        }
    }

    public void setCandidatesView(View view) {
        this.mCandidatesFrame.removeAllViews();
        this.mCandidatesFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    public void setInputView(View view) {
        this.mInputFrame.removeAllViews();
        this.mInputFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
        this.mInputView = view;
    }

    public View onCreateExtractTextView() {
        return this.mInflater.inflate(0x1090091, null);
    }

    public View onCreateCandidatesView() {
        return null;
    }

    public View onCreateInputView() {
        return null;
    }

    public void onStartInputView(EditorInfo editorInfo, boolean restarting) {
    }

    public void onFinishInputView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    public void onStartCandidatesView(EditorInfo editorInfo, boolean restarting) {
    }

    public void onFinishCandidatesView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    public void onPrepareStylusHandwriting() {
    }

    public boolean onStartStylusHandwriting() {
        return false;
    }

    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public boolean onStartConnectionlessStylusHandwriting(int inputType, @Nullable CursorAnchorInfo cursorAnchorInfo) {
        return false;
    }

    public void onStylusHandwritingMotionEvent(@NonNull MotionEvent motionEvent) {
        if (this.mInkWindow != null && this.mInkWindow.isInkViewVisible()) {
            this.mInkWindow.dispatchHandwritingEvent(motionEvent);
        } else {
            if (this.mPendingEvents == null) {
                this.mPendingEvents = new RingBuffer<MotionEvent>(MotionEvent.class, 500);
            }
            this.mPendingEvents.append(motionEvent);
            if (this.mInkWindow != null) {
                this.mInkWindow.setInkViewVisibilityListener(() -> {
                    if (this.mPendingEvents != null && !this.mPendingEvents.isEmpty()) {
                        for (MotionEvent event : this.mPendingEvents.toArray()) {
                            if (this.mInkWindow == null) break;
                            this.mInkWindow.dispatchHandwritingEvent(event);
                        }
                        this.mPendingEvents.clear();
                    }
                });
            }
        }
        if (motionEvent.getAction() == 0) {
            this.scheduleStylusWindowIdleTimeout();
        }
    }

    public void onFinishStylusHandwriting() {
    }

    @Nullable
    public Window getStylusHandwritingWindow() {
        return this.mInkWindow;
    }

    public void finishStylusHandwriting() {
        if (this.mInkWindow == null) {
            return;
        }
        if (!this.mHandwritingRequestId.isPresent()) {
            return;
        }
        if (this.mHandler != null && this.mFinishHwRunnable != null) {
            this.mHandler.removeCallbacks(this.mFinishHwRunnable);
        }
        this.mFinishHwRunnable = null;
        this.mLastHandwritingRegion = null;
        int requestId = this.mHandwritingRequestId.getAsInt();
        this.mHandwritingRequestId = OptionalInt.empty();
        this.mHandwritingEventReceiver.dispose();
        this.mHandwritingEventReceiver = null;
        this.mInkWindow.hide(false);
        if (this.mConnectionlessHandwritingCallback != null) {
            Log.i(TAG, "Connectionless handwriting session did not complete successfully");
            try {
                this.mConnectionlessHandwritingCallback.onError(2);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Couldn't send connectionless handwriting error result", e);
            }
            this.mConnectionlessHandwritingCallback = null;
        }
        this.mIsConnectionlessHandwritingForDelegation = false;
        this.mPrivOps.resetStylusHandwriting(requestId);
        this.mOnPreparedStylusHwCalled = false;
        this.onFinishStylusHandwriting();
    }

    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public void finishConnectionlessStylusHandwriting(@Nullable CharSequence text) {
        if (this.mConnectionlessHandwritingCallback != null) {
            try {
                if (!TextUtils.isEmpty(text)) {
                    this.mConnectionlessHandwritingCallback.onResult(text);
                    if (this.mIsConnectionlessHandwritingForDelegation) {
                        this.mHandwritingDelegationText = text;
                    }
                } else {
                    this.mConnectionlessHandwritingCallback.onError(0);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Couldn't send connectionless handwriting result", e);
            }
            this.mConnectionlessHandwritingCallback = null;
        }
        this.finishStylusHandwriting();
    }

    private void commitHandwritingDelegationTextIfAvailable() {
        InputConnection ic;
        if (!TextUtils.isEmpty(this.mHandwritingDelegationText) && (ic = this.getCurrentInputConnection()) != null) {
            ic.commitText(this.mHandwritingDelegationText, 1);
        }
        this.mHandwritingDelegationText = null;
    }

    private void discardHandwritingDelegationText() {
        this.mHandwritingDelegationText = null;
    }

    private void finishAndRemoveStylusHandwritingWindow() {
        this.cancelStylusWindowIdleTimeout();
        this.mOnPreparedStylusHwCalled = false;
        this.mStylusWindowIdleTimeoutRunnable = null;
        if (this.mInkWindow != null) {
            if (this.mHandwritingRequestId.isPresent()) {
                this.finishStylusHandwriting();
            }
            this.mInkWindow.hide(true);
            this.mInkWindow.destroy();
            this.mInkWindow = null;
        }
    }

    private void cancelStylusWindowIdleTimeout() {
        if (this.mStylusWindowIdleTimeoutRunnable != null && this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mStylusWindowIdleTimeoutRunnable);
        }
    }

    private void scheduleStylusWindowIdleTimeout() {
        if (this.mHandler == null) {
            return;
        }
        this.cancelStylusWindowIdleTimeout();
        long timeout = this.mStylusWindowIdleTimeoutForTest > 0L ? this.mStylusWindowIdleTimeoutForTest : 300000L;
        this.mHandler.postDelayed(this.getStylusWindowIdleTimeoutRunnable(), timeout);
    }

    private Runnable getStylusWindowIdleTimeoutRunnable() {
        if (this.mStylusWindowIdleTimeoutRunnable == null) {
            this.mStylusWindowIdleTimeoutRunnable = () -> {
                this.finishAndRemoveStylusHandwritingWindow();
                this.mStylusWindowIdleTimeoutRunnable = null;
            };
        }
        return this.mStylusWindowIdleTimeoutRunnable;
    }

    public void setStylusHandwritingSessionTimeout(@NonNull Duration duration) {
        long timeoutMs = duration.toMillis();
        if (timeoutMs <= 0L) {
            throw new IllegalStateException("A positive value should be set for Stylus handwriting session timeout.");
        }
        if (timeoutMs > 30000L) {
            timeoutMs = 30000L;
        }
        this.mStylusHwSessionsTimeout = timeoutMs;
        this.scheduleHandwritingSessionTimeout();
    }

    @NonNull
    public static Duration getStylusHandwritingIdleTimeoutMax() {
        return Duration.ofMillis(30000L);
    }

    @NonNull
    public Duration getStylusHandwritingSessionTimeout() {
        return Duration.ofMillis(this.mStylusHwSessionsTimeout);
    }

    private Runnable getFinishHandwritingRunnable() {
        if (this.mFinishHwRunnable != null) {
            return this.mFinishHwRunnable;
        }
        this.mFinishHwRunnable = () -> {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(this.mFinishHwRunnable);
            }
            Log.d(TAG, "Stylus handwriting idle timed-out. calling finishStylusHandwriting()");
            this.mFinishHwRunnable = null;
            this.finishStylusHandwriting();
        };
        return this.mFinishHwRunnable;
    }

    private void scheduleHandwritingSessionTimeout() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.getMainLooper());
        }
        if (this.mFinishHwRunnable != null) {
            this.mHandler.removeCallbacks(this.mFinishHwRunnable);
        }
        this.mHandler.postDelayed(this.getFinishHandwritingRunnable(), this.mStylusHwSessionsTimeout);
    }

    public boolean onShowInputRequested(int flags, boolean configChange) {
        if (!this.onEvaluateInputViewShown()) {
            return false;
        }
        if ((flags & 1) == 0) {
            if (!configChange && this.onEvaluateFullscreenMode() && !this.isInputViewShown()) {
                return false;
            }
            if (!this.mSettingsObserver.shouldShowImeWithHardKeyboard() && this.getResources().getConfiguration().keyboard != 1) {
                return false;
            }
        }
        return true;
    }

    private boolean dispatchOnShowInputRequested(int flags, boolean configChange) {
        boolean result = this.onShowInputRequested(flags, configChange);
        this.mInlineSuggestionSessionController.notifyOnShowInputRequested(result);
        this.mShowInputFlags = result ? flags : 0;
        return result;
    }

    private void showWindowWithToken(boolean showInput, int reason) {
        this.mCurStatsToken = this.createStatsToken(true, reason, ImeTracker.isFromUser(this.mRootView));
        this.showWindow(showInput);
    }

    public void showWindow(boolean showInput) {
        ImeTracker.Token statsToken = this.mCurStatsToken != null ? this.mCurStatsToken : this.createStatsToken(true, 42, ImeTracker.isFromUser(this.mRootView));
        this.mCurStatsToken = null;
        if (this.mInShowWindow) {
            Log.w(TAG, "Re-entrance in to showWindow");
            ImeTracker.forLogging().onCancelled(statsToken, 44);
            return;
        }
        ImeTracker.forLogging().onProgress(statsToken, 44);
        this.notifyPreImeWindowVisibilityChanged(true, statsToken);
        ImeTracing.getInstance().triggerServiceDump("InputMethodService#showWindow", this.mDumper, null);
        Trace.traceBegin(32L, "IMS.showWindow");
        this.mDecorViewWasVisible = this.mDecorViewVisible;
        this.mInShowWindow = true;
        this.startViews(this.prepareWindow(showInput));
        this.setImeWindowVisibility(this.computeImeWindowVis());
        this.mNavigationBarController.onWindowShown();
        this.onWindowShown();
        this.mWindowVisible = true;
        this.mWindow.show();
        this.mDecorViewWasVisible = true;
        this.cancelImeSurfaceRemoval();
        this.mInShowWindow = false;
        Trace.traceEnd(32L);
        this.registerDefaultOnBackInvokedCallback();
    }

    @FlaggedApi(value="android.view.inputmethod.adaptive_handwriting_bounds")
    public void setStylusHandwritingRegion(@NonNull Region handwritingRegion) {
        Region immutableHandwritingRegion = new Region(handwritingRegion);
        if (immutableHandwritingRegion.equals(this.mLastHandwritingRegion)) {
            Log.v(TAG, "Failed to set setStylusHandwritingRegion(): same region set twice.");
            return;
        }
        this.mPrivOps.setHandwritingTouchableRegion(immutableHandwritingRegion);
        this.mLastHandwritingRegion = immutableHandwritingRegion;
    }

    private void registerDefaultOnBackInvokedCallback() {
        if (this.mBackCallbackRegistered) {
            return;
        }
        if (this.mWindow != null) {
            if (this.getApplicationInfo().isOnBackInvokedCallbackEnabled()) {
                this.mWindow.getOnBackInvokedDispatcher().registerSystemOnBackInvokedCallback(this.mCompatBackCallback);
            } else {
                this.mWindow.getOnBackInvokedDispatcher().registerOnBackInvokedCallback(0, this.mCompatBackCallback);
            }
            this.mBackCallbackRegistered = true;
        }
    }

    private void unregisterDefaultOnBackInvokedCallback() {
        if (!this.mBackCallbackRegistered) {
            return;
        }
        if (this.mWindow != null) {
            this.mWindow.getOnBackInvokedDispatcher().unregisterOnBackInvokedCallback(this.mCompatBackCallback);
            this.mBackCallbackRegistered = false;
        }
    }

    private KeyEvent createBackKeyEvent(int action, boolean isTracking) {
        long when = SystemClock.uptimeMillis();
        return new KeyEvent(when, when, action, 4, 0, 0, -1, 0, 0x48 | (isTracking ? 512 : 0), 257);
    }

    private boolean prepareWindow(boolean showInput) {
        boolean doShowInput = false;
        this.mDecorViewVisible = true;
        if (!this.mShowInputRequested && this.mInputStarted && showInput) {
            doShowInput = true;
            this.mShowInputRequested = true;
        }
        this.initialize();
        this.updateFullscreenMode();
        this.updateInputViewShown();
        if (!this.mViewsCreated) {
            this.mViewsCreated = true;
            this.initialize();
            View v = this.onCreateCandidatesView();
            if (v != null) {
                this.setCandidatesView(v);
            }
        }
        return doShowInput;
    }

    private void startViews(boolean doShowInput) {
        if (this.mShowInputRequested) {
            if (!this.mInputViewStarted) {
                this.mInputViewStarted = true;
                this.mInlineSuggestionSessionController.notifyOnStartInputView();
                this.onStartInputView(this.mInputEditorInfo, false);
            }
        } else if (!this.mCandidatesViewStarted) {
            this.mCandidatesViewStarted = true;
            this.onStartCandidatesView(this.mInputEditorInfo, false);
        }
        if (doShowInput) {
            this.startExtractingText(false);
        }
    }

    private void notifyPreImeWindowVisibilityChanged(boolean visible, @NonNull ImeTracker.Token statsToken) {
        ViewRootImpl viewRootImpl = this.getWindow().getWindow().getDecorView().getViewRootImpl();
        if (viewRootImpl != null) {
            viewRootImpl.notifyImeVisibilityChanged(visible, statsToken);
        }
    }

    private void finishViews(boolean finishingInput) {
        if (this.mInputViewStarted) {
            this.mInlineSuggestionSessionController.notifyOnFinishInputView();
            this.onFinishInputView(finishingInput);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(finishingInput);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
    }

    private void hideWindowWithToken(int reason) {
        boolean isFromUser = ImeTracker.isFromUser(this.mRootView) || reason == 29;
        this.mCurStatsToken = this.createStatsToken(false, reason, isFromUser);
        this.hideWindow();
    }

    public void hideWindow() {
        ImeTracker.Token statsToken = this.mCurStatsToken != null ? this.mCurStatsToken : this.createStatsToken(false, 43, ImeTracker.isFromUser(this.mRootView));
        this.mCurStatsToken = null;
        ImeTracker.forLogging().onProgress(statsToken, 45);
        ImeTracing.getInstance().triggerServiceDump("InputMethodService#hideWindow", this.mDumper, null);
        this.setImeWindowVisibility(0);
        this.notifyPreImeWindowVisibilityChanged(false, statsToken);
        this.mWindowVisible = false;
        this.finishViews(false);
        if (this.mDecorViewVisible) {
            if (this.mInputView != null) {
                this.mInputView.dispatchWindowVisibilityChanged(8);
            }
            this.mDecorViewVisible = false;
            this.onWindowHidden();
            this.mDecorViewWasVisible = false;
        }
        this.mLastWasInFullscreenMode = this.mIsFullscreen;
        this.updateFullscreenMode();
        this.unregisterDefaultOnBackInvokedCallback();
    }

    public void onWindowShown() {
    }

    public void onWindowHidden() {
    }

    public void onBindInput() {
    }

    public void onUnbindInput() {
    }

    public void onStartInput(EditorInfo attribute, boolean restarting) {
    }

    void doFinishInput() {
        ImeTracing.getInstance().triggerServiceDump("InputMethodService#doFinishInput", this.mDumper, null);
        this.finishViews(true);
        if (this.mInputStarted) {
            this.mInlineSuggestionSessionController.notifyOnFinishInput();
            this.onFinishInput();
        }
        this.mInputStarted = false;
        this.mStartedInputConnection = null;
        this.mCurCompletions = null;
        if (!this.mOnPreparedStylusHwCalled) {
            this.finishStylusHandwriting();
        }
        this.unregisterDefaultOnBackInvokedCallback();
    }

    void doStartInput(InputConnection ic, EditorInfo editorInfo, boolean restarting) {
        if (!restarting && this.mInputStarted) {
            this.doFinishInput();
        }
        ImeTracing.getInstance().triggerServiceDump("InputMethodService#doStartInput", this.mDumper, null);
        this.mInputStarted = true;
        this.mStartedInputConnection = ic;
        this.mInputEditorInfo = editorInfo;
        this.initialize();
        this.mInlineSuggestionSessionController.notifyOnStartInput(editorInfo == null ? null : editorInfo.packageName, editorInfo == null ? null : editorInfo.getAutofillId());
        this.onStartInput(editorInfo, restarting);
        if (this.mDecorViewVisible) {
            if (this.mShowInputRequested) {
                this.mInputViewStarted = true;
                this.mInlineSuggestionSessionController.notifyOnStartInputView();
                this.onStartInputView(this.mInputEditorInfo, restarting);
                this.startExtractingText(true);
            } else if (this.mCandidatesVisibility == 0) {
                this.mCandidatesViewStarted = true;
                this.onStartCandidatesView(this.mInputEditorInfo, restarting);
            }
        }
    }

    public void onFinishInput() {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.finishComposingText();
        }
    }

    public void onDisplayCompletions(CompletionInfo[] completions) {
    }

    public void onUpdateExtractedText(int token, ExtractedText text) {
        if (this.mExtractedToken != token) {
            return;
        }
        if (text != null && this.mExtractEditText != null) {
            this.mExtractedText = text;
            this.mExtractEditText.setExtractedText(text);
        }
    }

    public void onUpdateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.isFullscreenMode() && this.mExtractedText != null) {
            int off = this.mExtractedText.startOffset;
            eet.startInternalChanges();
            newSelEnd -= off;
            int len = eet.getText().length();
            if ((newSelStart -= off) < 0) {
                newSelStart = 0;
            } else if (newSelStart > len) {
                newSelStart = len;
            }
            if (newSelEnd < 0) {
                newSelEnd = 0;
            } else if (newSelEnd > len) {
                newSelEnd = len;
            }
            eet.setSelection(newSelStart, newSelEnd);
            eet.finishInternalChanges();
        }
    }

    @Deprecated
    public void onViewClicked(boolean focusChanged) {
    }

    public void onUpdateEditorToolType(int toolType) {
    }

    @Deprecated
    public void onUpdateCursor(Rect newCursor) {
    }

    public void onUpdateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
    }

    public void requestHideSelf(int flags) {
        this.requestHideSelf(flags, 5);
    }

    private void requestHideSelf(int flags, int reason) {
        boolean isFromUser = ImeTracker.isFromUser(this.mRootView) || reason == 29;
        ImeTracker.Token statsToken = this.createStatsToken(false, reason, isFromUser);
        ImeTracing.getInstance().triggerServiceDump("InputMethodService#requestHideSelf", this.mDumper, null);
        this.mPrivOps.hideMySoftInput(statsToken, flags, reason);
    }

    public void requestShowSelf(int flags) {
        this.requestShowSelf(flags, 3);
    }

    private void requestShowSelf(int flags, int reason) {
        ImeTracker.Token statsToken = this.createStatsToken(true, reason, ImeTracker.isFromUser(this.mRootView));
        ImeTracing.getInstance().triggerServiceDump("InputMethodService#requestShowSelf", this.mDumper, null);
        this.mPrivOps.showMySoftInput(statsToken, flags, reason);
    }

    private boolean handleBack(boolean doIt) {
        if (this.mShowInputRequested) {
            if (doIt) {
                this.requestHideSelf(0, 29);
            }
            return true;
        }
        if (this.mDecorViewVisible) {
            if (this.mCandidatesVisibility == 0) {
                if (doIt) {
                    this.setCandidatesViewShown(false);
                }
            } else if (doIt) {
                this.hideWindowWithToken(29);
            }
            return true;
        }
        return false;
    }

    private ExtractEditText getExtractEditTextIfVisible() {
        if (!this.isExtractViewShown() || !this.isInputViewShown()) {
            return null;
        }
        return this.mExtractEditText;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        this.updateEditorToolTypeInternal(0);
        if (keyCode == 4) {
            ExtractEditText eet = this.getExtractEditTextIfVisible();
            if (eet != null && eet.handleBackInTextActionModeIfNeeded(event)) {
                return true;
            }
            if (this.handleBack(false)) {
                event.startTracking();
                return true;
            }
            return false;
        }
        if (keyCode == 62 && KeyEvent.metaStateHasModifiers(event.getMetaState() & 0xFFFFFF3E, 4096) && this.mDecorViewVisible && this.mWindowVisible) {
            int direction = (event.getMetaState() & 0xC1) != 0 ? -1 : 1;
            this.mPrivOps.switchKeyboardLayoutAsync(direction);
            event.startTracking();
            return true;
        }
        if (com.android.internal.hidden_from_bootclasspath.android.view.inputmethod.Flags.ctrlShiftShortcut()) {
            this.mUsingCtrlShiftShortcut = keyCode == 59 || keyCode == 60 ? KeyEvent.metaStateHasModifiers(event.getMetaState() & 0xFFFFFF3E, 4096) : (keyCode == 113 || keyCode == 114 ? KeyEvent.metaStateHasModifiers(event.getMetaState() & 0xFFFF8FFF, 1) : false);
        }
        return this.doMovementKey(keyCode, event, -1);
    }

    @Override
    @FlaggedApi(value="android.view.inputmethod.verify_key_event")
    public boolean onShouldVerifyKeyEvent(@NonNull KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
        return this.doMovementKey(keyCode, event, count);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (com.android.internal.hidden_from_bootclasspath.android.view.inputmethod.Flags.ctrlShiftShortcut()) {
            if (keyCode == 59 || keyCode == 60 || keyCode == 113 || keyCode == 114) {
                if (this.mUsingCtrlShiftShortcut && event.hasNoModifiers()) {
                    this.mUsingCtrlShiftShortcut = false;
                    if (this.mDecorViewVisible && this.mWindowVisible) {
                        this.switchToNextInputMethod(false);
                        return true;
                    }
                }
            } else {
                this.mUsingCtrlShiftShortcut = false;
            }
        }
        if (keyCode == 4) {
            ExtractEditText eet = this.getExtractEditTextIfVisible();
            if (eet != null && eet.handleBackInTextActionModeIfNeeded(event)) {
                return true;
            }
            if (event.isTracking() && !event.isCanceled()) {
                return this.handleBack(true);
            }
        } else if (keyCode == 62 && event.isTracking() && !event.isCanceled()) {
            return true;
        }
        return this.doMovementKey(keyCode, event, -2);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public void onAppPrivateCommand(String action, Bundle data) {
    }

    private void onToggleSoftInput(int showFlags, int hideFlags) {
        if (this.isInputViewShown()) {
            this.requestHideSelf(hideFlags, 30);
        } else {
            this.requestShowSelf(showFlags, 53);
        }
    }

    void reportExtractedMovement(int keyCode, int count) {
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 21: {
                dx = -count;
                break;
            }
            case 22: {
                dx = count;
                break;
            }
            case 19: {
                dy = -count;
                break;
            }
            case 20: {
                dy = count;
            }
        }
        this.onExtractedCursorMovement(dx, dy);
    }

    boolean doMovementKey(int keyCode, KeyEvent event, int count) {
        ExtractEditText eet = this.getExtractEditTextIfVisible();
        if (eet != null) {
            MovementMethod movement = eet.getMovementMethod();
            Layout layout2 = eet.getLayout();
            if (movement != null && layout2 != null) {
                if (count == -1) {
                    if (movement.onKeyDown(eet, eet.getText(), keyCode, event)) {
                        this.reportExtractedMovement(keyCode, 1);
                        return true;
                    }
                } else if (count == -2) {
                    if (movement.onKeyUp(eet, eet.getText(), keyCode, event)) {
                        return true;
                    }
                } else if (movement.onKeyOther(eet, eet.getText(), event)) {
                    this.reportExtractedMovement(keyCode, count);
                } else {
                    KeyEvent down = KeyEvent.changeAction(event, 0);
                    if (movement.onKeyDown(eet, eet.getText(), keyCode, down)) {
                        KeyEvent up = KeyEvent.changeAction(event, 1);
                        movement.onKeyUp(eet, eet.getText(), keyCode, up);
                        while (--count > 0) {
                            movement.onKeyDown(eet, eet.getText(), keyCode, down);
                            movement.onKeyUp(eet, eet.getText(), keyCode, up);
                        }
                        this.reportExtractedMovement(keyCode, count);
                    }
                }
            }
            switch (keyCode) {
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    return true;
                }
            }
        }
        return false;
    }

    public void sendDownUpKeyEvents(int keyEventCode) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic == null) {
            return;
        }
        long eventTime = SystemClock.uptimeMillis();
        ic.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, keyEventCode, 0, 0, -1, 0, 6));
        ic.sendKeyEvent(new KeyEvent(eventTime, SystemClock.uptimeMillis(), 1, keyEventCode, 0, 0, -1, 0, 6));
    }

    public boolean sendDefaultEditorAction(boolean fromEnterKey) {
        EditorInfo ei = this.getCurrentInputEditorInfo();
        if (!(ei == null || fromEnterKey && (ei.imeOptions & 0x40000000) != 0 || (ei.imeOptions & 0xFF) == 1)) {
            InputConnection ic = this.getCurrentInputConnection();
            if (ic != null) {
                ic.performEditorAction(ei.imeOptions & 0xFF);
            }
            return true;
        }
        return false;
    }

    public void sendKeyChar(char charCode) {
        switch (charCode) {
            case '\n': {
                if (this.sendDefaultEditorAction(true)) break;
                this.sendDownUpKeyEvents(66);
                break;
            }
            default: {
                if (charCode >= '0' && charCode <= '9') {
                    this.sendDownUpKeyEvents(charCode - 48 + 7);
                    break;
                }
                InputConnection ic = this.getCurrentInputConnection();
                if (ic == null) break;
                ic.commitText(String.valueOf(charCode), 1);
            }
        }
    }

    public void onExtractedSelectionChanged(int start, int end) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.setSelection(start, end);
        }
    }

    @UnsupportedAppUsage
    public void onExtractedDeleteText(int start, int end) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.finishComposingText();
            conn.setSelection(start, start);
            conn.deleteSurroundingText(0, end - start);
        }
    }

    @UnsupportedAppUsage
    public void onExtractedReplaceText(int start, int end, CharSequence text) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.setComposingRegion(start, end);
            conn.commitText(text, 1);
        }
    }

    @UnsupportedAppUsage
    public void onExtractedSetSpan(Object span, int start, int end, int flags) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            if (!conn.setSelection(start, end)) {
                return;
            }
            CharSequence text = conn.getSelectedText(1);
            if (text instanceof Spannable) {
                ((Spannable)text).setSpan(span, 0, text.length(), flags);
                conn.setComposingRegion(start, end);
                conn.commitText(text, 1);
            }
        }
    }

    public void onExtractedTextClicked() {
        if (this.mExtractEditText == null) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    public void onExtractedCursorMovement(int dx, int dy) {
        if (this.mExtractEditText == null || dy == 0) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    public boolean onExtractTextContextMenuItem(int id2) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.performContextMenuAction(id2);
        }
        return true;
    }

    public CharSequence getTextForImeAction(int imeOptions) {
        switch (imeOptions & 0xFF) {
            case 1: {
                return null;
            }
            case 2: {
                return this.getText(17040593);
            }
            case 3: {
                return this.getText(17040596);
            }
            case 4: {
                return this.getText(17040597);
            }
            case 5: {
                return this.getText(17040594);
            }
            case 6: {
                return this.getText(17040592);
            }
            case 7: {
                return this.getText(17040595);
            }
        }
        return this.getText(17040591);
    }

    private int getIconForImeAction(int imeOptions) {
        switch (imeOptions & 0xFF) {
            case 2: {
                return 17302623;
            }
            case 3: {
                return 17302627;
            }
            case 4: {
                return 17302628;
            }
            case 5: {
                return 17302624;
            }
            case 6: {
                return 17302622;
            }
            case 7: {
                return 17302625;
            }
        }
        return 17302626;
    }

    public void onUpdateExtractingVisibility(EditorInfo ei) {
        if (ei.inputType == 0 || (ei.imeOptions & 0x10000000) != 0) {
            this.setExtractViewShown(false);
            return;
        }
        this.setExtractViewShown(true);
    }

    public void onUpdateExtractingViews(EditorInfo ei) {
        boolean hasAction;
        if (!this.isExtractViewShown()) {
            return;
        }
        if (this.mExtractAccessories == null) {
            return;
        }
        boolean bl = hasAction = ei.actionLabel != null || (ei.imeOptions & 0xFF) != 1 && (ei.imeOptions & 0x20000000) == 0 && ei.inputType != 0;
        if (hasAction) {
            this.mExtractAccessories.setVisibility(0);
            if (this.mExtractAction != null) {
                if (this.mExtractAction instanceof ImageButton) {
                    ((ImageButton)this.mExtractAction).setImageResource(this.getIconForImeAction(ei.imeOptions));
                    if (ei.actionLabel != null) {
                        this.mExtractAction.setContentDescription(ei.actionLabel);
                    } else {
                        this.mExtractAction.setContentDescription(this.getTextForImeAction(ei.imeOptions));
                    }
                } else if (ei.actionLabel != null) {
                    ((TextView)this.mExtractAction).setText(ei.actionLabel);
                } else {
                    ((TextView)this.mExtractAction).setText(this.getTextForImeAction(ei.imeOptions));
                }
                this.mExtractAction.setOnClickListener(this.mActionClickListener);
            }
        } else {
            this.mExtractAccessories.setVisibility(8);
            if (this.mExtractAction != null) {
                this.mExtractAction.setOnClickListener(null);
            }
        }
    }

    public void onExtractingInputChanged(EditorInfo ei) {
        if (ei.inputType == 0) {
            this.requestHideSelf(2, 31);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startExtractingText(boolean inputChanged) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.getCurrentInputStarted() && this.isFullscreenMode()) {
            ++this.mExtractedToken;
            ExtractedTextRequest req = new ExtractedTextRequest();
            req.token = this.mExtractedToken;
            req.flags = 1;
            req.hintMaxLines = 10;
            req.hintMaxChars = 10000;
            InputConnection ic = this.getCurrentInputConnection();
            ExtractedText extractedText = this.mExtractedText = ic == null ? null : ic.getExtractedText(req, 1);
            if (this.mExtractedText == null || ic == null) {
                Log.e(TAG, "Unexpected null in startExtractingText : mExtractedText = " + this.mExtractedText + ", input connection = " + ic);
            }
            EditorInfo ei = this.getCurrentInputEditorInfo();
            try {
                eet.startInternalChanges();
                this.onUpdateExtractingVisibility(ei);
                this.onUpdateExtractingViews(ei);
                int inputType = ei.inputType;
                if ((inputType & 0xF) == 1 && (inputType & 0x40000) != 0) {
                    inputType |= 0x20000;
                }
                eet.setInputType(inputType);
                eet.setHint(ei.hintText);
                if (this.mExtractedText != null) {
                    eet.setEnabled(true);
                    eet.setExtractedText(this.mExtractedText);
                } else {
                    eet.setEnabled(false);
                    eet.setText("");
                }
            }
            finally {
                eet.finishInternalChanges();
            }
            if (inputChanged) {
                this.onExtractingInputChanged(ei);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchOnCurrentInputMethodSubtypeChanged(InputMethodSubtype newSubtype) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNotifyUserActionSent = false;
        }
        this.onCurrentInputMethodSubtypeChanged(newSubtype);
    }

    protected void onCurrentInputMethodSubtypeChanged(InputMethodSubtype newSubtype) {
    }

    @Deprecated
    public int getInputMethodWindowRecommendedHeight() {
        Log.w(TAG, "getInputMethodWindowRecommendedHeight() is deprecated and now always returns 0. Do not use this method.");
        return 0;
    }

    @VisibleForTesting
    public boolean isImeNavigationBarShownForTesting() {
        return this.mNavigationBarController.isShown();
    }

    @FlaggedApi(value="android.view.inputmethod.ime_switcher_revamp_api")
    public void onCustomImeSwitcherButtonRequestedVisible(boolean visible) {
    }

    void onImeSwitchButtonClickFromClient() {
        this.mPrivOps.onImeSwitchButtonClickFromClient(this.getDisplayId());
    }

    @Override
    @NonNull
    InputMethodServiceInternal createInputMethodServiceInternal() {
        return new InputMethodServiceInternal(){

            @Override
            @NonNull
            public Context getContext() {
                return InputMethodService.this;
            }

            @Override
            public void exposeContent(@NonNull InputContentInfo inputContentInfo, @NonNull InputConnection inputConnection) {
                if (inputConnection == null) {
                    return;
                }
                if (InputMethodService.this.getCurrentInputConnection() != inputConnection) {
                    return;
                }
                this.exposeContentInternal(inputContentInfo, InputMethodService.this.getCurrentInputEditorInfo());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyUserActionIfNecessary() {
                Object object = InputMethodService.this.mLock;
                synchronized (object) {
                    if (InputMethodService.this.mNotifyUserActionSent) {
                        return;
                    }
                    InputMethodService.this.mPrivOps.notifyUserActionAsync();
                    InputMethodService.this.mNotifyUserActionSent = true;
                }
            }

            private void exposeContentInternal(@NonNull InputContentInfo inputContentInfo, @NonNull EditorInfo editorInfo) {
                Uri contentUri = inputContentInfo.getContentUri();
                IInputContentUriToken uriToken = InputMethodService.this.mPrivOps.createInputContentUriToken(contentUri, editorInfo.packageName);
                if (uriToken == null) {
                    Log.e(InputMethodService.TAG, "createInputContentAccessToken failed. contentUri=" + contentUri.toString() + " packageName=" + editorInfo.packageName);
                    return;
                }
                inputContentInfo.setUriToken(uriToken);
            }

            @Override
            public void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
                InputMethodService.this.dump(fd, fout, args);
            }

            @Override
            public void triggerServiceDump(String where, @Nullable byte[] icProto) {
                ImeTracing.getInstance().triggerServiceDump(where, InputMethodService.this.mDumper, icProto);
            }

            @Override
            public boolean isServiceDestroyed() {
                return InputMethodService.this.mDestroyed;
            }
        };
    }

    @ImeWindowVisibility
    private int computeImeWindowVis() {
        return 1 | (this.isInputViewShown() ? 2 : 0);
    }

    @NonNull
    private ImeTracker.Token createStatsToken(boolean show, int reason, boolean isFromUser) {
        return ImeTracker.forLogging().onStart(show ? 1 : 2, 7, reason, isFromUser);
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method service state for " + this + ":");
        p.println("  mViewsCreated=" + this.mViewsCreated);
        p.println("  mDecorViewVisible=" + this.mDecorViewVisible + " mDecorViewWasVisible=" + this.mDecorViewWasVisible + " mWindowVisible=" + this.mWindowVisible + " mInShowWindow=" + this.mInShowWindow);
        p.println("  Configuration=" + this.getResources().getConfiguration());
        p.println("  mToken=" + this.mToken);
        p.println("  mInputBinding=" + this.mInputBinding);
        p.println("  mInputConnection=" + this.mInputConnection);
        p.println("  mStartedInputConnection=" + this.mStartedInputConnection);
        p.println("  mInputStarted=" + this.mInputStarted + " mInputViewStarted=" + this.mInputViewStarted + " mCandidatesViewStarted=" + this.mCandidatesViewStarted);
        if (this.mInputEditorInfo != null) {
            p.println("  mInputEditorInfo:");
            this.mInputEditorInfo.dump(p, "    ", false);
        } else {
            p.println("  mInputEditorInfo: null");
        }
        p.println("  mShowInputRequested=" + this.mShowInputRequested + " mLastShowInputRequested=" + this.mLastShowInputRequested + " mShowInputFlags=0x" + Integer.toHexString(this.mShowInputFlags));
        p.println("  mCandidatesVisibility=" + this.mCandidatesVisibility + " mFullscreenApplied=" + this.mFullscreenApplied + " mIsFullscreen=" + this.mIsFullscreen + " mExtractViewHidden=" + this.mExtractViewHidden);
        if (this.mExtractedText != null) {
            p.println("  mExtractedText:");
            p.println("    text=" + this.mExtractedText.text.length() + " chars startOffset=" + this.mExtractedText.startOffset);
            p.println("    selectionStart=" + this.mExtractedText.selectionStart + " selectionEnd=" + this.mExtractedText.selectionEnd + " flags=0x" + Integer.toHexString(this.mExtractedText.flags));
        } else {
            p.println("  mExtractedText: null");
        }
        p.println("  mExtractedToken=" + this.mExtractedToken);
        p.println("  mIsInputViewShown=" + this.mIsInputViewShown + " mStatusIcon=" + this.mStatusIcon);
        p.println("  Last computed insets:");
        p.println("    contentTopInsets=" + this.mTmpInsets.contentTopInsets + " visibleTopInsets=" + this.mTmpInsets.visibleTopInsets + " touchableInsets=" + this.mTmpInsets.touchableInsets + " touchableRegion=" + this.mTmpInsets.touchableRegion);
        p.println("  mSettingsObserver=" + this.mSettingsObserver);
        p.println("  mNavigationBarController=" + this.mNavigationBarController.toDebugString());
        p.println("  mBackCallbackRegistered=" + this.mBackCallbackRegistered);
    }

    private void compatHandleBack() {
        if (!this.mDecorViewVisible) {
            Log.e(TAG, "Back callback invoked on a hidden IME. Removing the callback...");
            this.unregisterDefaultOnBackInvokedCallback();
            return;
        }
        KeyEvent downEvent = this.createBackKeyEvent(0, false);
        this.onKeyDown(4, downEvent);
        boolean hasStartedTracking = (downEvent.getFlags() & 0x40000000) != 0;
        KeyEvent upEvent = this.createBackKeyEvent(1, hasStartedTracking);
        this.onKeyUp(4, upEvent);
    }

    private boolean methodIsOverridden(String methodName, Class<?> ... parameterTypes) {
        try {
            return this.getClass().getMethod(methodName, parameterTypes).getDeclaringClass() != InputMethodService.class;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Method must exist.", e);
        }
    }

    public static class Insets {
        public int contentTopInsets;
        public int visibleTopInsets;
        public final Region touchableRegion = new Region();
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_VISIBLE = 2;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public int touchableInsets;

        private void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.contentTopInsets);
            proto.write(1120986464258L, this.visibleTopInsets);
            proto.write(1120986464259L, this.touchableInsets);
            proto.write(1138166333444L, this.touchableRegion.toString());
            proto.end(token);
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mShowImeWithHardKeyboard = 0;
        private final InputMethodService mService;

        private SettingsObserver(InputMethodService service) {
            super(new Handler(service.getMainLooper()));
            this.mService = service;
        }

        public static SettingsObserver createAndRegister(InputMethodService service) {
            SettingsObserver observer = new SettingsObserver(service);
            service.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("show_ime_with_hard_keyboard"), false, observer);
            return observer;
        }

        void unregister() {
            this.mService.getContentResolver().unregisterContentObserver(this);
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private boolean shouldShowImeWithHardKeyboard() {
            if (this.mShowImeWithHardKeyboard == 0) {
                this.mShowImeWithHardKeyboard = Settings.Secure.getInt(this.mService.getContentResolver(), "show_ime_with_hard_keyboard", 0) != 0 ? 2 : 1;
            }
            switch (this.mShowImeWithHardKeyboard) {
                case 2: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            Log.e(InputMethodService.TAG, "Unexpected mShowImeWithHardKeyboard=" + this.mShowImeWithHardKeyboard);
            return false;
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Uri showImeWithHardKeyboardUri = Settings.Secure.getUriFor("show_ime_with_hard_keyboard");
            if (showImeWithHardKeyboardUri.equals(uri)) {
                this.mShowImeWithHardKeyboard = Settings.Secure.getInt(this.mService.getContentResolver(), "show_ime_with_hard_keyboard", 0) != 0 ? 2 : 1;
                this.mService.resetStateForNewConfiguration();
            }
        }

        public String toString() {
            return "SettingsObserver{mShowImeWithHardKeyboard=" + this.mShowImeWithHardKeyboard + "}";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface ShowImeWithHardKeyboardType {
            public static final int UNKNOWN = 0;
            public static final int FALSE = 1;
            public static final int TRUE = 2;
        }
    }

    public class InputMethodImpl
    extends AbstractInputMethodService.AbstractInputMethodImpl {
        private boolean mSystemCallingShowSoftInput;
        private boolean mSystemCallingHideSoftInput;
        private boolean mSimultaneousStylusAndTouchEnabled;

        @Override
        public void initializeInternal(@NonNull IInputMethod.InitParams params) {
            Trace.traceBegin(32L, "IMS.initializeInternal");
            InputMethodService.this.mPrivOps.set(params.privilegedOperations);
            InputMethodPrivilegedOperationsRegistry.put(params.token, InputMethodService.this.mPrivOps);
            this.onNavButtonFlagsChanged(params.navigationBarFlags);
            this.attachToken(params.token);
            Trace.traceEnd(32L);
        }

        @Override
        public void onCreateInlineSuggestionsRequest(@NonNull InlineSuggestionsRequestInfo requestInfo, @NonNull IInlineSuggestionsRequestCallback cb) {
            InputMethodService.this.mInlineSuggestionSessionController.onMakeInlineSuggestionsRequest(requestInfo, cb);
        }

        @Override
        public void attachToken(IBinder token) {
            if (InputMethodService.this.mToken != null) {
                throw new IllegalStateException("attachToken() must be called at most once. token=" + token);
            }
            InputMethodService.this.attachToWindowToken(token);
            InputMethodService.this.mToken = token;
            InputMethodService.this.mWindow.setToken(token);
        }

        @Override
        public void bindInput(InputBinding binding) {
            Trace.traceBegin(32L, "IMS.bindInput");
            InputMethodService.this.mInputBinding = binding;
            InputMethodService.this.mInputConnection = binding.getConnection();
            InputMethodService.this.reportFullscreenMode();
            InputMethodService.this.initialize();
            InputMethodService.this.onBindInput();
            InputMethodService.this.mConfigTracker.onBindInput(InputMethodService.this.getResources());
            Trace.traceEnd(32L);
        }

        @Override
        public void unbindInput() {
            InputMethodService.this.onUnbindInput();
            InputMethodService.this.mInputBinding = null;
            InputMethodService.this.mInputConnection = null;
            if (InputMethodService.this.mInkWindow != null) {
                this.finishStylusHandwriting();
                InputMethodService.this.scheduleStylusWindowIdleTimeout();
            }
        }

        @Override
        public void startInput(InputConnection ic, EditorInfo editorInfo) {
            Trace.traceBegin(32L, "IMS.startInput");
            InputMethodService.this.doStartInput(ic, editorInfo, false);
            Trace.traceEnd(32L);
        }

        @Override
        public void restartInput(InputConnection ic, EditorInfo editorInfo) {
            Trace.traceBegin(32L, "IMS.restartInput");
            InputMethodService.this.doStartInput(ic, editorInfo, true);
            Trace.traceEnd(32L);
        }

        @Override
        public void dispatchStartInput(@Nullable InputConnection inputConnection, @NonNull IInputMethod.StartInputParams params) {
            InputMethodService.this.mPrivOps.reportStartInputAsync(params.startInputToken);
            this.onNavButtonFlagsChanged(params.navigationBarFlags);
            if (params.restarting) {
                this.restartInput(inputConnection, params.editorInfo);
            } else {
                this.startInput(inputConnection, params.editorInfo);
            }
            InputMethodService.this.mImeDispatcher = params.imeDispatcher;
            if (InputMethodService.this.mWindow != null) {
                InputMethodService.this.mWindow.getOnBackInvokedDispatcher().setImeOnBackInvokedDispatcher(InputMethodService.this.mImeDispatcher);
                if (InputMethodService.this.mDecorViewVisible && InputMethodService.this.mShowInputRequested) {
                    InputMethodService.this.registerDefaultOnBackInvokedCallback();
                }
            }
        }

        @Override
        public void onNavButtonFlagsChanged(int navButtonFlags) {
            InputMethodService.this.mNavigationBarController.onNavButtonFlagsChanged(navButtonFlags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hideSoftInputWithToken(int flags, ResultReceiver resultReceiver, @NonNull ImeTracker.Token statsToken) {
            this.mSystemCallingHideSoftInput = true;
            InputMethodService.this.mCurStatsToken = statsToken;
            try {
                this.hideSoftInput(flags, resultReceiver);
            }
            finally {
                this.mSystemCallingHideSoftInput = false;
            }
        }

        @Override
        public void hideSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean visibilityChanged;
            ImeTracker.Token statsToken = InputMethodService.this.mCurStatsToken != null ? InputMethodService.this.mCurStatsToken : InputMethodService.this.createStatsToken(false, 41, ImeTracker.isFromUser(InputMethodService.this.mRootView));
            InputMethodService.this.mCurStatsToken = null;
            if (InputMethodService.this.getApplicationInfo().targetSdkVersion >= 30 && !this.mSystemCallingHideSoftInput) {
                Log.e("InputMethod", "IME shouldn't call hideSoftInput on itself. Use requestHideSelf(int) itself");
                ImeTracker.forLogging().onFailed(statsToken, 14);
                return;
            }
            ImeTracker.forLogging().onProgress(statsToken, 14);
            Trace.traceBegin(32L, "IMS.hideSoftInput");
            ImeTracing.getInstance().triggerServiceDump("InputMethodService.InputMethodImpl#hideSoftInput", InputMethodService.this.mDumper, null);
            boolean wasVisible = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            InputMethodService.this.mShowInputRequested = false;
            InputMethodService.this.mCurStatsToken = statsToken;
            InputMethodService.this.hideWindow();
            boolean isVisible = InputMethodService.this.isInputViewShown();
            boolean bl = visibilityChanged = isVisible != wasVisible;
            if (resultReceiver != null) {
                resultReceiver.send(visibilityChanged ? 3 : (wasVisible ? 0 : 1), null);
            }
            Trace.traceEnd(32L);
            InputMethodService.this.scheduleImeSurfaceRemoval();
            ImeTracker.forLogging().onHidden(statsToken);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showSoftInputWithToken(int flags, ResultReceiver resultReceiver, @NonNull ImeTracker.Token statsToken) {
            this.mSystemCallingShowSoftInput = true;
            InputMethodService.this.mCurStatsToken = statsToken;
            try {
                this.showSoftInput(flags, resultReceiver);
            }
            finally {
                this.mSystemCallingShowSoftInput = false;
            }
        }

        @Override
        public void showSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean visibilityChanged;
            ImeTracker.Token statsToken = InputMethodService.this.mCurStatsToken != null ? InputMethodService.this.mCurStatsToken : InputMethodService.this.createStatsToken(true, 40, ImeTracker.isFromUser(InputMethodService.this.mRootView));
            InputMethodService.this.mCurStatsToken = null;
            if (InputMethodService.this.getApplicationInfo().targetSdkVersion >= 30 && !this.mSystemCallingShowSoftInput) {
                Log.e("InputMethod", "IME shouldn't call showSoftInput on itself. Use requestShowSelf(int) itself");
                ImeTracker.forLogging().onFailed(statsToken, 13);
                return;
            }
            ImeTracker.forLogging().onProgress(statsToken, 13);
            Trace.traceBegin(32L, "IMS.showSoftInput");
            ImeTracing.getInstance().triggerServiceDump("InputMethodService.InputMethodImpl#showSoftInput", InputMethodService.this.mDumper, null);
            boolean wasVisible = InputMethodService.this.isInputViewShown();
            if (InputMethodService.this.dispatchOnShowInputRequested(flags, false)) {
                ImeTracker.forLogging().onProgress(statsToken, 15);
                InputMethodService.this.mCurStatsToken = statsToken;
                InputMethodService.this.showWindow(true);
            } else {
                ImeTracker.forLogging().onFailed(statsToken, 15);
            }
            InputMethodService.this.setImeWindowVisibility(InputMethodService.this.computeImeWindowVis());
            boolean isVisible = InputMethodService.this.isInputViewShown();
            boolean bl = visibilityChanged = isVisible != wasVisible;
            if (resultReceiver != null) {
                resultReceiver.send(visibilityChanged ? 2 : (wasVisible ? 0 : 1), null);
            }
            Trace.traceEnd(32L);
        }

        @Override
        public void updateEditorToolType(int toolType) {
            InputMethodService.this.updateEditorToolTypeInternal(toolType);
        }

        @Override
        public void canStartStylusHandwriting(int requestId, @Nullable IConnectionlessHandwritingCallback connectionlessCallback, @Nullable CursorAnchorInfo cursorAnchorInfo, boolean isConnectionlessForDelegation) {
            if (InputMethodService.this.mHandwritingRequestId.isPresent()) {
                Log.d("InputMethod", "There is an ongoing Handwriting session. ignoring.");
                return;
            }
            if (!InputMethodService.this.mInputStarted) {
                Log.d("InputMethod", "Input should have started before starting Stylus handwriting.");
                return;
            }
            this.maybeCreateAndInitInkWindow();
            if (!InputMethodService.this.mOnPreparedStylusHwCalled) {
                InputMethodService.this.onPrepareStylusHandwriting();
            }
            InputMethodService.this.mOnPreparedStylusHwCalled = false;
            if (connectionlessCallback != null) {
                if (InputMethodService.this.onStartConnectionlessStylusHandwriting(1, cursorAnchorInfo)) {
                    InputMethodService.this.mConnectionlessHandwritingCallback = connectionlessCallback;
                    InputMethodService.this.mIsConnectionlessHandwritingForDelegation = isConnectionlessForDelegation;
                    InputMethodService.this.cancelStylusWindowIdleTimeout();
                    InputMethodService.this.mPrivOps.onStylusHandwritingReady(requestId, Process.myPid());
                } else {
                    Log.i("InputMethod", "IME is not ready or doesn't currently support connectionless handwriting");
                    try {
                        connectionlessCallback.onError(1);
                    }
                    catch (RemoteException e) {
                        Log.e("InputMethod", "Couldn't send connectionless handwriting error result", e);
                    }
                }
            } else if (InputMethodService.this.onStartStylusHandwriting()) {
                InputMethodService.this.cancelStylusWindowIdleTimeout();
                InputMethodService.this.mPrivOps.onStylusHandwritingReady(requestId, Process.myPid());
            } else {
                Log.i("InputMethod", "IME is not ready. Can't start Stylus Handwriting");
            }
        }

        @Override
        public void startStylusHandwriting(int requestId, @NonNull InputChannel channel, @NonNull List<MotionEvent> stylusEvents) {
            Objects.requireNonNull(channel);
            Objects.requireNonNull(stylusEvents);
            if (InputMethodService.this.mHandwritingRequestId.isPresent()) {
                return;
            }
            InputMethodService.this.mHandwritingRequestId = OptionalInt.of(requestId);
            InputMethodService.this.mShowInputRequested = false;
            InputMethodService.this.mInkWindow.show();
            this.mSimultaneousStylusAndTouchEnabled = Flags.enableMultiDeviceInput();
            stylusEvents.forEach(this::deliverStylusHandwritingMotionEvent);
            InputMethodService.this.mHandwritingEventReceiver = new InputEventReceiver(channel, Looper.getMainLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputEvent(InputEvent event) {
                    boolean handled = false;
                    try {
                        if (!(event instanceof MotionEvent)) {
                            return;
                        }
                        MotionEvent motionEvent = (MotionEvent)event;
                        if (!motionEvent.isStylusPointer()) {
                            return;
                        }
                        InputMethodImpl.this.deliverStylusHandwritingMotionEvent(motionEvent);
                        InputMethodService.this.scheduleHandwritingSessionTimeout();
                        handled = true;
                    }
                    finally {
                        this.finishInputEvent(event, handled);
                    }
                }
            };
            InputMethodService.this.scheduleHandwritingSessionTimeout();
        }

        private void deliverStylusHandwritingMotionEvent(MotionEvent motionEvent) {
            InputMethodService.this.onStylusHandwritingMotionEvent(motionEvent);
            if (!this.mSimultaneousStylusAndTouchEnabled) {
                return;
            }
            switch (motionEvent.getAction()) {
                case 0: 
                case 9: {
                    InputMethodService.this.mPrivOps.setHandwritingSurfaceNotTouchable(false);
                    break;
                }
                case 1: 
                case 3: 
                case 10: {
                    InputMethodService.this.mPrivOps.setHandwritingSurfaceNotTouchable(true);
                    break;
                }
                case 4: {
                    this.finishStylusHandwriting();
                }
            }
        }

        @Override
        public void commitHandwritingDelegationTextIfAvailable() {
            InputMethodService.this.commitHandwritingDelegationTextIfAvailable();
        }

        @Override
        public void discardHandwritingDelegationText() {
            InputMethodService.this.discardHandwritingDelegationText();
        }

        @Override
        public void initInkWindow() {
            this.maybeCreateAndInitInkWindow();
            InputMethodService.this.onPrepareStylusHandwriting();
            InputMethodService.this.mOnPreparedStylusHwCalled = true;
        }

        private void maybeCreateAndInitInkWindow() {
            if (InputMethodService.this.mInkWindow == null) {
                InputMethodService.this.mInkWindow = new InkWindow(InputMethodService.this.mWindow.getContext());
                InputMethodService.this.mInkWindow.setToken(InputMethodService.this.mToken);
            }
            InputMethodService.this.mInkWindow.initOnly();
        }

        @Override
        public void finishStylusHandwriting() {
            InputMethodService.this.finishStylusHandwriting();
        }

        @Override
        public void removeStylusHandwritingWindow() {
            InputMethodService.this.finishAndRemoveStylusHandwritingWindow();
        }

        @Override
        public void setStylusWindowIdleTimeoutForTest(long timeout) {
            InputMethodService.this.mStylusWindowIdleTimeoutForTest = timeout;
        }

        @Override
        public void changeInputMethodSubtype(InputMethodSubtype subtype) {
            InputMethodService.this.dispatchOnCurrentInputMethodSubtypeChanged(subtype);
        }
    }

    public class InputMethodSessionImpl
    extends AbstractInputMethodService.AbstractInputMethodSessionImpl {
        @Override
        public void finishInput() {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.doFinishInput();
        }

        @Override
        public void displayCompletions(CompletionInfo[] completions) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.mCurCompletions = completions;
            InputMethodService.this.onDisplayCompletions(completions);
        }

        @Override
        public void updateExtractedText(int token, ExtractedText text) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateExtractedText(token, text);
        }

        @Override
        public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateSelection(oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd);
        }

        @Override
        public void viewClicked(boolean focusChanged) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onViewClicked(focusChanged);
        }

        @Override
        public void updateCursor(Rect newCursor) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursor(newCursor);
        }

        @Override
        public void appPrivateCommand(String action, Bundle data) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onAppPrivateCommand(action, data);
        }

        @Override
        @Deprecated
        public void toggleSoftInput(int showFlags, int hideFlags) {
            InputMethodService.this.onToggleSoftInput(showFlags, hideFlags);
        }

        @Override
        public void updateCursorAnchorInfo(CursorAnchorInfo info) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursorAnchorInfo(info);
        }

        @Override
        public void removeImeSurface() {
            InputMethodService.this.scheduleImeSurfaceRemoval();
        }

        @Override
        public void invalidateInputInternal(@NonNull EditorInfo editorInfo, @NonNull IRemoteInputConnection inputConnection, int sessionId) {
            if (InputMethodService.this.mStartedInputConnection instanceof RemoteInputConnection) {
                RemoteInputConnection ric = (RemoteInputConnection)InputMethodService.this.mStartedInputConnection;
                if (!ric.isSameConnection(inputConnection)) {
                    return;
                }
                editorInfo.makeCompatible(InputMethodService.this.getApplicationInfo().targetSdkVersion);
                InputMethodService.this.mLastHandwritingRegion = null;
                InputMethodService.this.getInputMethodInternal().restartInput(new RemoteInputConnection(ric, sessionId), editorInfo);
            }
        }
    }

    public static @interface ImeWindowVisibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackDispositionMode {
    }
}

