/*
 * Decompiled with CFR 0.152.
 */
package android.icu.platform;

import java.util.ArrayList;

public class AndroidDataFiles {
    public static final String ANDROID_ROOT_ENV = "ANDROID_ROOT";
    public static final String ANDROID_I18N_ROOT_ENV = "ANDROID_I18N_ROOT";
    public static final String ANDROID_TZDATA_ROOT_ENV = "ANDROID_TZDATA_ROOT";
    public static final int CURRENT_MAJOR_VERSION = 9;

    private static String getTimeZoneModuleFile(String fileName) {
        return System.getenv(ANDROID_TZDATA_ROOT_ENV) + "/etc/" + fileName;
    }

    private static String getTimeZoneModuleIcuFile(String fileName) {
        return AndroidDataFiles.getTimeZoneModuleFile("tz/versioned/9/icu/" + fileName);
    }

    public static String getI18nModuleIcuFile(String fileName) {
        return AndroidDataFiles.getI18nModuleFile("icu/" + fileName);
    }

    private static String getI18nModuleFile(String fileName) {
        return System.getenv(ANDROID_I18N_ROOT_ENV) + "/etc/" + fileName;
    }

    public static String generateIcuDataPath() {
        ArrayList<String> paths = new ArrayList<String>(2);
        String timeZoneModuleIcuDataPath = AndroidDataFiles.getTimeZoneModuleIcuFile("");
        paths.add(timeZoneModuleIcuDataPath);
        String i18nModuleIcuDataPath = AndroidDataFiles.getI18nModuleIcuFile("");
        paths.add(i18nModuleIcuDataPath);
        return String.join((CharSequence)":", paths);
    }
}

