/*
 * Decompiled with CFR 0.152.
 */
package android.icu.number;

import android.annotation.FlaggedApi;
import android.icu.impl.FormattedStringBuilder;
import android.icu.impl.StandardPlural;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.DecimalQuantity_DualStorageBCD;
import android.icu.impl.number.LocalizedNumberFormatterAsFormat;
import android.icu.impl.number.MacroProps;
import android.icu.impl.number.MicroProps;
import android.icu.number.FormattedNumber;
import android.icu.number.NumberFormatterImpl;
import android.icu.number.NumberFormatterSettings;
import android.icu.number.UnlocalizedNumberFormatter;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import java.text.Format;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalizedNumberFormatter
extends NumberFormatterSettings<LocalizedNumberFormatter> {
    static final AtomicLongFieldUpdater<LocalizedNumberFormatter> callCount = AtomicLongFieldUpdater.newUpdater(LocalizedNumberFormatter.class, "callCountInternal");
    volatile long callCountInternal;
    volatile LocalizedNumberFormatter savedWithUnit;
    volatile NumberFormatterImpl compiled;

    LocalizedNumberFormatter(NumberFormatterSettings<?> parent, int key, Object value) {
        super(parent, key, value);
    }

    public FormattedNumber format(long input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(double input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Number input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Measure input) {
        DecimalQuantity_DualStorageBCD fq = new DecimalQuantity_DualStorageBCD(input.getNumber());
        MeasureUnit unit = input.getUnit();
        FormattedStringBuilder string2 = new FormattedStringBuilder();
        MicroProps micros = this.formatImpl(fq, unit, string2);
        return new FormattedNumber(string2, fq, micros.outputUnit, micros.gender);
    }

    public Format toFormat() {
        return new LocalizedNumberFormatterAsFormat(this, this.resolve().loc);
    }

    @FlaggedApi(value="com.android.icu.icu_25q2_api")
    public UnlocalizedNumberFormatter withoutLocale() {
        return new UnlocalizedNumberFormatter(this, 1, null);
    }

    private FormattedNumber format(DecimalQuantity fq) {
        FormattedStringBuilder string2 = new FormattedStringBuilder();
        MicroProps micros = this.formatImpl(fq, string2);
        return new FormattedNumber(string2, fq, micros.outputUnit, micros.gender);
    }

    @Deprecated
    public MicroProps formatImpl(DecimalQuantity fq, FormattedStringBuilder string2) {
        if (this.computeCompiled()) {
            return this.compiled.format(fq, string2);
        }
        return NumberFormatterImpl.formatStatic(this.resolve(), fq, string2);
    }

    @Deprecated
    public MicroProps formatImpl(DecimalQuantity fq, MeasureUnit unit, FormattedStringBuilder string2) {
        if (Objects.equals(this.resolve().unit, unit)) {
            return this.formatImpl(fq, string2);
        }
        LocalizedNumberFormatter withUnit = this.savedWithUnit;
        if (withUnit == null || !Objects.equals(withUnit.resolve().unit, unit)) {
            this.savedWithUnit = withUnit = new LocalizedNumberFormatter(this, 3, unit);
        }
        return withUnit.formatImpl(fq, string2);
    }

    @Deprecated
    public String getAffixImpl(boolean isPrefix, boolean isNegative) {
        FormattedStringBuilder string2 = new FormattedStringBuilder();
        byte signum = (byte)(isNegative ? -1 : 1);
        StandardPlural plural = StandardPlural.OTHER;
        int prefixLength = this.computeCompiled() ? this.compiled.getPrefixSuffix(signum, plural, string2) : NumberFormatterImpl.getPrefixSuffixStatic(this.resolve(), signum, plural, string2);
        if (isPrefix) {
            return string2.subSequence(0, prefixLength).toString();
        }
        return string2.subSequence(prefixLength, string2.length()).toString();
    }

    private boolean computeCompiled() {
        MacroProps macros = this.resolve();
        long currentCount = callCount.incrementAndGet(this);
        if (currentCount == macros.threshold) {
            this.compiled = new NumberFormatterImpl(macros);
            return true;
        }
        return this.compiled != null;
    }

    @Override
    LocalizedNumberFormatter create(int key, Object value) {
        return new LocalizedNumberFormatter(this, key, value);
    }
}

