/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.migration;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.health.connect.migration.MigrationPayload;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PermissionMigrationPayload
extends MigrationPayload
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<PermissionMigrationPayload> CREATOR = new Parcelable.Creator<PermissionMigrationPayload>(){

        @Override
        public PermissionMigrationPayload createFromParcel(Parcel in) {
            in.readInt();
            return new PermissionMigrationPayload(in);
        }

        public PermissionMigrationPayload[] newArray(int size) {
            return new PermissionMigrationPayload[size];
        }
    };
    private final String mHoldingPackageName;
    private final Instant mFirstGrantTime;
    private final List<String> mPermissions;

    private PermissionMigrationPayload(@NonNull String holdingPackageName, @NonNull Instant firstGrantTime, @NonNull List<String> permissions) {
        this.mHoldingPackageName = holdingPackageName;
        this.mFirstGrantTime = firstGrantTime;
        this.mPermissions = permissions;
    }

    PermissionMigrationPayload(@NonNull Parcel in) {
        this.mHoldingPackageName = in.readString();
        this.mFirstGrantTime = in.readSerializable(Instant.class.getClassLoader(), Instant.class);
        this.mPermissions = in.createStringArrayList();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeString(this.mHoldingPackageName);
        dest.writeSerializable(this.mFirstGrantTime);
        dest.writeStringList(this.mPermissions);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String getHoldingPackageName() {
        return this.mHoldingPackageName;
    }

    @NonNull
    public Instant getFirstGrantTime() {
        return this.mFirstGrantTime;
    }

    @NonNull
    public List<String> getPermissions() {
        return this.mPermissions;
    }

    public static class Builder {
        private final List<String> mPermissions = new ArrayList<String>();
        private String mHoldingPackageName;
        private Instant mFirstGrantTime;

        public Builder(@NonNull String holdingPackageName, @NonNull Instant firstGrantTime) {
            Objects.requireNonNull(holdingPackageName);
            Objects.requireNonNull(firstGrantTime);
            this.mHoldingPackageName = holdingPackageName;
            this.mFirstGrantTime = firstGrantTime;
        }

        @NonNull
        public Builder setHoldingPackageName(@NonNull String holdingPackageName) {
            Objects.requireNonNull(holdingPackageName);
            this.mHoldingPackageName = holdingPackageName;
            return this;
        }

        @NonNull
        public Builder setFirstGrantTime(@NonNull Instant firstGrantTime) {
            Objects.requireNonNull(firstGrantTime);
            this.mFirstGrantTime = firstGrantTime;
            return this;
        }

        @NonNull
        public Builder addPermission(@NonNull String permission2) {
            Objects.requireNonNull(permission2);
            this.mPermissions.add(permission2);
            return this;
        }

        @NonNull
        public PermissionMigrationPayload build() {
            return new PermissionMigrationPayload(this.mHoldingPackageName, this.mFirstGrantTime, this.mPermissions);
        }
    }
}

