/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.HealthPermissions;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.DataTypeDescriptor;
import android.health.connect.internal.datatypes.utils.DataTypeDescriptors;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.healthfitness.flags.Flags;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HealthConnectMappings {
    private final Map<Integer, DataTypeDescriptor> mRecordIdToDescriptorMap;
    private final Map<Integer, String> mPermissionCategoryToReadPermissionMap;
    private final Map<Integer, String> mPermissionCategoryToWritePermissionMap;
    private final Map<String, Integer> mWritePermissionToDataCategoryMap;
    private final Map<Integer, String[]> mDataCategoryToWritePermissionsMap;
    private final Map<Integer, Class<? extends RecordInternal<?>>> mRecordIdToInternalRecordClassMap;
    private final Map<Integer, Class<? extends Record>> mRecordIdToRecordClassMap;
    private final Map<Class<? extends Record>, Integer> mRecordClassToRecordIdMap;
    private final Set<Integer> mHealthDataCategories;
    @Nullable
    private static volatile HealthConnectMappings sHealthConnectMappings;

    public static HealthConnectMappings getInstance() {
        if (sHealthConnectMappings == null) {
            sHealthConnectMappings = new HealthConnectMappings();
        }
        return sHealthConnectMappings;
    }

    @VisibleForTesting
    public static void resetInstanceForTesting() {
        sHealthConnectMappings = new HealthConnectMappings();
    }

    @VisibleForTesting
    public HealthConnectMappings() {
        List<DataTypeDescriptor> dataTypeDescriptors = DataTypeDescriptors.getAllDataTypeDescriptors();
        this.mRecordIdToDescriptorMap = HealthConnectMappings.toArrayMap(dataTypeDescriptors, DataTypeDescriptor::getRecordTypeIdentifier, Function.identity());
        this.mPermissionCategoryToReadPermissionMap = HealthConnectMappings.toArrayMap(dataTypeDescriptors, DataTypeDescriptor::getPermissionCategory, DataTypeDescriptor::getReadPermission);
        this.mPermissionCategoryToWritePermissionMap = HealthConnectMappings.toArrayMap(dataTypeDescriptors, DataTypeDescriptor::getPermissionCategory, DataTypeDescriptor::getWritePermission);
        this.mWritePermissionToDataCategoryMap = HealthConnectMappings.toArrayMap(dataTypeDescriptors, DataTypeDescriptor::getWritePermission, DataTypeDescriptor::getDataCategory);
        this.mDataCategoryToWritePermissionsMap = HealthConnectMappings.getDataCategoryToWritePermissionsMap(dataTypeDescriptors);
        this.mRecordIdToInternalRecordClassMap = HealthConnectMappings.toArrayMap(dataTypeDescriptors, DataTypeDescriptor::getRecordTypeIdentifier, DataTypeDescriptor::getRecordInternalClass);
        this.mRecordIdToRecordClassMap = HealthConnectMappings.toArrayMap(dataTypeDescriptors, DataTypeDescriptor::getRecordTypeIdentifier, DataTypeDescriptor::getRecordClass);
        this.mRecordClassToRecordIdMap = HealthConnectMappings.toArrayMap(dataTypeDescriptors, DataTypeDescriptor::getRecordClass, DataTypeDescriptor::getRecordTypeIdentifier);
        this.mHealthDataCategories = HealthConnectMappings.toArraySet(dataTypeDescriptors, DataTypeDescriptor::getDataCategory);
    }

    public Set<Integer> getAllRecordTypeIdentifiers() {
        return this.mRecordIdToDescriptorMap.keySet();
    }

    public boolean isWritePermission(@NonNull String permissionName) {
        return this.mWritePermissionToDataCategoryMap.containsKey(permissionName);
    }

    public boolean isFitnessPermission(@NonNull String permissionName) {
        return this.mPermissionCategoryToReadPermissionMap.containsValue(permissionName) || this.mPermissionCategoryToWritePermissionMap.containsValue(permissionName);
    }

    public String getHealthReadPermission(int permissionCategory) {
        return Objects.requireNonNull(this.mPermissionCategoryToReadPermissionMap.get(permissionCategory), "Read permission not found for permission category:" + permissionCategory);
    }

    public String getHealthWritePermission(int permissionCategory) {
        return Objects.requireNonNull(this.mPermissionCategoryToWritePermissionMap.get(permissionCategory), "Write permission not found for permission category:" + permissionCategory);
    }

    public int getHealthDataCategoryForWritePermission(@Nullable String permissionName) {
        if (!Flags.healthConnectMappingsFollowUp()) {
            return HealthPermissions.getHealthDataCategoryForWritePermission(permissionName);
        }
        return this.mWritePermissionToDataCategoryMap.getOrDefault(permissionName, -1);
    }

    public String[] getWriteHealthPermissionsFor(int dataCategory) {
        return this.mDataCategoryToWritePermissionsMap.getOrDefault(dataCategory, new String[0]);
    }

    public Map<Integer, Class<? extends RecordInternal<?>>> getRecordIdToInternalRecordClassMap() {
        return this.mRecordIdToInternalRecordClassMap;
    }

    public Map<Integer, Class<? extends Record>> getRecordIdToExternalRecordClassMap() {
        return this.mRecordIdToRecordClassMap;
    }

    public int getRecordType(Class<? extends Record> recordClass) {
        return Objects.requireNonNull(this.mRecordClassToRecordIdMap.get(recordClass));
    }

    public boolean hasRecordType(Class<? extends Record> recordClass) {
        return this.mRecordClassToRecordIdMap.containsKey(recordClass);
    }

    public int getHealthPermissionCategoryForRecordType(int recordType) {
        return Objects.requireNonNull(this.mRecordIdToDescriptorMap.get(recordType), "Unsupported record type: " + recordType).getPermissionCategory();
    }

    public int getRecordCategoryForRecordType(int recordType) {
        return Objects.requireNonNull(this.mRecordIdToDescriptorMap.get(recordType), "Unsupported record type: " + recordType).getDataCategory();
    }

    public Set<Integer> getAllHealthDataCategories() {
        return this.mHealthDataCategories;
    }

    private static ArrayMap<Integer, String[]> getDataCategoryToWritePermissionsMap(List<DataTypeDescriptor> descriptors) {
        Map map = descriptors.stream().collect(Collectors.groupingBy(DataTypeDescriptor::getDataCategory, Collectors.mapping(DataTypeDescriptor::getWritePermission, Collectors.toSet())));
        ArrayMap<Integer, String[]> result = new ArrayMap<Integer, String[]>();
        map.forEach((k, v) -> result.put((Integer)k, v.toArray(new String[0])));
        return result;
    }

    private static <T, K, V> ArrayMap<K, V> toArrayMap(Collection<T> collection, Function<T, K> keyFunc, Function<T, V> valueFunc) {
        ArrayMap<K, V> map = new ArrayMap<K, V>(collection.size());
        for (T item : collection) {
            K key = keyFunc.apply(item);
            V value = valueFunc.apply(item);
            map.put(key, value);
        }
        return map;
    }

    private static <T, R> ArraySet<R> toArraySet(Collection<T> collection, Function<T, R> mapFunc) {
        ArraySet<R> set = new ArraySet<R>(collection.size());
        for (T item : collection) {
            set.add(mapFunc.apply(item));
        }
        return set;
    }
}

