/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.ActiveCaloriesBurnedRecord;
import android.health.connect.datatypes.ActivityIntensityRecord;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.BasalMetabolicRateRecord;
import android.health.connect.datatypes.BloodPressureRecord;
import android.health.connect.datatypes.CyclingPedalingCadenceRecord;
import android.health.connect.datatypes.DistanceRecord;
import android.health.connect.datatypes.ElevationGainedRecord;
import android.health.connect.datatypes.ExerciseSessionRecord;
import android.health.connect.datatypes.FloorsClimbedRecord;
import android.health.connect.datatypes.HeartRateRecord;
import android.health.connect.datatypes.HeightRecord;
import android.health.connect.datatypes.HydrationRecord;
import android.health.connect.datatypes.MindfulnessSessionRecord;
import android.health.connect.datatypes.NutritionRecord;
import android.health.connect.datatypes.PowerRecord;
import android.health.connect.datatypes.RestingHeartRateRecord;
import android.health.connect.datatypes.SkinTemperatureRecord;
import android.health.connect.datatypes.SleepSessionRecord;
import android.health.connect.datatypes.SpeedRecord;
import android.health.connect.datatypes.StepsCadenceRecord;
import android.health.connect.datatypes.StepsRecord;
import android.health.connect.datatypes.TotalCaloriesBurnedRecord;
import android.health.connect.datatypes.WeightRecord;
import android.health.connect.datatypes.WheelchairPushesRecord;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Length;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.units.Pressure;
import android.health.connect.datatypes.units.TemperatureDelta;
import android.health.connect.datatypes.units.Velocity;
import android.health.connect.datatypes.units.Volume;
import android.os.Parcel;
import com.android.healthfitness.flags.AconfigFlagHelper;
import com.android.healthfitness.flags.Flags;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AggregationTypeIdMapper {
    @Nullable
    private static volatile AggregationTypeIdMapper sAggregationTypeIdMapper;
    private final Map<Integer, ParcelDataReader<?>> mIdToParcelDataReader = new HashMap();
    private final Map<Integer, AggregationType<?>> mIdDataAggregationTypeMap = new HashMap();
    private final Map<AggregationType<?>, Integer> mDataAggregationTypeIdMap = new HashMap();

    private AggregationTypeIdMapper() {
        ArrayList longAggregations = new ArrayList(List.of(HeartRateRecord.BPM_MAX, HeartRateRecord.BPM_MIN, StepsRecord.STEPS_COUNT_TOTAL, HeartRateRecord.BPM_AVG, RestingHeartRateRecord.BPM_MAX, RestingHeartRateRecord.BPM_MIN, RestingHeartRateRecord.BPM_AVG, WheelchairPushesRecord.WHEEL_CHAIR_PUSHES_COUNT_TOTAL, HeartRateRecord.HEART_MEASUREMENTS_COUNT, SleepSessionRecord.SLEEP_DURATION_TOTAL, ExerciseSessionRecord.EXERCISE_DURATION_TOTAL, MindfulnessSessionRecord.MINDFULNESS_DURATION_TOTAL));
        ArrayList durationAggregations = new ArrayList();
        if (Flags.activityIntensity() && AconfigFlagHelper.isActivityIntensityEnabled()) {
            durationAggregations.add(ActivityIntensityRecord.MODERATE_DURATION_TOTAL);
            durationAggregations.add(ActivityIntensityRecord.VIGOROUS_DURATION_TOTAL);
            durationAggregations.add(ActivityIntensityRecord.DURATION_TOTAL);
            longAggregations.add(ActivityIntensityRecord.INTENSITY_MINUTES_TOTAL);
        }
        this.addLongIdsToAggregateResultMap(longAggregations);
        this.addDoubleIdsToAggregateResultMap(Arrays.asList(FloorsClimbedRecord.FLOORS_CLIMBED_TOTAL, CyclingPedalingCadenceRecord.RPM_AVG, CyclingPedalingCadenceRecord.RPM_MAX, CyclingPedalingCadenceRecord.RPM_MIN, StepsCadenceRecord.STEPS_CADENCE_RATE_MAX, StepsCadenceRecord.STEPS_CADENCE_RATE_AVG, StepsCadenceRecord.STEPS_CADENCE_RATE_MIN));
        this.addPowerIdsToAggregateResultMap(Arrays.asList(PowerRecord.POWER_MIN, PowerRecord.POWER_MAX, PowerRecord.POWER_AVG));
        this.addTemperatureDeltaIdsToAggregateResultMap(Arrays.asList(SkinTemperatureRecord.SKIN_TEMPERATURE_DELTA_AVG, SkinTemperatureRecord.SKIN_TEMPERATURE_DELTA_MIN, SkinTemperatureRecord.SKIN_TEMPERATURE_DELTA_MAX));
        this.addEnergyIdsToAggregateResultMap(Arrays.asList(ActiveCaloriesBurnedRecord.ACTIVE_CALORIES_TOTAL, BasalMetabolicRateRecord.BASAL_CALORIES_TOTAL, NutritionRecord.ENERGY_TOTAL, NutritionRecord.ENERGY_FROM_FAT_TOTAL, TotalCaloriesBurnedRecord.ENERGY_TOTAL));
        this.addVolumeIdsToAggregateResultMap(Arrays.asList(HydrationRecord.VOLUME_TOTAL));
        this.addLengthIdsToAggregateResultMap(Arrays.asList(DistanceRecord.DISTANCE_TOTAL, ElevationGainedRecord.ELEVATION_GAINED_TOTAL, HeightRecord.HEIGHT_AVG, HeightRecord.HEIGHT_MAX, HeightRecord.HEIGHT_MIN));
        this.addMassIdsToAggregateResultMap(Arrays.asList(NutritionRecord.BIOTIN_TOTAL, NutritionRecord.CAFFEINE_TOTAL, NutritionRecord.CALCIUM_TOTAL, NutritionRecord.CHLORIDE_TOTAL, NutritionRecord.CHOLESTEROL_TOTAL, NutritionRecord.CHROMIUM_TOTAL, NutritionRecord.COPPER_TOTAL, NutritionRecord.DIETARY_FIBER_TOTAL, NutritionRecord.FOLATE_TOTAL, NutritionRecord.FOLIC_ACID_TOTAL, NutritionRecord.IODINE_TOTAL, NutritionRecord.IRON_TOTAL, NutritionRecord.MAGNESIUM_TOTAL, NutritionRecord.MANGANESE_TOTAL, NutritionRecord.MOLYBDENUM_TOTAL, NutritionRecord.MONOUNSATURATED_FAT_TOTAL, NutritionRecord.NIACIN_TOTAL, NutritionRecord.PANTOTHENIC_ACID_TOTAL, NutritionRecord.PHOSPHORUS_TOTAL, NutritionRecord.POLYUNSATURATED_FAT_TOTAL, NutritionRecord.POTASSIUM_TOTAL, NutritionRecord.PROTEIN_TOTAL, NutritionRecord.RIBOFLAVIN_TOTAL, NutritionRecord.SATURATED_FAT_TOTAL, NutritionRecord.SELENIUM_TOTAL, NutritionRecord.SODIUM_TOTAL, NutritionRecord.SUGAR_TOTAL, NutritionRecord.THIAMIN_TOTAL, NutritionRecord.TOTAL_CARBOHYDRATE_TOTAL, NutritionRecord.TOTAL_FAT_TOTAL, NutritionRecord.UNSATURATED_FAT_TOTAL, NutritionRecord.VITAMIN_A_TOTAL, NutritionRecord.VITAMIN_B12_TOTAL, NutritionRecord.VITAMIN_B6_TOTAL, NutritionRecord.VITAMIN_C_TOTAL, NutritionRecord.VITAMIN_D_TOTAL, NutritionRecord.VITAMIN_E_TOTAL, NutritionRecord.VITAMIN_K_TOTAL, NutritionRecord.ZINC_TOTAL, WeightRecord.WEIGHT_AVG, WeightRecord.WEIGHT_MAX, WeightRecord.WEIGHT_MIN, NutritionRecord.TRANS_FAT_TOTAL));
        this.addVelocityIdsToAggregateResultMap(Arrays.asList(SpeedRecord.SPEED_MAX, SpeedRecord.SPEED_AVG, SpeedRecord.SPEED_MIN));
        this.addPressureIdsToAggregateResultMap(Arrays.asList(BloodPressureRecord.DIASTOLIC_AVG, BloodPressureRecord.DIASTOLIC_MAX, BloodPressureRecord.DIASTOLIC_MIN, BloodPressureRecord.SYSTOLIC_AVG, BloodPressureRecord.SYSTOLIC_MAX, BloodPressureRecord.SYSTOLIC_MIN));
        this.addDurationIdsToAggregateResultMap(durationAggregations);
    }

    @NonNull
    public static synchronized AggregationTypeIdMapper getInstance() {
        AggregationTypeIdMapper instance = sAggregationTypeIdMapper;
        if (instance == null) {
            sAggregationTypeIdMapper = instance = new AggregationTypeIdMapper();
        }
        return instance;
    }

    @NonNull
    public ParcelDataReader<?> getParcelDataReaderFor(int id2) {
        return Objects.requireNonNull(this.mIdToParcelDataReader.get(id2), "No parcel data reader for aggregation type " + id2);
    }

    public AggregationType<?> getAggregationTypeFor(int id2) {
        return Objects.requireNonNull(this.mIdDataAggregationTypeMap.get(id2), "No aggregation type for id " + id2);
    }

    public int getIdFor(AggregationType<?> aggregationType) {
        return Objects.requireNonNull(this.mDataAggregationTypeIdMap.get(aggregationType), "No aggregation type id for " + aggregationType);
    }

    private void addLongIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), Parcel::readLong);
            this.populateIdDataAggregationType(type);
        }
    }

    private void addDoubleIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), Parcel::readDouble);
            this.populateIdDataAggregationType(type);
        }
    }

    private void addEnergyIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Energy.fromCalories(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addPowerIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Power.fromWatts(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addTemperatureDeltaIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> TemperatureDelta.fromCelsius(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addPressureIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Pressure.fromMillimetersOfMercury(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addLengthIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Length.fromMeters(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addVolumeIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Volume.fromLiters(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addMassIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Mass.fromGrams(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addVelocityIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Velocity.fromMetersPerSecond(parcel.readDouble()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void addDurationIdsToAggregateResultMap(@NonNull List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> type : aggregationTypeList) {
            this.mIdToParcelDataReader.put(type.getAggregationTypeIdentifier(), parcel -> Duration.ofMillis(parcel.readLong()));
            this.populateIdDataAggregationType(type);
        }
    }

    private void populateIdDataAggregationType(AggregationType<?> aggregationType) {
        this.mIdDataAggregationTypeMap.put(aggregationType.getAggregationTypeIdentifier(), aggregationType);
        this.mDataAggregationTypeIdMap.put(aggregationType, aggregationType.getAggregationTypeIdentifier());
    }

    public static interface ParcelDataReader<T> {
        public T readData(Parcel var1);
    }
}

