/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.SleepSessionRecord;
import android.os.Parcel;
import com.android.internal.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SleepStageInternal {
    private long mStartTime;
    private long mEndTime;
    private int mStageType;

    @VisibleForTesting
    public static SleepStageInternal readFromParcel(Parcel parcel) {
        return new SleepStageInternal().setStartTime(parcel.readLong()).setEndTime(parcel.readLong()).setStageType(parcel.readInt());
    }

    @Nullable
    static List<SleepStageInternal> populateStagesFromParcel(Parcel parcel) {
        int size = parcel.readInt();
        if (size == 0) {
            return null;
        }
        ArrayList<SleepStageInternal> stages = new ArrayList<SleepStageInternal>(size);
        for (int i = 0; i < size; ++i) {
            stages.add(SleepStageInternal.readFromParcel(parcel));
        }
        return stages;
    }

    static List<SleepSessionRecord.Stage> getExternalStages(@NonNull List<SleepStageInternal> internalStages) {
        ArrayList<SleepSessionRecord.Stage> externalStages = new ArrayList<SleepSessionRecord.Stage>(internalStages.size());
        internalStages.forEach(stage -> externalStages.add(stage.toExternalRecord()));
        return externalStages;
    }

    static void writeStagesToParcel(@Nullable List<SleepStageInternal> stages, Parcel parcel) {
        if (stages == null) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(stages.size());
        stages.forEach(stage -> stage.writeToParcel(parcel));
    }

    @VisibleForTesting
    public void writeToParcel(Parcel parcel) {
        parcel.writeLong(this.mStartTime);
        parcel.writeLong(this.mEndTime);
        parcel.writeInt(this.mStageType);
    }

    @VisibleForTesting
    public SleepSessionRecord.Stage toExternalRecord() {
        return new SleepSessionRecord.Stage(Instant.ofEpochMilli(this.getStartTime()), Instant.ofEpochMilli(this.getEndTime()), this.getStageType());
    }

    public SleepStageInternal setStartTime(long startTime) {
        this.mStartTime = startTime;
        return this;
    }

    public SleepStageInternal setEndTime(long endTime) {
        this.mEndTime = endTime;
        return this;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public int getStageType() {
        return this.mStageType;
    }

    public SleepStageInternal setStageType(int stageType) {
        this.mStageType = stageType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SleepStageInternal)) {
            return false;
        }
        SleepStageInternal that = (SleepStageInternal)o;
        return this.mStartTime == that.mStartTime && this.mEndTime == that.mEndTime && this.mStageType == that.mStageType;
    }

    public int hashCode() {
        return Objects.hash(this.mStartTime, this.mEndTime, this.mStageType);
    }
}

