/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.Nullable;
import android.health.connect.datatypes.PlannedExerciseStep;
import android.health.connect.internal.datatypes.ExerciseCompletionGoalInternal;
import android.health.connect.internal.datatypes.ExercisePerformanceGoalInternal;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PlannedExerciseStepInternal {
    private int mExerciseType;
    private int mExerciseCategory;
    @Nullable
    private String mDescription;
    private ExerciseCompletionGoalInternal mCompletionGoal;
    private List<ExercisePerformanceGoalInternal> mPerformanceGoals = Collections.emptyList();

    public PlannedExerciseStepInternal(int exerciseType, int exerciseCategory, ExerciseCompletionGoalInternal completionGoal) {
        this.mExerciseType = exerciseType;
        this.mExerciseCategory = exerciseCategory;
        this.mCompletionGoal = completionGoal;
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    public void setExerciseType(int exerciseType) {
        this.mExerciseType = exerciseType;
    }

    public void setExerciseCategory(int exerciseCategory) {
        this.mExerciseCategory = exerciseCategory;
    }

    public void setDescription(@Nullable String description) {
        this.mDescription = description;
    }

    public void setCompletionGoal(ExerciseCompletionGoalInternal completionGoal) {
        this.mCompletionGoal = completionGoal;
    }

    public void setPerformanceGoals(List<ExercisePerformanceGoalInternal> performanceGoals) {
        this.mPerformanceGoals = performanceGoals;
    }

    public int getExerciseCategory() {
        return this.mExerciseCategory;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public ExerciseCompletionGoalInternal getCompletionGoal() {
        return this.mCompletionGoal;
    }

    public List<ExercisePerformanceGoalInternal> getPerformanceGoals() {
        return this.mPerformanceGoals;
    }

    public PlannedExerciseStep toExternalObject() {
        PlannedExerciseStep.Builder builder = new PlannedExerciseStep.Builder(this.mExerciseType, this.mExerciseCategory, this.mCompletionGoal.toExternalObject());
        if (this.mDescription != null) {
            builder.setDescription(this.mDescription);
        }
        for (ExercisePerformanceGoalInternal goal : this.mPerformanceGoals) {
            builder.addPerformanceGoal(goal.toExternalObject());
        }
        return builder.build();
    }

    public static void writeToParcel(List<PlannedExerciseStepInternal> steps, Parcel parcel) {
        parcel.writeInt(steps.size());
        for (PlannedExerciseStepInternal step : steps) {
            parcel.writeInt(step.getExerciseType());
            parcel.writeInt(step.getExerciseCategory());
            step.getCompletionGoal().writeToParcel(parcel);
            parcel.writeString(step.getDescription());
            ExercisePerformanceGoalInternal.writeToParcel(step.getPerformanceGoals(), parcel);
        }
    }

    public static List<PlannedExerciseStepInternal> readFromParcel(Parcel parcel) {
        ArrayList<PlannedExerciseStepInternal> result = new ArrayList<PlannedExerciseStepInternal>();
        int count = parcel.readInt();
        for (int i = 0; i < count; ++i) {
            PlannedExerciseStepInternal step = new PlannedExerciseStepInternal(parcel.readInt(), parcel.readInt(), ExerciseCompletionGoalInternal.readFromParcel(parcel));
            step.setDescription(parcel.readString());
            step.setPerformanceGoals(ExercisePerformanceGoalInternal.readFromParcel(parcel));
            result.add(step);
        }
        return result;
    }
}

