/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.NicotineIntakeRecord;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.internal.datatypes.IntervalRecordInternal;
import android.os.Parcel;

@Identifier(recordIdentifier=43)
@FlaggedApi(value="com.android.healthfitness.flags.smoking")
public class NicotineIntakeRecordInternal
extends IntervalRecordInternal<NicotineIntakeRecord> {
    private double mNicotineIntakeGrams = Double.MIN_VALUE;
    private int mQuantity;
    private int mNicotineIntakeType;

    public NicotineIntakeRecordInternal() {
    }

    public NicotineIntakeRecordInternal(Parcel parcel) {
        super(parcel);
        this.mNicotineIntakeGrams = parcel.readDouble();
        this.mQuantity = parcel.readInt();
        this.mNicotineIntakeType = parcel.readInt();
    }

    @Override
    void populateIntervalRecordTo(@NonNull Parcel parcel) {
        parcel.writeDouble(this.mNicotineIntakeGrams);
        parcel.writeInt(this.mQuantity);
        parcel.writeInt(this.mNicotineIntakeType);
    }

    @Override
    public NicotineIntakeRecord toExternalRecord() {
        NicotineIntakeRecord.Builder builder = new NicotineIntakeRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.mQuantity, this.mNicotineIntakeType);
        if (this.mNicotineIntakeGrams != Double.MIN_VALUE) {
            builder.setNicotineIntake(Mass.fromGrams(this.mNicotineIntakeGrams));
        }
        if (this.getStartZoneOffset() != null) {
            builder.setStartZoneOffset(this.getStartZoneOffset());
        }
        if (this.getEndZoneOffset() != null) {
            builder.setEndZoneOffset(this.getEndZoneOffset());
        }
        return builder.build(true);
    }

    public double getNicotineIntakeGrams() {
        return this.mNicotineIntakeGrams;
    }

    public int getQuantity() {
        return this.mQuantity;
    }

    public int getNicotineIntakeType() {
        return this.mNicotineIntakeType;
    }

    @NonNull
    public NicotineIntakeRecordInternal setQuantity(int quantity) {
        this.mQuantity = quantity;
        return this;
    }

    @NonNull
    public NicotineIntakeRecordInternal setNicotineIntakeGrams(double nicotineIntakeGrams) {
        this.mNicotineIntakeGrams = nicotineIntakeGrams;
        return this;
    }

    @NonNull
    public NicotineIntakeRecordInternal setNicotineIntakeType(int nicotineIntakeType) {
        this.mNicotineIntakeType = nicotineIntakeType;
        return this;
    }
}

