/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.HeartRateRecordInternal;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

@Identifier(recordIdentifier=11)
public class HeartRateRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Long> BPM_MAX = new AggregationType<Long>(0, 0, 11, Long.class);
    @NonNull
    public static final AggregationType<Long> BPM_MIN = new AggregationType<Long>(1, 1, 11, Long.class);
    @NonNull
    public static final AggregationType<Long> BPM_AVG = new AggregationType<Long>(7, 2, 11, Long.class);
    @NonNull
    public static final AggregationType<Long> HEART_MEASUREMENTS_COUNT = new AggregationType<Long>(64, 4, 11, Long.class);
    private final List<HeartRateSample> mSamples;

    private HeartRateRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull List<HeartRateSample> samples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(samples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, samples.stream().map(HeartRateSample::getTime).toList());
        }
        this.mSamples = samples;
    }

    @NonNull
    public List<HeartRateSample> getSamples() {
        return this.mSamples;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (super.equals(object) && object instanceof HeartRateRecord) {
            HeartRateRecord other = (HeartRateRecord)object;
            return this.getSamples().equals(other.getSamples());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public HeartRateRecordInternal toRecordInternal() {
        HashSet<HeartRateRecordInternal.HeartRateSample> samples = new HashSet<HeartRateRecordInternal.HeartRateSample>(this.getSamples().size());
        for (HeartRateSample heartRateSample : this.getSamples()) {
            samples.add(new HeartRateRecordInternal.HeartRateSample((int)heartRateSample.getBeatsPerMinute(), heartRateSample.getTime().toEpochMilli()));
        }
        HeartRateRecordInternal recordInternal = (HeartRateRecordInternal)new HeartRateRecordInternal(samples).setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        return recordInternal;
    }

    public static class HeartRateSample {
        private final long mBeatsPerMinute;
        private final Instant mTime;

        public HeartRateSample(long beatsPerMinute, @NonNull Instant time) {
            this(beatsPerMinute, time, false);
        }

        public HeartRateSample(long beatsPerMinute, @NonNull Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(beatsPerMinute, 1L, 300L, "beatsPerMinute");
            }
            this.mBeatsPerMinute = beatsPerMinute;
            this.mTime = time;
        }

        public long getBeatsPerMinute() {
            return this.mBeatsPerMinute;
        }

        @NonNull
        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof HeartRateSample) {
                HeartRateSample other = (HeartRateSample)object;
                return this.getBeatsPerMinute() == other.getBeatsPerMinute() && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getBeatsPerMinute(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<HeartRateSample> mSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull List<HeartRateSample> heartRateSamples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(heartRateSamples);
            if (heartRateSamples.isEmpty()) {
                throw new IllegalArgumentException("record samples should not be empty");
            }
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            if (Flags.sampleTimeOrdering()) {
                TreeSet<HeartRateSample> sampleSet = new TreeSet<HeartRateSample>(Comparator.comparing(HeartRateSample::getTime));
                sampleSet.addAll(heartRateSamples);
                this.mSamples = sampleSet.stream().toList();
            } else {
                this.mSamples = heartRateSamples;
            }
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public HeartRateRecord buildWithoutValidation() {
            return new HeartRateRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, true);
        }

        @NonNull
        public HeartRateRecord build() {
            return new HeartRateRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, false);
        }
    }
}

