/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.validation.ValidationUtils;
import com.android.healthfitness.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Device {
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int DEVICE_TYPE_WATCH = 1;
    public static final int DEVICE_TYPE_PHONE = 2;
    public static final int DEVICE_TYPE_SCALE = 3;
    public static final int DEVICE_TYPE_RING = 4;
    public static final int DEVICE_TYPE_HEAD_MOUNTED = 5;
    public static final int DEVICE_TYPE_FITNESS_BAND = 6;
    public static final int DEVICE_TYPE_CHEST_STRAP = 7;
    public static final int DEVICE_TYPE_SMART_DISPLAY = 8;
    @FlaggedApi(value="com.android.healthfitness.flags.new_device_types")
    public static final int DEVICE_TYPE_CONSUMER_MEDICAL_DEVICE = 9;
    @FlaggedApi(value="com.android.healthfitness.flags.new_device_types")
    public static final int DEVICE_TYPE_GLASSES = 10;
    @FlaggedApi(value="com.android.healthfitness.flags.new_device_types")
    public static final int DEVICE_TYPE_HEARABLE = 11;
    @FlaggedApi(value="com.android.healthfitness.flags.new_device_types")
    public static final int DEVICE_TYPE_FITNESS_MACHINE = 12;
    @FlaggedApi(value="com.android.healthfitness.flags.new_device_types")
    public static final int DEVICE_TYPE_FITNESS_EQUIPMENT = 13;
    @FlaggedApi(value="com.android.healthfitness.flags.new_device_types")
    public static final int DEVICE_TYPE_PORTABLE_COMPUTER = 14;
    @FlaggedApi(value="com.android.healthfitness.flags.new_device_types")
    public static final int DEVICE_TYPE_METER = 15;
    @Nullable
    private final String mManufacturer;
    @Nullable
    private final String mModel;
    private final int mType;
    public static final Set<Integer> VALID_TYPES = Stream.concat(Stream.of(0, 1, 2, 3, 4, 5, 6, 7, 8), Flags.newDeviceTypes() ? Stream.of(9, 10, 11, 12, 13, 14, 15) : Stream.empty()).collect(Collectors.toUnmodifiableSet());

    private Device(@Nullable String manufacturer, @Nullable String model, int type) {
        ValidationUtils.validateIntDefValue(type, VALID_TYPES, DeviceType.class.getSimpleName());
        this.mManufacturer = manufacturer;
        this.mModel = model;
        this.mType = type;
    }

    @Nullable
    public String getManufacturer() {
        return this.mManufacturer;
    }

    @Nullable
    public String getModel() {
        return this.mModel;
    }

    public int getType() {
        return this.mType;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Device) {
            Device other = (Device)object;
            return this.getType() == other.getType() && Objects.equals(this.getManufacturer(), other.getManufacturer()) && Objects.equals(this.getModel(), other.getModel());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getManufacturer(), this.getModel(), this.getType());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceType {
    }

    public static class Builder {
        @Nullable
        private String mManufacturer;
        @Nullable
        private String mModel;
        private int mType = 0;

        @NonNull
        public Builder setManufacturer(@Nullable String manufacturer) {
            this.mManufacturer = manufacturer;
            return this;
        }

        @NonNull
        public Builder setModel(@Nullable String model) {
            this.mModel = model;
            return this;
        }

        @NonNull
        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Device build() {
            return new Device(this.mManufacturer, this.mModel, this.mType);
        }
    }
}

