/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.validation.ValidationUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;

public class AggregationType<T> {
    public static final int MAX = 0;
    public static final int MIN = 1;
    public static final int AVG = 2;
    public static final int SUM = 3;
    public static final int COUNT = 4;
    private final int mId;
    private final int mType;
    private final int mApplicableRecordTypeId;
    private final Class<T> mClass;
    public static final Set<Integer> OPERATION_VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));

    AggregationType(int id2, int type, int applicableRecordTypeId, Class<T> templateClass) {
        ValidationUtils.validateIntDefValue(id2, AggregationTypeIdentifier.IDENTIFIER_VALID_TYPES, AggregationTypeIdentifier.class.getSimpleName());
        ValidationUtils.validateIntDefValue(type, OPERATION_VALID_TYPES, AggregateOperationType.class.getSimpleName());
        this.mId = id2;
        this.mType = type;
        this.mApplicableRecordTypeId = applicableRecordTypeId;
        this.mClass = templateClass;
    }

    public int getAggregationTypeIdentifier() {
        return this.mId;
    }

    public int getApplicableRecordTypeId() {
        return this.mApplicableRecordTypeId;
    }

    public int getAggregateOperationType() {
        return this.mType;
    }

    public Class<T> getAggregateResultClass() {
        return this.mClass;
    }

    public static @interface AggregationTypeIdentifier {
        public static final int HEART_RATE_RECORD_BPM_MAX = 0;
        public static final int HEART_RATE_RECORD_BPM_MIN = 1;
        public static final int STEPS_RECORD_COUNT_TOTAL = 2;
        public static final int ACTIVE_CALORIES_BURNED_RECORD_ACTIVE_CALORIES_TOTAL = 3;
        public static final int BMR_RECORD_BASAL_CALORIES_TOTAL = 4;
        public static final int DISTANCE_RECORD_DISTANCE_TOTAL = 5;
        public static final int ELEVATION_RECORD_ELEVATION_GAINED_TOTAL = 6;
        public static final int HEART_RATE_RECORD_BPM_AVG = 7;
        public static final int POWER_RECORD_POWER_MIN = 8;
        public static final int POWER_RECORD_POWER_MAX = 9;
        public static final int POWER_RECORD_POWER_AVG = 10;
        public static final int HYDRATION_RECORD_VOLUME_TOTAL = 11;
        public static final int FLOORS_CLIMBED_RECORD_FLOORS_CLIMBED_TOTAL = 12;
        public static final int NUTRITION_RECORD_BIOTIN_TOTAL = 13;
        public static final int NUTRITION_RECORD_CAFFEINE_TOTAL = 14;
        public static final int NUTRITION_RECORD_CALCIUM_TOTAL = 15;
        public static final int NUTRITION_RECORD_CHLORIDE_TOTAL = 16;
        public static final int NUTRITION_RECORD_CHOLESTEROL_TOTAL = 17;
        public static final int NUTRITION_RECORD_CHROMIUM_TOTAL = 18;
        public static final int NUTRITION_RECORD_COPPER_TOTAL = 19;
        public static final int NUTRITION_RECORD_DIETARY_FIBER_TOTAL = 20;
        public static final int NUTRITION_RECORD_ENERGY_TOTAL = 21;
        public static final int NUTRITION_RECORD_ENERGY_FROM_FAT_TOTAL = 22;
        public static final int NUTRITION_RECORD_FOLATE_TOTAL = 23;
        public static final int NUTRITION_RECORD_FOLIC_ACID_TOTAL = 24;
        public static final int NUTRITION_RECORD_IODINE_TOTAL = 25;
        public static final int NUTRITION_RECORD_IRON_TOTAL = 26;
        public static final int NUTRITION_RECORD_MAGNESIUM_TOTAL = 27;
        public static final int NUTRITION_RECORD_MANGANESE_TOTAL = 28;
        public static final int NUTRITION_RECORD_MOLYBDENUM_TOTAL = 29;
        public static final int NUTRITION_RECORD_MONOUNSATURATED_FAT_TOTAL = 30;
        public static final int NUTRITION_RECORD_NIACIN_TOTAL = 31;
        public static final int NUTRITION_RECORD_PANTOTHENIC_ACID_TOTAL = 32;
        public static final int NUTRITION_RECORD_PHOSPHORUS_TOTAL = 33;
        public static final int NUTRITION_RECORD_POLYUNSATURATED_FAT_TOTAL = 34;
        public static final int NUTRITION_RECORD_POTASSIUM_TOTAL = 35;
        public static final int NUTRITION_RECORD_PROTEIN_TOTAL = 36;
        public static final int NUTRITION_RECORD_RIBOFLAVIN_TOTAL = 37;
        public static final int NUTRITION_RECORD_SATURATED_FAT_TOTAL = 38;
        public static final int NUTRITION_RECORD_SELENIUM_TOTAL = 39;
        public static final int NUTRITION_RECORD_SODIUM_TOTAL = 40;
        public static final int NUTRITION_RECORD_SUGAR_TOTAL = 41;
        public static final int NUTRITION_RECORD_THIAMIN_TOTAL = 42;
        public static final int NUTRITION_RECORD_TOTAL_CARBOHYDRATE_TOTAL = 43;
        public static final int NUTRITION_RECORD_TOTAL_FAT_TOTAL = 44;
        public static final int NUTRITION_RECORD_UNSATURATED_FAT_TOTAL = 45;
        public static final int NUTRITION_RECORD_VITAMIN_A_TOTAL = 46;
        public static final int NUTRITION_RECORD_VITAMIN_B12_TOTAL = 47;
        public static final int NUTRITION_RECORD_VITAMIN_B6_TOTAL = 48;
        public static final int NUTRITION_RECORD_VITAMIN_C_TOTAL = 49;
        public static final int NUTRITION_RECORD_VITAMIN_D_TOTAL = 50;
        public static final int NUTRITION_RECORD_VITAMIN_E_TOTAL = 51;
        public static final int NUTRITION_RECORD_VITAMIN_K_TOTAL = 52;
        public static final int NUTRITION_RECORD_ZINC_TOTAL = 53;
        public static final int HEIGHT_RECORD_HEIGHT_AVG = 54;
        public static final int HEIGHT_RECORD_HEIGHT_MAX = 55;
        public static final int HEIGHT_RECORD_HEIGHT_MIN = 56;
        public static final int RESTING_HEART_RATE_RECORD_BPM_MAX = 57;
        public static final int RESTING_HEART_RATE_RECORD_BPM_MIN = 58;
        public static final int TOTAL_CALORIES_BURNED_RECORD_ENERGY_TOTAL = 59;
        public static final int WEIGHT_RECORD_WEIGHT_AVG = 60;
        public static final int WEIGHT_RECORD_WEIGHT_MAX = 61;
        public static final int WEIGHT_RECORD_WEIGHT_MIN = 62;
        public static final int WHEEL_CHAIR_PUSHES_RECORD_COUNT_TOTAL = 63;
        public static final int HEART_RATE_RECORD_MEASUREMENTS_COUNT = 64;
        public static final int RESTING_HEART_RATE_RECORD_BPM_AVG = 65;
        public static final int SLEEP_SESSION_DURATION_TOTAL = 66;
        public static final int EXERCISE_SESSION_DURATION_TOTAL = 67;
        public static final int BLOOD_PRESSURE_RECORD_DIASTOLIC_AVG = 68;
        public static final int BLOOD_PRESSURE_RECORD_DIASTOLIC_MAX = 69;
        public static final int BLOOD_PRESSURE_RECORD_DIASTOLIC_MIN = 70;
        public static final int BLOOD_PRESSURE_RECORD_SYSTOLIC_AVG = 71;
        public static final int BLOOD_PRESSURE_RECORD_SYSTOLIC_MAX = 72;
        public static final int BLOOD_PRESSURE_RECORD_SYSTOLIC_MIN = 73;
        public static final int NUTRITION_RECORD_TRANS_FAT_TOTAL = 74;
        public static final int CYCLING_PEDALING_CADENCE_RECORD_RPM_AVG = 75;
        public static final int CYCLING_PEDALING_CADENCE_RECORD_RPM_MIN = 76;
        public static final int CYCLING_PEDALING_CADENCE_RECORD_RPM_MAX = 77;
        public static final int SPEED_RECORD_SPEED_AVG = 78;
        public static final int SPEED_RECORD_SPEED_MIN = 79;
        public static final int SPEED_RECORD_SPEED_MAX = 80;
        public static final int STEPS_CADENCE_RECORD_RATE_AVG = 81;
        public static final int STEPS_CADENCE_RECORD_RATE_MIN = 82;
        public static final int STEPS_CADENCE_RECORD_RATE_MAX = 83;
        public static final int SKIN_TEMPERATURE_RECORD_DELTA_AVG = 84;
        public static final int SKIN_TEMPERATURE_RECORD_DELTA_MIN = 85;
        public static final int SKIN_TEMPERATURE_RECORD_DELTA_MAX = 86;
        public static final int MINDFULNESS_SESSION_DURATION_TOTAL = 87;
        public static final int ACTIVITY_INTENSITY_MODERATE_DURATION_TOTAL = 88;
        public static final int ACTIVITY_INTENSITY_VIGOROUS_DURATION_TOTAL = 89;
        public static final int ACTIVITY_INTENSITY_DURATION_TOTAL = 90;
        public static final int ACTIVITY_INTENSITY_MINUTES_TOTAL = 91;
        public static final Set<Integer> IDENTIFIER_VALID_TYPES = Set.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 75, 76, 77, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 74, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Id {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AggregateOperationType {
    }
}

