/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ActiveCaloriesBurnedRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=2)
public class ActiveCaloriesBurnedRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Energy> ACTIVE_CALORIES_TOTAL = new AggregationType<Energy>(3, 3, 2, Energy.class);
    private final Energy mEnergy;

    private ActiveCaloriesBurnedRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull Energy energy, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(energy);
        if (!skipValidation) {
            ValidationUtils.requireInRange(energy.getInCalories(), 0.0, 1.0E9, "energy");
        }
        this.mEnergy = energy;
    }

    @NonNull
    public Energy getEnergy() {
        return this.mEnergy;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ActiveCaloriesBurnedRecord)) {
            return false;
        }
        ActiveCaloriesBurnedRecord that = (ActiveCaloriesBurnedRecord)o;
        return this.getEnergy().equals(that.getEnergy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEnergy());
    }

    public ActiveCaloriesBurnedRecordInternal toRecordInternal() {
        ActiveCaloriesBurnedRecordInternal recordInternal = (ActiveCaloriesBurnedRecordInternal)new ActiveCaloriesBurnedRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        recordInternal.setEnergy(this.mEnergy.getInCalories());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private final Energy mEnergy;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull Energy energy) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(energy);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mEnergy = energy;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public ActiveCaloriesBurnedRecord buildWithoutValidation() {
            return new ActiveCaloriesBurnedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mEnergy, true);
        }

        @NonNull
        public ActiveCaloriesBurnedRecord build() {
            return new ActiveCaloriesBurnedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mEnergy, false);
        }
    }
}

