/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.LocalTimeRangeFilter;
import android.health.connect.TimeInstantRangeFilter;
import android.health.connect.TimeRangeFilter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class TimeRangeFilterHelper {
    private static final ZoneOffset LOCAL_TIME_ZERO_OFFSET = ZoneOffset.UTC;

    public static boolean isLocalTimeFilter(@NonNull TimeRangeFilter timeRangeFilter) {
        return timeRangeFilter instanceof LocalTimeRangeFilter;
    }

    public static long getFilterStartTimeMillis(@NonNull TimeRangeFilter timeRangeFilter) {
        if (timeRangeFilter instanceof LocalTimeRangeFilter) {
            LocalTimeRangeFilter localTimeRangeFilter = (LocalTimeRangeFilter)timeRangeFilter;
            LocalDateTime startTime = localTimeRangeFilter.getStartTime();
            startTime = startTime != null ? startTime : LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.MIN);
            return TimeRangeFilterHelper.getMillisOfLocalTime(startTime);
        }
        if (timeRangeFilter instanceof TimeInstantRangeFilter) {
            TimeInstantRangeFilter timeInstantRangeFilter = (TimeInstantRangeFilter)timeRangeFilter;
            Instant startTime = timeInstantRangeFilter.getStartTime();
            startTime = startTime != null ? startTime : Instant.EPOCH;
            return startTime.toEpochMilli();
        }
        throw new IllegalArgumentException("Invalid time filter object. Object should be either TimeInstantRangeFilter or LocalTimeRangeFilter.");
    }

    public static long getFilterEndTimeMillis(@NonNull TimeRangeFilter timeRangeFilter) {
        if (timeRangeFilter instanceof LocalTimeRangeFilter) {
            LocalTimeRangeFilter localTimeRangeFilter = (LocalTimeRangeFilter)timeRangeFilter;
            LocalDateTime endTime = localTimeRangeFilter.getEndTime();
            endTime = endTime != null ? endTime : LocalDateTime.ofInstant(Instant.now().plus(1L, ChronoUnit.DAYS), ZoneOffset.MAX);
            return TimeRangeFilterHelper.getMillisOfLocalTime(endTime);
        }
        if (timeRangeFilter instanceof TimeInstantRangeFilter) {
            TimeInstantRangeFilter timeInstantRangeFilter = (TimeInstantRangeFilter)timeRangeFilter;
            Instant endTime = timeInstantRangeFilter.getEndTime();
            endTime = endTime != null ? endTime : Instant.now().plus(1L, ChronoUnit.DAYS);
            return endTime.toEpochMilli();
        }
        throw new IllegalArgumentException("Invalid time filter object. Object should be either TimeInstantRangeFilter or LocalTimeRangeFilter.");
    }

    public static LocalDateTime getLocalTimeFromMillis(Long localDateTimeMillis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(localDateTimeMillis), LOCAL_TIME_ZERO_OFFSET);
    }

    public static long getMillisOfLocalTime(LocalDateTime time) {
        return time.toInstant(LOCAL_TIME_ZERO_OFFSET).toEpochMilli();
    }

    public static Instant getInstantFromLocalTime(@NonNull LocalDateTime time, @Nullable ZoneOffset zoneOffset) {
        return zoneOffset != null ? time.toInstant(zoneOffset) : time.toInstant(ZoneOffset.systemDefault().getRules().getOffset(time));
    }
}

