/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.TimeRangeFilter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class TimeInstantRangeFilter
implements TimeRangeFilter {
    private final Instant mStartTime;
    private final Instant mEndTime;

    private TimeInstantRangeFilter(@Nullable Instant startTime, @Nullable Instant endTime) {
        if (startTime == null && endTime == null) {
            throw new IllegalArgumentException("Both start time and end time cannot be null.");
        }
        if (startTime != null && endTime != null && !endTime.isAfter(startTime)) {
            throw new IllegalArgumentException("end time needs to be after start time.");
        }
        this.mStartTime = startTime != null ? startTime : Instant.EPOCH;
        this.mEndTime = endTime != null ? endTime : Instant.now().plus(1L, ChronoUnit.DAYS);
    }

    @Nullable
    public Instant getStartTime() {
        return this.mStartTime;
    }

    @Nullable
    public Instant getEndTime() {
        return this.mEndTime;
    }

    @NonNull
    public boolean isBounded() {
        return this.mStartTime != null && this.mEndTime != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!((Object)this.mStartTime).equals(((TimeInstantRangeFilter)o).mStartTime)) {
            return false;
        }
        return ((Object)this.mEndTime).equals(((TimeInstantRangeFilter)o).mEndTime);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.mStartTime == null ? 0 : ((Object)this.mStartTime).hashCode());
        result = 31 * result + (this.mEndTime == null ? 0 : ((Object)this.mEndTime).hashCode());
        return result;
    }

    public static class Builder {
        @Nullable
        private Instant mStartTime;
        @Nullable
        private Instant mEndTime;

        @NonNull
        public Builder setStartTime(@Nullable Instant startTime) {
            this.mStartTime = startTime;
            return this;
        }

        @NonNull
        public Builder setEndTime(@Nullable Instant endTime) {
            this.mEndTime = endTime;
            return this;
        }

        @NonNull
        public TimeInstantRangeFilter build() {
            return new TimeInstantRangeFilter(this.mStartTime, this.mEndTime);
        }
    }
}

