/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.internal.ParcelUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class ReadMedicalResourcesResponse
implements Parcelable {
    @NonNull
    private final List<MedicalResource> mMedicalResources;
    @Nullable
    private final String mNextPageToken;
    private final int mRemainingCount;
    @NonNull
    public static final Parcelable.Creator<ReadMedicalResourcesResponse> CREATOR = new Parcelable.Creator<ReadMedicalResourcesResponse>(){

        @Override
        public ReadMedicalResourcesResponse createFromParcel(Parcel in) {
            return new ReadMedicalResourcesResponse(in);
        }

        public ReadMedicalResourcesResponse[] newArray(int size) {
            return new ReadMedicalResourcesResponse[size];
        }
    };

    public ReadMedicalResourcesResponse(@NonNull List<MedicalResource> medicalResources, @Nullable String nextPageToken, int remainingCount) {
        Objects.requireNonNull(medicalResources);
        if (nextPageToken == null && remainingCount > 0) {
            throw new IllegalArgumentException(String.format("Remaining count must be 0 to have a null next page token, but was %d", remainingCount));
        }
        if (nextPageToken != null && remainingCount == 0) {
            throw new IllegalArgumentException("Next page token provided with no remaining data");
        }
        this.mMedicalResources = medicalResources;
        this.mNextPageToken = nextPageToken;
        this.mRemainingCount = remainingCount;
    }

    private ReadMedicalResourcesResponse(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        in = ParcelUtils.getParcelForSharedMemoryIfRequired(in);
        this.mMedicalResources = new ArrayList<MedicalResource>();
        in.readParcelableList(this.mMedicalResources, MedicalResource.class.getClassLoader(), MedicalResource.class);
        this.mNextPageToken = in.readString();
        this.mRemainingCount = in.readInt();
    }

    @NonNull
    public List<MedicalResource> getMedicalResources() {
        return this.mMedicalResources;
    }

    @Nullable
    public String getNextPageToken() {
        return this.mNextPageToken;
    }

    public int getRemainingCount() {
        return this.mRemainingCount;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        ParcelUtils.putToRequiredMemory(dest, flags, this::writeToParcelInternal);
    }

    private void writeToParcelInternal(@NonNull Parcel dest) {
        Objects.requireNonNull(dest);
        dest.writeParcelableList(this.mMedicalResources, 0);
        dest.writeString(this.mNextPageToken);
        dest.writeInt(this.mRemainingCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadMedicalResourcesResponse)) {
            return false;
        }
        ReadMedicalResourcesResponse that = (ReadMedicalResourcesResponse)o;
        return this.getMedicalResources().equals(that.getMedicalResources()) && Objects.equals(this.getNextPageToken(), that.getNextPageToken()) && this.mRemainingCount == that.getRemainingCount();
    }

    public int hashCode() {
        return Objects.hash(this.getMedicalResources(), this.getNextPageToken(), this.mRemainingCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("medicalResources=").append(this.getMedicalResources());
        sb.append(",nextPageToken=").append(this.getNextPageToken());
        sb.append("}");
        return sb.toString();
    }
}

