/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.content.Context;
import android.content.pm.PackageManager;
import android.health.connect.HealthConnectManager;
import android.health.connect.aidl.IHealthConnectService;
import com.android.healthfitness.flags.Flags;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class HealthServicesInitializer {
    private HealthServicesInitializer() {
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("healthconnect", HealthConnectManager.class, (context, serviceBinder) -> {
            if (!HealthServicesInitializer.shouldReturnHealthConnectManager(context)) {
                return null;
            }
            IHealthConnectService service = IHealthConnectService.Stub.asInterface(serviceBinder);
            return new HealthConnectManager(context, service);
        });
    }

    private static boolean shouldReturnHealthConnectManager(Context context) {
        PackageManager pm = context.getPackageManager();
        if (pm.hasSystemFeature("android.hardware.type.embedded") || pm.hasSystemFeature("android.software.leanback") || pm.hasSystemFeature("android.hardware.type.automotive")) {
            return false;
        }
        if (pm.hasSystemFeature("android.hardware.type.watch")) {
            return Flags.replaceBodySensorPermissionEnabled() && context.checkSelfPermission("android.permission.MANAGE_HEALTH_PERMISSIONS") == 0;
        }
        return true;
    }
}

