/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PermissionInfo;
import android.health.connect.HealthConnectManager;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.healthfitness.flags.Flags;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HealthPermissions {
    @SystemApi
    public static final String MANAGE_HEALTH_PERMISSIONS = "android.permission.MANAGE_HEALTH_PERMISSIONS";
    @SystemApi
    public static final String MANAGE_HEALTH_DATA_PERMISSION = "android.permission.MANAGE_HEALTH_DATA";
    @FlaggedApi(value="com.android.healthfitness.flags.launch_onboarding_activity")
    public static final String START_ONBOARDING = "android.permission.health.START_ONBOARDING";
    @FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore_intent_api")
    public static final String START_BACKUP_RESTORE_SETTINGS_PERMISSION = "android.permission.health.START_BACKUP_RESTORE_SETTINGS";
    @SystemApi
    public static final String HEALTH_PERMISSION_GROUP = "android.permission-group.HEALTH";
    @FlaggedApi(value="com.android.healthconnect.flags.background_read")
    public static final String READ_HEALTH_DATA_IN_BACKGROUND = "android.permission.health.READ_HEALTH_DATA_IN_BACKGROUND";
    @FlaggedApi(value="com.android.healthconnect.flags.history_read")
    public static final String READ_HEALTH_DATA_HISTORY = "android.permission.health.READ_HEALTH_DATA_HISTORY";
    public static final String READ_ACTIVE_CALORIES_BURNED = "android.permission.health.READ_ACTIVE_CALORIES_BURNED";
    @FlaggedApi(value="com.android.healthfitness.flags.activity_intensity")
    public static final String READ_ACTIVITY_INTENSITY = "android.permission.health.READ_ACTIVITY_INTENSITY";
    public static final String READ_DISTANCE = "android.permission.health.READ_DISTANCE";
    public static final String READ_ELEVATION_GAINED = "android.permission.health.READ_ELEVATION_GAINED";
    public static final String READ_EXERCISE = "android.permission.health.READ_EXERCISE";
    public static final String READ_EXERCISE_ROUTE = "android.permission.health.READ_EXERCISE_ROUTE";
    @FlaggedApi(value="com.android.healthconnect.flags.read_exercise_routes_all_enabled")
    public static final String READ_EXERCISE_ROUTES = "android.permission.health.READ_EXERCISE_ROUTES";
    public static final String READ_FLOORS_CLIMBED = "android.permission.health.READ_FLOORS_CLIMBED";
    public static final String READ_STEPS = "android.permission.health.READ_STEPS";
    public static final String READ_TOTAL_CALORIES_BURNED = "android.permission.health.READ_TOTAL_CALORIES_BURNED";
    public static final String READ_VO2_MAX = "android.permission.health.READ_VO2_MAX";
    public static final String READ_WHEELCHAIR_PUSHES = "android.permission.health.READ_WHEELCHAIR_PUSHES";
    public static final String READ_POWER = "android.permission.health.READ_POWER";
    public static final String READ_SPEED = "android.permission.health.READ_SPEED";
    public static final String READ_BASAL_METABOLIC_RATE = "android.permission.health.READ_BASAL_METABOLIC_RATE";
    public static final String READ_BODY_FAT = "android.permission.health.READ_BODY_FAT";
    public static final String READ_BODY_WATER_MASS = "android.permission.health.READ_BODY_WATER_MASS";
    public static final String READ_BONE_MASS = "android.permission.health.READ_BONE_MASS";
    public static final String READ_HEIGHT = "android.permission.health.READ_HEIGHT";
    public static final String READ_LEAN_BODY_MASS = "android.permission.health.READ_LEAN_BODY_MASS";
    public static final String READ_WEIGHT = "android.permission.health.READ_WEIGHT";
    public static final String READ_CERVICAL_MUCUS = "android.permission.health.READ_CERVICAL_MUCUS";
    public static final String READ_MENSTRUATION = "android.permission.health.READ_MENSTRUATION";
    public static final String READ_INTERMENSTRUAL_BLEEDING = "android.permission.health.READ_INTERMENSTRUAL_BLEEDING";
    public static final String READ_OVULATION_TEST = "android.permission.health.READ_OVULATION_TEST";
    public static final String READ_SEXUAL_ACTIVITY = "android.permission.health.READ_SEXUAL_ACTIVITY";
    public static final String READ_HYDRATION = "android.permission.health.READ_HYDRATION";
    public static final String READ_NUTRITION = "android.permission.health.READ_NUTRITION";
    public static final String READ_SLEEP = "android.permission.health.READ_SLEEP";
    public static final String READ_BASAL_BODY_TEMPERATURE = "android.permission.health.READ_BASAL_BODY_TEMPERATURE";
    public static final String READ_BLOOD_GLUCOSE = "android.permission.health.READ_BLOOD_GLUCOSE";
    public static final String READ_BLOOD_PRESSURE = "android.permission.health.READ_BLOOD_PRESSURE";
    public static final String READ_BODY_TEMPERATURE = "android.permission.health.READ_BODY_TEMPERATURE";
    public static final String READ_HEART_RATE = "android.permission.health.READ_HEART_RATE";
    public static final String READ_HEART_RATE_VARIABILITY = "android.permission.health.READ_HEART_RATE_VARIABILITY";
    public static final String READ_OXYGEN_SATURATION = "android.permission.health.READ_OXYGEN_SATURATION";
    public static final String READ_RESPIRATORY_RATE = "android.permission.health.READ_RESPIRATORY_RATE";
    public static final String READ_RESTING_HEART_RATE = "android.permission.health.READ_RESTING_HEART_RATE";
    @FlaggedApi(value="com.android.healthconnect.flags.skin_temperature")
    public static final String READ_SKIN_TEMPERATURE = "android.permission.health.READ_SKIN_TEMPERATURE";
    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static final String READ_PLANNED_EXERCISE = "android.permission.health.READ_PLANNED_EXERCISE";
    @FlaggedApi(value="com.android.healthfitness.flags.mindfulness")
    public static final String READ_MINDFULNESS = "android.permission.health.READ_MINDFULNESS";
    @FlaggedApi(value="com.android.healthfitness.flags.smoking")
    public static final String READ_NICOTINE_INTAKE = "android.permission.health.READ_NICOTINE_INTAKE";
    public static final String WRITE_ACTIVE_CALORIES_BURNED = "android.permission.health.WRITE_ACTIVE_CALORIES_BURNED";
    @FlaggedApi(value="com.android.healthfitness.flags.activity_intensity")
    public static final String WRITE_ACTIVITY_INTENSITY = "android.permission.health.WRITE_ACTIVITY_INTENSITY";
    public static final String WRITE_DISTANCE = "android.permission.health.WRITE_DISTANCE";
    public static final String WRITE_ELEVATION_GAINED = "android.permission.health.WRITE_ELEVATION_GAINED";
    public static final String WRITE_EXERCISE = "android.permission.health.WRITE_EXERCISE";
    public static final String WRITE_EXERCISE_ROUTE = "android.permission.health.WRITE_EXERCISE_ROUTE";
    public static final String WRITE_FLOORS_CLIMBED = "android.permission.health.WRITE_FLOORS_CLIMBED";
    public static final String WRITE_STEPS = "android.permission.health.WRITE_STEPS";
    public static final String WRITE_TOTAL_CALORIES_BURNED = "android.permission.health.WRITE_TOTAL_CALORIES_BURNED";
    public static final String WRITE_VO2_MAX = "android.permission.health.WRITE_VO2_MAX";
    public static final String WRITE_WHEELCHAIR_PUSHES = "android.permission.health.WRITE_WHEELCHAIR_PUSHES";
    public static final String WRITE_POWER = "android.permission.health.WRITE_POWER";
    public static final String WRITE_SPEED = "android.permission.health.WRITE_SPEED";
    public static final String WRITE_BASAL_METABOLIC_RATE = "android.permission.health.WRITE_BASAL_METABOLIC_RATE";
    public static final String WRITE_BODY_FAT = "android.permission.health.WRITE_BODY_FAT";
    public static final String WRITE_BODY_WATER_MASS = "android.permission.health.WRITE_BODY_WATER_MASS";
    public static final String WRITE_BONE_MASS = "android.permission.health.WRITE_BONE_MASS";
    public static final String WRITE_HEIGHT = "android.permission.health.WRITE_HEIGHT";
    public static final String WRITE_LEAN_BODY_MASS = "android.permission.health.WRITE_LEAN_BODY_MASS";
    public static final String WRITE_WEIGHT = "android.permission.health.WRITE_WEIGHT";
    public static final String WRITE_CERVICAL_MUCUS = "android.permission.health.WRITE_CERVICAL_MUCUS";
    public static final String WRITE_MENSTRUATION = "android.permission.health.WRITE_MENSTRUATION";
    public static final String WRITE_INTERMENSTRUAL_BLEEDING = "android.permission.health.WRITE_INTERMENSTRUAL_BLEEDING";
    public static final String WRITE_OVULATION_TEST = "android.permission.health.WRITE_OVULATION_TEST";
    public static final String WRITE_SEXUAL_ACTIVITY = "android.permission.health.WRITE_SEXUAL_ACTIVITY";
    public static final String WRITE_HYDRATION = "android.permission.health.WRITE_HYDRATION";
    public static final String WRITE_NUTRITION = "android.permission.health.WRITE_NUTRITION";
    public static final String WRITE_SLEEP = "android.permission.health.WRITE_SLEEP";
    public static final String WRITE_BASAL_BODY_TEMPERATURE = "android.permission.health.WRITE_BASAL_BODY_TEMPERATURE";
    public static final String WRITE_BLOOD_GLUCOSE = "android.permission.health.WRITE_BLOOD_GLUCOSE";
    public static final String WRITE_BLOOD_PRESSURE = "android.permission.health.WRITE_BLOOD_PRESSURE";
    public static final String WRITE_BODY_TEMPERATURE = "android.permission.health.WRITE_BODY_TEMPERATURE";
    public static final String WRITE_HEART_RATE = "android.permission.health.WRITE_HEART_RATE";
    public static final String WRITE_HEART_RATE_VARIABILITY = "android.permission.health.WRITE_HEART_RATE_VARIABILITY";
    public static final String WRITE_OXYGEN_SATURATION = "android.permission.health.WRITE_OXYGEN_SATURATION";
    public static final String WRITE_RESPIRATORY_RATE = "android.permission.health.WRITE_RESPIRATORY_RATE";
    public static final String WRITE_RESTING_HEART_RATE = "android.permission.health.WRITE_RESTING_HEART_RATE";
    @FlaggedApi(value="com.android.healthconnect.flags.skin_temperature")
    public static final String WRITE_SKIN_TEMPERATURE = "android.permission.health.WRITE_SKIN_TEMPERATURE";
    public static final String WRITE_PLANNED_EXERCISE = "android.permission.health.WRITE_PLANNED_EXERCISE";
    @FlaggedApi(value="com.android.healthfitness.flags.mindfulness")
    public static final String WRITE_MINDFULNESS = "android.permission.health.WRITE_MINDFULNESS";
    @FlaggedApi(value="com.android.healthfitness.flags.smoking")
    public static final String WRITE_NICOTINE_INTAKE = "android.permission.health.WRITE_NICOTINE_INTAKE";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_ALLERGIES_INTOLERANCES = "android.permission.health.READ_MEDICAL_DATA_ALLERGIES_INTOLERANCES";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_CONDITIONS = "android.permission.health.READ_MEDICAL_DATA_CONDITIONS";
    public static final String READ_MEDICAL_DATA_DEVICES = "android.permission.health.READ_MEDICAL_DATA_DEVICES";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_LABORATORY_RESULTS = "android.permission.health.READ_MEDICAL_DATA_LABORATORY_RESULTS";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_MEDICATIONS = "android.permission.health.READ_MEDICAL_DATA_MEDICATIONS";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_PERSONAL_DETAILS = "android.permission.health.READ_MEDICAL_DATA_PERSONAL_DETAILS";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_PRACTITIONER_DETAILS = "android.permission.health.READ_MEDICAL_DATA_PRACTITIONER_DETAILS";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_PREGNANCY = "android.permission.health.READ_MEDICAL_DATA_PREGNANCY";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_PROCEDURES = "android.permission.health.READ_MEDICAL_DATA_PROCEDURES";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_SOCIAL_HISTORY = "android.permission.health.READ_MEDICAL_DATA_SOCIAL_HISTORY";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_VACCINES = "android.permission.health.READ_MEDICAL_DATA_VACCINES";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_VISITS = "android.permission.health.READ_MEDICAL_DATA_VISITS";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String READ_MEDICAL_DATA_VITAL_SIGNS = "android.permission.health.READ_MEDICAL_DATA_VITAL_SIGNS";
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public static final String WRITE_MEDICAL_DATA = "android.permission.health.WRITE_MEDICAL_DATA";
    private static final Set<String> sWritePermissionsSet = new ArraySet<String>(Set.of("android.permission.health.WRITE_ACTIVE_CALORIES_BURNED", "android.permission.health.WRITE_DISTANCE", "android.permission.health.WRITE_ELEVATION_GAINED", "android.permission.health.WRITE_EXERCISE", "android.permission.health.WRITE_FLOORS_CLIMBED", "android.permission.health.WRITE_STEPS", "android.permission.health.WRITE_TOTAL_CALORIES_BURNED", "android.permission.health.WRITE_VO2_MAX", "android.permission.health.WRITE_WHEELCHAIR_PUSHES", "android.permission.health.WRITE_POWER", "android.permission.health.WRITE_SPEED", "android.permission.health.WRITE_BASAL_METABOLIC_RATE", "android.permission.health.WRITE_BODY_FAT", "android.permission.health.WRITE_BODY_WATER_MASS", "android.permission.health.WRITE_BONE_MASS", "android.permission.health.WRITE_HEIGHT", "android.permission.health.WRITE_LEAN_BODY_MASS", "android.permission.health.WRITE_WEIGHT", "android.permission.health.WRITE_CERVICAL_MUCUS", "android.permission.health.WRITE_MENSTRUATION", "android.permission.health.WRITE_INTERMENSTRUAL_BLEEDING", "android.permission.health.WRITE_OVULATION_TEST", "android.permission.health.WRITE_SEXUAL_ACTIVITY", "android.permission.health.WRITE_HYDRATION", "android.permission.health.WRITE_NUTRITION", "android.permission.health.WRITE_SLEEP", "android.permission.health.WRITE_BASAL_BODY_TEMPERATURE", "android.permission.health.WRITE_BLOOD_GLUCOSE", "android.permission.health.WRITE_BLOOD_PRESSURE", "android.permission.health.WRITE_BODY_TEMPERATURE", "android.permission.health.WRITE_HEART_RATE", "android.permission.health.WRITE_HEART_RATE_VARIABILITY", "android.permission.health.WRITE_OXYGEN_SATURATION", "android.permission.health.WRITE_RESPIRATORY_RATE", "android.permission.health.WRITE_RESTING_HEART_RATE", "android.permission.health.WRITE_SKIN_TEMPERATURE", "android.permission.health.WRITE_PLANNED_EXERCISE", "android.permission.health.WRITE_MINDFULNESS"));
    private static final Map<String, Integer> sWriteHealthPermissionToHealthDataCategoryMap = new ArrayMap<String, Integer>();
    private static final Map<Integer, String> sHealthCategoryToReadPermissionMap = new ArrayMap<Integer, String>();
    private static final Map<Integer, String> sHealthCategoryToWritePermissionMap = new ArrayMap<Integer, String>();
    private static final Map<Integer, String[]> sDataCategoryToWritePermissionsMap = new ArrayMap<Integer, String[]>();

    private HealthPermissions() {
    }

    @Deprecated
    public static int getHealthDataCategoryForWritePermission(@Nullable String permissionName) {
        if (sWriteHealthPermissionToHealthDataCategoryMap.isEmpty()) {
            HealthPermissions.populateWriteHealthPermissionToHealthDataCategoryMap();
        }
        return sWriteHealthPermissionToHealthDataCategoryMap.getOrDefault(permissionName, -1);
    }

    public static Set<String> getAllMedicalPermissions() {
        ArraySet<String> permissions = new ArraySet<String>();
        permissions.add(WRITE_MEDICAL_DATA);
        permissions.add(READ_MEDICAL_DATA_ALLERGIES_INTOLERANCES);
        if (Flags.deviceResource()) {
            permissions.add(READ_MEDICAL_DATA_DEVICES);
        }
        permissions.add(READ_MEDICAL_DATA_CONDITIONS);
        permissions.add(READ_MEDICAL_DATA_LABORATORY_RESULTS);
        permissions.add(READ_MEDICAL_DATA_MEDICATIONS);
        permissions.add(READ_MEDICAL_DATA_PERSONAL_DETAILS);
        permissions.add(READ_MEDICAL_DATA_PRACTITIONER_DETAILS);
        permissions.add(READ_MEDICAL_DATA_PREGNANCY);
        permissions.add(READ_MEDICAL_DATA_PROCEDURES);
        permissions.add(READ_MEDICAL_DATA_SOCIAL_HISTORY);
        permissions.add(READ_MEDICAL_DATA_VACCINES);
        permissions.add(READ_MEDICAL_DATA_VISITS);
        permissions.add(READ_MEDICAL_DATA_VITAL_SIGNS);
        return permissions;
    }

    @NonNull
    public static Set<Integer> getDataCategoriesWithWritePermissionsForPackage(@NonNull PackageInfo packageInfo, @NonNull Context context) {
        HashSet<Integer> dataCategoriesWithPermissions = new HashSet<Integer>();
        for (int i = 0; i < packageInfo.requestedPermissions.length; ++i) {
            int dataCategory;
            String currPerm = packageInfo.requestedPermissions[i];
            if (!HealthConnectManager.isHealthPermission(context, currPerm) || (packageInfo.requestedPermissionsFlags[i] & 2) == 0 || (dataCategory = HealthConnectMappings.getInstance().getHealthDataCategoryForWritePermission(currPerm)) < 0) continue;
            dataCategoriesWithPermissions.add(dataCategory);
        }
        return dataCategoriesWithPermissions;
    }

    public static boolean getPackageHasWriteHealthPermissionsForCategory(@NonNull PackageInfo packageInfo, int dataCategory, @NonNull Context context) {
        return HealthPermissions.getDataCategoriesWithWritePermissionsForPackage(packageInfo, context).contains(dataCategory);
    }

    public static boolean isValidHealthPermission(PermissionInfo permissionInfo) {
        return HEALTH_PERMISSION_GROUP.equals(permissionInfo.group) && HealthPermissions.isPermissionEnabled(permissionInfo.name);
    }

    static boolean isPermissionEnabled(@NonNull String permission2) {
        boolean bl;
        switch (permission2) {
            case "android.permission.health.READ_ACTIVITY_INTENSITY": 
            case "android.permission.health.WRITE_ACTIVITY_INTENSITY": {
                bl = Flags.activityIntensity();
                break;
            }
            case "android.permission.health.READ_NICOTINE_INTAKE": 
            case "android.permission.health.WRITE_NICOTINE_INTAKE": {
                bl = Flags.smoking();
                break;
            }
            case "android.permission.health.READ_MEDICAL_DATA_DEVICES": {
                bl = Flags.deviceResource();
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static synchronized void populateWriteHealthPermissionToHealthDataCategoryMap() {
        if (Flags.healthConnectMappingsFollowUp()) {
            return;
        }
        if (!sWriteHealthPermissionToHealthDataCategoryMap.isEmpty()) {
            return;
        }
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_ACTIVE_CALORIES_BURNED, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_DISTANCE, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_ELEVATION_GAINED, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_EXERCISE, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_PLANNED_EXERCISE, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_FLOORS_CLIMBED, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_STEPS, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_TOTAL_CALORIES_BURNED, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_VO2_MAX, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_WHEELCHAIR_PUSHES, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_POWER, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_SPEED, 1);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BASAL_METABOLIC_RATE, 2);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BODY_FAT, 2);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BODY_WATER_MASS, 2);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BONE_MASS, 2);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_HEIGHT, 2);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_LEAN_BODY_MASS, 2);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_WEIGHT, 2);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_CERVICAL_MUCUS, 3);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_MENSTRUATION, 3);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_OVULATION_TEST, 3);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_SEXUAL_ACTIVITY, 3);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_INTERMENSTRUAL_BLEEDING, 3);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_HYDRATION, 4);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_NUTRITION, 4);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_SLEEP, 5);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BASAL_BODY_TEMPERATURE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_SKIN_TEMPERATURE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BLOOD_GLUCOSE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BLOOD_PRESSURE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_BODY_TEMPERATURE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_HEART_RATE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_HEART_RATE_VARIABILITY, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_OXYGEN_SATURATION, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_RESPIRATORY_RATE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_RESTING_HEART_RATE, 6);
        sWriteHealthPermissionToHealthDataCategoryMap.put(WRITE_MINDFULNESS, 7);
        sDataCategoryToWritePermissionsMap.put(1, new String[]{WRITE_ACTIVE_CALORIES_BURNED, WRITE_DISTANCE, WRITE_ELEVATION_GAINED, WRITE_EXERCISE, WRITE_PLANNED_EXERCISE, WRITE_FLOORS_CLIMBED, WRITE_STEPS, WRITE_TOTAL_CALORIES_BURNED, WRITE_VO2_MAX, WRITE_WHEELCHAIR_PUSHES, WRITE_POWER, WRITE_SPEED});
        sDataCategoryToWritePermissionsMap.put(2, new String[]{WRITE_BASAL_METABOLIC_RATE, WRITE_BODY_FAT, WRITE_BODY_WATER_MASS, WRITE_BONE_MASS, WRITE_HEIGHT, WRITE_LEAN_BODY_MASS, WRITE_WEIGHT});
        sDataCategoryToWritePermissionsMap.put(3, new String[]{WRITE_CERVICAL_MUCUS, WRITE_MENSTRUATION, WRITE_OVULATION_TEST, WRITE_SEXUAL_ACTIVITY, WRITE_INTERMENSTRUAL_BLEEDING});
        sDataCategoryToWritePermissionsMap.put(4, new String[]{WRITE_HYDRATION, WRITE_NUTRITION});
        sDataCategoryToWritePermissionsMap.put(5, new String[]{WRITE_SLEEP});
        sDataCategoryToWritePermissionsMap.put(6, new String[]{WRITE_BASAL_BODY_TEMPERATURE, WRITE_BLOOD_GLUCOSE, WRITE_BLOOD_PRESSURE, WRITE_BODY_TEMPERATURE, WRITE_HEART_RATE, WRITE_HEART_RATE_VARIABILITY, WRITE_OXYGEN_SATURATION, WRITE_RESPIRATORY_RATE, WRITE_RESTING_HEART_RATE, WRITE_SKIN_TEMPERATURE});
        if (Flags.mindfulness()) {
            sDataCategoryToWritePermissionsMap.put(7, new String[]{WRITE_MINDFULNESS});
        }
    }
}

