/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.FhirVersion;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class CreateMedicalDataSourceRequest
implements Parcelable {
    private static final int DISPLAY_NAME_CHARACTER_LIMIT = 90;
    private static final int FHIR_BASE_URI_CHARACTER_LIMIT = 2000;
    @NonNull
    private final Uri mFhirBaseUri;
    @NonNull
    private final String mDisplayName;
    @NonNull
    private final FhirVersion mFhirVersion;
    private long mDataSize;
    @NonNull
    public static final Parcelable.Creator<CreateMedicalDataSourceRequest> CREATOR = new Parcelable.Creator<CreateMedicalDataSourceRequest>(){

        @Override
        @NonNull
        public CreateMedicalDataSourceRequest createFromParcel(@NonNull Parcel in) {
            return new CreateMedicalDataSourceRequest(in);
        }

        @NonNull
        public CreateMedicalDataSourceRequest[] newArray(int size) {
            return new CreateMedicalDataSourceRequest[size];
        }
    };

    private CreateMedicalDataSourceRequest(@NonNull Uri fhirBaseUri, @NonNull String displayName, @NonNull FhirVersion fhirVersion) {
        Objects.requireNonNull(fhirBaseUri);
        Objects.requireNonNull(displayName);
        Objects.requireNonNull(fhirVersion);
        CreateMedicalDataSourceRequest.validateFhirBaseUriCharacterLimit(fhirBaseUri);
        CreateMedicalDataSourceRequest.validateDisplayNameCharacterLimit(displayName);
        CreateMedicalDataSourceRequest.validateFhirVersion(fhirVersion);
        this.mFhirBaseUri = fhirBaseUri;
        this.mDisplayName = displayName;
        this.mFhirVersion = fhirVersion;
    }

    private CreateMedicalDataSourceRequest(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mDataSize = in.dataSize();
        this.mFhirBaseUri = Objects.requireNonNull(in.readParcelable(Uri.class.getClassLoader(), Uri.class));
        this.mDisplayName = Objects.requireNonNull(in.readString());
        this.mFhirVersion = Objects.requireNonNull(in.readParcelable(FhirVersion.class.getClassLoader(), FhirVersion.class));
        CreateMedicalDataSourceRequest.validateFhirBaseUriCharacterLimit(this.mFhirBaseUri);
        CreateMedicalDataSourceRequest.validateDisplayNameCharacterLimit(this.mDisplayName);
        CreateMedicalDataSourceRequest.validateFhirVersion(this.mFhirVersion);
    }

    @NonNull
    public Uri getFhirBaseUri() {
        return this.mFhirBaseUri;
    }

    @NonNull
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @NonNull
    public FhirVersion getFhirVersion() {
        return this.mFhirVersion;
    }

    public long getDataSize() {
        return this.mDataSize;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mFhirBaseUri, 0);
        dest.writeString(this.mDisplayName);
        dest.writeParcelable(this.mFhirVersion, 0);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMedicalDataSourceRequest)) {
            return false;
        }
        CreateMedicalDataSourceRequest that = (CreateMedicalDataSourceRequest)o;
        return ((Object)this.getFhirBaseUri()).equals(that.getFhirBaseUri()) && this.getDisplayName().equals(that.getDisplayName()) && this.getFhirVersion().equals(that.getFhirVersion());
    }

    public int hashCode() {
        return Objects.hash(this.getFhirBaseUri(), this.getDisplayName(), this.getFhirVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("fhirBaseUri=").append(this.getFhirBaseUri());
        sb.append(",displayName=").append(this.getDisplayName());
        sb.append(",fhirVersion=").append(this.getFhirVersion());
        sb.append("}");
        return sb.toString();
    }

    private static void validateDisplayNameCharacterLimit(String displayName) {
        if (displayName.isEmpty()) {
            throw new IllegalArgumentException("Display name cannot be empty.");
        }
        if (displayName.length() > 90) {
            throw new IllegalArgumentException("Display name cannot be longer than 90 characters.");
        }
    }

    private static void validateFhirBaseUriCharacterLimit(Uri fhirBaseUri) {
        String fhirBaseUriString = fhirBaseUri.toString();
        if (fhirBaseUriString.isEmpty()) {
            throw new IllegalArgumentException("FHIR base URI cannot be empty.");
        }
        if (fhirBaseUriString.length() > 2000) {
            throw new IllegalArgumentException("FHIR base URI cannot be longer than 2000 characters.");
        }
    }

    private static void validateFhirVersion(FhirVersion fhirVersion) {
        if (!fhirVersion.isSupportedFhirVersion()) {
            throw new IllegalArgumentException("Unsupported FHIR version " + fhirVersion + ".");
        }
    }

    public static class Builder {
        @NonNull
        private Uri mFhirBaseUri;
        @NonNull
        private String mDisplayName;
        @NonNull
        private FhirVersion mFhirVersion;

        public Builder(@NonNull Uri fhirBaseUri, @NonNull String displayName, @NonNull FhirVersion fhirVersion) {
            Objects.requireNonNull(fhirBaseUri);
            Objects.requireNonNull(displayName);
            Objects.requireNonNull(fhirVersion);
            this.mFhirBaseUri = fhirBaseUri;
            this.mDisplayName = displayName;
            this.mFhirVersion = fhirVersion;
        }

        public Builder(@NonNull Builder other) {
            Objects.requireNonNull(other);
            this.mFhirBaseUri = other.mFhirBaseUri;
            this.mDisplayName = other.mDisplayName;
            this.mFhirVersion = other.mFhirVersion;
        }

        public Builder(@NonNull CreateMedicalDataSourceRequest other) {
            Objects.requireNonNull(other);
            this.mFhirBaseUri = other.getFhirBaseUri();
            this.mDisplayName = other.getDisplayName();
            this.mFhirVersion = other.getFhirVersion();
        }

        @NonNull
        public Builder setFhirBaseUri(@NonNull Uri fhirBaseUri) {
            Objects.requireNonNull(fhirBaseUri);
            this.mFhirBaseUri = fhirBaseUri;
            return this;
        }

        @NonNull
        public Builder setDisplayName(@NonNull String displayName) {
            Objects.requireNonNull(displayName);
            this.mDisplayName = displayName;
            return this;
        }

        @NonNull
        public Builder setFhirVersion(@NonNull FhirVersion fhirVersion) {
            Objects.requireNonNull(fhirVersion);
            this.mFhirVersion = fhirVersion;
            return this;
        }

        @NonNull
        public CreateMedicalDataSourceRequest build() {
            return new CreateMedicalDataSourceRequest(this.mFhirBaseUri, this.mDisplayName, this.mFhirVersion);
        }
    }
}

