/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.DataOrigin;
import android.os.Parcel;
import android.util.ArraySet;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Set;

public class AggregateResult<T> {
    private final T mResult;
    @Nullable
    private final ZoneOffset mZoneOffset;
    private final Set<DataOrigin> mDataOrigins;

    public AggregateResult(T result, @Nullable ZoneOffset zoneOffset, Set<DataOrigin> dataOrigins) {
        this.mResult = result;
        this.mZoneOffset = zoneOffset;
        this.mDataOrigins = dataOrigins;
    }

    public void putToParcel(@NonNull Parcel parcel) {
        if (this.mResult instanceof Long) {
            parcel.writeLong((Long)this.mResult);
        } else if (this.mResult instanceof Double) {
            parcel.writeDouble((Double)this.mResult);
        }
    }

    @Nullable
    public ZoneOffset getZoneOffset() {
        return this.mZoneOffset;
    }

    @NonNull
    public Set<DataOrigin> getDataOrigins() {
        return this.mDataOrigins;
    }

    @NonNull
    T getResult() {
        return this.mResult;
    }

    public static Set<DataOrigin> convertDataOrigins(@NonNull List<String> packageNameList) {
        ArraySet<DataOrigin> result = new ArraySet<DataOrigin>();
        for (String packageName : packageNameList) {
            result.add(new DataOrigin.Builder().setPackageName(packageName).build());
        }
        return result;
    }
}

