/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class DisplayPortAltModeInfo
implements Parcelable {
    private final int mPartnerSinkStatus;
    private final int mCableStatus;
    private final int mNumLanes;
    private final boolean mHotPlugDetect;
    private final int mLinkTrainingStatus;
    public static final int DISPLAYPORT_ALT_MODE_STATUS_UNKNOWN = 0;
    public static final int DISPLAYPORT_ALT_MODE_STATUS_NOT_CAPABLE = 1;
    public static final int DISPLAYPORT_ALT_MODE_STATUS_CAPABLE_DISABLED = 2;
    public static final int DISPLAYPORT_ALT_MODE_STATUS_ENABLED = 3;
    public static final int LINK_TRAINING_STATUS_UNKNOWN = 0;
    public static final int LINK_TRAINING_STATUS_SUCCESS = 1;
    public static final int LINK_TRAINING_STATUS_FAILURE = 2;
    @NonNull
    public static final Parcelable.Creator<DisplayPortAltModeInfo> CREATOR = new Parcelable.Creator<DisplayPortAltModeInfo>(){

        @Override
        public DisplayPortAltModeInfo createFromParcel(Parcel in) {
            int partnerSinkStatus = in.readInt();
            int cableStatus = in.readInt();
            int numLanes = in.readInt();
            boolean hotPlugDetect = in.readBoolean();
            int linkTrainingStatus = in.readInt();
            return new DisplayPortAltModeInfo(partnerSinkStatus, cableStatus, numLanes, hotPlugDetect, linkTrainingStatus);
        }

        public DisplayPortAltModeInfo[] newArray(int size) {
            return new DisplayPortAltModeInfo[size];
        }
    };

    public DisplayPortAltModeInfo() {
        this.mPartnerSinkStatus = 0;
        this.mCableStatus = 0;
        this.mNumLanes = 0;
        this.mHotPlugDetect = false;
        this.mLinkTrainingStatus = 0;
    }

    public DisplayPortAltModeInfo(int partnerSinkStatus, int cableStatus, int numLanes, boolean hotPlugDetect, int linkTrainingStatus) {
        this.mPartnerSinkStatus = partnerSinkStatus;
        this.mCableStatus = cableStatus;
        this.mNumLanes = numLanes;
        this.mHotPlugDetect = hotPlugDetect;
        this.mLinkTrainingStatus = linkTrainingStatus;
    }

    public int getPartnerSinkStatus() {
        return this.mPartnerSinkStatus;
    }

    public int getCableStatus() {
        return this.mCableStatus;
    }

    public int getNumberOfLanes() {
        return this.mNumLanes;
    }

    public boolean isHotPlugDetectActive() {
        return this.mHotPlugDetect;
    }

    public int getLinkTrainingStatus() {
        return this.mLinkTrainingStatus;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPartnerSinkStatus);
        dest.writeInt(this.mCableStatus);
        dest.writeInt(this.mNumLanes);
        dest.writeBoolean(this.mHotPlugDetect);
        dest.writeInt(this.mLinkTrainingStatus);
    }

    private String displayPortAltModeStatusToString(int status) {
        switch (status) {
            case 1: {
                return "not capable";
            }
            case 2: {
                return "capable disabled";
            }
            case 3: {
                return "enabled";
            }
        }
        return "unknown";
    }

    private String linkTrainingStatusToString(int status) {
        switch (status) {
            case 1: {
                return "success";
            }
            case 2: {
                return "failure";
            }
        }
        return "unknown";
    }

    @NonNull
    public String toString() {
        return "DisplayPortAltModeInfo{partnerSink=" + this.displayPortAltModeStatusToString(this.mPartnerSinkStatus) + ", cable=" + this.displayPortAltModeStatusToString(this.mCableStatus) + ", numLanes=" + this.mNumLanes + ", hotPlugDetect=" + this.mHotPlugDetect + ", linkTrainingStatus=" + this.linkTrainingStatusToString(this.mLinkTrainingStatus) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisplayPortAltModeInfo)) {
            return false;
        }
        DisplayPortAltModeInfo other = (DisplayPortAltModeInfo)o;
        return this.mPartnerSinkStatus == other.mPartnerSinkStatus && this.mCableStatus == other.mCableStatus && this.mNumLanes == other.mNumLanes && this.mHotPlugDetect == other.mHotPlugDetect && this.mLinkTrainingStatus == other.mLinkTrainingStatus;
    }

    public int hashCode() {
        return Objects.hash(this.mPartnerSinkStatus, this.mCableStatus, this.mNumLanes, this.mHotPlugDetect, this.mLinkTrainingStatus);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LinkTrainingStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayPortAltModeStatus {
    }
}

