/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.graphics.Bitmap;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;

@SystemApi
public abstract class RadioTuner {
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_DOWN = 1;
    @Deprecated
    public static final int ERROR_HARDWARE_FAILURE = 0;
    @Deprecated
    public static final int ERROR_SERVER_DIED = 1;
    @Deprecated
    public static final int ERROR_CANCELLED = 2;
    @Deprecated
    public static final int ERROR_SCAN_TIMEOUT = 3;
    @Deprecated
    public static final int ERROR_CONFIG = 4;
    @Deprecated
    public static final int ERROR_BACKGROUND_SCAN_UNAVAILABLE = 5;
    @Deprecated
    public static final int ERROR_BACKGROUND_SCAN_FAILED = 6;
    public static final int TUNER_RESULT_OK = 0;
    public static final int TUNER_RESULT_INTERNAL_ERROR = 1;
    public static final int TUNER_RESULT_INVALID_ARGUMENTS = 2;
    public static final int TUNER_RESULT_INVALID_STATE = 3;
    public static final int TUNER_RESULT_NOT_SUPPORTED = 4;
    public static final int TUNER_RESULT_TIMEOUT = 5;
    public static final int TUNER_RESULT_CANCELED = 6;
    public static final int TUNER_RESULT_UNKNOWN_ERROR = 7;

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract void close();

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int setConfiguration(RadioManager.BandConfig var1);

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int getConfiguration(RadioManager.BandConfig[] var1);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int setMute(boolean var1);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract boolean getMute();

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int step(int var1, boolean var2);

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int scan(int var1, boolean var2);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public int seek(int direction, boolean skipSubChannel) {
        throw new UnsupportedOperationException("Seeking is not supported");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int tune(int var1, int var2);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract void tune(@NonNull ProgramSelector var1);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int cancel();

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract void cancelAnnouncement();

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract int getProgramInformation(RadioManager.ProgramInfo[] var1);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    @NonNull
    public Bitmap getMetadataImage(int id2) {
        throw new UnsupportedOperationException("Getting metadata image must be implemented in child classes");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract boolean startBackgroundScan();

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    @NonNull
    public abstract List<RadioManager.ProgramInfo> getProgramList(@Nullable Map<String, String> var1);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    @Nullable
    public ProgramList getDynamicProgramList(@Nullable ProgramList.Filter filter) {
        return null;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract boolean isAnalogForced();

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract void setAnalogForced(boolean var1);

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public boolean isConfigFlagSupported(int flag) {
        return false;
    }

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public boolean isConfigFlagSet(int flag) {
        throw new UnsupportedOperationException("isConfigFlagSet is not supported");
    }

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public void setConfigFlag(int flag, boolean value) {
        throw new UnsupportedOperationException("Setting config flag is not supported");
    }

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    @NonNull
    public Map<String, String> setParameters(@NonNull Map<String, String> parameters) {
        throw new UnsupportedOperationException("Setting parameters is not supported");
    }

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    @NonNull
    public Map<String, String> getParameters(@NonNull List<String> keys) {
        throw new UnsupportedOperationException("Getting parameters is not supported");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract boolean isAntennaConnected();

    @RequiresPermission(value="android.permission.ACCESS_BROADCAST_RADIO")
    public abstract boolean hasControl();

    public static abstract class Callback {
        public void onError(int status) {
        }

        public void onTuneFailed(int result, @Nullable ProgramSelector selector) {
        }

        @Deprecated
        public void onConfigurationChanged(RadioManager.BandConfig config) {
        }

        public void onProgramInfoChanged(RadioManager.ProgramInfo info) {
        }

        @Deprecated
        public void onMetadataChanged(RadioMetadata metadata) {
        }

        public void onTrafficAnnouncement(boolean active) {
        }

        public void onEmergencyAnnouncement(boolean active) {
        }

        public void onAntennaState(boolean connected) {
        }

        public void onControlChanged(boolean control) {
        }

        public void onBackgroundScanAvailabilityChange(boolean isAvailable) {
        }

        public void onBackgroundScanComplete() {
        }

        public void onProgramListChanged() {
        }

        public void onConfigFlagUpdated(int flag, boolean value) {
        }

        public void onParametersUpdated(@NonNull Map<String, String> parameters) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TunerResultType {
    }
}

