/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class NanoAppRpcService
implements Parcelable {
    private long mServiceId;
    private int mServiceVersion;
    @NonNull
    public static final Parcelable.Creator<NanoAppRpcService> CREATOR = new Parcelable.Creator<NanoAppRpcService>(){

        @Override
        public NanoAppRpcService createFromParcel(Parcel in) {
            return new NanoAppRpcService(in);
        }

        public NanoAppRpcService[] newArray(int size) {
            return new NanoAppRpcService[size];
        }
    };

    public NanoAppRpcService(long serviceId, int serviceVersion) {
        this.mServiceId = serviceId;
        this.mServiceVersion = serviceVersion;
    }

    public long getId() {
        return this.mServiceId;
    }

    public int getVersion() {
        return this.mServiceVersion;
    }

    private int getMajorVersion() {
        return (this.mServiceVersion & 0xFF000000) >>> 24;
    }

    private int getMinorVersion() {
        return (this.mServiceVersion & 0xFF0000) >>> 16;
    }

    private int getPatchVersion() {
        return this.mServiceVersion & 0xFFFF;
    }

    private NanoAppRpcService(Parcel in) {
        this.mServiceId = in.readLong();
        this.mServiceVersion = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeLong(this.mServiceId);
        out.writeInt(this.mServiceVersion);
    }

    @NonNull
    public String toString() {
        return "NanoAppRpcService[Id = " + Long.toHexString(this.mServiceId) + ", version = v" + this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getPatchVersion() + "]";
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        boolean isEqual = false;
        if (object instanceof NanoAppRpcService) {
            NanoAppRpcService other = (NanoAppRpcService)object;
            isEqual = other.getId() == this.mServiceId && other.getVersion() == this.mServiceVersion;
        }
        return isEqual;
    }

    public int hashCode() {
        return (int)this.getId();
    }
}

