/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class MemoryRegion
implements Parcelable {
    private int mSizeBytes;
    private int mSizeBytesFree;
    private boolean mIsReadable;
    private boolean mIsWritable;
    private boolean mIsExecutable;
    @NonNull
    public static final Parcelable.Creator<MemoryRegion> CREATOR = new Parcelable.Creator<MemoryRegion>(){

        @Override
        public MemoryRegion createFromParcel(Parcel in) {
            return new MemoryRegion(in);
        }

        public MemoryRegion[] newArray(int size) {
            return new MemoryRegion[size];
        }
    };

    public int getCapacityBytes() {
        return this.mSizeBytes;
    }

    public int getFreeCapacityBytes() {
        return this.mSizeBytesFree;
    }

    public boolean isReadable() {
        return this.mIsReadable;
    }

    public boolean isWritable() {
        return this.mIsWritable;
    }

    public boolean isExecutable() {
        return this.mIsExecutable;
    }

    @NonNull
    public String toString() {
        String mask = "";
        mask = this.isReadable() ? mask + "r" : mask + "-";
        mask = this.isWritable() ? mask + "w" : mask + "-";
        mask = this.isExecutable() ? mask + "x" : mask + "-";
        String retVal = "[ " + this.mSizeBytesFree + "/ " + this.mSizeBytes + " ] : " + mask;
        return retVal;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        boolean isEqual = false;
        if (object instanceof MemoryRegion) {
            MemoryRegion other = (MemoryRegion)object;
            isEqual = other.getCapacityBytes() == this.mSizeBytes && other.getFreeCapacityBytes() == this.mSizeBytesFree && other.isReadable() == this.mIsReadable && other.isWritable() == this.mIsWritable && other.isExecutable() == this.mIsExecutable;
        }
        return isEqual;
    }

    public int hashCode() {
        return Objects.hash(this.mSizeBytes, this.mSizeBytesFree, this.mIsReadable, this.mIsWritable, this.mIsExecutable);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSizeBytes);
        dest.writeInt(this.mSizeBytesFree);
        dest.writeInt(this.mIsReadable ? 1 : 0);
        dest.writeInt(this.mIsWritable ? 1 : 0);
        dest.writeInt(this.mIsExecutable ? 1 : 0);
    }

    public MemoryRegion(Parcel source) {
        this.mSizeBytes = source.readInt();
        this.mSizeBytesFree = source.readInt();
        this.mIsReadable = source.readInt() != 0;
        this.mIsWritable = source.readInt() != 0;
        this.mIsExecutable = source.readInt() != 0;
    }
}

