/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

@SystemApi
public class VirtualMouseScrollEvent
implements Parcelable {
    private final float mXAxisMovement;
    private final float mYAxisMovement;
    private final long mEventTimeNanos;
    @NonNull
    public static final Parcelable.Creator<VirtualMouseScrollEvent> CREATOR = new Parcelable.Creator<VirtualMouseScrollEvent>(){

        @Override
        public VirtualMouseScrollEvent createFromParcel(Parcel source) {
            return new VirtualMouseScrollEvent(source);
        }

        public VirtualMouseScrollEvent[] newArray(int size) {
            return new VirtualMouseScrollEvent[size];
        }
    };

    private VirtualMouseScrollEvent(float xAxisMovement, float yAxisMovement, long eventTimeNanos) {
        this.mXAxisMovement = xAxisMovement;
        this.mYAxisMovement = yAxisMovement;
        this.mEventTimeNanos = eventTimeNanos;
    }

    private VirtualMouseScrollEvent(@NonNull Parcel parcel) {
        this.mXAxisMovement = parcel.readFloat();
        this.mYAxisMovement = parcel.readFloat();
        this.mEventTimeNanos = parcel.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelableFlags) {
        parcel.writeFloat(this.mXAxisMovement);
        parcel.writeFloat(this.mYAxisMovement);
        parcel.writeLong(this.mEventTimeNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "VirtualMouseScrollEvent( x=" + this.mXAxisMovement + " y=" + this.mYAxisMovement + " eventTime(ns)=" + this.mEventTimeNanos;
    }

    public float getXAxisMovement() {
        return this.mXAxisMovement;
    }

    public float getYAxisMovement() {
        return this.mYAxisMovement;
    }

    public long getEventTimeNanos() {
        return this.mEventTimeNanos;
    }

    public static class Builder {
        private float mXAxisMovement;
        private float mYAxisMovement;
        private long mEventTimeNanos = 0L;

        @NonNull
        public VirtualMouseScrollEvent build() {
            return new VirtualMouseScrollEvent(this.mXAxisMovement, this.mYAxisMovement, this.mEventTimeNanos);
        }

        @NonNull
        public Builder setXAxisMovement(float xAxisMovement) {
            Preconditions.checkArgumentInRange(xAxisMovement, -1.0f, 1.0f, "xAxisMovement");
            this.mXAxisMovement = xAxisMovement;
            return this;
        }

        @NonNull
        public Builder setYAxisMovement(float yAxisMovement) {
            Preconditions.checkArgumentInRange(yAxisMovement, -1.0f, 1.0f, "yAxisMovement");
            this.mYAxisMovement = yAxisMovement;
            return this;
        }

        @NonNull
        public Builder setEventTimeNanos(long eventTimeNanos) {
            if (eventTimeNanos < 0L) {
                throw new IllegalArgumentException("Event time cannot be negative");
            }
            this.mEventTimeNanos = eventTimeNanos;
            return this;
        }
    }
}

