/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class VirtualMouseRelativeEvent
implements Parcelable {
    private final float mRelativeX;
    private final float mRelativeY;
    private final long mEventTimeNanos;
    @NonNull
    public static final Parcelable.Creator<VirtualMouseRelativeEvent> CREATOR = new Parcelable.Creator<VirtualMouseRelativeEvent>(){

        @Override
        public VirtualMouseRelativeEvent createFromParcel(Parcel source) {
            return new VirtualMouseRelativeEvent(source);
        }

        public VirtualMouseRelativeEvent[] newArray(int size) {
            return new VirtualMouseRelativeEvent[size];
        }
    };

    private VirtualMouseRelativeEvent(float relativeX, float relativeY, long eventTimeNanos) {
        this.mRelativeX = relativeX;
        this.mRelativeY = relativeY;
        this.mEventTimeNanos = eventTimeNanos;
    }

    private VirtualMouseRelativeEvent(@NonNull Parcel parcel) {
        this.mRelativeX = parcel.readFloat();
        this.mRelativeY = parcel.readFloat();
        this.mEventTimeNanos = parcel.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelableFlags) {
        parcel.writeFloat(this.mRelativeX);
        parcel.writeFloat(this.mRelativeY);
        parcel.writeLong(this.mEventTimeNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "VirtualMouseRelativeEvent( x=" + this.mRelativeX + " y=" + this.mRelativeY + " eventTime(ns)=" + this.mEventTimeNanos;
    }

    public float getRelativeX() {
        return this.mRelativeX;
    }

    public float getRelativeY() {
        return this.mRelativeY;
    }

    public long getEventTimeNanos() {
        return this.mEventTimeNanos;
    }

    public static class Builder {
        private float mRelativeX;
        private float mRelativeY;
        private long mEventTimeNanos = 0L;

        @NonNull
        public VirtualMouseRelativeEvent build() {
            return new VirtualMouseRelativeEvent(this.mRelativeX, this.mRelativeY, this.mEventTimeNanos);
        }

        @NonNull
        public Builder setRelativeX(float relativeX) {
            this.mRelativeX = relativeX;
            return this;
        }

        @NonNull
        public Builder setRelativeY(float relativeY) {
            this.mRelativeY = relativeY;
            return this;
        }

        @NonNull
        public Builder setEventTimeNanos(long eventTimeNanos) {
            if (eventTimeNanos < 0L) {
                throw new IllegalArgumentException("Event time cannot be negative");
            }
            this.mEventTimeNanos = eventTimeNanos;
            return this;
        }
    }
}

