/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class KeyboardLayoutSelectionResult
implements Parcelable {
    @Nullable
    private final String mLayoutDescriptor;
    public static final int LAYOUT_SELECTION_CRITERIA_UNSPECIFIED = 0;
    public static final int LAYOUT_SELECTION_CRITERIA_USER = 1;
    public static final int LAYOUT_SELECTION_CRITERIA_DEVICE = 2;
    public static final int LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD = 3;
    public static final int LAYOUT_SELECTION_CRITERIA_DEFAULT = 4;
    public static final KeyboardLayoutSelectionResult FAILED = new KeyboardLayoutSelectionResult(null, 0);
    private final int mSelectionCriteria;
    @NonNull
    public static final Parcelable.Creator<KeyboardLayoutSelectionResult> CREATOR = new Parcelable.Creator<KeyboardLayoutSelectionResult>(){

        public KeyboardLayoutSelectionResult[] newArray(int size) {
            return new KeyboardLayoutSelectionResult[size];
        }

        @Override
        public KeyboardLayoutSelectionResult createFromParcel(@NonNull Parcel in) {
            return new KeyboardLayoutSelectionResult(in);
        }
    };

    public static String layoutSelectionCriteriaToString(int value) {
        switch (value) {
            case 0: {
                return "LAYOUT_SELECTION_CRITERIA_UNSPECIFIED";
            }
            case 1: {
                return "LAYOUT_SELECTION_CRITERIA_USER";
            }
            case 2: {
                return "LAYOUT_SELECTION_CRITERIA_DEVICE";
            }
            case 3: {
                return "LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD";
            }
            case 4: {
                return "LAYOUT_SELECTION_CRITERIA_DEFAULT";
            }
        }
        return Integer.toHexString(value);
    }

    public KeyboardLayoutSelectionResult(@Nullable String layoutDescriptor, int selectionCriteria) {
        this.mLayoutDescriptor = layoutDescriptor;
        this.mSelectionCriteria = selectionCriteria;
        if (this.mSelectionCriteria != 0 && this.mSelectionCriteria != 1 && this.mSelectionCriteria != 2 && this.mSelectionCriteria != 3 && this.mSelectionCriteria != 4) {
            throw new IllegalArgumentException("selectionCriteria was " + this.mSelectionCriteria + " but must be one of: LAYOUT_SELECTION_CRITERIA_UNSPECIFIED(" + 0 + "), LAYOUT_SELECTION_CRITERIA_USER(" + 1 + "), LAYOUT_SELECTION_CRITERIA_DEVICE(" + 2 + "), LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD(" + 3 + "), LAYOUT_SELECTION_CRITERIA_DEFAULT(" + 4 + ")");
        }
    }

    @Nullable
    public String getLayoutDescriptor() {
        return this.mLayoutDescriptor;
    }

    public int getSelectionCriteria() {
        return this.mSelectionCriteria;
    }

    public String toString() {
        return "KeyboardLayoutSelectionResult { layoutDescriptor = " + this.mLayoutDescriptor + ", selectionCriteria = " + KeyboardLayoutSelectionResult.layoutSelectionCriteriaToString(this.mSelectionCriteria) + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyboardLayoutSelectionResult that = (KeyboardLayoutSelectionResult)o;
        return Objects.equals(this.mLayoutDescriptor, that.mLayoutDescriptor) && this.mSelectionCriteria == that.mSelectionCriteria;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mLayoutDescriptor);
        _hash = 31 * _hash + this.mSelectionCriteria;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mLayoutDescriptor != null) {
            flg = (byte)(flg | 1);
        }
        dest.writeByte(flg);
        if (this.mLayoutDescriptor != null) {
            dest.writeString(this.mLayoutDescriptor);
        }
        dest.writeInt(this.mSelectionCriteria);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    KeyboardLayoutSelectionResult(@NonNull Parcel in) {
        byte flg = in.readByte();
        String layoutDescriptor = (flg & 1) == 0 ? null : in.readString();
        int selectionCriteria = in.readInt();
        this.mLayoutDescriptor = layoutDescriptor;
        this.mSelectionCriteria = selectionCriteria;
        if (this.mSelectionCriteria != 0 && this.mSelectionCriteria != 1 && this.mSelectionCriteria != 2 && this.mSelectionCriteria != 3 && this.mSelectionCriteria != 4) {
            throw new IllegalArgumentException("selectionCriteria was " + this.mSelectionCriteria + " but must be one of: LAYOUT_SELECTION_CRITERIA_UNSPECIFIED(" + 0 + "), LAYOUT_SELECTION_CRITERIA_USER(" + 1 + "), LAYOUT_SELECTION_CRITERIA_DEVICE(" + 2 + "), LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD(" + 3 + "), LAYOUT_SELECTION_CRITERIA_DEFAULT(" + 4 + ")");
        }
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LayoutSelectionCriteria {
    }
}

