/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.hardware.BatteryState;
import android.hardware.SensorManager;
import android.hardware.input.AidlKeyGestureEvent;
import android.hardware.input.HostUsiVersion;
import android.hardware.input.IInputDeviceBatteryListener;
import android.hardware.input.IInputDeviceBatteryState;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputManager;
import android.hardware.input.IInputSensorEventListener;
import android.hardware.input.IKeyEventActivityListener;
import android.hardware.input.IKeyGestureEventListener;
import android.hardware.input.IKeyGestureHandler;
import android.hardware.input.IKeyboardBacklightListener;
import android.hardware.input.IKeyboardBacklightState;
import android.hardware.input.IStickyModifierStateListener;
import android.hardware.input.ITabletModeChangedListener;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputDeviceLightsManager;
import android.hardware.input.InputDeviceSensorManager;
import android.hardware.input.InputDeviceVibrator;
import android.hardware.input.InputDeviceVibratorManager;
import android.hardware.input.InputManager;
import android.hardware.input.InputSensorInfo;
import android.hardware.input.KeyGestureEvent;
import android.hardware.input.KeyboardBacklightState;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.StickyModifierState;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.hardware.lights.LightsManager;
import android.hardware.lights.LightsRequest;
import android.os.Binder;
import android.os.CombinedVibration;
import android.os.Handler;
import android.os.IBinder;
import android.os.IVibratorStateListener;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorManager;
import android.util.IntArray;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputMonitor;
import android.view.KeyCharacterMap;
import android.view.PointerIcon;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class InputManagerGlobal {
    private static final String TAG = "InputManagerGlobal";
    @GuardedBy(value={"mInputDeviceListeners"})
    @Nullable
    private SparseArray<InputDevice> mInputDevices;
    @GuardedBy(value={"mInputDeviceListeners"})
    @Nullable
    private InputDevicesChangedListener mInputDevicesChangedListener;
    @GuardedBy(value={"mInputDeviceListeners"})
    private final ArrayList<InputDeviceListenerDelegate> mInputDeviceListeners = new ArrayList();
    @GuardedBy(value={"mOnTabletModeChangedListeners"})
    private final ArrayList<OnTabletModeChangedListenerDelegate> mOnTabletModeChangedListeners = new ArrayList();
    private final Object mBatteryListenersLock = new Object();
    @GuardedBy(value={"mBatteryListenersLock"})
    @Nullable
    private SparseArray<RegisteredBatteryListeners> mBatteryListeners;
    @GuardedBy(value={"mBatteryListenersLock"})
    @Nullable
    private IInputDeviceBatteryListener mInputDeviceBatteryListener;
    private final Object mKeyboardBacklightListenerLock = new Object();
    @GuardedBy(value={"mKeyboardBacklightListenerLock"})
    @Nullable
    private ArrayList<KeyboardBacklightListenerDelegate> mKeyboardBacklightListeners;
    @GuardedBy(value={"mKeyboardBacklightListenerLock"})
    @Nullable
    private IKeyboardBacklightListener mKeyboardBacklightListener;
    private final Object mStickyModifierStateListenerLock = new Object();
    @GuardedBy(value={"mStickyModifierStateListenerLock"})
    @Nullable
    private ArrayList<StickyModifierStateListenerDelegate> mStickyModifierStateListeners;
    @GuardedBy(value={"mStickyModifierStateListenerLock"})
    @Nullable
    private IStickyModifierStateListener mStickyModifierStateListener;
    private final Object mKeyGestureEventListenerLock = new Object();
    @GuardedBy(value={"mKeyGestureEventListenerLock"})
    @Nullable
    private ArrayList<KeyGestureEventListenerDelegate> mKeyGestureEventListeners;
    @GuardedBy(value={"mKeyGestureEventListenerLock"})
    @Nullable
    private IKeyGestureEventListener mKeyGestureEventListener;
    private final Object mKeyEventActivityLock = new Object();
    @GuardedBy(value={"mKeyEventActivityLock"})
    private ArrayList<InputManager.KeyEventActivityListener> mKeyEventActivityListeners;
    @GuardedBy(value={"mKeyEventActivityLock"})
    @Nullable
    private IKeyEventActivityListener mKeyEventActivityListener;
    @GuardedBy(value={"mKeyGesturesToHandlerMap"})
    @Nullable
    private IKeyGestureHandler mKeyGestureHandler;
    @GuardedBy(value={"mKeyGesturesToHandlerMap"})
    private final SparseArray<InputManager.KeyGestureEventHandler> mKeyGesturesToHandlerMap = new SparseArray();
    @GuardedBy(value={"mInputDeviceListeners"})
    @Nullable
    private InputDeviceSensorManager mInputDeviceSensorManager;
    public static InputManagerGlobal sInstance;
    private final String mVelocityTrackerStrategy;
    private final IInputManager mIm;

    private boolean debug() {
        return Log.isLoggable(TAG, 3);
    }

    public InputManagerGlobal(IInputManager im) {
        this.mIm = im;
        String strategy = null;
        try {
            strategy = this.mIm.getVelocityTrackerStrategy();
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not get VelocityTracker strategy: " + ex);
        }
        this.mVelocityTrackerStrategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputManagerGlobal getInstance() {
        Class<InputManagerGlobal> clazz = InputManagerGlobal.class;
        synchronized (InputManagerGlobal.class) {
            IBinder b;
            if (sInstance == null && (b = ServiceManager.getService("input")) != null) {
                sInstance = new InputManagerGlobal(IInputManager.Stub.asInterface(b));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public IInputManager getInputManagerService() {
        return this.mIm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static TestSession createTestSession(IInputManager inputManagerService) {
        Class<InputManagerGlobal> clazz = InputManagerGlobal.class;
        synchronized (InputManagerGlobal.class) {
            InputManagerGlobal oldInstance = sInstance;
            sInstance = new InputManagerGlobal(inputManagerService);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return () -> {
                sInstance = oldInstance;
            };
        }
    }

    public String getVelocityTrackerStrategy() {
        return this.mVelocityTrackerStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputDevice getInputDevice(int id2) {
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            this.populateInputDevicesLocked();
            int index = this.mInputDevices.indexOfKey(id2);
            if (index < 0) {
                return null;
            }
            InputDevice inputDevice = this.mInputDevices.valueAt(index);
            if (inputDevice == null) {
                try {
                    inputDevice = this.mIm.getInputDevice(id2);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
                if (inputDevice != null) {
                    this.mInputDevices.setValueAt(index, inputDevice);
                }
            }
            return inputDevice;
        }
    }

    @GuardedBy(value={"mInputDeviceListeners"})
    private void populateInputDevicesLocked() {
        if (this.mInputDevicesChangedListener == null) {
            InputDevicesChangedListener listener = new InputDevicesChangedListener();
            try {
                this.mIm.registerInputDevicesChangedListener(listener);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            this.mInputDevicesChangedListener = listener;
        }
        if (this.mInputDevices == null) {
            int[] ids;
            try {
                ids = this.mIm.getInputDeviceIds();
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            this.mInputDevices = new SparseArray();
            for (int id2 : ids) {
                this.mInputDevices.put(id2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInputDevicesChanged(int[] deviceIdAndGeneration) {
        boolean enableDebugLogs = this.debug();
        if (enableDebugLogs) {
            Log.d(TAG, "Received input devices changed: " + Arrays.toString(deviceIdAndGeneration));
        }
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            int deviceId;
            int i = this.mInputDevices.size();
            while (--i > 0) {
                deviceId = this.mInputDevices.keyAt(i);
                if (InputManagerGlobal.containsDeviceId(deviceIdAndGeneration, deviceId)) continue;
                if (enableDebugLogs) {
                    InputDevice device = this.mInputDevices.valueAt(i);
                    String name = device != null ? device.getName() : "<null>";
                    Log.d(TAG, "Device removed: " + deviceId + " (" + name + ")");
                }
                this.mInputDevices.removeAt(i);
                if (this.mInputDeviceSensorManager != null) {
                    this.mInputDeviceSensorManager.onInputDeviceRemoved(deviceId);
                }
                this.sendMessageToInputDeviceListenersLocked(2, deviceId);
            }
            for (i = 0; i < deviceIdAndGeneration.length; i += 2) {
                deviceId = deviceIdAndGeneration[i];
                int index = this.mInputDevices.indexOfKey(deviceId);
                if (index >= 0) {
                    InputDevice device = this.mInputDevices.valueAt(index);
                    if (device == null) continue;
                    int generation = deviceIdAndGeneration[i + 1];
                    if (device.getGeneration() == generation) continue;
                    if (enableDebugLogs) {
                        Log.d(TAG, "Device changed: " + deviceId + " (" + device.getName() + ")");
                    }
                    this.mInputDevices.setValueAt(index, null);
                    if (this.mInputDeviceSensorManager != null) {
                        this.mInputDeviceSensorManager.onInputDeviceChanged(deviceId);
                    }
                    this.sendMessageToInputDeviceListenersLocked(3, deviceId);
                    continue;
                }
                if (enableDebugLogs) {
                    Log.d(TAG, "Device added: " + deviceId);
                }
                this.mInputDevices.put(deviceId, null);
                if (this.mInputDeviceSensorManager != null) {
                    this.mInputDeviceSensorManager.onInputDeviceAdded(deviceId);
                }
                this.sendMessageToInputDeviceListenersLocked(1, deviceId);
            }
        }
    }

    private static boolean containsDeviceId(int[] deviceIdAndGeneration, int deviceId) {
        for (int i = 0; i < deviceIdAndGeneration.length; i += 2) {
            if (deviceIdAndGeneration[i] != deviceId) continue;
            return true;
        }
        return false;
    }

    @GuardedBy(value={"mInputDeviceListeners"})
    private void sendMessageToInputDeviceListenersLocked(int what, int deviceId) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            InputDeviceListenerDelegate listener = this.mInputDeviceListeners.get(i);
            listener.sendMessage(listener.obtainMessage(what, deviceId, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInputDeviceListener(InputManager.InputDeviceListener listener, Handler handler) {
        Objects.requireNonNull(listener, "listener must not be null");
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            this.populateInputDevicesLocked();
            int index = this.findInputDeviceListenerLocked(listener);
            if (index < 0) {
                this.mInputDeviceListeners.add(new InputDeviceListenerDelegate(listener, handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInputDeviceListener(InputManager.InputDeviceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            int index = this.findInputDeviceListenerLocked(listener);
            if (index >= 0) {
                InputDeviceListenerDelegate d = this.mInputDeviceListeners.get(index);
                d.removeCallbacksAndMessages(null);
                this.mInputDeviceListeners.remove(index);
            }
        }
    }

    @GuardedBy(value={"mInputDeviceListeners"})
    private int findInputDeviceListenerLocked(InputManager.InputDeviceListener listener) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.mInputDeviceListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getInputDeviceIds() {
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            this.populateInputDevicesLocked();
            int count = this.mInputDevices.size();
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = this.mInputDevices.keyAt(i);
            }
            return ids;
        }
    }

    public void enableInputDevice(int id2) {
        try {
            this.mIm.enableInputDevice(id2);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not enable input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    public void disableInputDevice(int id2) {
        try {
            this.mIm.disableInputDevice(id2);
        }
        catch (RemoteException ex) {
            Log.w(TAG, "Could not disable input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputDevice getInputDeviceByDescriptor(String descriptor) {
        Objects.requireNonNull(descriptor, "descriptor must not be null.");
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            this.populateInputDevicesLocked();
            int numDevices = this.mInputDevices.size();
            for (int i = 0; i < numDevices; ++i) {
                InputDevice inputDevice = this.mInputDevices.valueAt(i);
                if (inputDevice == null) {
                    int id2 = this.mInputDevices.keyAt(i);
                    try {
                        inputDevice = this.mIm.getInputDevice(id2);
                    }
                    catch (RemoteException ex) {
                        throw ex.rethrowFromSystemServer();
                    }
                    if (inputDevice == null) continue;
                    this.mInputDevices.setValueAt(i, inputDevice);
                }
                if (!descriptor.equals(inputDevice.getDescriptor())) continue;
                return inputDevice;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    HostUsiVersion getHostUsiVersion(@NonNull Display display) {
        Objects.requireNonNull(display, "display should not be null");
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            this.populateInputDevicesLocked();
            for (int i = 0; i < this.mInputDevices.size(); ++i) {
                InputDevice device = this.getInputDevice(this.mInputDevices.keyAt(i));
                if (device == null || device.getAssociatedDisplayId() != display.getDisplayId() || device.getHostUsiVersion() == null) continue;
                return device.getHostUsiVersion();
            }
        }
        try {
            return this.mIm.getHostUsiVersionFromDisplayConfig(display.getDisplayId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTabletModeChanged(long whenNanos, boolean inTabletMode) {
        if (this.debug()) {
            Log.d(TAG, "Received tablet mode changed: whenNanos=" + whenNanos + ", inTabletMode=" + inTabletMode);
        }
        ArrayList<OnTabletModeChangedListenerDelegate> arrayList = this.mOnTabletModeChangedListeners;
        synchronized (arrayList) {
            int numListeners = this.mOnTabletModeChangedListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                OnTabletModeChangedListenerDelegate listener = this.mOnTabletModeChangedListeners.get(i);
                listener.sendTabletModeChanged(whenNanos, inTabletMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOnTabletModeChangedListener(InputManager.OnTabletModeChangedListener listener, Handler handler) {
        Objects.requireNonNull(listener, "listener must not be null");
        ArrayList<OnTabletModeChangedListenerDelegate> arrayList = this.mOnTabletModeChangedListeners;
        synchronized (arrayList) {
            int idx;
            if (this.mOnTabletModeChangedListeners.isEmpty()) {
                this.initializeTabletModeListenerLocked();
            }
            if ((idx = this.findOnTabletModeChangedListenerLocked(listener)) < 0) {
                OnTabletModeChangedListenerDelegate d = new OnTabletModeChangedListenerDelegate(listener, handler);
                this.mOnTabletModeChangedListeners.add(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOnTabletModeChangedListener(InputManager.OnTabletModeChangedListener listener) {
        Objects.requireNonNull(listener, "listener must not be null");
        ArrayList<OnTabletModeChangedListenerDelegate> arrayList = this.mOnTabletModeChangedListeners;
        synchronized (arrayList) {
            int idx = this.findOnTabletModeChangedListenerLocked(listener);
            if (idx >= 0) {
                OnTabletModeChangedListenerDelegate d = this.mOnTabletModeChangedListeners.remove(idx);
                d.removeCallbacksAndMessages(null);
            }
        }
    }

    @GuardedBy(value={"mOnTabletModeChangedListeners"})
    private void initializeTabletModeListenerLocked() {
        TabletModeChangedListener listener = new TabletModeChangedListener();
        try {
            this.mIm.registerTabletModeChangedListener(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value={"mOnTabletModeChangedListeners"})
    private int findOnTabletModeChangedListenerLocked(InputManager.OnTabletModeChangedListener listener) {
        int n = this.mOnTabletModeChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            if (this.mOnTabletModeChangedListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputDeviceBatteryListener(int deviceId, @NonNull Executor executor, @NonNull InputManager.InputDeviceBatteryListener listener) {
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mBatteryListenersLock;
        synchronized (object) {
            RegisteredBatteryListeners listenersForDevice;
            if (this.mBatteryListeners == null) {
                this.mBatteryListeners = new SparseArray();
                this.mInputDeviceBatteryListener = new LocalInputDeviceBatteryListener();
            }
            if ((listenersForDevice = this.mBatteryListeners.get(deviceId)) == null) {
                listenersForDevice = new RegisteredBatteryListeners();
                this.mBatteryListeners.put(deviceId, listenersForDevice);
                try {
                    this.mIm.registerBatteryListener(deviceId, this.mInputDeviceBatteryListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            } else {
                int numDelegates = listenersForDevice.mDelegates.size();
                for (int i = 0; i < numDelegates; ++i) {
                    InputManager.InputDeviceBatteryListener registeredListener = listenersForDevice.mDelegates.get((int)i).mListener;
                    if (!Objects.equals(listener, registeredListener)) continue;
                    throw new IllegalArgumentException("Attempting to register an InputDeviceBatteryListener that has already been registered for deviceId: " + deviceId);
                }
            }
            InputDeviceBatteryListenerDelegate delegate = new InputDeviceBatteryListenerDelegate(listener, executor);
            listenersForDevice.mDelegates.add(delegate);
            if (listenersForDevice.mInputDeviceBatteryState != null) {
                delegate.notifyBatteryStateChanged(listenersForDevice.mInputDeviceBatteryState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInputDeviceBatteryListener(int deviceId, @NonNull InputManager.InputDeviceBatteryListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mBatteryListenersLock;
        synchronized (object) {
            if (this.mBatteryListeners == null) {
                return;
            }
            RegisteredBatteryListeners listenersForDevice = this.mBatteryListeners.get(deviceId);
            if (listenersForDevice == null) {
                return;
            }
            List<InputDeviceBatteryListenerDelegate> delegates = listenersForDevice.mDelegates;
            int i = 0;
            while (i < delegates.size()) {
                if (Objects.equals(listener, delegates.get((int)i).mListener)) {
                    delegates.remove(i);
                    continue;
                }
                ++i;
            }
            if (!delegates.isEmpty()) {
                return;
            }
            this.mBatteryListeners.remove(deviceId);
            try {
                this.mIm.unregisterBatteryListener(deviceId, this.mInputDeviceBatteryListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (this.mBatteryListeners.size() == 0) {
                this.mBatteryListeners = null;
                this.mInputDeviceBatteryListener = null;
            }
        }
    }

    @NonNull
    public BatteryState getInputDeviceBatteryState(int deviceId, boolean hasBattery) {
        if (!hasBattery) {
            return new LocalBatteryState();
        }
        try {
            IInputDeviceBatteryState state = this.mIm.getBatteryState(deviceId);
            return new LocalBatteryState(state.isPresent, state.status, state.capacity);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    void registerKeyboardBacklightListener(@NonNull Executor executor, @NonNull InputManager.KeyboardBacklightListener listener) throws IllegalArgumentException {
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mKeyboardBacklightListenerLock;
        synchronized (object) {
            if (this.mKeyboardBacklightListener == null) {
                this.mKeyboardBacklightListeners = new ArrayList();
                this.mKeyboardBacklightListener = new LocalKeyboardBacklightListener();
                try {
                    this.mIm.registerKeyboardBacklightListener(this.mKeyboardBacklightListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            int numListeners = this.mKeyboardBacklightListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                if (this.mKeyboardBacklightListeners.get((int)i).mListener != listener) continue;
                throw new IllegalArgumentException("Listener has already been registered!");
            }
            KeyboardBacklightListenerDelegate delegate = new KeyboardBacklightListenerDelegate(listener, executor);
            this.mKeyboardBacklightListeners.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    void unregisterKeyboardBacklightListener(@NonNull InputManager.KeyboardBacklightListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mKeyboardBacklightListenerLock;
        synchronized (object) {
            if (this.mKeyboardBacklightListeners == null) {
                return;
            }
            this.mKeyboardBacklightListeners.removeIf(delegate -> delegate.mListener == listener);
            if (this.mKeyboardBacklightListeners.isEmpty()) {
                try {
                    this.mIm.unregisterKeyboardBacklightListener(this.mKeyboardBacklightListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mKeyboardBacklightListeners = null;
                this.mKeyboardBacklightListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    void registerStickyModifierStateListener(@NonNull Executor executor, @NonNull InputManager.StickyModifierStateListener listener) throws IllegalArgumentException {
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mStickyModifierStateListenerLock;
        synchronized (object) {
            if (this.mStickyModifierStateListener == null) {
                this.mStickyModifierStateListeners = new ArrayList();
                this.mStickyModifierStateListener = new LocalStickyModifierStateListener();
                try {
                    this.mIm.registerStickyModifierStateListener(this.mStickyModifierStateListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            int numListeners = this.mStickyModifierStateListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                if (this.mStickyModifierStateListeners.get((int)i).mListener != listener) continue;
                throw new IllegalArgumentException("Listener has already been registered!");
            }
            StickyModifierStateListenerDelegate delegate = new StickyModifierStateListenerDelegate(listener, executor);
            this.mStickyModifierStateListeners.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    void unregisterStickyModifierStateListener(@NonNull InputManager.StickyModifierStateListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mStickyModifierStateListenerLock;
        synchronized (object) {
            if (this.mStickyModifierStateListeners == null) {
                return;
            }
            this.mStickyModifierStateListeners.removeIf(delegate -> delegate.mListener == listener);
            if (this.mStickyModifierStateListeners.isEmpty()) {
                try {
                    this.mIm.unregisterStickyModifierStateListener(this.mStickyModifierStateListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mStickyModifierStateListeners = null;
                this.mStickyModifierStateListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    void registerKeyGestureEventListener(@NonNull Executor executor, @NonNull InputManager.KeyGestureEventListener listener) throws IllegalArgumentException {
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mKeyGestureEventListenerLock;
        synchronized (object) {
            if (this.mKeyGestureEventListener == null) {
                this.mKeyGestureEventListeners = new ArrayList();
                this.mKeyGestureEventListener = new LocalKeyGestureEventListener();
                try {
                    this.mIm.registerKeyGestureEventListener(this.mKeyGestureEventListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            int numListeners = this.mKeyGestureEventListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                if (this.mKeyGestureEventListeners.get((int)i).mListener != listener) continue;
                throw new IllegalArgumentException("Listener has already been registered!");
            }
            KeyGestureEventListenerDelegate delegate = new KeyGestureEventListenerDelegate(listener, executor);
            this.mKeyGestureEventListeners.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    void unregisterKeyGestureEventListener(@NonNull InputManager.KeyGestureEventListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        Object object = this.mKeyGestureEventListenerLock;
        synchronized (object) {
            if (this.mKeyGestureEventListeners == null) {
                return;
            }
            this.mKeyGestureEventListeners.removeIf(delegate -> delegate.mListener == listener);
            if (this.mKeyGestureEventListeners.isEmpty()) {
                try {
                    this.mIm.unregisterKeyGestureEventListener(this.mKeyGestureEventListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mKeyGestureEventListeners = null;
                this.mKeyGestureEventListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    void registerKeyGestureEventHandler(List<Integer> keyGesturesToHandle, @NonNull InputManager.KeyGestureEventHandler handler) throws IllegalArgumentException {
        Objects.requireNonNull(keyGesturesToHandle, "List of gestures should not be null");
        Objects.requireNonNull(handler, "handler should not be null");
        if (keyGesturesToHandle.isEmpty()) {
            throw new IllegalArgumentException("No key gestures provided!");
        }
        SparseArray<InputManager.KeyGestureEventHandler> sparseArray = this.mKeyGesturesToHandlerMap;
        synchronized (sparseArray) {
            IntArray newKeyGestures = new IntArray(keyGesturesToHandle.size() + this.mKeyGesturesToHandlerMap.size());
            for (int i = 0; i < this.mKeyGesturesToHandlerMap.size(); ++i) {
                InputManager.KeyGestureEventHandler h = this.mKeyGesturesToHandlerMap.valueAt(i);
                if (h == handler) {
                    throw new IllegalArgumentException("Handler has already been registered!");
                }
                newKeyGestures.add(this.mKeyGesturesToHandlerMap.keyAt(i));
            }
            for (int gesture : keyGesturesToHandle) {
                if (this.mKeyGesturesToHandlerMap.contains(gesture)) {
                    throw new IllegalArgumentException("Key gesture " + gesture + " is already registered by another handler!");
                }
                newKeyGestures.add(gesture);
            }
            try {
                if (this.mKeyGestureHandler != null) {
                    this.mIm.unregisterKeyGestureHandler(this.mKeyGestureHandler);
                } else {
                    this.mKeyGestureHandler = new LocalKeyGestureHandler();
                }
                this.mIm.registerKeyGestureHandler(newKeyGestures.toArray(), this.mKeyGestureHandler);
                for (int gesture : keyGesturesToHandle) {
                    this.mKeyGesturesToHandlerMap.put(gesture, handler);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    void unregisterKeyGestureEventHandler(@NonNull InputManager.KeyGestureEventHandler handler) {
        Objects.requireNonNull(handler, "handler should not be null");
        SparseArray<InputManager.KeyGestureEventHandler> sparseArray = this.mKeyGesturesToHandlerMap;
        synchronized (sparseArray) {
            if (this.mKeyGestureHandler == null) {
                return;
            }
            for (int i = this.mKeyGesturesToHandlerMap.size() - 1; i >= 0; --i) {
                if (this.mKeyGesturesToHandlerMap.valueAt(i) != handler) continue;
                this.mKeyGesturesToHandlerMap.removeAt(i);
            }
            if (this.mKeyGesturesToHandlerMap.size() == 0) {
                try {
                    this.mIm.unregisterKeyGestureHandler(this.mKeyGestureHandler);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mKeyGestureHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerKeyEventActivityListener(@NonNull InputManager.KeyEventActivityListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        boolean success = false;
        Object object = this.mKeyEventActivityLock;
        synchronized (object) {
            if (this.mKeyEventActivityListener == null) {
                this.mKeyEventActivityListeners = new ArrayList();
                this.mKeyEventActivityListener = new LocalKeyEventActivityListener();
                try {
                    success = this.mIm.registerKeyEventActivityListener(this.mKeyEventActivityListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            if (this.mKeyEventActivityListeners.contains(listener)) {
                throw new IllegalArgumentException("Listener has already been registered!");
            }
            this.mKeyEventActivityListeners.add(listener);
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unregisterKeyEventActivityListener(@NonNull InputManager.KeyEventActivityListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        boolean success = true;
        Object object = this.mKeyEventActivityLock;
        synchronized (object) {
            if (this.mKeyEventActivityListeners == null) {
                return success;
            }
            this.mKeyEventActivityListeners.remove(listener);
            if (this.mKeyEventActivityListeners.isEmpty()) {
                try {
                    success = this.mIm.unregisterKeyEventActivityListener(this.mKeyEventActivityListener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mKeyEventActivityListeners = null;
                this.mKeyEventActivityListener = null;
            }
        }
        return success;
    }

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void setKeyboardLayoutOverrideForInputDevice(@NonNull InputDeviceIdentifier identifier, @NonNull String keyboardLayoutDescriptor) {
        Objects.requireNonNull(identifier, "identifier should not be null");
        Objects.requireNonNull(keyboardLayoutDescriptor, "keyboardLayoutDescriptor should not be null");
        try {
            this.mIm.setKeyboardLayoutOverrideForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(@NonNull InputDeviceIdentifier identifier) {
        return new KeyboardLayout[0];
    }

    public void setCurrentKeyboardLayoutForInputDevice(@NonNull InputDeviceIdentifier identifier, @NonNull String keyboardLayoutDescriptor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public SensorManager getInputDeviceSensorManager(int deviceId) {
        ArrayList<InputDeviceListenerDelegate> arrayList = this.mInputDeviceListeners;
        synchronized (arrayList) {
            if (this.mInputDeviceSensorManager == null) {
                this.mInputDeviceSensorManager = new InputDeviceSensorManager(this);
            }
            return this.mInputDeviceSensorManager.getSensorManager(deviceId);
        }
    }

    InputSensorInfo[] getSensorList(int deviceId) {
        try {
            return this.mIm.getSensorList(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean enableSensor(int deviceId, int sensorType, int samplingPeriodUs, int maxBatchReportLatencyUs) {
        try {
            return this.mIm.enableSensor(deviceId, sensorType, samplingPeriodUs, maxBatchReportLatencyUs);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void disableSensor(int deviceId, int sensorType) {
        try {
            this.mIm.disableSensor(deviceId, sensorType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean flushSensor(int deviceId, int sensorType) {
        try {
            return this.mIm.flushSensor(deviceId, sensorType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean registerSensorListener(IInputSensorEventListener listener) {
        try {
            return this.mIm.registerSensorListener(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void unregisterSensorListener(IInputSensorEventListener listener) {
        try {
            this.mIm.unregisterSensorListener(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @NonNull
    public LightsManager getInputDeviceLightsManager(int deviceId) {
        return new InputDeviceLightsManager(deviceId);
    }

    @NonNull
    List<Light> getLights(int deviceId) {
        try {
            return this.mIm.getLights(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    LightState getLightState(int deviceId, @NonNull Light light) {
        try {
            return this.mIm.getLightState(deviceId, light.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void requestLights(int deviceId, @NonNull LightsRequest request, IBinder token) {
        try {
            List<Integer> lightIdList = request.getLights();
            int[] lightIds = new int[lightIdList.size()];
            for (int i = 0; i < lightIds.length; ++i) {
                lightIds[i] = lightIdList.get(i);
            }
            List<LightState> lightStateList = request.getLightStates();
            this.mIm.setLightStates(deviceId, lightIds, lightStateList.toArray(new LightState[0]), token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void openLightSession(int deviceId, String opPkg, @NonNull IBinder token) {
        try {
            this.mIm.openLightSession(deviceId, opPkg, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void closeLightSession(int deviceId, @NonNull IBinder token) {
        try {
            this.mIm.closeLightSession(deviceId, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Vibrator getInputDeviceVibrator(int deviceId, int vibratorId) {
        return new InputDeviceVibrator(deviceId, vibratorId);
    }

    @NonNull
    public VibratorManager getInputDeviceVibratorManager(int deviceId) {
        return new InputDeviceVibratorManager(deviceId);
    }

    int[] getVibratorIds(int deviceId) {
        try {
            return this.mIm.getVibratorIds(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void vibrate(int deviceId, VibrationEffect effect, IBinder token) {
        try {
            this.mIm.vibrate(deviceId, effect, token);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void vibrate(int deviceId, CombinedVibration effect, IBinder token) {
        try {
            this.mIm.vibrateCombined(deviceId, effect, token);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    void cancelVibrate(int deviceId, IBinder token) {
        try {
            this.mIm.cancelVibrate(deviceId, token);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean isVibrating(int deviceId) {
        try {
            return this.mIm.isVibrating(deviceId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean registerVibratorStateListener(int deviceId, IVibratorStateListener listener) {
        try {
            return this.mIm.registerVibratorStateListener(deviceId, listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    boolean unregisterVibratorStateListener(int deviceId, IVibratorStateListener listener) {
        try {
            return this.mIm.unregisterVibratorStateListener(deviceId, listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean[] deviceHasKeys(int[] keyCodes) {
        return this.deviceHasKeys(-1, keyCodes);
    }

    public boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        boolean[] ret = new boolean[keyCodes.length];
        try {
            this.mIm.hasKeys(id2, -256, keyCodes, ret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return ret;
    }

    public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) {
        try {
            return this.mIm.getKeyCodeForKeyLocation(deviceId, locationKeyCode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public KeyCharacterMap getKeyCharacterMap(@Nullable KeyboardLayout keyboardLayout) {
        if (keyboardLayout == null) {
            return KeyCharacterMap.load(-1);
        }
        try {
            return this.mIm.getKeyCharacterMap(keyboardLayout.getDescriptor());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean injectInputEvent(InputEvent event, int mode, int targetUid) {
        Objects.requireNonNull(event, "event must not be null");
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("mode is invalid");
        }
        try {
            return this.mIm.injectInputEventToTarget(event, mode, targetUid);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public boolean injectInputEvent(InputEvent event, int mode) {
        return this.injectInputEvent(event, mode, -1);
    }

    public boolean setPointerIcon(PointerIcon icon, int displayId, int deviceId, int pointerId, IBinder inputToken) {
        try {
            return this.mIm.setPointerIcon(icon, displayId, deviceId, pointerId, inputToken);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void requestPointerCapture(IBinder windowToken, boolean enable) {
        try {
            this.mIm.requestPointerCapture(windowToken, enable);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public InputMonitor monitorGestureInput(String name, int displayId) {
        try {
            return this.mIm.monitorGestureInput(new Binder(), name, displayId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void addUniqueIdAssociationByPort(@NonNull String inputPort, @NonNull String displayUniqueId) {
        try {
            this.mIm.addUniqueIdAssociationByPort(inputPort, displayUniqueId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeUniqueIdAssociationByPort(@NonNull String inputPort) {
        try {
            this.mIm.removeUniqueIdAssociationByPort(inputPort);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addUniqueIdAssociationByDescriptor(@NonNull String inputDeviceDescriptor, @NonNull String displayUniqueId) {
        try {
            this.mIm.addUniqueIdAssociationByDescriptor(inputDeviceDescriptor, displayUniqueId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeUniqueIdAssociationByDescriptor(@NonNull String inputDeviceDescriptor) {
        try {
            this.mIm.removeUniqueIdAssociationByDescriptor(inputDeviceDescriptor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    @Nullable
    public String getInputDeviceBluetoothAddress(int deviceId) {
        try {
            return this.mIm.getInputDeviceBluetoothAddress(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void cancelCurrentTouch() {
        try {
            this.mIm.cancelCurrentTouch();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MONITOR_INPUT")
    public void pilferPointers(IBinder inputChannelToken) {
        try {
            this.mIm.pilferPointers(inputChannelToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    public static interface TestSession
    extends AutoCloseable {
        @Override
        public void close();
    }

    private class InputDevicesChangedListener
    extends IInputDevicesChangedListener.Stub {
        private InputDevicesChangedListener() {
        }

        @Override
        public void onInputDevicesChanged(int[] deviceIdAndGeneration) throws RemoteException {
            InputManagerGlobal.this.onInputDevicesChanged(deviceIdAndGeneration);
        }
    }

    private static class InputDeviceListenerDelegate
    extends Handler {
        public final InputManager.InputDeviceListener mListener;
        static final int MSG_DEVICE_ADDED = 1;
        static final int MSG_DEVICE_REMOVED = 2;
        static final int MSG_DEVICE_CHANGED = 3;

        InputDeviceListenerDelegate(InputManager.InputDeviceListener listener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.mListener = listener;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onInputDeviceAdded(msg.arg1);
                    break;
                }
                case 2: {
                    this.mListener.onInputDeviceRemoved(msg.arg1);
                    break;
                }
                case 3: {
                    this.mListener.onInputDeviceChanged(msg.arg1);
                }
            }
        }
    }

    private static class OnTabletModeChangedListenerDelegate
    extends Handler {
        private static final int MSG_TABLET_MODE_CHANGED = 0;
        public final InputManager.OnTabletModeChangedListener mListener;

        OnTabletModeChangedListenerDelegate(InputManager.OnTabletModeChangedListener listener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.mListener = listener;
        }

        public void sendTabletModeChanged(long whenNanos, boolean inTabletMode) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = (int)whenNanos;
            args.argi2 = (int)(whenNanos >> 32);
            args.arg1 = inTabletMode;
            this.obtainMessage(0, args).sendToTarget();
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                SomeArgs args = (SomeArgs)msg.obj;
                long whenNanos = (long)args.argi1 & 0xFFFFFFFFL | (long)args.argi2 << 32;
                boolean inTabletMode = (Boolean)args.arg1;
                this.mListener.onTabletModeChanged(whenNanos, inTabletMode);
            }
        }
    }

    private class TabletModeChangedListener
    extends ITabletModeChangedListener.Stub {
        private TabletModeChangedListener() {
        }

        @Override
        public void onTabletModeChanged(long whenNanos, boolean inTabletMode) {
            InputManagerGlobal.this.onTabletModeChanged(whenNanos, inTabletMode);
        }
    }

    private class LocalInputDeviceBatteryListener
    extends IInputDeviceBatteryListener.Stub {
        private LocalInputDeviceBatteryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBatteryStateChanged(IInputDeviceBatteryState state) {
            Object object = InputManagerGlobal.this.mBatteryListenersLock;
            synchronized (object) {
                if (InputManagerGlobal.this.mBatteryListeners == null) {
                    return;
                }
                RegisteredBatteryListeners entry = InputManagerGlobal.this.mBatteryListeners.get(state.deviceId);
                if (entry == null) {
                    return;
                }
                entry.mInputDeviceBatteryState = state;
                int numDelegates = entry.mDelegates.size();
                for (int i = 0; i < numDelegates; ++i) {
                    entry.mDelegates.get(i).notifyBatteryStateChanged(entry.mInputDeviceBatteryState);
                }
            }
        }
    }

    private static class RegisteredBatteryListeners {
        final List<InputDeviceBatteryListenerDelegate> mDelegates = new ArrayList<InputDeviceBatteryListenerDelegate>();
        IInputDeviceBatteryState mInputDeviceBatteryState;

        private RegisteredBatteryListeners() {
        }
    }

    private static class InputDeviceBatteryListenerDelegate {
        final InputManager.InputDeviceBatteryListener mListener;
        final Executor mExecutor;

        InputDeviceBatteryListenerDelegate(InputManager.InputDeviceBatteryListener listener, Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
        }

        void notifyBatteryStateChanged(IInputDeviceBatteryState state) {
            this.mExecutor.execute(() -> this.mListener.onBatteryStateChanged(state.deviceId, state.updateTime, new LocalBatteryState(state.isPresent, state.status, state.capacity)));
        }
    }

    private static class LocalBatteryState
    extends BatteryState {
        private final boolean mIsPresent;
        private final int mStatus;
        private final float mCapacity;

        LocalBatteryState() {
            this(false, 1, Float.NaN);
        }

        LocalBatteryState(boolean isPresent, int status, float capacity) {
            this.mIsPresent = isPresent;
            this.mStatus = status;
            this.mCapacity = capacity;
        }

        @Override
        public boolean isPresent() {
            return this.mIsPresent;
        }

        @Override
        public int getStatus() {
            return this.mStatus;
        }

        @Override
        public float getCapacity() {
            return this.mCapacity;
        }
    }

    private class LocalKeyboardBacklightListener
    extends IKeyboardBacklightListener.Stub {
        private LocalKeyboardBacklightListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBrightnessChanged(int deviceId, IKeyboardBacklightState state, boolean isTriggeredByKeyPress) {
            Object object = InputManagerGlobal.this.mKeyboardBacklightListenerLock;
            synchronized (object) {
                if (InputManagerGlobal.this.mKeyboardBacklightListeners == null) {
                    return;
                }
                int numListeners = InputManagerGlobal.this.mKeyboardBacklightListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    InputManagerGlobal.this.mKeyboardBacklightListeners.get(i).notifyKeyboardBacklightChange(deviceId, state, isTriggeredByKeyPress);
                }
            }
        }
    }

    private static class KeyboardBacklightListenerDelegate {
        final InputManager.KeyboardBacklightListener mListener;
        final Executor mExecutor;

        KeyboardBacklightListenerDelegate(InputManager.KeyboardBacklightListener listener, Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
        }

        void notifyKeyboardBacklightChange(int deviceId, IKeyboardBacklightState state, boolean isTriggeredByKeyPress) {
            this.mExecutor.execute(() -> this.mListener.onKeyboardBacklightChanged(deviceId, new LocalKeyboardBacklightState(state.brightnessLevel, state.maxBrightnessLevel), isTriggeredByKeyPress));
        }
    }

    private class LocalStickyModifierStateListener
    extends IStickyModifierStateListener.Stub {
        private LocalStickyModifierStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStickyModifierStateChanged(int modifierState, int lockedModifierState) {
            Object object = InputManagerGlobal.this.mStickyModifierStateListenerLock;
            synchronized (object) {
                if (InputManagerGlobal.this.mStickyModifierStateListeners == null) {
                    return;
                }
                int numListeners = InputManagerGlobal.this.mStickyModifierStateListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    InputManagerGlobal.this.mStickyModifierStateListeners.get(i).notifyStickyModifierStateChange(modifierState, lockedModifierState);
                }
            }
        }
    }

    private static class StickyModifierStateListenerDelegate {
        final InputManager.StickyModifierStateListener mListener;
        final Executor mExecutor;

        StickyModifierStateListenerDelegate(InputManager.StickyModifierStateListener listener, Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
        }

        void notifyStickyModifierStateChange(int modifierState, int lockedModifierState) {
            this.mExecutor.execute(() -> this.mListener.onStickyModifierStateChanged(new LocalStickyModifierState(modifierState, lockedModifierState)));
        }
    }

    private class LocalKeyGestureEventListener
    extends IKeyGestureEventListener.Stub {
        private LocalKeyGestureEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKeyGestureEvent(@NonNull AidlKeyGestureEvent ev) {
            Object object = InputManagerGlobal.this.mKeyGestureEventListenerLock;
            synchronized (object) {
                if (InputManagerGlobal.this.mKeyGestureEventListeners == null) {
                    return;
                }
                int numListeners = InputManagerGlobal.this.mKeyGestureEventListeners.size();
                KeyGestureEvent event = new KeyGestureEvent(ev);
                for (int i = 0; i < numListeners; ++i) {
                    InputManagerGlobal.this.mKeyGestureEventListeners.get(i).onKeyGestureEvent(event);
                }
            }
        }
    }

    private static class KeyGestureEventListenerDelegate {
        final InputManager.KeyGestureEventListener mListener;
        final Executor mExecutor;

        KeyGestureEventListenerDelegate(InputManager.KeyGestureEventListener listener, Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
        }

        void onKeyGestureEvent(KeyGestureEvent event) {
            this.mExecutor.execute(() -> this.mListener.onKeyGestureEvent(event));
        }
    }

    private class LocalKeyGestureHandler
    extends IKeyGestureHandler.Stub {
        private LocalKeyGestureHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleKeyGesture(@NonNull AidlKeyGestureEvent ev, IBinder focusedToken) {
            SparseArray<InputManager.KeyGestureEventHandler> sparseArray = InputManagerGlobal.this.mKeyGesturesToHandlerMap;
            synchronized (sparseArray) {
                InputManager.KeyGestureEventHandler handler = InputManagerGlobal.this.mKeyGesturesToHandlerMap.get(ev.gestureType);
                if (handler == null) {
                    Log.w(InputManagerGlobal.TAG, "Key gesture event " + ev.gestureType + " occurred without a registered handler!");
                    return;
                }
                handler.handleKeyGestureEvent(new KeyGestureEvent(ev), focusedToken);
            }
        }
    }

    private class LocalKeyEventActivityListener
    extends IKeyEventActivityListener.Stub {
        private LocalKeyEventActivityListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKeyEventActivity() {
            Object object = InputManagerGlobal.this.mKeyEventActivityLock;
            synchronized (object) {
                int numListeners = InputManagerGlobal.this.mKeyEventActivityListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    InputManager.KeyEventActivityListener listener = InputManagerGlobal.this.mKeyEventActivityListeners.get(i);
                    listener.onKeyEventActivity();
                }
            }
        }
    }

    private static class LocalStickyModifierState
    extends StickyModifierState {
        private final int mModifierState;
        private final int mLockedModifierState;

        LocalStickyModifierState(int modifierState, int lockedModifierState) {
            this.mModifierState = modifierState;
            this.mLockedModifierState = lockedModifierState;
        }

        @Override
        public boolean isShiftModifierOn() {
            return (this.mModifierState & 1) != 0;
        }

        @Override
        public boolean isShiftModifierLocked() {
            return (this.mLockedModifierState & 1) != 0;
        }

        @Override
        public boolean isCtrlModifierOn() {
            return (this.mModifierState & 0x1000) != 0;
        }

        @Override
        public boolean isCtrlModifierLocked() {
            return (this.mLockedModifierState & 0x1000) != 0;
        }

        @Override
        public boolean isMetaModifierOn() {
            return (this.mModifierState & 0x10000) != 0;
        }

        @Override
        public boolean isMetaModifierLocked() {
            return (this.mLockedModifierState & 0x10000) != 0;
        }

        @Override
        public boolean isAltModifierOn() {
            return (this.mModifierState & 0x10) != 0;
        }

        @Override
        public boolean isAltModifierLocked() {
            return (this.mLockedModifierState & 0x10) != 0;
        }

        @Override
        public boolean isAltGrModifierOn() {
            return (this.mModifierState & 0x20) != 0;
        }

        @Override
        public boolean isAltGrModifierLocked() {
            return (this.mLockedModifierState & 0x20) != 0;
        }
    }

    private static class LocalKeyboardBacklightState
    extends KeyboardBacklightState {
        private final int mBrightnessLevel;
        private final int mMaxBrightnessLevel;

        LocalKeyboardBacklightState(int brightnessLevel, int maxBrightnessLevel) {
            this.mBrightnessLevel = brightnessLevel;
            this.mMaxBrightnessLevel = maxBrightnessLevel;
        }

        @Override
        public int getBrightnessLevel() {
            return this.mBrightnessLevel;
        }

        @Override
        public int getMaxBrightnessLevel() {
            return this.mMaxBrightnessLevel;
        }
    }
}

