/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FaceEnrollOptions
implements Parcelable {
    public static final int ENROLL_REASON_UNKNOWN = 0;
    public static final int ENROLL_REASON_RE_ENROLL_NOTIFICATION = 1;
    public static final int ENROLL_REASON_SETTINGS = 2;
    public static final int ENROLL_REASON_SUW = 3;
    private final int mEnrollReason;
    @NonNull
    public static final Parcelable.Creator<FaceEnrollOptions> CREATOR = new Parcelable.Creator<FaceEnrollOptions>(){

        public FaceEnrollOptions[] newArray(int size) {
            return new FaceEnrollOptions[size];
        }

        @Override
        public FaceEnrollOptions createFromParcel(@NonNull Parcel in) {
            return new FaceEnrollOptions(in);
        }
    };

    private static int defaultEnrollReason() {
        return 0;
    }

    public static String enrollReasonToString(int value) {
        switch (value) {
            case 0: {
                return "ENROLL_REASON_UNKNOWN";
            }
            case 1: {
                return "ENROLL_REASON_RE_ENROLL_NOTIFICATION";
            }
            case 2: {
                return "ENROLL_REASON_SETTINGS";
            }
            case 3: {
                return "ENROLL_REASON_SUW";
            }
        }
        return Integer.toHexString(value);
    }

    FaceEnrollOptions(int enrollReason) {
        this.mEnrollReason = enrollReason;
        if (this.mEnrollReason != 0 && this.mEnrollReason != 1 && this.mEnrollReason != 2 && this.mEnrollReason != 3) {
            throw new IllegalArgumentException("enrollReason was " + this.mEnrollReason + " but must be one of: ENROLL_REASON_UNKNOWN(" + 0 + "), ENROLL_REASON_RE_ENROLL_NOTIFICATION(" + 1 + "), ENROLL_REASON_SETTINGS(" + 2 + "), ENROLL_REASON_SUW(" + 3 + ")");
        }
    }

    public int getEnrollReason() {
        return this.mEnrollReason;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaceEnrollOptions that = (FaceEnrollOptions)o;
        return this.mEnrollReason == that.mEnrollReason;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mEnrollReason;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mEnrollReason);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected FaceEnrollOptions(@NonNull Parcel in) {
        int enrollReason;
        this.mEnrollReason = enrollReason = in.readInt();
        if (this.mEnrollReason != 0 && this.mEnrollReason != 1 && this.mEnrollReason != 2 && this.mEnrollReason != 3) {
            throw new IllegalArgumentException("enrollReason was " + this.mEnrollReason + " but must be one of: ENROLL_REASON_UNKNOWN(" + 0 + "), ENROLL_REASON_RE_ENROLL_NOTIFICATION(" + 1 + "), ENROLL_REASON_SETTINGS(" + 2 + "), ENROLL_REASON_SUW(" + 3 + ")");
        }
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private int mEnrollReason;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setEnrollReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mEnrollReason = value;
            return this;
        }

        @NonNull
        public FaceEnrollOptions build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mEnrollReason = FaceEnrollOptions.defaultEnrollReason();
            }
            FaceEnrollOptions o = new FaceEnrollOptions(this.mEnrollReason);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 2L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnrollReason {
    }
}

