/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.content.res.Resources;
import android.graphics.Point;
import android.hardware.display.AmbientBrightnessDayStats;
import android.hardware.display.AmbientDisplayConfiguration;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.ColorDisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.DisplayTopology;
import android.hardware.display.HdrConversionMode;
import android.hardware.display.IDisplayManager;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserManager;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.Surface;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.com.android.server.display.feature.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DisplayManager {
    private static final String TAG = "DisplayManager";
    static final boolean DEBUG = Log.isLoggable("DisplayManager", 3) || Log.isLoggable("DisplayManager_All", 3);
    private static final boolean ENABLE_VIRTUAL_DISPLAY_REFRESH_RATE = true;
    public static final String HDR_OUTPUT_CONTROL_FLAG = "enable_hdr_output_control";
    private final Context mContext;
    private final DisplayManagerGlobal mGlobal;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final WeakDisplayCache mDisplayCache = new WeakDisplayCache();
    private int mDisplayIdToMirror = -1;
    private AmbientDisplayConfiguration mAmbientDisplayConfiguration;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String ACTION_WIFI_DISPLAY_STATUS_CHANGED = "android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_WIFI_DISPLAY_STATUS = "android.hardware.display.extra.WIFI_DISPLAY_STATUS";
    public static final String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";
    @FlaggedApi(value="com.android.server.display.feature.flags.display_category_built_in")
    public static final String DISPLAY_CATEGORY_BUILT_IN_DISPLAYS = "android.hardware.display.category.BUILT_IN_DISPLAYS";
    public static final String DISPLAY_CATEGORY_REAR = "android.hardware.display.category.REAR";
    @SuppressLint(value={"UnflaggedApi"})
    public static final String DISPLAY_CATEGORY_ALL_INCLUDING_DISABLED = "android.hardware.display.category.ALL_INCLUDING_DISABLED";
    public static final int VIRTUAL_DISPLAY_FLAG_PUBLIC = 1;
    public static final int VIRTUAL_DISPLAY_FLAG_PRESENTATION = 2;
    public static final int VIRTUAL_DISPLAY_FLAG_SECURE = 4;
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY = 8;
    public static final int VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR = 16;
    public static final int VIRTUAL_DISPLAY_FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD = 32;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int VIRTUAL_DISPLAY_FLAG_SUPPORTS_TOUCH = 64;
    @SystemApi
    public static final int VIRTUAL_DISPLAY_FLAG_ROTATES_WITH_CONTENT = 128;
    public static final int VIRTUAL_DISPLAY_FLAG_DESTROY_CONTENT_ON_REMOVAL = 256;
    public static final int VIRTUAL_DISPLAY_FLAG_SHOULD_SHOW_SYSTEM_DECORATIONS = 512;
    @SystemApi
    public static final int VIRTUAL_DISPLAY_FLAG_TRUSTED = 1024;
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_DISPLAY_GROUP = 2048;
    public static final int VIRTUAL_DISPLAY_FLAG_ALWAYS_UNLOCKED = 4096;
    public static final int VIRTUAL_DISPLAY_FLAG_TOUCH_FEEDBACK_DISABLED = 8192;
    public static final int VIRTUAL_DISPLAY_FLAG_OWN_FOCUS = 16384;
    public static final int VIRTUAL_DISPLAY_FLAG_DEVICE_DISPLAY_GROUP = 32768;
    @SystemApi
    public static final int VIRTUAL_DISPLAY_FLAG_STEAL_TOP_FOCUS_DISABLED = 65536;
    public static final int MATCH_CONTENT_FRAMERATE_UNKNOWN = -1;
    public static final int MATCH_CONTENT_FRAMERATE_NEVER = 0;
    public static final int MATCH_CONTENT_FRAMERATE_SEAMLESSS_ONLY = 1;
    public static final int MATCH_CONTENT_FRAMERATE_ALWAYS = 2;
    public static final int SWITCHING_TYPE_NONE = 0;
    public static final int SWITCHING_TYPE_WITHIN_GROUPS = 1;
    public static final int SWITCHING_TYPE_ACROSS_AND_WITHIN_GROUPS = 2;
    public static final int SWITCHING_TYPE_RENDER_FRAME_RATE_ONLY = 3;
    @FlaggedApi(value="com.android.server.display.feature.flags.display_listener_performance_improvements")
    public static final long EVENT_TYPE_DISPLAY_ADDED = 1L;
    @FlaggedApi(value="com.android.server.display.feature.flags.display_listener_performance_improvements")
    public static final long EVENT_TYPE_DISPLAY_REMOVED = 2L;
    @FlaggedApi(value="com.android.server.display.feature.flags.display_listener_performance_improvements")
    public static final long EVENT_TYPE_DISPLAY_CHANGED = 4L;
    @FlaggedApi(value="com.android.server.display.feature.flags.display_listener_performance_improvements")
    public static final long EVENT_TYPE_DISPLAY_REFRESH_RATE = 8L;
    @FlaggedApi(value="com.android.server.display.feature.flags.display_listener_performance_improvements")
    public static final long EVENT_TYPE_DISPLAY_STATE = 16L;
    public static final long PRIVATE_EVENT_TYPE_DISPLAY_BRIGHTNESS = 1L;
    public static final long PRIVATE_EVENT_TYPE_HDR_SDR_RATIO_CHANGED = 2L;
    public static final long PRIVATE_EVENT_TYPE_DISPLAY_CONNECTION_CHANGED = 4L;
    public static final long PRIVATE_EVENT_TYPE_DISPLAY_COMMITTED_STATE_CHANGED = 8L;
    @FlaggedApi(value="com.android.server.display.feature.flags.set_brightness_by_unit")
    public static final int BRIGHTNESS_UNIT_PERCENTAGE = 0;

    public static String brightnessUnitToString(int unit) {
        if (Flags.setBrightnessByUnit() && unit == 0) {
            return "percentage";
        }
        throw new IllegalStateException("Unexpected value: " + unit);
    }

    public DisplayManager(Context context) {
        this.mContext = context;
        this.mGlobal = DisplayManagerGlobal.getInstance();
    }

    public Display getDisplay(int displayId) {
        return this.getOrCreateDisplay(displayId, false);
    }

    public Display[] getDisplays() {
        return this.getDisplays(null);
    }

    public Display[] getDisplays(String category) {
        boolean includeDisabled = this.shouldIncludeDisabledDisplays(category);
        int[] displayIds = this.mGlobal.getDisplayIds(includeDisabled);
        if (Flags.displayCategoryBuiltIn() && DISPLAY_CATEGORY_BUILT_IN_DISPLAYS.equals(category)) {
            Display[] value = this.getDisplays(displayIds, DisplayManager::isBuiltInDisplay);
            return value;
        }
        if (DISPLAY_CATEGORY_PRESENTATION.equals(category)) {
            return this.getDisplays(displayIds, DisplayManager::isPresentationDisplay);
        }
        if (DISPLAY_CATEGORY_REAR.equals(category)) {
            return this.getDisplays(displayIds, DisplayManager::isRearDisplay);
        }
        if (category == null || DISPLAY_CATEGORY_ALL_INCLUDING_DISABLED.equals(category)) {
            return this.getDisplays(displayIds, Objects::nonNull);
        }
        return new Display[0];
    }

    private boolean shouldIncludeDisabledDisplays(@Nullable String category) {
        if (DISPLAY_CATEGORY_BUILT_IN_DISPLAYS.equals(category)) {
            return true;
        }
        return DISPLAY_CATEGORY_ALL_INCLUDING_DISABLED.equals(category);
    }

    private Display[] getDisplays(int[] displayIds, Predicate<Display> predicate) {
        ArrayList<Display> tmpDisplays = new ArrayList<Display>();
        for (int displayId : displayIds) {
            Display display = this.getOrCreateDisplay(displayId, true);
            if (!predicate.test(display)) continue;
            tmpDisplays.add(display);
        }
        return tmpDisplays.toArray(new Display[tmpDisplays.size()]);
    }

    private static boolean isBuiltInDisplay(@Nullable Display display) {
        if (display == null) {
            return false;
        }
        return display.getType() == 1;
    }

    private static boolean isPresentationDisplay(@Nullable Display display) {
        if (display == null || display.getDisplayId() == 0 || (display.getFlags() & 8) == 0) {
            return false;
        }
        switch (display.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRearDisplay(@Nullable Display display) {
        return display != null && display.getDisplayId() != 0 && display.getType() == 1 && (display.getFlags() & 0x2000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Display getOrCreateDisplay(int displayId, boolean assumeValid) {
        Display display;
        Object object = this.mLock;
        synchronized (object) {
            display = this.mDisplayCache.get(displayId);
            if (display == null) {
                Resources resources = this.mContext.getDisplayId() == displayId ? this.mContext.getResources() : null;
                display = this.mGlobal.getCompatibleDisplay(displayId, resources);
                if (display != null) {
                    this.mDisplayCache.put(display);
                }
            } else if (!assumeValid && !display.isValid()) {
                display = null;
            }
        }
        return display;
    }

    public void registerDisplayListener(DisplayListener listener, Handler handler) {
        this.registerDisplayListener(listener, handler, 7L, 0L, ActivityThread.currentPackageName(), false);
    }

    public void registerDisplayListener(@NonNull DisplayListener listener, @Nullable Handler handler, long eventFilter) {
        this.registerDisplayListener(listener, handler, eventFilter, 0L, ActivityThread.currentPackageName(), true);
    }

    @FlaggedApi(value="com.android.server.display.feature.flags.display_listener_performance_improvements")
    public void registerDisplayListener(@NonNull Executor executor, long eventFilter, @NonNull DisplayListener listener) {
        this.registerDisplayListener(listener, executor, eventFilter, 0L, ActivityThread.currentPackageName(), true);
    }

    public void registerDisplayListener(@NonNull DisplayListener listener, @Nullable Handler handler, long eventFilter, long privateEventFilter) {
        this.registerDisplayListener(listener, handler, eventFilter, privateEventFilter, ActivityThread.currentPackageName(), true);
    }

    private void registerDisplayListener(@NonNull DisplayListener listener, @Nullable Handler handler, long eventFilter, long privateEventFilter, String packageName, boolean isEventFilterExplicit) {
        this.mGlobal.registerDisplayListener(listener, handler, this.mGlobal.mapFiltersToInternalEventFlag(eventFilter, privateEventFilter), packageName, isEventFilterExplicit);
    }

    private void registerDisplayListener(@NonNull DisplayListener listener, Executor executor, long eventFilter, long privateEventFilter, String packageName, boolean isEventFilterExplicit) {
        this.mGlobal.registerDisplayListener(listener, executor, this.mGlobal.mapFiltersToInternalEventFlag(eventFilter, privateEventFilter), packageName, isEventFilterExplicit);
    }

    public void unregisterDisplayListener(DisplayListener listener) {
        this.mGlobal.unregisterDisplayListener(listener);
    }

    @UnsupportedAppUsage
    public void startWifiDisplayScan() {
        this.mGlobal.startWifiDisplayScan();
    }

    @UnsupportedAppUsage
    public void stopWifiDisplayScan() {
        this.mGlobal.stopWifiDisplayScan();
    }

    @UnsupportedAppUsage
    public void connectWifiDisplay(String deviceAddress) {
        this.mGlobal.connectWifiDisplay(deviceAddress);
    }

    @UnsupportedAppUsage
    public void pauseWifiDisplay() {
        this.mGlobal.pauseWifiDisplay();
    }

    @UnsupportedAppUsage
    public void resumeWifiDisplay() {
        this.mGlobal.resumeWifiDisplay();
    }

    @UnsupportedAppUsage
    public void disconnectWifiDisplay() {
        this.mGlobal.disconnectWifiDisplay();
    }

    @UnsupportedAppUsage
    public void renameWifiDisplay(String deviceAddress, String alias) {
        this.mGlobal.renameWifiDisplay(deviceAddress, alias);
    }

    @UnsupportedAppUsage
    public void forgetWifiDisplay(String deviceAddress) {
        this.mGlobal.forgetWifiDisplay(deviceAddress);
    }

    @UnsupportedAppUsage
    public WifiDisplayStatus getWifiDisplayStatus() {
        return this.mGlobal.getWifiDisplayStatus();
    }

    @RequiresPermission(value="android.permission.MANAGE_DISPLAYS")
    public void enableConnectedDisplay(int displayId) {
        this.mGlobal.enableConnectedDisplay(displayId);
    }

    @RequiresPermission(value="android.permission.MANAGE_DISPLAYS")
    public void disableConnectedDisplay(int displayId) {
        this.mGlobal.disableConnectedDisplay(displayId);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_SATURATION")
    public void setSaturationLevel(float level) {
        if (level < 0.0f || level > 1.0f) {
            throw new IllegalArgumentException("Saturation level must be between 0 and 1");
        }
        ColorDisplayManager cdm = this.mContext.getSystemService(ColorDisplayManager.class);
        cdm.setSaturationLevel(Math.round(level * 100.0f));
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setUserDisabledHdrTypes(@NonNull int[] userDisabledTypes) {
        this.mGlobal.setUserDisabledHdrTypes(userDisabledTypes);
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) {
        this.mGlobal.setAreUserDisabledHdrTypesAllowed(areUserDisabledHdrTypesAllowed);
    }

    public boolean areUserDisabledHdrTypesAllowed() {
        return this.mGlobal.areUserDisabledHdrTypesAllowed();
    }

    @NonNull
    public int[] getUserDisabledHdrTypes() {
        return this.mGlobal.getUserDisabledHdrTypes();
    }

    @FlaggedApi(value="com.android.server.display.feature.flags.delay_implicit_rr_registration_until_rr_accessed")
    public void resetImplicitRefreshRateCallbackStatus() {
        this.mGlobal.resetImplicitRefreshRateCallbackStatus();
    }

    @RequiresPermission(value="android.permission.ACCESS_SURFACE_FLINGER")
    public void overrideHdrTypes(int displayId, @NonNull int[] modes) {
        this.mGlobal.overrideHdrTypes(displayId, modes);
    }

    public VirtualDisplay createVirtualDisplay(@NonNull String name, int width, int height, int densityDpi, @Nullable Surface surface, int flags) {
        return this.createVirtualDisplay(name, width, height, densityDpi, surface, flags, null, null);
    }

    public VirtualDisplay createVirtualDisplay(@NonNull String name, int width, int height, int densityDpi, @Nullable Surface surface, int flags, @Nullable VirtualDisplay.Callback callback, @Nullable Handler handler) {
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, densityDpi);
        builder.setFlags(flags);
        if (surface != null) {
            builder.setSurface(surface);
        }
        builder.setDisplayIdToMirror(this.getDisplayIdToMirror());
        return this.createVirtualDisplay(builder.build(), handler, callback);
    }

    @Nullable
    public VirtualDisplay createVirtualDisplay(@NonNull VirtualDisplayConfig config) {
        return this.createVirtualDisplay(config, null, null);
    }

    @Nullable
    public VirtualDisplay createVirtualDisplay(@NonNull VirtualDisplayConfig config, @Nullable Handler handler, @Nullable VirtualDisplay.Callback callback) {
        return this.createVirtualDisplay(null, config, callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(@Nullable MediaProjection projection, @NonNull String name, int width, int height, int densityDpi, @Nullable Surface surface, int flags, @Nullable VirtualDisplay.Callback callback, @Nullable Handler handler, @Nullable String uniqueId) {
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, densityDpi);
        builder.setFlags(flags);
        if (uniqueId != null) {
            builder.setUniqueId(uniqueId);
        }
        if (surface != null) {
            builder.setSurface(surface);
        }
        builder.setDisplayIdToMirror(this.getDisplayIdToMirror());
        return this.createVirtualDisplay(projection, builder.build(), callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(@Nullable MediaProjection projection, @NonNull VirtualDisplayConfig virtualDisplayConfig, @Nullable VirtualDisplay.Callback callback, @Nullable Handler handler) {
        HandlerExecutor executor = null;
        if (callback != null) {
            executor = new HandlerExecutor(Handler.createAsync(handler != null ? handler.getLooper() : Looper.myLooper()));
        }
        return this.mGlobal.createVirtualDisplay(this.mContext, projection, virtualDisplayConfig, callback, executor);
    }

    @SystemApi
    public Point getStableDisplaySize() {
        return this.mGlobal.getStableDisplaySize();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BRIGHTNESS_SLIDER_USAGE")
    public List<BrightnessChangeEvent> getBrightnessEvents() {
        return this.mGlobal.getBrightnessEvents(this.mContext.getOpPackageName());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_LIGHT_STATS")
    public List<AmbientBrightnessDayStats> getAmbientBrightnessStats() {
        return this.mGlobal.getAmbientBrightnessStats();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public void setBrightnessConfiguration(BrightnessConfiguration c) {
        this.setBrightnessConfigurationForUser(c, this.mContext.getUserId(), this.mContext.getPackageName());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public void setBrightnessConfigurationForDisplay(@NonNull BrightnessConfiguration c, @NonNull String uniqueId) {
        this.mGlobal.setBrightnessConfigurationForDisplay(c, uniqueId, this.mContext.getUserId(), this.mContext.getPackageName());
    }

    @SystemApi
    @Nullable
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public BrightnessConfiguration getBrightnessConfigurationForDisplay(@NonNull String uniqueId) {
        return this.mGlobal.getBrightnessConfigurationForDisplay(uniqueId, this.mContext.getUserId());
    }

    public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) {
        this.mGlobal.setBrightnessConfigurationForUser(c, userId, packageName);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public BrightnessConfiguration getBrightnessConfiguration() {
        return this.getBrightnessConfigurationForUser(this.mContext.getUserId());
    }

    public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) {
        return this.mGlobal.getBrightnessConfigurationForUser(userId);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    @Nullable
    public BrightnessConfiguration getDefaultBrightnessConfiguration() {
        return this.mGlobal.getDefaultBrightnessConfiguration();
    }

    public boolean isMinimalPostProcessingRequested(int displayId) {
        return this.mGlobal.isMinimalPostProcessingRequested(displayId);
    }

    public void setTemporaryBrightness(int displayId, float brightness) {
        this.mGlobal.setTemporaryBrightness(displayId, brightness);
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void setBrightness(int displayId, float brightness) {
        this.mGlobal.setBrightness(displayId, brightness);
    }

    @FlaggedApi(value="com.android.server.display.feature.flags.set_brightness_by_unit")
    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public void setBrightness(int displayId, float value, int unit) {
        this.mGlobal.setBrightness(displayId, value, unit);
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public float getBrightness(int displayId) {
        return this.mGlobal.getBrightness(displayId);
    }

    public float getBrightness(int displayId, int unit) {
        return this.mGlobal.getBrightness(displayId, unit);
    }

    public void setTemporaryAutoBrightnessAdjustment(float adjustment) {
        this.mGlobal.setTemporaryAutoBrightnessAdjustment(adjustment);
    }

    @SystemApi
    public Pair<float[], float[]> getMinimumBrightnessCurve() {
        return this.mGlobal.getMinimumBrightnessCurve();
    }

    @RequiresPermission(value="android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE")
    public void setGlobalUserPreferredDisplayMode(@NonNull Display.Mode mode) {
        Display.Mode preferredMode = new Display.Mode(mode.getPhysicalWidth(), mode.getPhysicalHeight(), mode.getRefreshRate());
        this.mGlobal.setUserPreferredDisplayMode(-1, preferredMode);
    }

    @RequiresPermission(value="android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE")
    public void clearGlobalUserPreferredDisplayMode() {
        this.mGlobal.setUserPreferredDisplayMode(-1, null);
    }

    @Nullable
    public Display.Mode getGlobalUserPreferredDisplayMode() {
        return this.mGlobal.getUserPreferredDisplayMode(-1);
    }

    @RequiresPermission(value="android.permission.MODIFY_HDR_CONVERSION_MODE")
    public void setHdrConversionMode(@NonNull HdrConversionMode hdrConversionMode) {
        this.mGlobal.setHdrConversionMode(hdrConversionMode);
    }

    @NonNull
    public HdrConversionMode getHdrConversionMode() {
        return this.mGlobal.getHdrConversionMode();
    }

    @NonNull
    public HdrConversionMode getHdrConversionModeSetting() {
        return this.mGlobal.getHdrConversionModeSetting();
    }

    @NonNull
    public int[] getSupportedHdrOutputTypes() {
        return this.mGlobal.getSupportedHdrOutputTypes();
    }

    @RequiresPermission(value="android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS")
    public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) {
        this.mGlobal.setShouldAlwaysRespectAppRequestedMode(enabled);
    }

    @RequiresPermission(value="android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS")
    public boolean shouldAlwaysRespectAppRequestedMode() {
        return this.mGlobal.shouldAlwaysRespectAppRequestedMode();
    }

    @SystemApi
    @FlaggedApi(value="com.android.server.display.feature.flags.is_always_on_available_api")
    public boolean isAlwaysOnDisplayCurrentlyAvailable() {
        return this.getAmbientDisplayConfiguration().alwaysOnAvailableForUser(this.mContext.getUserId());
    }

    public boolean supportsSeamlessRefreshRateSwitching() {
        return this.mContext.getResources().getBoolean(17891966);
    }

    @RequiresPermission(value="android.permission.MODIFY_REFRESH_RATE_SWITCHING_TYPE")
    public void setRefreshRateSwitchingType(int newValue) {
        this.mGlobal.setRefreshRateSwitchingType(newValue);
    }

    public int getMatchContentFrameRateUserPreference() {
        return this.toMatchContentFrameRateSetting(this.mGlobal.getRefreshRateSwitchingType());
    }

    private int toMatchContentFrameRateSetting(int switchingType) {
        switch (switchingType) {
            case 0: {
                return 0;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        Slog.e(TAG, switchingType + " is not a valid value of switching type.");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AmbientDisplayConfiguration getAmbientDisplayConfiguration() {
        DisplayManager displayManager = this;
        synchronized (displayManager) {
            if (this.mAmbientDisplayConfiguration == null) {
                this.mAmbientDisplayConfiguration = new AmbientDisplayConfiguration(this.mContext);
            }
        }
        return this.mAmbientDisplayConfiguration;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CAPTURE_VIDEO_OUTPUT")
    @Nullable
    public static VirtualDisplay createVirtualDisplay(@NonNull String name, int width, int height, int displayIdToMirror, @Nullable Surface surface) {
        int displayId;
        String[] packages;
        IDisplayManager sDm = IDisplayManager.Stub.asInterface(ServiceManager.getService("display"));
        IPackageManager sPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, 1).setFlags(16).setDisplayIdToMirror(displayIdToMirror);
        if (surface != null) {
            builder.setSurface(surface);
        }
        VirtualDisplayConfig virtualDisplayConfig = builder.build();
        try {
            packages = sPackageManager.getPackagesForUid(Process.myUid());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        String packageName = packages == null ? null : packages[0];
        DisplayManagerGlobal.VirtualDisplayCallback callbackWrapper = new DisplayManagerGlobal.VirtualDisplayCallback(null, null);
        try {
            displayId = sDm.createVirtualDisplay(virtualDisplayConfig, callbackWrapper, null, packageName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        return DisplayManagerGlobal.getInstance().createVirtualDisplayWrapper(virtualDisplayConfig, callbackWrapper, displayId);
    }

    @RequiresPermission(value="android.permission.RESTRICT_DISPLAY_MODES")
    public void requestDisplayModes(int displayId, @Nullable int[] modeIds) {
        if (modeIds != null && modeIds.length == 0) {
            throw new IllegalArgumentException("requestDisplayModes: modesIds can't be empty");
        }
        this.mGlobal.requestDisplayModes(displayId, modeIds);
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    @Nullable
    public float[] getDozeBrightnessSensorValueToBrightness(int displayId) {
        return this.mGlobal.getDozeBrightnessSensorValueToBrightness(displayId);
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public float getDefaultDozeBrightness(int displayId) {
        return this.mGlobal.getDefaultDozeBrightness(displayId);
    }

    private int getDisplayIdToMirror() {
        if (this.mDisplayIdToMirror == -1) {
            UserManager userManager = this.mContext.getSystemService(UserManager.class);
            this.mDisplayIdToMirror = userManager.isVisibleBackgroundUsersSupported() ? userManager.getMainDisplayIdAssignedToUser() : 0;
        }
        return this.mDisplayIdToMirror;
    }

    @RequiresPermission(value="android.permission.MANAGE_DISPLAYS")
    @Nullable
    @FlaggedApi(value="com.android.server.display.feature.flags.display_topology_api")
    public DisplayTopology getDisplayTopology() {
        return this.mGlobal.getDisplayTopology();
    }

    @RequiresPermission(value="android.permission.MANAGE_DISPLAYS")
    public void setDisplayTopology(DisplayTopology topology) {
        this.mGlobal.setDisplayTopology(topology);
    }

    @RequiresPermission(value="android.permission.MANAGE_DISPLAYS")
    @FlaggedApi(value="com.android.server.display.feature.flags.display_topology_api")
    public void registerTopologyListener(@NonNull Executor executor, @NonNull Consumer<DisplayTopology> listener) {
        this.mGlobal.registerTopologyListener(executor, listener, ActivityThread.currentPackageName());
    }

    @RequiresPermission(value="android.permission.MANAGE_DISPLAYS")
    @FlaggedApi(value="com.android.server.display.feature.flags.display_topology_api")
    public void unregisterTopologyListener(@NonNull Consumer<DisplayTopology> listener) {
        this.mGlobal.unregisterTopologyListener(listener);
    }

    private static class WeakDisplayCache {
        private final SparseArray<WeakReference<Display>> mDisplayCache = new SparseArray();

        private WeakDisplayCache() {
        }

        Display get(int displayId) {
            WeakReference<Display> wrDisplay = this.mDisplayCache.get(displayId);
            if (wrDisplay == null) {
                return null;
            }
            return (Display)wrDisplay.get();
        }

        void put(Display display) {
            this.removeStaleEntries();
            this.mDisplayCache.put(display.getDisplayId(), new WeakReference<Display>(display));
        }

        private void removeStaleEntries() {
            int i;
            ArrayList<Integer> staleEntriesIndices = new ArrayList<Integer>();
            for (i = 0; i < this.mDisplayCache.size(); ++i) {
                if (this.mDisplayCache.valueAt(i).get() != null) continue;
                staleEntriesIndices.add(i);
            }
            for (i = 0; i < staleEntriesIndices.size(); ++i) {
                this.mDisplayCache.removeAt((Integer)staleEntriesIndices.get(i));
            }
        }
    }

    public static interface DisplayListener {
        public void onDisplayAdded(int var1);

        public void onDisplayRemoved(int var1);

        public void onDisplayChanged(int var1);

        default public void onDisplayConnected(int displayId) {
        }

        default public void onDisplayDisconnected(int displayId) {
        }
    }

    public static interface DeviceConfig {
        public static final String KEY_REFRESH_RATE_IN_LOW_ZONE = "refresh_rate_in_zone";
        public static final String KEY_FIXED_REFRESH_RATE_LOW_DISPLAY_BRIGHTNESS_THRESHOLDS = "peak_refresh_rate_brightness_thresholds";
        public static final String KEY_FIXED_REFRESH_RATE_LOW_AMBIENT_BRIGHTNESS_THRESHOLDS = "peak_refresh_rate_ambient_thresholds";
        public static final String KEY_REFRESH_RATE_IN_HIGH_ZONE = "refresh_rate_in_high_zone";
        public static final String KEY_FIXED_REFRESH_RATE_HIGH_DISPLAY_BRIGHTNESS_THRESHOLDS = "fixed_refresh_rate_high_display_brightness_thresholds";
        public static final String KEY_FIXED_REFRESH_RATE_HIGH_AMBIENT_BRIGHTNESS_THRESHOLDS = "fixed_refresh_rate_high_ambient_brightness_thresholds";
        public static final String KEY_REFRESH_RATE_IN_HBM_SUNLIGHT = "refresh_rate_in_hbm_sunlight";
        public static final String KEY_REFRESH_RATE_IN_HBM_HDR = "refresh_rate_in_hbm_hdr";
        public static final String KEY_PEAK_REFRESH_RATE_DEFAULT = "peak_refresh_rate_default";
        public static final String KEY_HIGH_REFRESH_RATE_BLACKLIST = "high_refresh_rate_blacklist";
        public static final String KEY_BRIGHTNESS_THROTTLING_DATA = "brightness_throttling_data";
        public static final String KEY_POWER_THROTTLING_DATA = "power_throttling_data";
        public static final String KEY_USE_NORMAL_BRIGHTNESS_MODE_CONTROLLER = "use_normal_brightness_mode_controller";
        public static final String KEY_DISABLE_SCREEN_WAKE_LOCKS_WHILE_CACHED = "disable_screen_wake_locks_while_cached";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BrightnessUnit {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrivateEventType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwitchingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchContentFrameRateType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VirtualDisplayFlag {
    }
}

