/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.Context;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.internal.hidden_from_bootclasspath.android.hardware.biometrics.Flags;
import com.android.internal.util.ArrayUtils;
import java.util.Map;

public class AmbientDisplayConfiguration {
    private static final String TAG = "AmbientDisplayConfig";
    private final Context mContext;
    private final boolean mAlwaysOnByDefault;
    private final boolean mPickupGestureEnabledByDefault;
    private final boolean mScreenOffUdfpsAvailable;
    private static final String[] DOZE_SETTINGS = new String[]{"doze_enabled", "doze_always_on", "doze_pulse_on_pick_up", "doze_pulse_on_long_press", "doze_pulse_on_double_tap", "doze_wake_screen_gesture", "doze_wake_display_gesture", "doze_tap_gesture"};
    private static final String[] NON_USER_CONFIGURABLE_DOZE_SETTINGS = new String[]{"doze_quick_pickup_gesture"};
    final SparseArray<Map<String, String>> mUsersInitialValues = new SparseArray();

    public AmbientDisplayConfiguration(Context context) {
        this.mContext = context;
        this.mAlwaysOnByDefault = this.mContext.getResources().getBoolean(17891670);
        this.mPickupGestureEnabledByDefault = this.mContext.getResources().getBoolean(17891671);
        this.mScreenOffUdfpsAvailable = this.mContext.getResources().getBoolean(17891894);
    }

    public boolean enabled(int user) {
        return this.pulseOnNotificationEnabled(user) || this.pulseOnLongPressEnabled(user) || this.alwaysOnEnabled(user) || this.wakeLockScreenGestureEnabled(user) || this.wakeDisplayGestureEnabled(user) || this.pickupGestureEnabled(user) || this.tapGestureEnabled(user) || this.doubleTapGestureEnabled(user) || this.quickPickupSensorEnabled(user) || this.screenOffUdfpsEnabled(user);
    }

    public boolean pulseOnNotificationEnabled(int user) {
        return this.boolSettingDefaultOn("doze_enabled", user) && this.pulseOnNotificationAvailable();
    }

    public boolean pulseOnNotificationAvailable() {
        return this.mContext.getResources().getBoolean(0x1110220) && this.ambientDisplayAvailable();
    }

    public boolean pickupGestureEnabled(int user) {
        return this.boolSetting("doze_pulse_on_pick_up", user, this.mPickupGestureEnabledByDefault ? 1 : 0) && this.dozePickupSensorAvailable();
    }

    public boolean dozePickupSensorAvailable() {
        return this.mContext.getResources().getBoolean(17891672);
    }

    public boolean tapGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_tap_gesture", user) && this.tapSensorAvailable();
    }

    public boolean tapSensorAvailable() {
        for (String tapType : this.tapSensorTypeMapping()) {
            if (TextUtils.isEmpty(tapType)) continue;
            return true;
        }
        return false;
    }

    public boolean doubleTapGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_pulse_on_double_tap", user) && this.doubleTapSensorAvailable();
    }

    public boolean doubleTapSensorAvailable() {
        return !TextUtils.isEmpty(this.doubleTapSensorType());
    }

    public boolean quickPickupSensorEnabled(int user) {
        return this.boolSettingDefaultOn("doze_quick_pickup_gesture", user) && !TextUtils.isEmpty(this.quickPickupSensorType()) && this.pickupGestureEnabled(user) && !this.alwaysOnEnabled(user);
    }

    public boolean screenOffUdfpsEnabled(int user) {
        return !TextUtils.isEmpty(this.udfpsLongPressSensorType()) && (this.mScreenOffUdfpsAvailable && Flags.screenOffUnlockUdfps() && this.mContext.getResources().getBoolean(17891893) ? this.boolSettingDefaultOn("screen_off_udfps_enabled", user) : this.boolSettingDefaultOff("screen_off_udfps_enabled", user));
    }

    public boolean wakeScreenGestureAvailable() {
        return this.mContext.getResources().getBoolean(17891674);
    }

    public boolean wakeLockScreenGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_wake_screen_gesture", user) && this.wakeScreenGestureAvailable();
    }

    public boolean wakeDisplayGestureEnabled(int user) {
        return this.boolSettingDefaultOn("doze_wake_display_gesture", user) && this.wakeScreenGestureAvailable();
    }

    public long getWakeLockScreenDebounce() {
        return this.mContext.getResources().getInteger(17694867);
    }

    public String doubleTapSensorType() {
        return this.mContext.getResources().getString(17039986);
    }

    public String[] tapSensorTypeMapping() {
        String[] postureMapping = this.mContext.getResources().getStringArray(17236078);
        if (ArrayUtils.isEmpty(postureMapping)) {
            return new String[]{this.mContext.getResources().getString(17039988)};
        }
        return postureMapping;
    }

    public String longPressSensorType() {
        return this.mContext.getResources().getString(17039987);
    }

    public String udfpsLongPressSensorType() {
        return this.mContext.getResources().getString(17039989);
    }

    public String quickPickupSensorType() {
        return this.mContext.getResources().getString(17040064);
    }

    public boolean pulseOnLongPressEnabled(int user) {
        return this.pulseOnLongPressAvailable() && this.boolSettingDefaultOff("doze_pulse_on_long_press", user);
    }

    private boolean pulseOnLongPressAvailable() {
        return !TextUtils.isEmpty(this.longPressSensorType());
    }

    public boolean alwaysOnEnabled(int user) {
        return this.boolSetting("doze_always_on", user, this.mAlwaysOnByDefault ? 1 : 0) && this.alwaysOnAvailable() && !this.accessibilityInversionEnabled(user);
    }

    public boolean alwaysOnAvailable() {
        return (this.alwaysOnDisplayDebuggingEnabled() || this.alwaysOnDisplayAvailable()) && this.ambientDisplayAvailable();
    }

    public boolean alwaysOnAvailableForUser(int user) {
        return this.alwaysOnAvailable() && !this.accessibilityInversionEnabled(user);
    }

    public String ambientDisplayComponent() {
        return this.mContext.getResources().getString(17039985);
    }

    public boolean accessibilityInversionEnabled(int user) {
        return this.boolSettingDefaultOff("accessibility_display_inversion_enabled", user);
    }

    public boolean ambientDisplayAvailable() {
        return !TextUtils.isEmpty(this.ambientDisplayComponent());
    }

    public boolean dozeSuppressed(int user) {
        return this.boolSettingDefaultOff("suppress_doze", user);
    }

    private boolean alwaysOnDisplayAvailable() {
        return this.mContext.getResources().getBoolean(0x1110155);
    }

    private boolean alwaysOnDisplayDebuggingEnabled() {
        return SystemProperties.getBoolean("debug.doze.aod", false) && _Original_Build.IS_DEBUGGABLE;
    }

    private boolean boolSettingDefaultOn(String name, int user) {
        return this.boolSetting(name, user, 1);
    }

    private boolean boolSettingDefaultOff(String name, int user) {
        return this.boolSetting(name, user, 0);
    }

    private boolean boolSetting(String name, int user, int def) {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), name, def, user) != 0;
    }

    public void disableDozeSettings(int userId) {
        this.disableDozeSettings(false, userId);
    }

    public void disableDozeSettings(boolean shouldDisableNonUserConfigurable, int userId) {
        Map<String, String> initialValues = this.mUsersInitialValues.get(userId);
        if (initialValues != null && !initialValues.isEmpty()) {
            throw new IllegalStateException("Don't call #disableDozeSettings more than once,without first calling #restoreDozeSettings");
        }
        initialValues = new ArrayMap<String, String>();
        for (String name : DOZE_SETTINGS) {
            initialValues.put(name, this.getDozeSetting(name, userId));
            this.putDozeSetting(name, "0", userId);
        }
        if (shouldDisableNonUserConfigurable) {
            for (String name : NON_USER_CONFIGURABLE_DOZE_SETTINGS) {
                initialValues.put(name, this.getDozeSetting(name, userId));
                this.putDozeSetting(name, "0", userId);
            }
        }
        this.mUsersInitialValues.put(userId, initialValues);
    }

    public void restoreDozeSettings(int userId) {
        Map<String, String> initialValues = this.mUsersInitialValues.get(userId);
        if (initialValues != null && !initialValues.isEmpty()) {
            for (String name : DOZE_SETTINGS) {
                this.putDozeSetting(name, initialValues.get(name), userId);
            }
            this.mUsersInitialValues.remove(userId);
        }
    }

    private String getDozeSetting(String name, int userId) {
        return Settings.Secure.getStringForUser(this.mContext.getContentResolver(), name, userId);
    }

    private void putDozeSetting(String name, String value, int userId) {
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), name, value, userId);
    }
}

