/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@SystemApi
@FlaggedApi(value="android.hardware.devicestate.feature.flags.device_state_property_api")
public class DeviceState {
    public static final int PROPERTY_FOLDABLE_HARDWARE_CONFIGURATION_FOLD_IN_CLOSED = 1;
    public static final int PROPERTY_FOLDABLE_HARDWARE_CONFIGURATION_FOLD_IN_HALF_OPEN = 2;
    public static final int PROPERTY_FOLDABLE_HARDWARE_CONFIGURATION_FOLD_IN_OPEN = 3;
    public static final int PROPERTY_POLICY_CANCEL_OVERRIDE_REQUESTS = 4;
    public static final int PROPERTY_POLICY_CANCEL_WHEN_REQUESTER_NOT_ON_TOP = 5;
    public static final int PROPERTY_POLICY_UNSUPPORTED_WHEN_THERMAL_STATUS_CRITICAL = 6;
    public static final int PROPERTY_POLICY_UNSUPPORTED_WHEN_POWER_SAVE_MODE = 7;
    public static final int PROPERTY_POLICY_AVAILABLE_FOR_APP_REQUEST = 8;
    public static final int PROPERTY_APP_INACCESSIBLE = 9;
    public static final int PROPERTY_EMULATED_ONLY = 10;
    public static final int PROPERTY_FOLDABLE_DISPLAY_CONFIGURATION_OUTER_PRIMARY = 11;
    public static final int PROPERTY_FOLDABLE_DISPLAY_CONFIGURATION_INNER_PRIMARY = 12;
    public static final int PROPERTY_POWER_CONFIGURATION_TRIGGER_SLEEP = 13;
    public static final int PROPERTY_POWER_CONFIGURATION_TRIGGER_WAKE = 14;
    public static final int PROPERTY_EXTENDED_DEVICE_STATE_EXTERNAL_DISPLAY = 15;
    public static final int PROPERTY_FEATURE_REAR_DISPLAY = 16;
    public static final int PROPERTY_FEATURE_DUAL_DISPLAY_INTERNAL_DEFAULT = 17;
    @FlaggedApi(value="android.hardware.devicestate.feature.flags.desktop_device_state_property_api")
    public static final int PROPERTY_LAPTOP_HARDWARE_CONFIGURATION_LID_CLOSED = 101;
    @FlaggedApi(value="android.hardware.devicestate.feature.flags.desktop_device_state_property_api")
    public static final int PROPERTY_LAPTOP_HARDWARE_CONFIGURATION_LID_OPEN = 102;
    @FlaggedApi(value="android.hardware.devicestate.feature.flags.desktop_device_state_property_api")
    public static final int PROPERTY_LAPTOP_HARDWARE_CONFIGURATION_SLATE = 103;
    @FlaggedApi(value="android.hardware.devicestate.feature.flags.desktop_device_state_property_api")
    public static final int PROPERTY_LAPTOP_HARDWARE_CONFIGURATION_DOCKED = 104;
    @FlaggedApi(value="android.hardware.devicestate.feature.flags.device_state_rdm_v2")
    public static final int PROPERTY_FEATURE_REAR_DISPLAY_OUTER_DEFAULT = 1001;
    @NonNull
    private final Configuration mDeviceStateConfiguration;

    public DeviceState(@NonNull Configuration deviceStateConfiguration) {
        Objects.requireNonNull(deviceStateConfiguration, "Device StateConfiguration is null");
        this.mDeviceStateConfiguration = deviceStateConfiguration;
    }

    public int getIdentifier() {
        return this.mDeviceStateConfiguration.getIdentifier();
    }

    @NonNull
    public String getName() {
        return this.mDeviceStateConfiguration.getName();
    }

    public String toString() {
        return "DeviceState{identifier=" + this.mDeviceStateConfiguration.getIdentifier() + ", name='" + this.mDeviceStateConfiguration.getName() + '\'' + ", app_accessible=" + !this.mDeviceStateConfiguration.getSystemProperties().contains(9) + ", cancel_when_requester_not_on_top=" + this.mDeviceStateConfiguration.getSystemProperties().contains(5) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceState that = (DeviceState)o;
        return Objects.equals(this.mDeviceStateConfiguration, that.mDeviceStateConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.mDeviceStateConfiguration);
    }

    public boolean hasProperty(int propertyToCheckFor) {
        return this.mDeviceStateConfiguration.mSystemProperties.contains(propertyToCheckFor) || this.mDeviceStateConfiguration.mPhysicalProperties.contains(propertyToCheckFor);
    }

    public boolean hasProperties(int ... properties) {
        for (int i = 0; i < properties.length; ++i) {
            if (this.hasProperty(properties[i])) continue;
            return false;
        }
        return true;
    }

    public Configuration getConfiguration() {
        return this.mDeviceStateConfiguration;
    }

    public static class Configuration
    implements Parcelable {
        private final int mIdentifier;
        @NonNull
        private final String mName;
        @NonNull
        private final ArraySet<Integer> mSystemProperties;
        @NonNull
        private final ArraySet<Integer> mPhysicalProperties;
        @NonNull
        public static final Parcelable.Creator<Configuration> CREATOR = new Parcelable.Creator<Configuration>(){

            @Override
            public Configuration createFromParcel(Parcel source) {
                int identifier = source.readInt();
                String name = source.readString8();
                ArraySet<? extends Object> systemProperties = source.readArraySet(null);
                ArraySet<? extends Object> physicalProperties = source.readArraySet(null);
                return new Configuration(identifier, name, systemProperties, physicalProperties);
            }

            public Configuration[] newArray(int size) {
                return new Configuration[size];
            }
        };

        private Configuration(int identifier, @NonNull String name, @NonNull ArraySet<Integer> systemProperties, @NonNull ArraySet<Integer> physicalProperties) {
            this.mIdentifier = identifier;
            this.mName = name;
            this.mSystemProperties = systemProperties;
            this.mPhysicalProperties = physicalProperties;
        }

        public int getIdentifier() {
            return this.mIdentifier;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        @NonNull
        public Set<Integer> getSystemProperties() {
            return this.mSystemProperties;
        }

        @NonNull
        public Set<Integer> getPhysicalProperties() {
            return this.mPhysicalProperties;
        }

        public String toString() {
            return "DeviceState{identifier=" + this.mIdentifier + ", name='" + this.mName + '\'' + ", app_accessible=" + this.mSystemProperties.contains(9) + ", cancel_when_requester_not_on_top=" + this.mSystemProperties.contains(5) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Configuration that = (Configuration)o;
            return this.mIdentifier == that.mIdentifier && Objects.equals(this.mName, that.mName) && Objects.equals(this.mSystemProperties, that.mSystemProperties) && Objects.equals(this.mPhysicalProperties, that.mPhysicalProperties);
        }

        public int hashCode() {
            return Objects.hash(this.mIdentifier, this.mName, this.mSystemProperties, this.mPhysicalProperties);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mIdentifier);
            dest.writeString8(this.mName);
            dest.writeArraySet(this.mSystemProperties);
            dest.writeArraySet(this.mPhysicalProperties);
        }

        public static class Builder {
            private final int mIdentifier;
            @NonNull
            private final String mName;
            @NonNull
            private Set<Integer> mSystemProperties = Collections.emptySet();
            @NonNull
            private Set<Integer> mPhysicalProperties = Collections.emptySet();

            public Builder(int identifier, @NonNull String name) {
                this.mIdentifier = identifier;
                this.mName = name;
            }

            @NonNull
            public Builder setSystemProperties(@NonNull Set<Integer> systemProperties) {
                this.mSystemProperties = systemProperties;
                return this;
            }

            @NonNull
            public Builder setPhysicalProperties(@NonNull Set<Integer> physicalProperties) {
                this.mPhysicalProperties = physicalProperties;
                return this;
            }

            @NonNull
            public Configuration build() {
                return new Configuration(this.mIdentifier, this.mName, new ArraySet<Integer>(this.mSystemProperties), new ArraySet<Integer>(this.mPhysicalProperties));
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface SystemDeviceStateProperties {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface PhysicalDeviceStateProperties {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface DeviceStateProperties {
    }
}

