/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.annotation.NonNull;
import android.hardware.CameraExtensionSessionStats;
import android.hardware.camera2.CameraManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExtensionSessionStatsAggregator {
    private static final boolean DEBUG = false;
    private static final String TAG = ExtensionSessionStatsAggregator.class.getSimpleName();
    private final ExecutorService mExecutor = Executors.newSingleThreadExecutor();
    private final Object mLock = new Object();
    private boolean mIsDone = false;
    private final CameraExtensionSessionStats mStats = new CameraExtensionSessionStats();

    public ExtensionSessionStatsAggregator(@NonNull String cameraId, boolean isAdvanced) {
        this.mStats.key = "";
        this.mStats.cameraId = cameraId;
        this.mStats.isAdvanced = isAdvanced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientName(@NonNull String clientName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsDone) {
                return;
            }
            this.mStats.clientName = clientName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaptureFormat(int format) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsDone) {
                return;
            }
            this.mStats.captureFormat = format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtensionType(int extensionType) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsDone) {
                return;
            }
            this.mStats.type = extensionType;
        }
    }

    public void commit(boolean isFinal) {
        this.mExecutor.execute(() -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsDone) {
                    return;
                }
                this.mIsDone = isFinal;
                this.mStats.key = CameraManager.reportExtensionSessionStats(this.mStats);
            }
        });
    }

    private static String prettyPrintStats(@NonNull CameraExtensionSessionStats stats) {
        return CameraExtensionSessionStats.class.getSimpleName() + ":\n  key: '" + stats.key + "'\n  cameraId: '" + stats.cameraId + "'\n  clientName: '" + stats.clientName + "'\n  type: '" + stats.type + "'\n  isAdvanced: '" + stats.isAdvanced + "'\n  captureFormat: '" + stats.captureFormat + "'\n";
    }

    public String getStatsKey() {
        return this.mStats.key;
    }
}

