/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.Pair;
import java.util.Set;

public class ConcurrentCameraIdCombination
implements Parcelable {
    private final Set<Pair<String, Integer>> mConcurrentCameraIdDeviceIdPairs = new ArraySet<Pair<String, Integer>>();
    @NonNull
    public static final Parcelable.Creator<ConcurrentCameraIdCombination> CREATOR = new Parcelable.Creator<ConcurrentCameraIdCombination>(){

        @Override
        public ConcurrentCameraIdCombination createFromParcel(Parcel in) {
            return new ConcurrentCameraIdCombination(in);
        }

        public ConcurrentCameraIdCombination[] newArray(int size) {
            return new ConcurrentCameraIdCombination[size];
        }
    };

    private ConcurrentCameraIdCombination(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mConcurrentCameraIdDeviceIdPairs.size());
        for (Pair<String, Integer> cameraIdDeviceIdPair : this.mConcurrentCameraIdDeviceIdPairs) {
            dest.writeString((String)cameraIdDeviceIdPair.first);
            dest.writeInt((Integer)cameraIdDeviceIdPair.second);
        }
    }

    public void readFromParcel(Parcel in) {
        this.mConcurrentCameraIdDeviceIdPairs.clear();
        int cameraCombinationSize = in.readInt();
        if (cameraCombinationSize < 0) {
            throw new RuntimeException("cameraCombinationSize " + cameraCombinationSize + " should not be negative");
        }
        for (int i = 0; i < cameraCombinationSize; ++i) {
            String cameraId = in.readString();
            if (cameraId == null) {
                throw new RuntimeException("Failed to read camera id from Parcel");
            }
            int deviceId = in.readInt();
            this.mConcurrentCameraIdDeviceIdPairs.add(new Pair<String, Integer>(cameraId, deviceId));
        }
    }

    public Set<Pair<String, Integer>> getConcurrentCameraIdCombination() {
        return this.mConcurrentCameraIdDeviceIdPairs;
    }
}

